/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.replicator.exception;

import java.util.UUID;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.replicator.exception.ExpectedReplicationException;
import org.apache.ignite3.lang.ErrorGroups;
import org.apache.ignite3.tx.RetriableTransactionException;
import org.jetbrains.annotations.Nullable;

public class PrimaryReplicaMissException
extends IgniteInternalException
implements ExpectedReplicationException,
RetriableTransactionException {
    private static final long serialVersionUID = 8755220779942651494L;

    public PrimaryReplicaMissException(UUID txId, Long expectedEnlistmentConsistencyToken, Long currentEnlistmentConsistencyToken) {
        super(ErrorGroups.Replicator.REPLICA_MISS_ERR, IgniteStringFormatter.format("The primary replica has changed [txId={}, expectedEnlistmentConsistencyToken={}, currentEnlistmentConsistencyToken={}].", txId, expectedEnlistmentConsistencyToken, currentEnlistmentConsistencyToken));
    }

    public PrimaryReplicaMissException(String expectedLeaseholderName, @Nullable String currentLeaseholderName, UUID expectedLeaseholderId, @Nullable UUID currentLeaseholderId, @Nullable Long expectedEnlistmentConsistencyToken, @Nullable Long currentEnlistmentConsistencyToken, @Nullable Throwable cause) {
        super(ErrorGroups.Replicator.REPLICA_MISS_ERR, "The primary replica has changed [expectedLeaseholderName={}, currentLeaseholderName={}, expectedLeaseholderId={}, currentLeaseholderId={}, expectedEnlistmentConsistencyToken={}, currentEnlistmentConsistencyToken={}]", cause, expectedLeaseholderName, currentLeaseholderName, expectedLeaseholderId, currentLeaseholderId, expectedEnlistmentConsistencyToken, currentEnlistmentConsistencyToken);
    }
}

