/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.ignite.internal.processors.query.stat.StatisticsTarget;
import org.apache.ignite.internal.sql.SqlLexer;
import org.apache.ignite.internal.sql.SqlLexerToken;
import org.apache.ignite.internal.sql.SqlLexerTokenType;
import org.apache.ignite.internal.sql.SqlParserUtils;
import org.apache.ignite.internal.sql.command.SqlCommand;
import org.apache.ignite.internal.sql.command.SqlQualifiedName;

public abstract class SqlStatisticsCommands
implements SqlCommand {
    private String schemaName;
    protected List<StatisticsTarget> targets = new ArrayList<StatisticsTarget>();

    protected SqlStatisticsCommands() {
    }

    protected SqlStatisticsCommands(Collection<StatisticsTarget> targets) {
        this.targets = new ArrayList<StatisticsTarget>(targets);
    }

    @Override
    public String schemaName() {
        return this.schemaName;
    }

    @Override
    public void schemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public Collection<StatisticsTarget> targets() {
        return Collections.unmodifiableList(this.targets);
    }

    @Override
    public SqlCommand parse(SqlLexer lex) {
        do {
            SqlQualifiedName tblQName = SqlParserUtils.parseQualifiedIdentifier(lex, new String[0]);
            String[] cols = this.parseColumnList(lex, false);
            this.targets.add(new StatisticsTarget(tblQName.schemaName(), tblQName.name(), cols));
        } while (!this.tryEnd(lex));
        return this;
    }

    protected boolean tryEnd(SqlLexer lex) {
        return !lex.shift() || lex.tokenType() == SqlLexerTokenType.SEMICOLON;
    }

    protected String[] parseColumnList(SqlLexer lex, boolean allowParams) {
        SqlLexerToken nextTok = lex.lookAhead();
        if (nextTok.token() == null || nextTok.tokenType() == SqlLexerTokenType.SEMICOLON || nextTok.tokenType() == SqlLexerTokenType.COMMA) {
            return null;
        }
        if (allowParams && SqlParserUtils.matchesKeyword(nextTok, "WITH")) {
            return null;
        }
        lex.shift();
        if (lex.tokenType() != SqlLexerTokenType.PARENTHESIS_LEFT) {
            throw SqlParserUtils.errorUnexpectedToken(lex, "(");
        }
        HashSet<String> res = new HashSet<String>();
        do {
            this.parseColumn(lex, res);
        } while (!SqlParserUtils.skipCommaOrRightParenthesis(lex));
        return res.isEmpty() ? null : res.toArray(new String[0]);
    }

    private void parseColumn(SqlLexer lex, Set<String> cols) {
        String name = SqlParserUtils.parseIdentifier(lex, new String[0]);
        if (!cols.add(name)) {
            throw SqlParserUtils.error(lex, "Column " + name + " already defined.");
        }
    }
}

