/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.security.thread;

import java.util.concurrent.Executor;
import org.apache.ignite.internal.processors.security.IgniteSecurity;
import org.apache.ignite.internal.processors.security.thread.SecurityAwareRunnable;
import org.apache.ignite.plugin.extensions.communication.IoPool;
import org.jetbrains.annotations.NotNull;

public class SecurityAwareIoPool
implements IoPool {
    private final IgniteSecurity security;
    private final IoPool delegate;
    private final Executor executor;

    public SecurityAwareIoPool(IgniteSecurity security, IoPool delegate) {
        assert (security.enabled());
        assert (delegate != null);
        this.security = security;
        this.delegate = delegate;
        final Executor delegateExecutor = delegate.executor();
        this.executor = delegateExecutor == null ? null : new Executor(){

            @Override
            public void execute(@NotNull Runnable cmd) {
                delegateExecutor.execute(SecurityAwareRunnable.of(SecurityAwareIoPool.this.security, cmd));
            }
        };
    }

    @Override
    public byte id() {
        return this.delegate.id();
    }

    @Override
    public Executor executor() {
        return this.executor;
    }
}

