/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.trait;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.sql.engine.exec.RowPartitionExtractor;
import org.apache.ignite.internal.sql.engine.trait.Destination;

public final class Partitioned<RowT>
implements Destination<RowT> {
    private final Int2ObjectMap<String> assignments;
    private final RowPartitionExtractor<RowT> calc;

    public Partitioned(Int2ObjectMap<String> assignments, RowPartitionExtractor<RowT> calc) {
        this.calc = calc;
        this.assignments = assignments;
    }

    @Override
    public List<String> targets(RowT row) {
        int part = this.calc.partition(row);
        return List.of((String)this.assignments.get(part));
    }

    public List<String> targets() {
        return this.assignments.values().stream().distinct().collect(Collectors.toUnmodifiableList());
    }
}

