/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.ssl;

import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Primary;
import io.micronaut.http.ssl.SslConfiguration;

@ConfigurationProperties(value="micronaut.ssl")
@Primary
@BootstrapContextCompatible
public class DefaultSslConfiguration
extends SslConfiguration {
    void setKey(DefaultKeyConfiguration keyConfiguration) {
        if (keyConfiguration != null) {
            super.setKey(keyConfiguration);
        }
    }

    void setKeyStore(DefaultKeyStoreConfiguration keyStoreConfiguration) {
        if (keyStoreConfiguration != null) {
            super.setKeyStore(keyStoreConfiguration);
        }
    }

    void setTrustStore(DefaultTrustStoreConfiguration trustStore) {
        super.setTrustStore(trustStore);
    }

    @Primary
    @ConfigurationProperties(value="trust-store")
    @BootstrapContextCompatible
    public static class DefaultTrustStoreConfiguration
    extends SslConfiguration.TrustStoreConfiguration {
    }

    @Primary
    @ConfigurationProperties(value="key-store")
    @BootstrapContextCompatible
    public static class DefaultKeyStoreConfiguration
    extends SslConfiguration.KeyStoreConfiguration {
    }

    @Primary
    @ConfigurationProperties(value="key")
    @BootstrapContextCompatible
    public static class DefaultKeyConfiguration
    extends SslConfiguration.KeyConfiguration {
    }
}

