/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.filename;

import java.io.File;
import java.io.Serializable;
import org.apache.ignite.internal.processors.cache.persistence.FileLockHolder;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PdsFolderSettings<L extends FileLockHolder> {
    @Nullable
    private final File persistentStoreRootPath;
    private final String folderName;
    private final Serializable consistentId;
    @Nullable
    private final L fileLockHolder;
    private final boolean compatible;

    public PdsFolderSettings(@Nullable File persistentStoreRootPath, String folderName, Serializable consistentId, @Nullable L fileLockHolder, boolean compatible) {
        this.consistentId = consistentId;
        this.folderName = folderName;
        this.fileLockHolder = fileLockHolder;
        this.compatible = compatible;
        this.persistentStoreRootPath = persistentStoreRootPath;
    }

    public PdsFolderSettings(@Nullable File persistentStoreRootPath, @NotNull Serializable consistentId) {
        this.consistentId = consistentId;
        this.compatible = true;
        this.folderName = U.maskForFileName(consistentId.toString());
        this.persistentStoreRootPath = persistentStoreRootPath;
        this.fileLockHolder = null;
    }

    public String folderName() {
        return this.folderName;
    }

    public Serializable consistentId() {
        return this.consistentId;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    @Nullable
    public L getLockedFileLockHolder() {
        return this.fileLockHolder;
    }

    @Nullable
    public File persistentStoreRootPath() {
        return this.persistentStoreRootPath;
    }

    public File persistentStoreNodePath() {
        assert (this.persistentStoreRootPath != null);
        return new File(this.persistentStoreRootPath, this.folderName);
    }

    public String toString() {
        return S.toString(PdsFolderSettings.class, this);
    }
}

