/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.handlers.cluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cluster.BaselineNode;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.IgniteClusterEx;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.GridRestResponse;
import org.apache.ignite.internal.processors.rest.handlers.GridRestCommandHandlerAdapter;
import org.apache.ignite.internal.processors.rest.handlers.cluster.GridBaselineCommandResponse;
import org.apache.ignite.internal.processors.rest.request.GridRestBaselineRequest;
import org.apache.ignite.internal.processors.rest.request.GridRestRequest;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridBaselineCommandHandler
extends GridRestCommandHandlerAdapter {
    private static final Collection<GridRestCommand> SUPPORTED_COMMANDS = U.sealList(GridRestCommand.BASELINE_CURRENT_STATE, GridRestCommand.BASELINE_SET, GridRestCommand.BASELINE_ADD, GridRestCommand.BASELINE_REMOVE);

    public GridBaselineCommandHandler(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public Collection<GridRestCommand> supportedCommands() {
        return SUPPORTED_COMMANDS;
    }

    @Override
    public IgniteInternalFuture<GridRestResponse> handleAsync(GridRestRequest req) throws IgniteCheckedException {
        assert (req != null);
        assert (SUPPORTED_COMMANDS.contains((Object)req.command()));
        assert (req instanceof GridRestBaselineRequest) : "Invalid type of baseline request.";
        if (this.log.isDebugEnabled()) {
            this.log.debug("Handling baseline REST request: " + req);
        }
        GridRestBaselineRequest req0 = (GridRestBaselineRequest)req;
        IgniteClusterEx cluster = this.ctx.grid().cluster();
        List<Object> consistentIds = req0.consistentIds();
        switch (req0.command()) {
            case BASELINE_CURRENT_STATE: {
                break;
            }
            case BASELINE_SET: {
                Long topVer = req0.topologyVersion();
                if (topVer == null && consistentIds == null) {
                    throw new IgniteCheckedException("Failed to handle request (either topVer or consistentIds should be specified).");
                }
                if (topVer != null) {
                    cluster.setBaselineTopology(topVer);
                    break;
                }
                cluster.setBaselineTopology(this.filterServerNodesByConsId(consistentIds));
                break;
            }
            case BASELINE_ADD: {
                if (consistentIds == null) {
                    throw new IgniteCheckedException(GridBaselineCommandHandler.missingParameter("consistentIds"));
                }
                HashSet<BaselineNode> baselineTop = new HashSet<BaselineNode>(this.currentBaseLine());
                baselineTop.addAll(this.filterServerNodesByConsId(consistentIds));
                cluster.setBaselineTopology(baselineTop);
                break;
            }
            case BASELINE_REMOVE: {
                if (consistentIds == null) {
                    throw new IgniteCheckedException(GridBaselineCommandHandler.missingParameter("consistentIds"));
                }
                Collection<BaselineNode> baseline = this.currentBaseLine();
                HashSet<BaselineNode> baselineTop = new HashSet<BaselineNode>(baseline);
                baselineTop.removeAll(this.filterNodesByConsId(baseline, consistentIds));
                cluster.setBaselineTopology(baselineTop);
                break;
            }
            default: {
                assert (false) : "Invalid command for baseline handler: " + req;
                break;
            }
        }
        return new GridFinishedFuture<GridRestResponse>(new GridRestResponse(this.currentState()));
    }

    private Collection<BaselineNode> currentBaseLine() {
        Collection<BaselineNode> baselineNodes = this.ctx.grid().cluster().currentBaselineTopology();
        return baselineNodes != null ? baselineNodes : Collections.emptyList();
    }

    private GridBaselineCommandResponse currentState() {
        IgniteClusterEx cluster = this.ctx.grid().cluster();
        Collection<ClusterNode> srvrs = cluster.forServers().nodes();
        return new GridBaselineCommandResponse(cluster.state().active(), cluster.topologyVersion(), this.currentBaseLine(), srvrs);
    }

    private Collection<BaselineNode> filterNodesByConsId(Collection<? extends BaselineNode> nodes, List<Object> consistentIds) {
        Map nodeMap = nodes.stream().collect(Collectors.toMap(n -> n.consistentId().toString(), Function.identity()));
        ArrayList<BaselineNode> filtered = new ArrayList<BaselineNode>(consistentIds.size());
        for (Object consistentId : consistentIds) {
            BaselineNode node = (BaselineNode)nodeMap.get(consistentId);
            if (node == null) {
                throw new IllegalStateException("Node not found for consistent ID: " + consistentId);
            }
            filtered.add(node);
        }
        return filtered;
    }

    private Collection<BaselineNode> filterServerNodesByConsId(List<Object> consistentIds) {
        return this.filterNodesByConsId(this.ctx.grid().cluster().forServers().nodes(), consistentIds);
    }
}

