/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import java.nio.ByteBuffer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionEx;

public class CacheVersionIO {
    private static final byte NULL_PROTO_VER = 0;
    private static final byte MAX_PROTO_VER = 2;
    private static final int NULL_SIZE = 1;
    private static final int SIZE_V1 = 17;
    private static final int SIZE_V2 = 33;

    public static int size(GridCacheVersion ver, boolean allowNull) {
        if (ver == null) {
            if (allowNull) {
                return 1;
            }
            throw new IllegalStateException("Cache version is null");
        }
        return ver instanceof GridCacheVersionEx ? 33 : 17;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(ByteBuffer buf, GridCacheVersion ver, boolean allowNull) {
        if (ver == null) {
            if (!allowNull) throw new IllegalStateException("Cache version is null");
            buf.put((byte)0);
            return;
        } else if (ver instanceof GridCacheVersionEx) {
            byte protoVer = 2;
            buf.put(protoVer);
            buf.putInt(ver.topologyVersion());
            buf.putInt(ver.nodeOrderAndDrIdRaw());
            buf.putLong(ver.order());
            buf.putInt(ver.conflictVersion().topologyVersion());
            buf.putInt(ver.conflictVersion().nodeOrderAndDrIdRaw());
            buf.putLong(ver.conflictVersion().order());
            return;
        } else {
            byte protoVer = 1;
            buf.put(protoVer);
            buf.putInt(ver.topologyVersion());
            buf.putInt(ver.nodeOrderAndDrIdRaw());
            buf.putLong(ver.order());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void write(long addr, GridCacheVersion ver, boolean allowNull) {
        if (ver == null) {
            if (!allowNull) throw new IllegalStateException("Cache version is null");
            PageUtils.putByte(addr, 0, (byte)0);
            return;
        } else if (ver instanceof GridCacheVersionEx) {
            byte protoVer = 2;
            PageUtils.putByte(addr, 0, protoVer);
            PageUtils.putInt(addr, 1, ver.topologyVersion());
            PageUtils.putInt(addr, 5, ver.nodeOrderAndDrIdRaw());
            PageUtils.putLong(addr, 9, ver.order());
            PageUtils.putInt(addr, 17, ver.conflictVersion().topologyVersion());
            PageUtils.putInt(addr, 21, ver.conflictVersion().nodeOrderAndDrIdRaw());
            PageUtils.putLong(addr, 25, ver.conflictVersion().order());
            return;
        } else {
            byte protoVer = 1;
            PageUtils.putByte(addr, 0, protoVer);
            PageUtils.putInt(addr, 1, ver.topologyVersion());
            PageUtils.putInt(addr, 5, ver.nodeOrderAndDrIdRaw());
            PageUtils.putLong(addr, 9, ver.order());
        }
    }

    private static byte checkProtocolVersion(byte protoVer, boolean allowNull) throws IgniteCheckedException {
        if (protoVer >= 0 && protoVer <= 2) {
            if (protoVer == 0 && !allowNull) {
                throw new IllegalStateException("Cache version is null.");
            }
            return protoVer;
        }
        throw new IgniteCheckedException("Unsupported protocol version: " + protoVer);
    }

    public static int readSize(ByteBuffer buf, boolean allowNull) throws IgniteCheckedException {
        byte protoVer = CacheVersionIO.checkProtocolVersion(buf.get(buf.position()), allowNull);
        return CacheVersionIO.sizeForVersion(protoVer);
    }

    public static int readSize(long pageAddr, boolean allowNull) throws IgniteCheckedException {
        byte protoVer = CacheVersionIO.checkProtocolVersion(PageUtils.getByte(pageAddr, 0), allowNull);
        return CacheVersionIO.sizeForVersion(protoVer);
    }

    private static int sizeForVersion(int protoVer) {
        switch (protoVer) {
            case 0: {
                return 1;
            }
            case 1: {
                return 17;
            }
            case 2: {
                return 33;
            }
        }
        throw new IllegalStateException();
    }

    public static GridCacheVersion read(ByteBuffer buf, boolean allowNull) throws IgniteCheckedException {
        byte protoVer = CacheVersionIO.checkProtocolVersion(buf.get(), allowNull);
        switch (protoVer) {
            case 0: {
                return null;
            }
            case 1: {
                int topVer = buf.getInt();
                int nodeOrderDrId = buf.getInt();
                long order = buf.getLong();
                return new GridCacheVersion(topVer, nodeOrderDrId, order);
            }
            case 2: {
                int topVer = buf.getInt();
                int nodeOrderDrId = buf.getInt();
                long order = buf.getLong();
                int conflictTop = buf.getInt();
                int conflictNodeOrderDrId = buf.getInt();
                long conflictOrder = buf.getLong();
                return new GridCacheVersionEx(topVer, nodeOrderDrId, order, new GridCacheVersion(conflictTop, conflictNodeOrderDrId, conflictOrder));
            }
        }
        throw new IllegalStateException();
    }

    public static GridCacheVersion read(long pageAddr, boolean allowNull) throws IgniteCheckedException {
        byte protoVer = CacheVersionIO.checkProtocolVersion(PageUtils.getByte(pageAddr, 0), allowNull);
        switch (protoVer) {
            case 0: {
                return null;
            }
            case 1: {
                int topVer = PageUtils.getInt(pageAddr, 1);
                int nodeOrderDrId = PageUtils.getInt(pageAddr, 5);
                long order = PageUtils.getLong(pageAddr, 9);
                return new GridCacheVersion(topVer, nodeOrderDrId, order);
            }
            case 2: {
                int topVer = PageUtils.getInt(pageAddr, 1);
                int nodeOrderDrId = PageUtils.getInt(pageAddr, 5);
                long order = PageUtils.getLong(pageAddr, 9);
                int conflictTop = PageUtils.getInt(pageAddr, 17);
                int conflictNodeOrderDrId = PageUtils.getInt(pageAddr, 21);
                long conflictOrder = PageUtils.getLong(pageAddr, 25);
                return new GridCacheVersionEx(topVer, nodeOrderDrId, order, new GridCacheVersion(conflictTop, conflictNodeOrderDrId, conflictOrder));
            }
        }
        throw new IllegalStateException();
    }
}

