/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.UnregisteredBinaryTypeException;
import org.apache.ignite.internal.UnregisteredClassException;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.BinaryWriteMode;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public abstract class BinaryFieldAccessor {
    protected final int id;
    protected final String name;
    protected final BinaryWriteMode mode;

    public static BinaryFieldAccessor create(Field field, int id) {
        BinaryWriteMode mode = BinaryUtils.mode(field.getType());
        switch (mode) {
            case P_BYTE: {
                return new BytePrimitiveAccessor(field, id);
            }
            case P_BOOLEAN: {
                return new BooleanPrimitiveAccessor(field, id);
            }
            case P_SHORT: {
                return new ShortPrimitiveAccessor(field, id);
            }
            case P_CHAR: {
                return new CharPrimitiveAccessor(field, id);
            }
            case P_INT: {
                return new IntPrimitiveAccessor(field, id);
            }
            case P_LONG: {
                return new LongPrimitiveAccessor(field, id);
            }
            case P_FLOAT: {
                return new FloatPrimitiveAccessor(field, id);
            }
            case P_DOUBLE: {
                return new DoublePrimitiveAccessor(field, id);
            }
            case BYTE: 
            case BOOLEAN: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case STRING: 
            case UUID: 
            case DATE: 
            case TIMESTAMP: 
            case TIME: 
            case BYTE_ARR: 
            case SHORT_ARR: 
            case INT_ARR: 
            case LONG_ARR: 
            case FLOAT_ARR: 
            case DOUBLE_ARR: 
            case CHAR_ARR: 
            case BOOLEAN_ARR: 
            case DECIMAL_ARR: 
            case STRING_ARR: 
            case UUID_ARR: 
            case DATE_ARR: 
            case TIMESTAMP_ARR: 
            case TIME_ARR: 
            case ENUM_ARR: 
            case OBJECT_ARR: 
            case BINARY_OBJ: 
            case BINARY: {
                return new DefaultFinalClassAccessor(field, id, mode, false);
            }
        }
        return new DefaultFinalClassAccessor(field, id, mode, !U.isFinal(field.getType()));
    }

    protected BinaryFieldAccessor(Field field, int id, BinaryWriteMode mode) {
        assert (field != null);
        assert (id != 0);
        assert (mode != null);
        this.name = field.getName();
        this.id = id;
        this.mode = mode;
    }

    public BinaryWriteMode mode() {
        return this.mode;
    }

    public void write(Object obj, BinaryWriterExImpl writer) throws BinaryObjectException {
        try {
            this.write0(obj, writer);
        }
        catch (UnregisteredBinaryTypeException | UnregisteredClassException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (S.includeSensitive() && !F.isEmpty(this.name)) {
                throw new BinaryObjectException("Failed to write field [name=" + this.name + "]", ex);
            }
            throw new BinaryObjectException("Failed to write field [id=" + this.id + "]", ex);
        }
    }

    protected abstract void write0(Object var1, BinaryWriterExImpl var2) throws BinaryObjectException;

    public void read(Object obj, BinaryReaderExImpl reader) throws BinaryObjectException {
        try {
            this.read0(obj, reader);
        }
        catch (Exception ex) {
            if (S.includeSensitive() && !F.isEmpty(this.name)) {
                throw new BinaryObjectException("Failed to read field [name=" + this.name + "]", ex);
            }
            throw new BinaryObjectException("Failed to read field [id=" + this.id + "]", ex);
        }
    }

    protected abstract void read0(Object var1, BinaryReaderExImpl var2) throws BinaryObjectException;

    private static class DefaultFinalClassAccessor
    extends BinaryFieldAccessor {
        private final Field field;
        private final boolean dynamic;

        DefaultFinalClassAccessor(Field field, int id, BinaryWriteMode mode, boolean dynamic) {
            super(field, id, mode);
            this.field = field;
            this.dynamic = dynamic;
        }

        @Override
        protected void write0(Object obj, BinaryWriterExImpl writer) throws BinaryObjectException {
            Object val;
            assert (obj != null);
            assert (writer != null);
            writer.writeFieldIdNoSchemaUpdate(this.id);
            try {
                val = this.field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new BinaryObjectException("Failed to get value for field: " + this.field, e);
            }
            switch (this.mode(val)) {
                case BYTE: {
                    writer.writeByteField((Byte)val);
                    break;
                }
                case SHORT: {
                    writer.writeShortField((Short)val);
                    break;
                }
                case INT: {
                    writer.writeIntField((Integer)val);
                    break;
                }
                case LONG: {
                    writer.writeLongField((Long)val);
                    break;
                }
                case FLOAT: {
                    writer.writeFloatField((Float)val);
                    break;
                }
                case DOUBLE: {
                    writer.writeDoubleField((Double)val);
                    break;
                }
                case CHAR: {
                    writer.writeCharField((Character)val);
                    break;
                }
                case BOOLEAN: {
                    writer.writeBooleanField((Boolean)val);
                    break;
                }
                case DECIMAL: {
                    writer.writeDecimalField((BigDecimal)val);
                    break;
                }
                case STRING: {
                    writer.writeStringField((String)val);
                    break;
                }
                case UUID: {
                    writer.writeUuidField((UUID)val);
                    break;
                }
                case DATE: {
                    writer.writeDateField((Date)val);
                    break;
                }
                case TIMESTAMP: {
                    writer.writeTimestampField((Timestamp)val);
                    break;
                }
                case TIME: {
                    writer.writeTimeField((Time)val);
                    break;
                }
                case BYTE_ARR: {
                    writer.writeByteArrayField((byte[])val);
                    break;
                }
                case SHORT_ARR: {
                    writer.writeShortArrayField((short[])val);
                    break;
                }
                case INT_ARR: {
                    writer.writeIntArrayField((int[])val);
                    break;
                }
                case LONG_ARR: {
                    writer.writeLongArrayField((long[])val);
                    break;
                }
                case FLOAT_ARR: {
                    writer.writeFloatArrayField((float[])val);
                    break;
                }
                case DOUBLE_ARR: {
                    writer.writeDoubleArrayField((double[])val);
                    break;
                }
                case CHAR_ARR: {
                    writer.writeCharArrayField((char[])val);
                    break;
                }
                case BOOLEAN_ARR: {
                    writer.writeBooleanArrayField((boolean[])val);
                    break;
                }
                case DECIMAL_ARR: {
                    writer.writeDecimalArrayField((BigDecimal[])val);
                    break;
                }
                case STRING_ARR: {
                    writer.writeStringArrayField((String[])val);
                    break;
                }
                case UUID_ARR: {
                    writer.writeUuidArrayField((UUID[])val);
                    break;
                }
                case DATE_ARR: {
                    writer.writeDateArrayField((Date[])val);
                    break;
                }
                case TIMESTAMP_ARR: {
                    writer.writeTimestampArrayField((Timestamp[])val);
                    break;
                }
                case TIME_ARR: {
                    writer.writeTimeArrayField((Time[])val);
                    break;
                }
                case OBJECT_ARR: {
                    writer.writeObjectArrayField((Object[])val);
                    break;
                }
                case COL: {
                    writer.writeCollectionField((Collection)val);
                    break;
                }
                case MAP: {
                    writer.writeMapField((Map)val);
                    break;
                }
                case BINARY_OBJ: {
                    writer.writeBinaryObjectField((BinaryObjectImpl)val);
                    break;
                }
                case ENUM: {
                    writer.writeEnumField((Enum)val);
                    break;
                }
                case BINARY_ENUM: {
                    writer.doWriteBinaryEnum((BinaryEnumObjectImpl)val);
                    break;
                }
                case ENUM_ARR: {
                    writer.writeEnumArrayField((Object[])val);
                    break;
                }
                case BINARY: 
                case OBJECT: 
                case PROXY: {
                    writer.writeObjectField(val);
                    break;
                }
                case CLASS: {
                    writer.writeClassField((Class)val);
                    break;
                }
                default: {
                    assert (false) : "Invalid mode: " + this.mode;
                    break;
                }
            }
        }

        @Override
        public void read0(Object obj, BinaryReaderExImpl reader) throws BinaryObjectException {
            Object val = this.dynamic ? reader.readField(this.id) : this.readFixedType(reader);
            try {
                if (val != null || !this.field.getType().isPrimitive()) {
                    this.field.set(obj, val);
                }
            }
            catch (IllegalAccessException e) {
                throw new BinaryObjectException("Failed to set value for field: " + this.field, e);
            }
        }

        protected Object readFixedType(BinaryReaderExImpl reader) throws BinaryObjectException {
            Object val = null;
            switch (this.mode) {
                case BYTE: {
                    val = reader.readByteNullable(this.id);
                    break;
                }
                case SHORT: {
                    val = reader.readShortNullable(this.id);
                    break;
                }
                case INT: {
                    val = reader.readIntNullable(this.id);
                    break;
                }
                case LONG: {
                    val = reader.readLongNullable(this.id);
                    break;
                }
                case FLOAT: {
                    val = reader.readFloatNullable(this.id);
                    break;
                }
                case DOUBLE: {
                    val = reader.readDoubleNullable(this.id);
                    break;
                }
                case CHAR: {
                    val = reader.readCharNullable(this.id);
                    break;
                }
                case BOOLEAN: {
                    val = reader.readBooleanNullable(this.id);
                    break;
                }
                case DECIMAL: {
                    val = reader.readDecimal(this.id);
                    break;
                }
                case STRING: {
                    val = reader.readString(this.id);
                    break;
                }
                case UUID: {
                    val = reader.readUuid(this.id);
                    break;
                }
                case DATE: {
                    val = reader.readDate(this.id);
                    break;
                }
                case TIMESTAMP: {
                    val = reader.readTimestamp(this.id);
                    break;
                }
                case TIME: {
                    val = reader.readTime(this.id);
                    break;
                }
                case BYTE_ARR: {
                    val = reader.readByteArray(this.id);
                    break;
                }
                case SHORT_ARR: {
                    val = reader.readShortArray(this.id);
                    break;
                }
                case INT_ARR: {
                    val = reader.readIntArray(this.id);
                    break;
                }
                case LONG_ARR: {
                    val = reader.readLongArray(this.id);
                    break;
                }
                case FLOAT_ARR: {
                    val = reader.readFloatArray(this.id);
                    break;
                }
                case DOUBLE_ARR: {
                    val = reader.readDoubleArray(this.id);
                    break;
                }
                case CHAR_ARR: {
                    val = reader.readCharArray(this.id);
                    break;
                }
                case BOOLEAN_ARR: {
                    val = reader.readBooleanArray(this.id);
                    break;
                }
                case DECIMAL_ARR: {
                    val = reader.readDecimalArray(this.id);
                    break;
                }
                case STRING_ARR: {
                    val = reader.readStringArray(this.id);
                    break;
                }
                case UUID_ARR: {
                    val = reader.readUuidArray(this.id);
                    break;
                }
                case DATE_ARR: {
                    val = reader.readDateArray(this.id);
                    break;
                }
                case TIMESTAMP_ARR: {
                    val = reader.readTimestampArray(this.id);
                    break;
                }
                case TIME_ARR: {
                    val = reader.readTimeArray(this.id);
                    break;
                }
                case OBJECT_ARR: {
                    val = reader.readObjectArray(this.id);
                    break;
                }
                case COL: {
                    val = reader.readCollection(this.id, null);
                    break;
                }
                case MAP: {
                    val = reader.readMap(this.id, null);
                    break;
                }
                case BINARY_OBJ: {
                    val = reader.readBinaryObject(this.id);
                    break;
                }
                case ENUM: {
                    val = reader.readEnum(this.id, this.field.getType());
                    break;
                }
                case ENUM_ARR: {
                    val = reader.readEnumArray(this.id, this.field.getType().getComponentType());
                    break;
                }
                case BINARY_ENUM: {
                    val = reader.readBinaryEnum(this.id);
                    break;
                }
                case BINARY: 
                case OBJECT: {
                    val = reader.readObject(this.id);
                    break;
                }
                case CLASS: {
                    val = reader.readClass(this.id);
                    break;
                }
                default: {
                    assert (false) : "Invalid mode: " + this.mode;
                    break;
                }
            }
            return val;
        }

        protected BinaryWriteMode mode(Object val) {
            return this.dynamic ? (val == null ? BinaryWriteMode.OBJECT : BinaryUtils.mode(val.getClass())) : this.mode;
        }
    }

    private static class DoublePrimitiveAccessor
    extends AbstractPrimitiveAccessor {
        public DoublePrimitiveAccessor(Field field, int id) {
            super(field, id, BinaryWriteMode.P_DOUBLE);
        }

        @Override
        protected void write0(Object obj, BinaryWriterExImpl writer) throws BinaryObjectException {
            writer.writeFieldIdNoSchemaUpdate(this.id);
            double val = GridUnsafe.getDoubleField(obj, this.offset);
            writer.writeDoubleFieldPrimitive(val);
        }

        @Override
        protected void read0(Object obj, BinaryReaderExImpl reader) throws BinaryObjectException {
            double val = reader.readDouble(this.id);
            GridUnsafe.putDoubleField(obj, this.offset, val);
        }
    }

    private static class FloatPrimitiveAccessor
    extends AbstractPrimitiveAccessor {
        public FloatPrimitiveAccessor(Field field, int id) {
            super(field, id, BinaryWriteMode.P_FLOAT);
        }

        @Override
        protected void write0(Object obj, BinaryWriterExImpl writer) throws BinaryObjectException {
            writer.writeFieldIdNoSchemaUpdate(this.id);
            float val = GridUnsafe.getFloatField(obj, this.offset);
            writer.writeFloatFieldPrimitive(val);
        }

        @Override
        protected void read0(Object obj, BinaryReaderExImpl reader) throws BinaryObjectException {
            float val = reader.readFloat(this.id);
            GridUnsafe.putFloatField(obj, this.offset, val);
        }
    }

    private static class LongPrimitiveAccessor
    extends AbstractPrimitiveAccessor {
        public LongPrimitiveAccessor(Field field, int id) {
            super(field, id, BinaryWriteMode.P_LONG);
        }

        @Override
        protected void write0(Object obj, BinaryWriterExImpl writer) throws BinaryObjectException {
            writer.writeFieldIdNoSchemaUpdate(this.id);
            long val = GridUnsafe.getLongField(obj, this.offset);
            writer.writeLongFieldPrimitive(val);
        }

        @Override
        protected void read0(Object obj, BinaryReaderExImpl reader) throws BinaryObjectException {
            long val = reader.readLong(this.id);
            GridUnsafe.putLongField(obj, this.offset, val);
        }
    }

    private static class IntPrimitiveAccessor
    extends AbstractPrimitiveAccessor {
        public IntPrimitiveAccessor(Field field, int id) {
            super(field, id, BinaryWriteMode.P_INT);
        }

        @Override
        protected void write0(Object obj, BinaryWriterExImpl writer) throws BinaryObjectException {
            writer.writeFieldIdNoSchemaUpdate(this.id);
            int val = GridUnsafe.getIntField(obj, this.offset);
            writer.writeIntFieldPrimitive(val);
        }

        @Override
        protected void read0(Object obj, BinaryReaderExImpl reader) throws BinaryObjectException {
            int val = reader.readInt(this.id);
            GridUnsafe.putIntField(obj, this.offset, val);
        }
    }

    private static class CharPrimitiveAccessor
    extends AbstractPrimitiveAccessor {
        public CharPrimitiveAccessor(Field field, int id) {
            super(field, id, BinaryWriteMode.P_CHAR);
        }

        @Override
        protected void write0(Object obj, BinaryWriterExImpl writer) throws BinaryObjectException {
            writer.writeFieldIdNoSchemaUpdate(this.id);
            char val = GridUnsafe.getCharField(obj, this.offset);
            writer.writeCharFieldPrimitive(val);
        }

        @Override
        protected void read0(Object obj, BinaryReaderExImpl reader) throws BinaryObjectException {
            char val = reader.readChar(this.id);
            GridUnsafe.putCharField(obj, this.offset, val);
        }
    }

    private static class ShortPrimitiveAccessor
    extends AbstractPrimitiveAccessor {
        public ShortPrimitiveAccessor(Field field, int id) {
            super(field, id, BinaryWriteMode.P_SHORT);
        }

        @Override
        protected void write0(Object obj, BinaryWriterExImpl writer) throws BinaryObjectException {
            writer.writeFieldIdNoSchemaUpdate(this.id);
            short val = GridUnsafe.getShortField(obj, this.offset);
            writer.writeShortFieldPrimitive(val);
        }

        @Override
        protected void read0(Object obj, BinaryReaderExImpl reader) throws BinaryObjectException {
            short val = reader.readShort(this.id);
            GridUnsafe.putShortField(obj, this.offset, val);
        }
    }

    private static class BooleanPrimitiveAccessor
    extends AbstractPrimitiveAccessor {
        public BooleanPrimitiveAccessor(Field field, int id) {
            super(field, id, BinaryWriteMode.P_BOOLEAN);
        }

        @Override
        protected void write0(Object obj, BinaryWriterExImpl writer) throws BinaryObjectException {
            writer.writeFieldIdNoSchemaUpdate(this.id);
            boolean val = GridUnsafe.getBooleanField(obj, this.offset);
            writer.writeBooleanFieldPrimitive(val);
        }

        @Override
        protected void read0(Object obj, BinaryReaderExImpl reader) throws BinaryObjectException {
            boolean val = reader.readBoolean(this.id);
            GridUnsafe.putBooleanField(obj, this.offset, val);
        }
    }

    private static class BytePrimitiveAccessor
    extends AbstractPrimitiveAccessor {
        public BytePrimitiveAccessor(Field field, int id) {
            super(field, id, BinaryWriteMode.P_BYTE);
        }

        @Override
        protected void write0(Object obj, BinaryWriterExImpl writer) throws BinaryObjectException {
            writer.writeFieldIdNoSchemaUpdate(this.id);
            byte val = GridUnsafe.getByteField(obj, this.offset);
            writer.writeByteFieldPrimitive(val);
        }

        @Override
        protected void read0(Object obj, BinaryReaderExImpl reader) throws BinaryObjectException {
            byte val = reader.readByte(this.id);
            GridUnsafe.putByteField(obj, this.offset, val);
        }
    }

    private static abstract class AbstractPrimitiveAccessor
    extends BinaryFieldAccessor {
        protected final long offset;

        protected AbstractPrimitiveAccessor(Field field, int id, BinaryWriteMode mode) {
            super(field, id, mode);
            this.offset = GridUnsafe.objectFieldOffset(field);
        }
    }
}

