/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.managers.systemview.walker;

import org.apache.ignite.spi.systemview.view.SystemViewRowAttributeWalker;
import org.apache.ignite.spi.systemview.view.sql.SqlTableColumnView;

/**
 * Generated by {@code org.apache.ignite.codegen.SystemViewRowAttributeWalkerGenerator}.
 * {@link SqlTableColumnView} attributes walker.
 * 
 * @see SqlTableColumnView
 */
public class SqlTableColumnViewWalker implements SystemViewRowAttributeWalker<SqlTableColumnView> {
    /** {@inheritDoc} */
    @Override public void visitAll(AttributeVisitor v) {
        v.accept(0, "columnName", String.class);
        v.accept(1, "tableName", String.class);
        v.accept(2, "schemaName", String.class);
        v.accept(3, "affinityColumn", boolean.class);
        v.accept(4, "autoIncrement", boolean.class);
        v.accept(5, "defaultValue", String.class);
        v.accept(6, "nullable", boolean.class);
        v.accept(7, "pk", boolean.class);
        v.accept(8, "precision", int.class);
        v.accept(9, "scale", int.class);
        v.accept(10, "type", Class.class);
    }

    /** {@inheritDoc} */
    @Override public void visitAll(SqlTableColumnView row, AttributeWithValueVisitor v) {
        v.accept(0, "columnName", String.class, row.columnName());
        v.accept(1, "tableName", String.class, row.tableName());
        v.accept(2, "schemaName", String.class, row.schemaName());
        v.acceptBoolean(3, "affinityColumn", row.affinityColumn());
        v.acceptBoolean(4, "autoIncrement", row.autoIncrement());
        v.accept(5, "defaultValue", String.class, row.defaultValue());
        v.acceptBoolean(6, "nullable", row.nullable());
        v.acceptBoolean(7, "pk", row.pk());
        v.acceptInt(8, "precision", row.precision());
        v.acceptInt(9, "scale", row.scale());
        v.accept(10, "type", Class.class, row.type());
    }

    /** {@inheritDoc} */
    @Override public int count() {
        return 11;
    }
}
