/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.yardstick.cache;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.yardstick.cache.IgniteCacheAbstractBenchmark;
import org.apache.ignite.yardstick.cache.model.Person;
import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkUtils;

public class IgniteJdbcSqlQueryBenchmark
extends IgniteCacheAbstractBenchmark<Integer, Object> {
    Set<PreparedStatement> stms = Collections.synchronizedSet(new HashSet());

    @Override
    public void setUp(BenchmarkConfiguration cfg) throws Exception {
        super.setUp(cfg);
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)"Populating query data...");
        long start = System.nanoTime();
        try (IgniteDataStreamer dataLdr = this.ignite().dataStreamer(this.cache.getName());){
            for (int i = 0; i < this.args.range() && !Thread.currentThread().isInterrupted(); ++i) {
                dataLdr.addData((Object)i, (Object)new Person(i, "firstName" + i, "lastName" + i, i * 1000));
                if (i % 100000 != 0) continue;
                BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Populated persons: " + i));
            }
        }
        BenchmarkUtils.println((BenchmarkConfiguration)cfg, (String)("Finished populating query data in " + (System.nanoTime() - start) / 1000000L + " ms."));
    }

    public boolean test(Map<Object, Object> ctx) throws Exception {
        PreparedStatement stm = (PreparedStatement)ctx.get(0);
        if (stm == null) {
            stm = this.createStatement();
            this.stms.add(stm);
            ctx.put(0, stm);
        }
        double salary = ThreadLocalRandom.current().nextDouble() * (double)this.args.range() * 1000.0;
        double maxSalary = salary + 1000.0;
        stm.clearParameters();
        stm.setDouble(1, salary);
        stm.setDouble(2, maxSalary);
        ResultSet rs = stm.executeQuery();
        while (rs.next()) {
            double sal = rs.getDouble("salary");
            if (!(sal < salary) && !(sal > maxSalary)) continue;
            throw new Exception("Invalid person retrieved [min=" + salary + ", max=" + maxSalary + "]");
        }
        return true;
    }

    @Override
    public void tearDown() throws Exception {
        for (PreparedStatement stm : this.stms) {
            try {
                stm.getConnection().close();
                stm.close();
            }
            catch (Exception ignore) {
                BenchmarkUtils.println((String)("Failed to close connection." + stm));
            }
        }
        super.tearDown();
    }

    private PreparedStatement createStatement() throws Exception {
        Class.forName("org.apache.ignite.IgniteJdbcDriver");
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(this.args.jdbcUrl());
            return conn.prepareStatement("select * from Person where salary >= ? and salary <= ?");
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            throw new IgniteException("Failed to create prepare statement.", (Throwable)e);
        }
    }

    @Override
    protected IgniteCache<Integer, Object> cache() {
        return this.ignite().cache("query");
    }
}

