/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.Collection;
import java.util.Set;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.query.GridQueryRowDescriptor;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.h2.value.DataType;
import org.jetbrains.annotations.Nullable;

public class GridH2RowDescriptor
implements GridQueryRowDescriptor {
    private volatile int[] fieldTypes;
    private final int keyType;
    private final int valType;
    private final GridQueryRowDescriptor delegate;

    public GridH2RowDescriptor(GridQueryRowDescriptor delegate) {
        this.delegate = delegate;
        this.keyType = DataType.getTypeFromClass((Class)delegate.type().keyClass());
        this.valType = DataType.getTypeFromClass((Class)delegate.type().valueClass());
        this.updateFieldTypes();
    }

    public void onMetadataUpdated() {
        this.delegate.onMetadataUpdated();
        this.updateFieldTypes();
    }

    private void updateFieldTypes() {
        Collection classes = this.delegate.type().fields().values();
        this.fieldTypes = new int[classes.size()];
        int fieldIdx = 0;
        for (Class cls : classes) {
            this.fieldTypes[fieldIdx++] = DataType.getTypeFromClass((Class)cls);
        }
    }

    public GridQueryTypeDescriptor type() {
        return this.delegate.type();
    }

    @Nullable
    public GridCacheContext<?, ?> context() {
        return this.delegate.context();
    }

    public int keyType() {
        return this.keyType;
    }

    public int valueType() {
        return this.valType;
    }

    public int fieldType(int fieldIdx) {
        return this.fieldTypes[fieldIdx];
    }

    public int fieldsCount() {
        return this.delegate.fieldsCount();
    }

    public Object getFieldValue(Object key, Object val, int fieldIdx) {
        return this.delegate.getFieldValue(key, val, fieldIdx);
    }

    public void setFieldValue(Object key, Object val, Object fieldVal, int fieldIdx) {
        this.delegate.setFieldValue(key, val, fieldVal, fieldIdx);
    }

    public boolean isFieldKeyProperty(int fieldIdx) {
        return this.delegate.isFieldKeyProperty(fieldIdx);
    }

    public boolean isKeyColumn(int colId) {
        return this.delegate.isKeyColumn(colId);
    }

    public boolean isValueColumn(int colId) {
        return this.delegate.isValueColumn(colId);
    }

    public int getAlternativeColumnId(int colId) {
        return this.delegate.getAlternativeColumnId(colId);
    }

    public Set<String> getRowKeyColumnNames() {
        return this.delegate.getRowKeyColumnNames();
    }
}

