/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.zk.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.discovery.zk.internal.ZookeeperClusterNode;

public class ZkClusterNodes {
    final ConcurrentSkipListMap<Long, ZookeeperClusterNode> nodesByOrder = new ConcurrentSkipListMap();
    final ConcurrentSkipListMap<Long, ZookeeperClusterNode> nodesByInternalId = new ConcurrentSkipListMap();
    final ConcurrentHashMap<UUID, ZookeeperClusterNode> nodesById = new ConcurrentHashMap();

    public Collection<ClusterNode> remoteNodes() {
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>();
        for (ClusterNode clusterNode : this.nodesById.values()) {
            if (clusterNode.isLocal()) continue;
            nodes.add(clusterNode);
        }
        return nodes;
    }

    public boolean isAllNodes(IgnitePredicate<ClusterNode> p) {
        for (ZookeeperClusterNode node : this.nodesById.values()) {
            if (p.apply((Object)node)) continue;
            return false;
        }
        return true;
    }

    List<ClusterNode> topologySnapshot() {
        return new ArrayList<ZookeeperClusterNode>(this.nodesByOrder.values());
    }

    void addNode(ZookeeperClusterNode node) {
        assert (node.id() != null) : node;
        assert (node.order() > 0L) : node;
        ZookeeperClusterNode old = this.nodesById.put(node.id(), node);
        assert (old == null) : old;
        old = this.nodesByOrder.put(node.order(), node);
        assert (old == null) : old;
        old = this.nodesByInternalId.put(node.internalId(), node);
        assert (old == null) : old;
    }

    ZookeeperClusterNode removeNode(long internalId) {
        ZookeeperClusterNode node = this.nodesByInternalId.remove(internalId);
        assert (node != null) : internalId;
        assert (node.order() > 0L) : node;
        ZookeeperClusterNode rvmd = this.nodesByOrder.remove(node.order());
        assert (rvmd != null);
        rvmd = this.nodesById.remove(node.id());
        assert (rvmd != null);
        return node;
    }
}

