/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.tracker;

import org.apache.ignite.internal.processors.query.calcite.exec.tracker.MemoryTracker;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.NoOpMemoryTracker;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.NoOpRowTracker;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.ObjectSizeCalculator;
import org.apache.ignite.internal.processors.query.calcite.exec.tracker.RowTracker;

public class ExecutionNodeMemoryTracker<Row>
implements RowTracker<Row> {
    static final long BATCH_SIZE = 65536L;
    private final MemoryTracker qryMemoryTracker;
    private final ObjectSizeCalculator<Row> sizeCalculator = new ObjectSizeCalculator();
    private long allocated;
    private long prevReported;
    private final long rowOverhead;

    public static <T> RowTracker<T> create(MemoryTracker qryMemoryTracker, long rowOverhead) {
        if (qryMemoryTracker == NoOpMemoryTracker.INSTANCE) {
            return NoOpRowTracker.instance();
        }
        return new ExecutionNodeMemoryTracker(qryMemoryTracker, rowOverhead);
    }

    ExecutionNodeMemoryTracker(MemoryTracker qryMemoryTracker, long rowOverhead) {
        this.qryMemoryTracker = qryMemoryTracker;
        this.rowOverhead = rowOverhead;
    }

    @Override
    public void onRowAdded(Row obj) {
        long size = this.sizeCalculator.sizeOf(obj);
        long newAllocated = this.allocated + (size += this.rowOverhead);
        if (newAllocated > this.prevReported) {
            long newReported = newAllocated + 65535L & 0xFFFFFFFFFFFF0000L;
            this.qryMemoryTracker.onMemoryAllocated(newReported - this.prevReported);
            this.prevReported = newReported;
        }
        this.allocated = newAllocated;
    }

    @Override
    public void onRowRemoved(Row obj) {
        long size = this.sizeCalculator.sizeOf(obj);
        size += this.rowOverhead;
        if ((size = Math.min(size, this.allocated)) > 0L) {
            long newAllocated = this.allocated - size;
            if (newAllocated <= this.prevReported - 65536L) {
                long newReported = newAllocated + 65535L & 0xFFFFFFFFFFFF0000L;
                this.qryMemoryTracker.onMemoryReleased(this.prevReported - newReported);
                this.prevReported = newReported;
            }
            this.allocated = newAllocated;
        }
    }

    @Override
    public void reset() {
        if (this.prevReported > 0L) {
            this.qryMemoryTracker.onMemoryReleased(this.prevReported);
        }
        this.allocated = 0L;
    }
}

