/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec.partition;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.ignite.internal.processors.query.calcite.exec.partition.PartitionAllNode;
import org.apache.ignite.internal.processors.query.calcite.exec.partition.PartitionNode;
import org.apache.ignite.internal.processors.query.calcite.exec.partition.PartitionNoneNode;
import org.apache.ignite.internal.processors.query.calcite.exec.partition.PartitionPruningContext;

public class PartitionOperandNode
implements PartitionNode {
    private final Operand op;
    private final List<PartitionNode> operands;

    private PartitionOperandNode(Operand op, List<PartitionNode> operands) {
        this.op = op;
        this.operands = Collections.unmodifiableList(operands);
    }

    @Override
    public Collection<Integer> apply(PartitionPruningContext ctx) {
        HashSet<Integer> allParts = null;
        if (this.op == Operand.AND) {
            for (PartitionNode operand : this.operands) {
                Collection<Integer> parts;
                if (operand == PartitionAllNode.IGNORE || (parts = operand.apply(ctx)) == null) continue;
                if (allParts == null) {
                    allParts = new HashSet<Integer>(parts);
                    continue;
                }
                allParts.retainAll(parts);
            }
        } else {
            for (PartitionNode operand : this.operands) {
                if (operand == PartitionAllNode.IGNORE) continue;
                Collection<Integer> parts = operand.apply(ctx);
                if (parts == null) {
                    return null;
                }
                if (allParts == null) {
                    allParts = new HashSet<Integer>(parts);
                    continue;
                }
                allParts.addAll(parts);
            }
        }
        return allParts != null ? Collections.unmodifiableCollection(allParts) : null;
    }

    public static PartitionNode createAndOperandNode(List<PartitionNode> operands) {
        if (operands.stream().anyMatch(n -> n == PartitionNoneNode.INSTANCE)) {
            return PartitionNoneNode.INSTANCE;
        }
        return new PartitionOperandNode(Operand.AND, operands);
    }

    public static PartitionNode createOrOperandNode(List<PartitionNode> operands) {
        if (operands.stream().anyMatch(n -> n == PartitionAllNode.INSTANCE)) {
            return PartitionAllNode.INSTANCE;
        }
        return new PartitionOperandNode(Operand.OR, operands);
    }

    private static enum Operand {
        AND,
        OR;

    }
}

