/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import com.google.common.primitives.Primitives;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.internal.processors.query.calcite.exec.partition.PartitionAllNode;
import org.apache.ignite.internal.processors.query.calcite.exec.partition.PartitionLiteralNode;
import org.apache.ignite.internal.processors.query.calcite.exec.partition.PartitionNode;
import org.apache.ignite.internal.processors.query.calcite.exec.partition.PartitionNoneNode;
import org.apache.ignite.internal.processors.query.calcite.exec.partition.PartitionOperandNode;
import org.apache.ignite.internal.processors.query.calcite.exec.partition.PartitionParameterNode;
import org.apache.ignite.internal.processors.query.calcite.prepare.Fragment;
import org.apache.ignite.internal.processors.query.calcite.prepare.IgniteRelShuttle;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteIndexScan;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteReceiver;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteRel;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteSender;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTableScan;
import org.apache.ignite.internal.processors.query.calcite.rel.IgniteTrimExchange;
import org.apache.ignite.internal.processors.query.calcite.rel.ProjectableFilterableTableScan;
import org.apache.ignite.internal.processors.query.calcite.schema.CacheTableDescriptor;
import org.apache.ignite.internal.processors.query.calcite.schema.IgniteTable;
import org.apache.ignite.internal.processors.query.calcite.type.IgniteTypeFactory;
import org.apache.ignite.internal.processors.query.calcite.util.Commons;

public class PartitionExtractor
extends IgniteRelShuttle {
    private final IgniteTypeFactory typeFactory;
    private final Deque<PartitionNode> stack = new ArrayDeque<PartitionNode>();

    public PartitionExtractor(IgniteTypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    @Override
    public IgniteRel visit(IgniteIndexScan rel) {
        this.processScan(rel);
        return rel;
    }

    @Override
    public IgniteRel visit(IgniteTableScan rel) {
        this.processScan(rel);
        return rel;
    }

    @Override
    public IgniteRel visit(IgniteTrimExchange rel) {
        this.stack.push(PartitionAllNode.IGNORE);
        return rel;
    }

    @Override
    public IgniteRel visit(IgniteReceiver rel) {
        this.stack.push(PartitionAllNode.IGNORE);
        return rel;
    }

    @Override
    protected IgniteRel processNode(IgniteRel rel) {
        IgniteRel res = super.processNode(rel);
        if (rel.getInputs().size() > 1) {
            ArrayList<PartitionNode> operands = new ArrayList<PartitionNode>();
            for (int i = 0; i < rel.getInputs().size(); ++i) {
                operands.add(this.stack.pop());
            }
            this.stack.push(PartitionOperandNode.createOrOperandNode(operands));
        } else if (rel.getInputs().isEmpty()) {
            this.stack.push(PartitionAllNode.INSTANCE);
        }
        return res;
    }

    public PartitionNode go(Fragment fragment) {
        if (!(fragment.root() instanceof IgniteSender)) {
            return PartitionAllNode.INSTANCE;
        }
        if (fragment.mapping() == null || !fragment.mapping().colocated()) {
            return PartitionAllNode.INSTANCE;
        }
        this.processNode(fragment.root());
        if (this.stack.isEmpty()) {
            return PartitionAllNode.INSTANCE;
        }
        return this.stack.pop();
    }

    private void processScan(IgniteRel rel) {
        assert (rel instanceof ProjectableFilterableTableScan);
        RexNode condition = ((ProjectableFilterableTableScan)((Object)rel)).condition();
        IgniteTable tbl = (IgniteTable)rel.getTable().unwrap(IgniteTable.class);
        if (!tbl.distribution().function().affinity() || tbl.distribution().getKeys().size() != 1) {
            this.stack.push(PartitionAllNode.INSTANCE);
            return;
        }
        ImmutableIntList keys = tbl.distribution().getKeys();
        RelDataType rowType = tbl.getRowType((RelDataTypeFactory)this.typeFactory);
        int cacheId = ((CacheTableDescriptor)tbl.descriptor()).cacheInfo().cacheId();
        ArrayList types = new ArrayList(rowType.getFieldCount());
        for (RelDataTypeField field : rowType.getFieldList()) {
            if ("_KEY".equals(field.getName())) {
                keys = keys.append(field.getIndex());
            }
            types.add(Primitives.wrap((Class)((Class)this.typeFactory.getJavaClass(field.getType()))));
        }
        List requiredCols = ((ProjectableFilterableTableScan)((Object)rel)).requiredColumns() != null ? ((ProjectableFilterableTableScan)((Object)rel)).requiredColumns().asList() : Collections.emptyList();
        PartitionNode partNode = this.processCondition(condition, types, keys, requiredCols, cacheId);
        this.stack.push(partNode);
    }

    private PartitionNode processCondition(RexNode condition, List<Class<?>> types, ImmutableIntList keys, List<Integer> requiredCols, int cacheId) {
        if (!(condition instanceof RexCall)) {
            return PartitionAllNode.INSTANCE;
        }
        SqlKind opKind = condition.getKind();
        List operands = ((RexCall)condition).getOperands();
        switch (opKind) {
            case IS_NULL: {
                RexNode left = (RexNode)operands.get(0);
                if (!left.isA(SqlKind.LOCAL_REF)) {
                    return PartitionAllNode.INSTANCE;
                }
                int idx = ((RexLocalRef)left).getIndex();
                if (!requiredCols.isEmpty()) {
                    idx = requiredCols.get(idx);
                }
                if (!keys.contains((Object)idx)) {
                    return PartitionAllNode.INSTANCE;
                }
                return PartitionNoneNode.INSTANCE;
            }
            case EQUALS: {
                RexNode right;
                RexNode left;
                if (operands.size() != 2) {
                    return PartitionAllNode.INSTANCE;
                }
                if (((RexNode)operands.get(0)).isA(SqlKind.LOCAL_REF)) {
                    left = (RexNode)operands.get(0);
                    right = (RexNode)operands.get(1);
                } else {
                    left = (RexNode)operands.get(1);
                    right = (RexNode)operands.get(0);
                }
                if (!left.isA(SqlKind.LOCAL_REF)) {
                    return PartitionAllNode.INSTANCE;
                }
                if (!right.isA(SqlKind.LITERAL) && !right.isA(SqlKind.DYNAMIC_PARAM)) {
                    return PartitionAllNode.INSTANCE;
                }
                int idx = ((RexLocalRef)left).getIndex();
                if (!requiredCols.isEmpty()) {
                    idx = requiredCols.get(idx);
                }
                if (!keys.contains((Object)idx)) {
                    return PartitionAllNode.INSTANCE;
                }
                Class<?> fldType = types.get(idx);
                if (right.isA(SqlKind.LITERAL)) {
                    return new PartitionLiteralNode(cacheId, (RexLiteral)right, fldType);
                }
                return new PartitionParameterNode(cacheId, (RexDynamicParam)right, fldType);
            }
            case SEARCH: {
                RexNode condition0 = RexUtil.expandSearch((RexBuilder)Commons.emptyCluster().getRexBuilder(), null, (RexNode)condition);
                return this.processCondition(condition0, types, keys, requiredCols, cacheId);
            }
            case OR: 
            case AND: {
                List<PartitionNode> operands0 = ((RexCall)condition).getOperands().stream().map(node -> this.processCondition((RexNode)node, types, keys, requiredCols, cacheId)).collect(Collectors.toList());
                return opKind == SqlKind.OR ? PartitionOperandNode.createOrOperandNode(operands0) : PartitionOperandNode.createAndOperandNode(operands0);
            }
        }
        return PartitionAllNode.INSTANCE;
    }
}

