/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.cache.ClientCacheDataRequest;
import org.apache.ignite.internal.processors.platform.client.tx.ClientTxAwareRequest;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.internal.util.typedef.internal.U;

public class ClientCacheRemoveAllConflictRequest
extends ClientCacheDataRequest
implements ClientTxAwareRequest {
    private final Map<KeyCacheObject, GridCacheVersion> map;

    public ClientCacheRemoveAllConflictRequest(BinaryReaderExImpl reader) {
        super(reader);
        int cnt = reader.readInt();
        this.map = new LinkedHashMap<KeyCacheObject, GridCacheVersion>(cnt);
        for (int i = 0; i < cnt; ++i) {
            KeyCacheObject key = (KeyCacheObject)PlatformUtils.readCacheObject(reader, true);
            GridCacheVersion ver = (GridCacheVersion)reader.readObjectDetached();
            this.map.put(key, ver);
        }
    }

    @Override
    public ClientResponse process(ClientConnectionContext ctx) {
        try {
            this.cachex(ctx).removeAllConflict(this.map);
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
        return super.process(ctx);
    }
}

