/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query.reducer;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.query.reducer.NodePageStream;
import org.apache.ignite.internal.util.lang.GridIteratorAdapter;

public abstract class CacheQueryReducer<T>
extends GridIteratorAdapter<T> {
    private static final long serialVersionUID = 0L;
    protected final Map<UUID, NodePageStream<T>> pageStreams;

    protected CacheQueryReducer(Map<UUID, NodePageStream<T>> pageStreams) {
        this.pageStreams = pageStreams;
    }

    @Override
    public void removeX() throws IgniteCheckedException {
        throw new UnsupportedOperationException("CacheQueryReducer doesn't support removing items.");
    }

    public static <T> T get(CompletableFuture<?> fut) throws IgniteCheckedException {
        try {
            return (T)fut.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IgniteCheckedException("Query was interrupted.", e);
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof IgniteCheckedException) {
                throw (IgniteCheckedException)t;
            }
            throw new IgniteCheckedException("Page future was completed with unexpected error.", e);
        }
    }
}

