/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.aware;

import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.wal.aware.SegmentObservable;

class SegmentCurrentStateStorage
extends SegmentObservable {
    private volatile boolean interrupted;
    private volatile boolean forceInterrupted;
    private final int walSegmentsCnt;
    private volatile long curAbsWalIdx = -1L;
    private volatile long lastAbsArchivedIdx = -1L;

    SegmentCurrentStateStorage(int walSegmentsCnt) {
        this.walSegmentsCnt = walSegmentsCnt;
    }

    synchronized void awaitSegment(long absSegIdx) throws IgniteInterruptedCheckedException {
        try {
            while (this.curAbsWalIdx < absSegIdx && !this.interrupted) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            throw new IgniteInterruptedCheckedException(e);
        }
        this.checkInterrupted();
    }

    synchronized long waitNextSegmentForArchivation() throws IgniteInterruptedCheckedException {
        this.awaitSegment(this.lastAbsArchivedIdx + 2L);
        return this.lastAbsArchivedIdx + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long nextAbsoluteSegmentIndex() throws IgniteInterruptedCheckedException {
        long nextAbsIdx;
        SegmentCurrentStateStorage segmentCurrentStateStorage = this;
        synchronized (segmentCurrentStateStorage) {
            try {
                while (this.curAbsWalIdx + 1L - this.lastAbsArchivedIdx > (long)this.walSegmentsCnt && !this.forceInterrupted) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new IgniteInterruptedCheckedException(e);
            }
            if (this.forceInterrupted) {
                throw new IgniteInterruptedCheckedException("Interrupt waiting of change archived idx");
            }
            nextAbsIdx = ++this.curAbsWalIdx;
            this.notifyAll();
        }
        this.notifyObservers(nextAbsIdx);
        return nextAbsIdx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void curAbsWalIdx(long curAbsWalIdx) {
        SegmentCurrentStateStorage segmentCurrentStateStorage = this;
        synchronized (segmentCurrentStateStorage) {
            this.curAbsWalIdx = curAbsWalIdx;
            this.notifyAll();
        }
        this.notifyObservers(curAbsWalIdx);
    }

    long curAbsWalIdx() {
        return this.curAbsWalIdx;
    }

    synchronized void interrupt() {
        this.interrupted = true;
        this.notifyAll();
    }

    synchronized void forceInterrupt() {
        this.interrupted = true;
        this.forceInterrupted = true;
        this.notifyAll();
    }

    synchronized void onSegmentArchived(long lastAbsArchivedIdx) {
        this.lastAbsArchivedIdx = lastAbsArchivedIdx;
        this.notifyAll();
    }

    private void checkInterrupted() throws IgniteInterruptedCheckedException {
        if (this.interrupted) {
            throw new IgniteInterruptedCheckedException("Interrupt waiting of change current idx");
        }
    }

    public void reset() {
        this.interrupted = false;
        this.forceInterrupted = false;
    }
}

