// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package utils

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
)

type awsctxkey struct{}

// WithAwsConfig returns a new context with the given AWS config
func WithAwsConfig(ctx context.Context, cfg *aws.Config) context.Context {
	return context.WithValue(ctx, awsctxkey{}, cfg)
}

// GetAwsConfig returns the AWS config from the given context. Returns
// nil if no config is set.
func GetAwsConfig(ctx context.Context) *aws.Config {
	if v := ctx.Value(awsctxkey{}); v != nil {
		return v.(*aws.Config)
	}

	return nil
}
