/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.cassandra;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.store.BackendSession;
import org.apache.hugegraph.backend.store.BackendSessionPool;
import org.apache.hugegraph.backend.store.cassandra.CassandraOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.util.E;

public class CassandraSessionPool
extends BackendSessionPool {
    private static final int SECOND = 1000;
    private Cluster cluster = null;
    private final String keyspace;

    public CassandraSessionPool(HugeConfig config, String keyspace, String store) {
        super(config, keyspace + "/" + store);
        this.keyspace = keyspace;
    }

    public synchronized void open() {
        if (this.opened()) {
            throw new BackendException("Please close the old SessionPool before opening a new one");
        }
        HugeConfig config = this.config();
        String hosts = (String)config.get(CassandraOptions.CASSANDRA_HOST);
        int port = (Integer)config.get(CassandraOptions.CASSANDRA_PORT);
        assert (this.cluster == null || this.cluster.isClosed());
        Cluster.Builder builder = Cluster.builder().addContactPoints(hosts.split(",")).withoutMetrics().withPort(port);
        int connTimeout = (Integer)config.get(CassandraOptions.CASSANDRA_CONN_TIMEOUT);
        int readTimeout = (Integer)config.get(CassandraOptions.CASSANDRA_READ_TIMEOUT);
        SocketOptions socketOptions = new SocketOptions();
        socketOptions.setConnectTimeoutMillis(connTimeout * 1000);
        socketOptions.setReadTimeoutMillis(readTimeout * 1000);
        builder.withSocketOptions(socketOptions);
        String username = (String)config.get(CassandraOptions.CASSANDRA_USERNAME);
        String password = (String)config.get(CassandraOptions.CASSANDRA_PASSWORD);
        if (!username.isEmpty()) {
            builder.withCredentials(username, password);
        }
        String compression = (String)config.get(CassandraOptions.CASSANDRA_COMPRESSION);
        builder.withCompression(ProtocolOptions.Compression.valueOf((String)compression.toUpperCase()));
        this.cluster = builder.build();
    }

    public final synchronized boolean opened() {
        return this.cluster != null && !this.cluster.isClosed();
    }

    protected final synchronized Cluster cluster() {
        E.checkState((this.cluster != null ? 1 : 0) != 0, (String)"Cassandra cluster has not been initialized", (Object[])new Object[0]);
        return this.cluster;
    }

    public final Session session() {
        return (Session)super.getOrNewSession();
    }

    protected Session newSession() {
        E.checkState((this.cluster != null ? 1 : 0) != 0, (String)"Cassandra cluster has not been initialized", (Object[])new Object[0]);
        return new Session();
    }

    protected synchronized void doClose() {
        if (this.cluster != null && !this.cluster.isClosed()) {
            this.cluster.close();
        }
    }

    public final boolean clusterConnected() {
        E.checkState((this.cluster != null ? 1 : 0) != 0, (String)"Cassandra cluster has not been initialized", (Object[])new Object[0]);
        return !this.cluster.isClosed();
    }

    public final class Session
    extends BackendSession.AbstractBackendSession {
        private com.datastax.driver.core.Session session = null;
        private BatchStatement batch = new BatchStatement();

        public BatchStatement add(Statement statement) {
            return this.batch.add(statement);
        }

        public void rollback() {
            this.batch.clear();
        }

        public ResultSet commit() {
            ResultSet rs = this.session.execute((Statement)this.batch);
            this.batch.clear();
            return rs;
        }

        public void commitAsync() {
            Collection statements = this.batch.getStatements();
            int count = 0;
            int processors = Math.min(statements.size(), 1023);
            ArrayList<ResultSetFuture> results = new ArrayList<ResultSetFuture>(processors + 1);
            for (Statement s : statements) {
                ResultSetFuture future = this.session.executeAsync(s);
                results.add(future);
                if (++count <= processors) continue;
                results.forEach(ResultSetFuture::getUninterruptibly);
                results.clear();
                count = 0;
            }
            for (ResultSetFuture future : results) {
                future.getUninterruptibly();
            }
            this.batch.clear();
        }

        public ResultSet query(Statement statement) {
            assert (!this.hasChanges());
            return this.execute(statement);
        }

        public ResultSet execute(Statement statement) {
            return this.session.execute(statement);
        }

        public ResultSet execute(String statement) {
            return this.session.execute(statement);
        }

        public ResultSet execute(String statement, Object ... args) {
            return this.session.execute(statement, args);
        }

        private void tryOpen() {
            assert (this.session == null);
            try {
                this.open();
            }
            catch (InvalidQueryException invalidQueryException) {
                // empty catch block
            }
        }

        public void open() {
            this.opened = true;
            assert (this.session == null);
            this.session = CassandraSessionPool.this.cluster().connect(this.keyspace());
        }

        public boolean opened() {
            if (this.opened && this.session == null) {
                this.tryOpen();
            }
            return this.opened && this.session != null;
        }

        public boolean closed() {
            if (!this.opened || this.session == null) {
                return true;
            }
            return this.session.isClosed();
        }

        public void close() {
            assert (this.closeable());
            if (this.session == null) {
                return;
            }
            this.session.close();
            this.session = null;
        }

        public boolean hasChanges() {
            return this.batch.size() > 0;
        }

        public Collection<Statement> statements() {
            return this.batch.getStatements();
        }

        public String keyspace() {
            return CassandraSessionPool.this.keyspace;
        }

        public Metadata metadata() {
            return CassandraSessionPool.this.cluster.getMetadata();
        }

        public int aggregateTimeout() {
            HugeConfig conf = CassandraSessionPool.this.config();
            return (Integer)conf.get(CassandraOptions.AGGR_TIMEOUT);
        }
    }
}

