/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.id;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.TimeUtil;
import org.slf4j.Logger;

public class SnowflakeIdGenerator
extends IdGenerator {
    private static final Logger LOG = Log.logger(SnowflakeIdGenerator.class);
    private static final Map<String, SnowflakeIdGenerator> INSTANCES = new ConcurrentHashMap<String, SnowflakeIdGenerator>();
    private final boolean forceString;
    private final IdWorker idWorker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SnowflakeIdGenerator init(HugeGraphParams graph) {
        String graphName = graph.name();
        SnowflakeIdGenerator generator = INSTANCES.get(graphName);
        if (generator == null) {
            Map<String, SnowflakeIdGenerator> map = INSTANCES;
            synchronized (map) {
                if (!INSTANCES.containsKey(graphName)) {
                    HugeConfig conf = graph.configuration();
                    INSTANCES.put(graphName, new SnowflakeIdGenerator(conf));
                }
                generator = INSTANCES.get(graphName);
                assert (generator != null);
            }
        }
        return generator;
    }

    public static SnowflakeIdGenerator instance(HugeGraph graph) {
        String graphName = graph.name();
        SnowflakeIdGenerator generator = INSTANCES.get(graphName);
        E.checkState((generator != null ? 1 : 0) != 0, (String)"SnowflakeIdGenerator of graph '%s' is not initialized", (Object[])new Object[]{graphName});
        return generator;
    }

    private SnowflakeIdGenerator(HugeConfig config) {
        long workerId = (Long)config.get(CoreOptions.SNOWFLAKE_WORKER_ID);
        long datacenterId = (Long)config.get(CoreOptions.SNOWFLAKE_DATACENTER_ID);
        this.forceString = (Boolean)config.get(CoreOptions.SNOWFLAKE_FORCE_STRING);
        this.idWorker = new IdWorker(workerId, datacenterId);
        LOG.debug("SnowflakeId Worker started: datacenter id {}, worker id {}, forced string id {}", new Object[]{datacenterId, workerId, this.forceString});
    }

    public Id generate() {
        if (this.idWorker == null) {
            throw new HugeException("Please initialize before using");
        }
        Id id = SnowflakeIdGenerator.of(this.idWorker.nextId());
        if (!this.forceString) {
            return id;
        }
        return IdGenerator.of(id.asString());
    }

    @Override
    public Id generate(HugeVertex vertex) {
        return this.generate();
    }

    private static class IdWorker {
        private final long workerId;
        private final long datacenterId;
        private long sequence = 0L;
        private long lastTimestamp = -1L;
        private static final long WORKER_BIT = 5L;
        private static final long MAX_WORKER_ID = 31L;
        private static final long DC_BIT = 5L;
        private static final long MAX_DC_ID = 31L;
        private static final long SEQUENCE_BIT = 12L;
        private static final long SEQUENCE_MASK = 4095L;
        private static final long WORKER_SHIFT = 12L;
        private static final long DC_SHIFT = 17L;
        private static final long TIMESTAMP_SHIFT = 22L;

        public IdWorker(long workerId, long datacenterId) {
            if (workerId > 31L || workerId < 0L) {
                throw new IllegalArgumentException(String.format("Worker id can't > %d or < 0", 31L));
            }
            if (datacenterId > 31L || datacenterId < 0L) {
                throw new IllegalArgumentException(String.format("Datacenter id can't > %d or < 0", 31L));
            }
            this.workerId = workerId;
            this.datacenterId = datacenterId;
            LOG.debug("Id Worker starting. timestamp left shift {},datacenter id bits {}, worker id bits {},sequence bits {}", new Object[]{22L, 5L, 5L, 12L});
        }

        public synchronized long nextId() {
            long timestamp = TimeUtil.timeGen();
            if (timestamp > this.lastTimestamp) {
                this.sequence = 0L;
            } else if (timestamp == this.lastTimestamp) {
                this.sequence = this.sequence + 1L & 0xFFFL;
                if (this.sequence == 0L) {
                    timestamp = TimeUtil.tillNextMillis((long)this.lastTimestamp);
                }
            } else {
                LOG.error("Clock is moving backwards, rejecting requests until {}.", (Object)this.lastTimestamp);
                throw new HugeException("Clock moved backwards. Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp);
            }
            this.lastTimestamp = timestamp;
            return timestamp << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence;
        }
    }
}

