/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.graph;

import org.psjava.ds.Collection;
import org.psjava.ds.array.DynamicArray;
import org.psjava.ds.graph.BipartiteGraph;
import org.psjava.ds.graph.BipartiteGraphEdge;
import org.psjava.ds.graph.SimpleBipartiteGraphEdge;
import org.psjava.ds.set.MutableSet;
import org.psjava.goods.GoodMutableSetFactory;
import org.psjava.util.AssertStatus;
import org.psjava.util.IterableToString;

public class MutableBipartiteGraph<V>
implements BipartiteGraph<V> {
    private MutableSet<V> left = GoodMutableSetFactory.getInstance().create();
    private MutableSet<V> right = GoodMutableSetFactory.getInstance().create();
    private DynamicArray<BipartiteGraphEdge<V>> edges = DynamicArray.create();

    public static <V> MutableBipartiteGraph<V> create() {
        return new MutableBipartiteGraph<V>();
    }

    public void insertLeftVertex(V v) {
        AssertStatus.assertTrue(!this.right.contains(v));
        this.left.addIfAbsent(v);
    }

    public void insertRightVertex(V v) {
        AssertStatus.assertTrue(!this.left.contains(v));
        this.right.addIfAbsent(v);
    }

    public void addEdge(V leftv, V rightv) {
        this.assertVertexExist(leftv, this.left);
        this.assertVertexExist(rightv, this.right);
        this.edges.addToLast(SimpleBipartiteGraphEdge.create(leftv, rightv));
    }

    private void assertVertexExist(V v, MutableSet<V> set) {
        AssertStatus.assertTrue(set.contains(v), "vertex is not in graph");
    }

    @Override
    public Collection<V> getLeftVertices() {
        return this.left;
    }

    @Override
    public Collection<V> getRightVertices() {
        return this.right;
    }

    @Override
    public Iterable<BipartiteGraphEdge<V>> getEdges() {
        return this.edges;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + IterableToString.toString(this.getEdges());
    }
}

