/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.output.hg.task;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.output.hg.metrics.LoadSummary;
import org.apache.hugegraph.computer.core.output.hg.task.InsertTask;
import org.apache.hugegraph.computer.core.output.hg.task.TaskManager;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.structure.graph.Vertex;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class SingleInsertTask
extends InsertTask {
    private static final Logger LOG = Log.logger(TaskManager.class);

    public SingleInsertTask(Config config, HugeClient client, List<Vertex> batch, LoadSummary loadSummary) {
        super(config, client, batch, loadSummary);
    }

    @Override
    public void run() {
        for (Vertex vertex : this.batch) {
            try {
                this.insertSingle(vertex);
                this.increaseLoadSuccess();
            }
            catch (Exception e) {
                this.metrics().increaseInsertFailure();
                this.handleInsertFailure(e);
            }
        }
    }

    private void handleInsertFailure(Exception e) {
        LOG.error("Single insert error", e);
    }

    private void insertSingle(Vertex vertex) {
        this.insertBatch(ImmutableList.of(vertex));
    }
}

