/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.rpc;

import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.manager.Manager;
import org.apache.hugegraph.computer.core.rpc.AggregateRpcService;
import org.apache.hugegraph.computer.core.rpc.InputSplitRpcService;
import org.apache.hugegraph.config.RpcOptions;
import org.apache.hugegraph.rpc.RpcClientProvider;
import org.apache.hugegraph.rpc.RpcConsumerConfig;

public class WorkerRpcManager
implements Manager {
    public static final String NAME = "worker_rpc";
    private RpcClientProvider rpcClient = null;

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(Config config) {
        if (this.rpcClient != null) {
            return;
        }
        this.rpcClient = new RpcClientProvider(config.hugeConfig());
    }

    @Override
    public void close(Config config) {
        this.rpcClient.destroy();
    }

    public InputSplitRpcService inputSplitService() {
        RpcConsumerConfig clientConfig = this.rpcClient.config();
        return (InputSplitRpcService)clientConfig.serviceProxy(InputSplitRpcService.class);
    }

    public AggregateRpcService aggregateRpcService() {
        RpcConsumerConfig clientConfig = this.rpcClient.config();
        return (AggregateRpcService)clientConfig.serviceProxy(AggregateRpcService.class);
    }

    public static void updateRpcRemoteServerConfig(Config config, String host, int port) {
        String url = host + ":" + port;
        config.hugeConfig().setProperty(RpcOptions.RPC_REMOTE_URL.name(), (Object)url);
    }
}

