/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.bsp;

import java.util.List;
import org.apache.hugegraph.computer.core.bsp.BspBase;
import org.apache.hugegraph.computer.core.bsp.BspEvent;
import org.apache.hugegraph.computer.core.common.Constants;
import org.apache.hugegraph.computer.core.common.ContainerInfo;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.graph.SuperstepStat;
import org.apache.hugegraph.computer.core.graph.value.IntValue;
import org.apache.hugegraph.computer.core.io.Readable;
import org.apache.hugegraph.computer.core.util.SerializeUtil;
import org.apache.hugegraph.computer.core.worker.WorkerStat;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class Bsp4Worker
extends BspBase {
    private static final Logger LOG = Log.logger(Bsp4Worker.class);
    private final ContainerInfo workerInfo;

    public Bsp4Worker(Config config, ContainerInfo workerInfo) {
        super(config);
        this.workerInfo = workerInfo;
    }

    public ContainerInfo waitMasterInitDone() {
        LOG.info("Worker({}) is waiting for master init-done", (Object)this.workerInfo.uniqueName());
        String path = this.constructPath(BspEvent.BSP_MASTER_INIT_DONE, new Object[0]);
        byte[] bytes = this.bspClient().get(path, this.registerTimeout(), this.logInterval());
        ContainerInfo masterInfo = new ContainerInfo();
        SerializeUtil.fromBytes(bytes, masterInfo);
        LOG.info("Worker({}) waited master init-done: {}", (Object)this.workerInfo.uniqueName(), (Object)masterInfo);
        return masterInfo;
    }

    public void workerInitDone() {
        String path = this.constructPath(BspEvent.BSP_WORKER_INIT_DONE, this.workerInfo.uniqueName());
        this.bspClient().put(path, SerializeUtil.toBytes(this.workerInfo));
        LOG.info("Worker set init-done: {}", (Object)this.workerInfo.uniqueName());
    }

    public List<ContainerInfo> waitMasterAllInitDone() {
        LOG.info("Worker({}) is waiting for master all-init-done", (Object)this.workerInfo.id());
        String path = this.constructPath(BspEvent.BSP_MASTER_ALL_INIT_DONE, new Object[0]);
        byte[] serializedContainers = this.bspClient().get(path, this.registerTimeout(), this.logInterval());
        List<ContainerInfo> containers = SerializeUtil.fromBytes(serializedContainers, ContainerInfo::new);
        this.assignThisWorkerId(containers);
        LOG.info("Worker({}) waited master all-init-done, workers: {}", (Object)this.workerInfo.id(), containers);
        return containers;
    }

    public int waitMasterResumeDone() {
        LOG.info("Worker({}) is waiting for master resume-done", (Object)this.workerInfo.id());
        String path = this.constructPath(BspEvent.BSP_MASTER_RESUME_DONE, new Object[0]);
        byte[] bytes = this.bspClient().get(path, this.barrierOnMasterTimeout(), this.logInterval());
        IntValue superstep = new IntValue();
        SerializeUtil.fromBytes(bytes, (Readable)superstep);
        LOG.info("Worker({}) waited master resume-done({})", (Object)this.workerInfo.id(), (Object)superstep.value());
        return superstep.value();
    }

    public void workerInputDone() {
        String path = this.constructPath(BspEvent.BSP_WORKER_INPUT_DONE, this.workerInfo.id());
        this.bspClient().put(path, Constants.EMPTY_BYTES);
        LOG.info("Worker({}) set input-done", (Object)this.workerInfo.id());
    }

    public void waitMasterInputDone() {
        LOG.info("Worker({}) is waiting for master input-done", (Object)this.workerInfo.id());
        String path = this.constructPath(BspEvent.BSP_MASTER_INPUT_DONE, new Object[0]);
        this.bspClient().get(path, this.barrierOnMasterTimeout(), this.logInterval());
        LOG.info("Worker({}) waited master input-done", (Object)this.workerInfo.id());
    }

    public void workerStepPrepareDone(int superstep) {
        String path = this.constructPath(BspEvent.BSP_WORKER_STEP_PREPARE_DONE, superstep, this.workerInfo.id());
        this.bspClient().put(path, Constants.EMPTY_BYTES);
        LOG.info("Worker({}) set superstep-prepare-done({})", (Object)this.workerInfo.id(), (Object)superstep);
    }

    public void waitMasterStepPrepareDone(int superstep) {
        LOG.info("Worker({}) is waiting for master superstep-prepare-done({})", (Object)this.workerInfo.id(), (Object)superstep);
        String path = this.constructPath(BspEvent.BSP_MASTER_STEP_PREPARE_DONE, superstep);
        this.bspClient().get(path, this.barrierOnMasterTimeout(), this.logInterval());
        LOG.info("Worker({}) waited master superstep-prepare-done({})", (Object)this.workerInfo.id(), (Object)superstep);
    }

    public void workerStepComputeDone(int superstep) {
        String path = this.constructPath(BspEvent.BSP_WORKER_STEP_COMPUTE_DONE, superstep, this.workerInfo.id());
        this.bspClient().put(path, Constants.EMPTY_BYTES);
        LOG.info("Worker({}) set superstep-compute-done({})", (Object)this.workerInfo.id(), (Object)superstep);
    }

    public void waitMasterStepComputeDone(int superstep) {
        LOG.info("Worker({}) is waiting for master superstep-compute-done({})", (Object)this.workerInfo.id(), (Object)superstep);
        String path = this.constructPath(BspEvent.BSP_MASTER_STEP_COMPUTE_DONE, superstep);
        this.bspClient().get(path, this.barrierOnMasterTimeout(), this.logInterval());
        LOG.info("Worker({}) waited master superstep-compute-done({})", (Object)this.workerInfo.id(), (Object)superstep);
    }

    public void workerStepDone(int superstep, WorkerStat workerStat) {
        String path = this.constructPath(BspEvent.BSP_WORKER_STEP_DONE, superstep, this.workerInfo.id());
        this.bspClient().put(path, SerializeUtil.toBytes(workerStat));
        LOG.info("Worker({}) set superstep-done({}), worker stat: {}", new Object[]{this.workerInfo.id(), superstep, workerStat});
    }

    public SuperstepStat waitMasterStepDone(int superstep) {
        LOG.info("Worker({}) is waiting for master superstep-done({})", (Object)this.workerInfo.id(), (Object)superstep);
        String path = this.constructPath(BspEvent.BSP_MASTER_STEP_DONE, superstep);
        byte[] bytes = this.bspClient().get(path, this.barrierOnMasterTimeout(), this.logInterval());
        SuperstepStat superstepStat = new SuperstepStat();
        SerializeUtil.fromBytes(bytes, superstepStat);
        LOG.info("Worker({}) waited master superstep-done({}), graph stat: {}", new Object[]{this.workerInfo.id(), superstep, superstepStat});
        return superstepStat;
    }

    public void workerOutputDone() {
        String path = this.constructPath(BspEvent.BSP_WORKER_OUTPUT_DONE, this.workerInfo.id());
        this.bspClient().put(path, Constants.EMPTY_BYTES);
        LOG.info("Worker({}) set output-done", (Object)this.workerInfo.id());
    }

    public void workerCloseDone() {
        String path = this.constructPath(BspEvent.BSP_WORKER_CLOSE_DONE, this.workerInfo.id());
        this.bspClient().put(path, Constants.EMPTY_BYTES);
        LOG.info("Worker({}) set close-done", (Object)this.workerInfo.id());
    }

    private void assignThisWorkerId(List<ContainerInfo> workersFromMaster) {
        for (ContainerInfo container : workersFromMaster) {
            if (!this.workerInfo.uniqueName().equals(container.uniqueName())) continue;
            this.workerInfo.id(container.id());
            LOG.info("Worker({}) assigned id {} from master", (Object)this.workerInfo.uniqueName(), (Object)this.workerInfo.id());
            break;
        }
    }
}

