/**
 * Autogenerated by Thrift Compiler (0.14.1)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.hadoop.hbase.thrift2.generated;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked", "unused"})
@javax.annotation.Generated(value = "Autogenerated by Thrift Compiler (0.14.1)", date = "2025-08-18")
public class THBaseService {

  public interface Iface {

    /**
     * Test for the existence of columns in the table, as specified in the TGet.
     * 
     * @return true if the specified TGet matches one or more keys, false if not
     * 
     * @param table the table to check on
     * 
     * @param tget the TGet to check for
     */
    public boolean exists(java.nio.ByteBuffer table, TGet tget) throws TIOError, org.apache.thrift.TException;

    /**
     * Test for the existence of columns in the table, as specified by the TGets.
     * 
     * This will return an array of booleans. Each value will be true if the related Get matches
     * one or more keys, false if not.
     * 
     * @param table the table to check on
     * 
     * @param tgets a list of TGets to check for
     */
    public java.util.List<java.lang.Boolean> existsAll(java.nio.ByteBuffer table, java.util.List<TGet> tgets) throws TIOError, org.apache.thrift.TException;

    /**
     * Method for getting data from a row.
     * 
     * If the row cannot be found an empty Result is returned.
     * This can be checked by the empty field of the TResult
     * 
     * @return the result
     * 
     * @param table the table to get from
     * 
     * @param tget the TGet to fetch
     */
    public TResult get(java.nio.ByteBuffer table, TGet tget) throws TIOError, org.apache.thrift.TException;

    /**
     * Method for getting multiple rows.
     * 
     * If a row cannot be found there will be a null
     * value in the result list for that TGet at the
     * same position.
     * 
     * So the Results are in the same order as the TGets.
     * 
     * @param table the table to get from
     * 
     * @param tgets a list of TGets to fetch, the Result list
     * will have the Results at corresponding positions
     * or null if there was an error
     */
    public java.util.List<TResult> getMultiple(java.nio.ByteBuffer table, java.util.List<TGet> tgets) throws TIOError, org.apache.thrift.TException;

    /**
     * Commit a TPut to a table.
     * 
     * @param table the table to put data in
     * 
     * @param tput the TPut to put
     */
    public void put(java.nio.ByteBuffer table, TPut tput) throws TIOError, org.apache.thrift.TException;

    /**
     * Atomically checks if a row/family/qualifier value matches the expected
     * value. If it does, it adds the TPut.
     * 
     * @return true if the new put was executed, false otherwise
     * 
     * @param table to check in and put to
     * 
     * @param row row to check
     * 
     * @param family column family to check
     * 
     * @param qualifier column qualifier to check
     * 
     * @param value the expected value, if not provided the
     * check is for the non-existence of the
     * column in question
     * 
     * @param tput the TPut to put if the check succeeds
     */
    public boolean checkAndPut(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, java.nio.ByteBuffer value, TPut tput) throws TIOError, org.apache.thrift.TException;

    /**
     * Commit a List of Puts to the table.
     * 
     * @param table the table to put data in
     * 
     * @param tputs a list of TPuts to commit
     */
    public void putMultiple(java.nio.ByteBuffer table, java.util.List<TPut> tputs) throws TIOError, org.apache.thrift.TException;

    /**
     * Deletes as specified by the TDelete.
     * 
     * Note: "delete" is a reserved keyword and cannot be used in Thrift
     * thus the inconsistent naming scheme from the other functions.
     * 
     * @param table the table to delete from
     * 
     * @param tdelete the TDelete to delete
     */
    public void deleteSingle(java.nio.ByteBuffer table, TDelete tdelete) throws TIOError, org.apache.thrift.TException;

    /**
     * Bulk commit a List of TDeletes to the table.
     * 
     * Throws a TIOError if any of the deletes fail.
     * 
     * Always returns an empty list for backwards compatibility.
     * 
     * @param table the table to delete from
     * 
     * @param tdeletes list of TDeletes to delete
     */
    public java.util.List<TDelete> deleteMultiple(java.nio.ByteBuffer table, java.util.List<TDelete> tdeletes) throws TIOError, org.apache.thrift.TException;

    /**
     * Atomically checks if a row/family/qualifier value matches the expected
     * value. If it does, it adds the delete.
     * 
     * @return true if the new delete was executed, false otherwise
     * 
     * @param table to check in and delete from
     * 
     * @param row row to check
     * 
     * @param family column family to check
     * 
     * @param qualifier column qualifier to check
     * 
     * @param value the expected value, if not provided the
     * check is for the non-existence of the
     * column in question
     * 
     * @param tdelete the TDelete to execute if the check succeeds
     */
    public boolean checkAndDelete(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, java.nio.ByteBuffer value, TDelete tdelete) throws TIOError, org.apache.thrift.TException;

    public TResult increment(java.nio.ByteBuffer table, TIncrement tincrement) throws TIOError, org.apache.thrift.TException;

    public TResult append(java.nio.ByteBuffer table, TAppend tappend) throws TIOError, org.apache.thrift.TException;

    /**
     * Get a Scanner for the provided TScan object.
     * 
     * @return Scanner Id to be used with other scanner procedures
     * 
     * @param table the table to get the Scanner for
     * 
     * @param tscan the scan object to get a Scanner for
     */
    public int openScanner(java.nio.ByteBuffer table, TScan tscan) throws TIOError, org.apache.thrift.TException;

    /**
     * Grabs multiple rows from a Scanner.
     * 
     * @return Between zero and numRows TResults
     * 
     * @param scannerId the Id of the Scanner to return rows from. This is an Id returned from the openScanner function.
     * 
     * @param numRows number of rows to return
     */
    public java.util.List<TResult> getScannerRows(int scannerId, int numRows) throws TIOError, TIllegalArgument, org.apache.thrift.TException;

    /**
     * Closes the scanner. Should be called to free server side resources timely.
     * Typically close once the scanner is not needed anymore, i.e. after looping
     * over it to get all the required rows.
     * 
     * @param scannerId the Id of the Scanner to close *
     */
    public void closeScanner(int scannerId) throws TIOError, TIllegalArgument, org.apache.thrift.TException;

    /**
     * mutateRow performs multiple mutations atomically on a single row.
     * 
     * @param table table to apply the mutations
     * 
     * @param trowMutations mutations to apply
     */
    public void mutateRow(java.nio.ByteBuffer table, TRowMutations trowMutations) throws TIOError, org.apache.thrift.TException;

    /**
     * Get results for the provided TScan object.
     * This helper function opens a scanner, get the results and close the scanner.
     * 
     * @return between zero and numRows TResults
     * 
     * @param table the table to get the Scanner for
     * 
     * @param tscan the scan object to get a Scanner for
     * 
     * @param numRows number of rows to return
     */
    public java.util.List<TResult> getScannerResults(java.nio.ByteBuffer table, TScan tscan, int numRows) throws TIOError, org.apache.thrift.TException;

    /**
     * Given a table and a row get the location of the region that
     * would contain the given row key.
     * 
     * reload = true means the cache will be cleared and the location
     * will be fetched from meta.
     * 
     * @param table
     * @param row
     * @param reload
     */
    public THRegionLocation getRegionLocation(java.nio.ByteBuffer table, java.nio.ByteBuffer row, boolean reload) throws TIOError, org.apache.thrift.TException;

    /**
     * Get all of the region locations for a given table.
     * 
     * 
     * @param table
     */
    public java.util.List<THRegionLocation> getAllRegionLocations(java.nio.ByteBuffer table) throws TIOError, org.apache.thrift.TException;

    /**
     * Atomically checks if a row/family/qualifier value matches the expected
     * value. If it does, it mutates the row.
     * 
     * @return true if the row was mutated, false otherwise
     * 
     * @param table to check in and delete from
     * 
     * @param row row to check
     * 
     * @param family column family to check
     * 
     * @param qualifier column qualifier to check
     * 
     * @param compareOp comparison to make on the value
     * 
     * @param value the expected value to be compared against, if not provided the
     * check is for the non-existence of the column in question
     * 
     * @param rowMutations row mutations to execute if the value matches
     */
    public boolean checkAndMutate(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, TCompareOp compareOp, java.nio.ByteBuffer value, TRowMutations rowMutations) throws TIOError, org.apache.thrift.TException;

    /**
     * Get a table descriptor.
     * @return the TableDescriptor of the giving tablename
     * 
     * 
     * @param table the tablename of the table to get tableDescriptor
     */
    public TTableDescriptor getTableDescriptor(TTableName table) throws TIOError, org.apache.thrift.TException;

    /**
     * Get table descriptors of tables.
     * @return the TableDescriptor of the giving tablename
     * 
     * 
     * @param tables the tablename list of the tables to get tableDescriptor
     */
    public java.util.List<TTableDescriptor> getTableDescriptors(java.util.List<TTableName> tables) throws TIOError, org.apache.thrift.TException;

    /**
     * 
     * @return true if table exists already, false if not
     * 
     * 
     * @param tableName the tablename of the tables to check
     */
    public boolean tableExists(TTableName tableName) throws TIOError, org.apache.thrift.TException;

    /**
     * Get table descriptors of tables that match the given pattern
     * @return the tableDescriptors of the matching table
     * 
     * 
     * @param regex The regular expression to match against
     * 
     * @param includeSysTables set to false if match only against userspace tables
     */
    public java.util.List<TTableDescriptor> getTableDescriptorsByPattern(java.lang.String regex, boolean includeSysTables) throws TIOError, org.apache.thrift.TException;

    /**
     * Get table descriptors of tables in the given namespace
     * @return the tableDescriptors in the namespce
     * 
     * 
     * @param name The namesapce's name
     */
    public java.util.List<TTableDescriptor> getTableDescriptorsByNamespace(java.lang.String name) throws TIOError, org.apache.thrift.TException;

    /**
     * Get table names of tables that match the given pattern
     * @return the table names of the matching table
     * 
     * 
     * @param regex The regular expression to match against
     * 
     * @param includeSysTables set to false if match only against userspace tables
     */
    public java.util.List<TTableName> getTableNamesByPattern(java.lang.String regex, boolean includeSysTables) throws TIOError, org.apache.thrift.TException;

    /**
     * Get table names of tables in the given namespace
     * @return the table names of the matching table
     * 
     * 
     * @param name The namesapce's name
     */
    public java.util.List<TTableName> getTableNamesByNamespace(java.lang.String name) throws TIOError, org.apache.thrift.TException;

    /**
     * Creates a new table with an initial set of empty regions defined by the specified split keys.
     * The total number of regions created will be the number of split keys plus one. Synchronous
     * operation.
     * 
     * 
     * @param desc table descriptor for table
     * 
     * @param splitKeys rray of split keys for the initial regions of the table
     */
    public void createTable(TTableDescriptor desc, java.util.List<java.nio.ByteBuffer> splitKeys) throws TIOError, org.apache.thrift.TException;

    /**
     * Deletes a table. Synchronous operation.
     * 
     * 
     * @param tableName the tablename to delete
     */
    public void deleteTable(TTableName tableName) throws TIOError, org.apache.thrift.TException;

    /**
     * Truncate a table. Synchronous operation.
     * 
     * 
     * @param tableName the tablename to truncate
     * 
     * @param preserveSplits whether to  preserve previous splits
     */
    public void truncateTable(TTableName tableName, boolean preserveSplits) throws TIOError, org.apache.thrift.TException;

    /**
     * Enalbe a table
     * 
     * 
     * @param tableName the tablename to enable
     */
    public void enableTable(TTableName tableName) throws TIOError, org.apache.thrift.TException;

    /**
     * Disable a table
     * 
     * 
     * @param tableName the tablename to disable
     */
    public void disableTable(TTableName tableName) throws TIOError, org.apache.thrift.TException;

    /**
     * 
     * @return true if table is enabled, false if not
     * 
     * 
     * @param tableName the tablename to check
     */
    public boolean isTableEnabled(TTableName tableName) throws TIOError, org.apache.thrift.TException;

    /**
     * 
     * @return true if table is disabled, false if not
     * 
     * 
     * @param tableName the tablename to check
     */
    public boolean isTableDisabled(TTableName tableName) throws TIOError, org.apache.thrift.TException;

    /**
     * 
     * @return true if table is available, false if not
     * 
     * 
     * @param tableName the tablename to check
     */
    public boolean isTableAvailable(TTableName tableName) throws TIOError, org.apache.thrift.TException;

    /**
     *  * Use this api to check if the table has been created with the specified number of splitkeys
     *  * which was used while creating the given table. Note : If this api is used after a table's
     *  * region gets splitted, the api may return false.
     *  *
     *  * @return true if table is available, false if not
     *  *
     *  * @deprecated Since 2.2.0. Because the same method in Table interface has been deprecated
     *  * since 2.0.0, we will remove it in 3.0.0 release.
     *  * Use {@link #isTableAvailable(TTableName tableName)} instead
     * *
     * 
     * @param tableName the tablename to check
     * 
     * @param splitKeys keys to check if the table has been created with all split keys
     */
    public boolean isTableAvailableWithSplit(TTableName tableName, java.util.List<java.nio.ByteBuffer> splitKeys) throws TIOError, org.apache.thrift.TException;

    /**
     * Add a column family to an existing table. Synchronous operation.
     * 
     * 
     * @param tableName the tablename to add column family to
     * 
     * @param column column family descriptor of column family to be added
     */
    public void addColumnFamily(TTableName tableName, TColumnFamilyDescriptor column) throws TIOError, org.apache.thrift.TException;

    /**
     * Delete a column family from a table. Synchronous operation.
     * 
     * 
     * @param tableName the tablename to delete column family from
     * 
     * @param column name of column family to be deleted
     */
    public void deleteColumnFamily(TTableName tableName, java.nio.ByteBuffer column) throws TIOError, org.apache.thrift.TException;

    /**
     * Modify an existing column family on a table. Synchronous operation.
     * 
     * 
     * @param tableName the tablename to modify column family
     * 
     * @param column column family descriptor of column family to be modified
     */
    public void modifyColumnFamily(TTableName tableName, TColumnFamilyDescriptor column) throws TIOError, org.apache.thrift.TException;

    /**
     * Modify an existing table
     * 
     * 
     * @param desc the descriptor of the table to modify
     */
    public void modifyTable(TTableDescriptor desc) throws TIOError, org.apache.thrift.TException;

    /**
     * Create a new namespace. Blocks until namespace has been successfully created or an exception is
     * thrown
     * 
     * 
     * @param namespaceDesc descriptor which describes the new namespace
     */
    public void createNamespace(TNamespaceDescriptor namespaceDesc) throws TIOError, org.apache.thrift.TException;

    /**
     * Modify an existing namespace.  Blocks until namespace has been successfully modified or an
     * exception is thrown
     * 
     * 
     * @param namespaceDesc descriptor which describes the new namespace
     */
    public void modifyNamespace(TNamespaceDescriptor namespaceDesc) throws TIOError, org.apache.thrift.TException;

    /**
     * Delete an existing namespace. Only empty namespaces (no tables) can be removed.
     * Blocks until namespace has been successfully deleted or an
     * exception is thrown.
     * 
     * 
     * @param name namespace name
     */
    public void deleteNamespace(java.lang.String name) throws TIOError, org.apache.thrift.TException;

    /**
     * Get a namespace descriptor by name.
     * @retrun the descriptor
     * 
     * 
     * @param name name of namespace descriptor
     */
    public TNamespaceDescriptor getNamespaceDescriptor(java.lang.String name) throws TIOError, org.apache.thrift.TException;

    /**
     * @return all namespaces
     * 
     */
    public java.util.List<TNamespaceDescriptor> listNamespaceDescriptors() throws TIOError, org.apache.thrift.TException;

    /**
     * @return all namespace names
     * 
     */
    public java.util.List<java.lang.String> listNamespaces() throws TIOError, org.apache.thrift.TException;

    /**
     * Get the type of this thrift server.
     * 
     * @return the type of this thrift server
     */
    public TThriftServerType getThriftServerType() throws org.apache.thrift.TException;

    /**
     * Retrieves online slow RPC logs from the provided list of
     * RegionServers
     * 
     * @return online slowlog response list
     * @throws TIOError if a remote or network exception occurs
     * 
     * @param serverNames @param serverNames Server names to get slowlog responses from
     * 
     * @param logQueryFilter @param logQueryFilter filter to be used if provided
     */
    public java.util.List<TOnlineLogRecord> getSlowLogResponses(java.util.Set<TServerName> serverNames, TLogQueryFilter logQueryFilter) throws TIOError, org.apache.thrift.TException;

    /**
     * Clears online slow/large RPC logs from the provided list of
     * RegionServers
     * 
     * @return List of booleans representing if online slowlog response buffer is cleaned
     *   from each RegionServer
     * @throws TIOError if a remote or network exception occurs
     * 
     * @param serverNames @param serverNames Set of Server names to clean slowlog responses from
     */
    public java.util.List<java.lang.Boolean> clearSlowLogResponses(java.util.Set<TServerName> serverNames) throws TIOError, org.apache.thrift.TException;

    /**
     * Returns the cluster ID for this cluster.
     */
    public java.lang.String getClusterId() throws org.apache.thrift.TException;

  }

  public interface AsyncIface {

    public void exists(java.nio.ByteBuffer table, TGet tget, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException;

    public void existsAll(java.nio.ByteBuffer table, java.util.List<TGet> tgets, org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.Boolean>> resultHandler) throws org.apache.thrift.TException;

    public void get(java.nio.ByteBuffer table, TGet tget, org.apache.thrift.async.AsyncMethodCallback<TResult> resultHandler) throws org.apache.thrift.TException;

    public void getMultiple(java.nio.ByteBuffer table, java.util.List<TGet> tgets, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>> resultHandler) throws org.apache.thrift.TException;

    public void put(java.nio.ByteBuffer table, TPut tput, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void checkAndPut(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, java.nio.ByteBuffer value, TPut tput, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException;

    public void putMultiple(java.nio.ByteBuffer table, java.util.List<TPut> tputs, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void deleteSingle(java.nio.ByteBuffer table, TDelete tdelete, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void deleteMultiple(java.nio.ByteBuffer table, java.util.List<TDelete> tdeletes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TDelete>> resultHandler) throws org.apache.thrift.TException;

    public void checkAndDelete(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, java.nio.ByteBuffer value, TDelete tdelete, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException;

    public void increment(java.nio.ByteBuffer table, TIncrement tincrement, org.apache.thrift.async.AsyncMethodCallback<TResult> resultHandler) throws org.apache.thrift.TException;

    public void append(java.nio.ByteBuffer table, TAppend tappend, org.apache.thrift.async.AsyncMethodCallback<TResult> resultHandler) throws org.apache.thrift.TException;

    public void openScanner(java.nio.ByteBuffer table, TScan tscan, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException;

    public void getScannerRows(int scannerId, int numRows, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>> resultHandler) throws org.apache.thrift.TException;

    public void closeScanner(int scannerId, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void mutateRow(java.nio.ByteBuffer table, TRowMutations trowMutations, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void getScannerResults(java.nio.ByteBuffer table, TScan tscan, int numRows, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>> resultHandler) throws org.apache.thrift.TException;

    public void getRegionLocation(java.nio.ByteBuffer table, java.nio.ByteBuffer row, boolean reload, org.apache.thrift.async.AsyncMethodCallback<THRegionLocation> resultHandler) throws org.apache.thrift.TException;

    public void getAllRegionLocations(java.nio.ByteBuffer table, org.apache.thrift.async.AsyncMethodCallback<java.util.List<THRegionLocation>> resultHandler) throws org.apache.thrift.TException;

    public void checkAndMutate(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, TCompareOp compareOp, java.nio.ByteBuffer value, TRowMutations rowMutations, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException;

    public void getTableDescriptor(TTableName table, org.apache.thrift.async.AsyncMethodCallback<TTableDescriptor> resultHandler) throws org.apache.thrift.TException;

    public void getTableDescriptors(java.util.List<TTableName> tables, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>> resultHandler) throws org.apache.thrift.TException;

    public void tableExists(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException;

    public void getTableDescriptorsByPattern(java.lang.String regex, boolean includeSysTables, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>> resultHandler) throws org.apache.thrift.TException;

    public void getTableDescriptorsByNamespace(java.lang.String name, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>> resultHandler) throws org.apache.thrift.TException;

    public void getTableNamesByPattern(java.lang.String regex, boolean includeSysTables, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableName>> resultHandler) throws org.apache.thrift.TException;

    public void getTableNamesByNamespace(java.lang.String name, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableName>> resultHandler) throws org.apache.thrift.TException;

    public void createTable(TTableDescriptor desc, java.util.List<java.nio.ByteBuffer> splitKeys, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void deleteTable(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void truncateTable(TTableName tableName, boolean preserveSplits, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void enableTable(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void disableTable(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void isTableEnabled(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException;

    public void isTableDisabled(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException;

    public void isTableAvailable(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException;

    public void isTableAvailableWithSplit(TTableName tableName, java.util.List<java.nio.ByteBuffer> splitKeys, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException;

    public void addColumnFamily(TTableName tableName, TColumnFamilyDescriptor column, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void deleteColumnFamily(TTableName tableName, java.nio.ByteBuffer column, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void modifyColumnFamily(TTableName tableName, TColumnFamilyDescriptor column, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void modifyTable(TTableDescriptor desc, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void createNamespace(TNamespaceDescriptor namespaceDesc, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void modifyNamespace(TNamespaceDescriptor namespaceDesc, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void deleteNamespace(java.lang.String name, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException;

    public void getNamespaceDescriptor(java.lang.String name, org.apache.thrift.async.AsyncMethodCallback<TNamespaceDescriptor> resultHandler) throws org.apache.thrift.TException;

    public void listNamespaceDescriptors(org.apache.thrift.async.AsyncMethodCallback<java.util.List<TNamespaceDescriptor>> resultHandler) throws org.apache.thrift.TException;

    public void listNamespaces(org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.String>> resultHandler) throws org.apache.thrift.TException;

    public void getThriftServerType(org.apache.thrift.async.AsyncMethodCallback<TThriftServerType> resultHandler) throws org.apache.thrift.TException;

    public void getSlowLogResponses(java.util.Set<TServerName> serverNames, TLogQueryFilter logQueryFilter, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TOnlineLogRecord>> resultHandler) throws org.apache.thrift.TException;

    public void clearSlowLogResponses(java.util.Set<TServerName> serverNames, org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.Boolean>> resultHandler) throws org.apache.thrift.TException;

    public void getClusterId(org.apache.thrift.async.AsyncMethodCallback<java.lang.String> resultHandler) throws org.apache.thrift.TException;

  }

  public static class Client extends org.apache.thrift.TServiceClient implements Iface {
    public static class Factory implements org.apache.thrift.TServiceClientFactory<Client> {
      public Factory() {}
      public Client getClient(org.apache.thrift.protocol.TProtocol prot) {
        return new Client(prot);
      }
      public Client getClient(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
        return new Client(iprot, oprot);
      }
    }

    public Client(org.apache.thrift.protocol.TProtocol prot)
    {
      super(prot, prot);
    }

    public Client(org.apache.thrift.protocol.TProtocol iprot, org.apache.thrift.protocol.TProtocol oprot) {
      super(iprot, oprot);
    }

    public boolean exists(java.nio.ByteBuffer table, TGet tget) throws TIOError, org.apache.thrift.TException
    {
      send_exists(table, tget);
      return recv_exists();
    }

    public void send_exists(java.nio.ByteBuffer table, TGet tget) throws org.apache.thrift.TException
    {
      exists_args args = new exists_args();
      args.setTable(table);
      args.setTget(tget);
      sendBase("exists", args);
    }

    public boolean recv_exists() throws TIOError, org.apache.thrift.TException
    {
      exists_result result = new exists_result();
      receiveBase(result, "exists");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "exists failed: unknown result");
    }

    public java.util.List<java.lang.Boolean> existsAll(java.nio.ByteBuffer table, java.util.List<TGet> tgets) throws TIOError, org.apache.thrift.TException
    {
      send_existsAll(table, tgets);
      return recv_existsAll();
    }

    public void send_existsAll(java.nio.ByteBuffer table, java.util.List<TGet> tgets) throws org.apache.thrift.TException
    {
      existsAll_args args = new existsAll_args();
      args.setTable(table);
      args.setTgets(tgets);
      sendBase("existsAll", args);
    }

    public java.util.List<java.lang.Boolean> recv_existsAll() throws TIOError, org.apache.thrift.TException
    {
      existsAll_result result = new existsAll_result();
      receiveBase(result, "existsAll");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "existsAll failed: unknown result");
    }

    public TResult get(java.nio.ByteBuffer table, TGet tget) throws TIOError, org.apache.thrift.TException
    {
      send_get(table, tget);
      return recv_get();
    }

    public void send_get(java.nio.ByteBuffer table, TGet tget) throws org.apache.thrift.TException
    {
      get_args args = new get_args();
      args.setTable(table);
      args.setTget(tget);
      sendBase("get", args);
    }

    public TResult recv_get() throws TIOError, org.apache.thrift.TException
    {
      get_result result = new get_result();
      receiveBase(result, "get");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "get failed: unknown result");
    }

    public java.util.List<TResult> getMultiple(java.nio.ByteBuffer table, java.util.List<TGet> tgets) throws TIOError, org.apache.thrift.TException
    {
      send_getMultiple(table, tgets);
      return recv_getMultiple();
    }

    public void send_getMultiple(java.nio.ByteBuffer table, java.util.List<TGet> tgets) throws org.apache.thrift.TException
    {
      getMultiple_args args = new getMultiple_args();
      args.setTable(table);
      args.setTgets(tgets);
      sendBase("getMultiple", args);
    }

    public java.util.List<TResult> recv_getMultiple() throws TIOError, org.apache.thrift.TException
    {
      getMultiple_result result = new getMultiple_result();
      receiveBase(result, "getMultiple");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getMultiple failed: unknown result");
    }

    public void put(java.nio.ByteBuffer table, TPut tput) throws TIOError, org.apache.thrift.TException
    {
      send_put(table, tput);
      recv_put();
    }

    public void send_put(java.nio.ByteBuffer table, TPut tput) throws org.apache.thrift.TException
    {
      put_args args = new put_args();
      args.setTable(table);
      args.setTput(tput);
      sendBase("put", args);
    }

    public void recv_put() throws TIOError, org.apache.thrift.TException
    {
      put_result result = new put_result();
      receiveBase(result, "put");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public boolean checkAndPut(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, java.nio.ByteBuffer value, TPut tput) throws TIOError, org.apache.thrift.TException
    {
      send_checkAndPut(table, row, family, qualifier, value, tput);
      return recv_checkAndPut();
    }

    public void send_checkAndPut(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, java.nio.ByteBuffer value, TPut tput) throws org.apache.thrift.TException
    {
      checkAndPut_args args = new checkAndPut_args();
      args.setTable(table);
      args.setRow(row);
      args.setFamily(family);
      args.setQualifier(qualifier);
      args.setValue(value);
      args.setTput(tput);
      sendBase("checkAndPut", args);
    }

    public boolean recv_checkAndPut() throws TIOError, org.apache.thrift.TException
    {
      checkAndPut_result result = new checkAndPut_result();
      receiveBase(result, "checkAndPut");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "checkAndPut failed: unknown result");
    }

    public void putMultiple(java.nio.ByteBuffer table, java.util.List<TPut> tputs) throws TIOError, org.apache.thrift.TException
    {
      send_putMultiple(table, tputs);
      recv_putMultiple();
    }

    public void send_putMultiple(java.nio.ByteBuffer table, java.util.List<TPut> tputs) throws org.apache.thrift.TException
    {
      putMultiple_args args = new putMultiple_args();
      args.setTable(table);
      args.setTputs(tputs);
      sendBase("putMultiple", args);
    }

    public void recv_putMultiple() throws TIOError, org.apache.thrift.TException
    {
      putMultiple_result result = new putMultiple_result();
      receiveBase(result, "putMultiple");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void deleteSingle(java.nio.ByteBuffer table, TDelete tdelete) throws TIOError, org.apache.thrift.TException
    {
      send_deleteSingle(table, tdelete);
      recv_deleteSingle();
    }

    public void send_deleteSingle(java.nio.ByteBuffer table, TDelete tdelete) throws org.apache.thrift.TException
    {
      deleteSingle_args args = new deleteSingle_args();
      args.setTable(table);
      args.setTdelete(tdelete);
      sendBase("deleteSingle", args);
    }

    public void recv_deleteSingle() throws TIOError, org.apache.thrift.TException
    {
      deleteSingle_result result = new deleteSingle_result();
      receiveBase(result, "deleteSingle");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public java.util.List<TDelete> deleteMultiple(java.nio.ByteBuffer table, java.util.List<TDelete> tdeletes) throws TIOError, org.apache.thrift.TException
    {
      send_deleteMultiple(table, tdeletes);
      return recv_deleteMultiple();
    }

    public void send_deleteMultiple(java.nio.ByteBuffer table, java.util.List<TDelete> tdeletes) throws org.apache.thrift.TException
    {
      deleteMultiple_args args = new deleteMultiple_args();
      args.setTable(table);
      args.setTdeletes(tdeletes);
      sendBase("deleteMultiple", args);
    }

    public java.util.List<TDelete> recv_deleteMultiple() throws TIOError, org.apache.thrift.TException
    {
      deleteMultiple_result result = new deleteMultiple_result();
      receiveBase(result, "deleteMultiple");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "deleteMultiple failed: unknown result");
    }

    public boolean checkAndDelete(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, java.nio.ByteBuffer value, TDelete tdelete) throws TIOError, org.apache.thrift.TException
    {
      send_checkAndDelete(table, row, family, qualifier, value, tdelete);
      return recv_checkAndDelete();
    }

    public void send_checkAndDelete(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, java.nio.ByteBuffer value, TDelete tdelete) throws org.apache.thrift.TException
    {
      checkAndDelete_args args = new checkAndDelete_args();
      args.setTable(table);
      args.setRow(row);
      args.setFamily(family);
      args.setQualifier(qualifier);
      args.setValue(value);
      args.setTdelete(tdelete);
      sendBase("checkAndDelete", args);
    }

    public boolean recv_checkAndDelete() throws TIOError, org.apache.thrift.TException
    {
      checkAndDelete_result result = new checkAndDelete_result();
      receiveBase(result, "checkAndDelete");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "checkAndDelete failed: unknown result");
    }

    public TResult increment(java.nio.ByteBuffer table, TIncrement tincrement) throws TIOError, org.apache.thrift.TException
    {
      send_increment(table, tincrement);
      return recv_increment();
    }

    public void send_increment(java.nio.ByteBuffer table, TIncrement tincrement) throws org.apache.thrift.TException
    {
      increment_args args = new increment_args();
      args.setTable(table);
      args.setTincrement(tincrement);
      sendBase("increment", args);
    }

    public TResult recv_increment() throws TIOError, org.apache.thrift.TException
    {
      increment_result result = new increment_result();
      receiveBase(result, "increment");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "increment failed: unknown result");
    }

    public TResult append(java.nio.ByteBuffer table, TAppend tappend) throws TIOError, org.apache.thrift.TException
    {
      send_append(table, tappend);
      return recv_append();
    }

    public void send_append(java.nio.ByteBuffer table, TAppend tappend) throws org.apache.thrift.TException
    {
      append_args args = new append_args();
      args.setTable(table);
      args.setTappend(tappend);
      sendBase("append", args);
    }

    public TResult recv_append() throws TIOError, org.apache.thrift.TException
    {
      append_result result = new append_result();
      receiveBase(result, "append");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "append failed: unknown result");
    }

    public int openScanner(java.nio.ByteBuffer table, TScan tscan) throws TIOError, org.apache.thrift.TException
    {
      send_openScanner(table, tscan);
      return recv_openScanner();
    }

    public void send_openScanner(java.nio.ByteBuffer table, TScan tscan) throws org.apache.thrift.TException
    {
      openScanner_args args = new openScanner_args();
      args.setTable(table);
      args.setTscan(tscan);
      sendBase("openScanner", args);
    }

    public int recv_openScanner() throws TIOError, org.apache.thrift.TException
    {
      openScanner_result result = new openScanner_result();
      receiveBase(result, "openScanner");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "openScanner failed: unknown result");
    }

    public java.util.List<TResult> getScannerRows(int scannerId, int numRows) throws TIOError, TIllegalArgument, org.apache.thrift.TException
    {
      send_getScannerRows(scannerId, numRows);
      return recv_getScannerRows();
    }

    public void send_getScannerRows(int scannerId, int numRows) throws org.apache.thrift.TException
    {
      getScannerRows_args args = new getScannerRows_args();
      args.setScannerId(scannerId);
      args.setNumRows(numRows);
      sendBase("getScannerRows", args);
    }

    public java.util.List<TResult> recv_getScannerRows() throws TIOError, TIllegalArgument, org.apache.thrift.TException
    {
      getScannerRows_result result = new getScannerRows_result();
      receiveBase(result, "getScannerRows");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getScannerRows failed: unknown result");
    }

    public void closeScanner(int scannerId) throws TIOError, TIllegalArgument, org.apache.thrift.TException
    {
      send_closeScanner(scannerId);
      recv_closeScanner();
    }

    public void send_closeScanner(int scannerId) throws org.apache.thrift.TException
    {
      closeScanner_args args = new closeScanner_args();
      args.setScannerId(scannerId);
      sendBase("closeScanner", args);
    }

    public void recv_closeScanner() throws TIOError, TIllegalArgument, org.apache.thrift.TException
    {
      closeScanner_result result = new closeScanner_result();
      receiveBase(result, "closeScanner");
      if (result.io != null) {
        throw result.io;
      }
      if (result.ia != null) {
        throw result.ia;
      }
      return;
    }

    public void mutateRow(java.nio.ByteBuffer table, TRowMutations trowMutations) throws TIOError, org.apache.thrift.TException
    {
      send_mutateRow(table, trowMutations);
      recv_mutateRow();
    }

    public void send_mutateRow(java.nio.ByteBuffer table, TRowMutations trowMutations) throws org.apache.thrift.TException
    {
      mutateRow_args args = new mutateRow_args();
      args.setTable(table);
      args.setTrowMutations(trowMutations);
      sendBase("mutateRow", args);
    }

    public void recv_mutateRow() throws TIOError, org.apache.thrift.TException
    {
      mutateRow_result result = new mutateRow_result();
      receiveBase(result, "mutateRow");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public java.util.List<TResult> getScannerResults(java.nio.ByteBuffer table, TScan tscan, int numRows) throws TIOError, org.apache.thrift.TException
    {
      send_getScannerResults(table, tscan, numRows);
      return recv_getScannerResults();
    }

    public void send_getScannerResults(java.nio.ByteBuffer table, TScan tscan, int numRows) throws org.apache.thrift.TException
    {
      getScannerResults_args args = new getScannerResults_args();
      args.setTable(table);
      args.setTscan(tscan);
      args.setNumRows(numRows);
      sendBase("getScannerResults", args);
    }

    public java.util.List<TResult> recv_getScannerResults() throws TIOError, org.apache.thrift.TException
    {
      getScannerResults_result result = new getScannerResults_result();
      receiveBase(result, "getScannerResults");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getScannerResults failed: unknown result");
    }

    public THRegionLocation getRegionLocation(java.nio.ByteBuffer table, java.nio.ByteBuffer row, boolean reload) throws TIOError, org.apache.thrift.TException
    {
      send_getRegionLocation(table, row, reload);
      return recv_getRegionLocation();
    }

    public void send_getRegionLocation(java.nio.ByteBuffer table, java.nio.ByteBuffer row, boolean reload) throws org.apache.thrift.TException
    {
      getRegionLocation_args args = new getRegionLocation_args();
      args.setTable(table);
      args.setRow(row);
      args.setReload(reload);
      sendBase("getRegionLocation", args);
    }

    public THRegionLocation recv_getRegionLocation() throws TIOError, org.apache.thrift.TException
    {
      getRegionLocation_result result = new getRegionLocation_result();
      receiveBase(result, "getRegionLocation");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getRegionLocation failed: unknown result");
    }

    public java.util.List<THRegionLocation> getAllRegionLocations(java.nio.ByteBuffer table) throws TIOError, org.apache.thrift.TException
    {
      send_getAllRegionLocations(table);
      return recv_getAllRegionLocations();
    }

    public void send_getAllRegionLocations(java.nio.ByteBuffer table) throws org.apache.thrift.TException
    {
      getAllRegionLocations_args args = new getAllRegionLocations_args();
      args.setTable(table);
      sendBase("getAllRegionLocations", args);
    }

    public java.util.List<THRegionLocation> recv_getAllRegionLocations() throws TIOError, org.apache.thrift.TException
    {
      getAllRegionLocations_result result = new getAllRegionLocations_result();
      receiveBase(result, "getAllRegionLocations");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getAllRegionLocations failed: unknown result");
    }

    public boolean checkAndMutate(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, TCompareOp compareOp, java.nio.ByteBuffer value, TRowMutations rowMutations) throws TIOError, org.apache.thrift.TException
    {
      send_checkAndMutate(table, row, family, qualifier, compareOp, value, rowMutations);
      return recv_checkAndMutate();
    }

    public void send_checkAndMutate(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, TCompareOp compareOp, java.nio.ByteBuffer value, TRowMutations rowMutations) throws org.apache.thrift.TException
    {
      checkAndMutate_args args = new checkAndMutate_args();
      args.setTable(table);
      args.setRow(row);
      args.setFamily(family);
      args.setQualifier(qualifier);
      args.setCompareOp(compareOp);
      args.setValue(value);
      args.setRowMutations(rowMutations);
      sendBase("checkAndMutate", args);
    }

    public boolean recv_checkAndMutate() throws TIOError, org.apache.thrift.TException
    {
      checkAndMutate_result result = new checkAndMutate_result();
      receiveBase(result, "checkAndMutate");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "checkAndMutate failed: unknown result");
    }

    public TTableDescriptor getTableDescriptor(TTableName table) throws TIOError, org.apache.thrift.TException
    {
      send_getTableDescriptor(table);
      return recv_getTableDescriptor();
    }

    public void send_getTableDescriptor(TTableName table) throws org.apache.thrift.TException
    {
      getTableDescriptor_args args = new getTableDescriptor_args();
      args.setTable(table);
      sendBase("getTableDescriptor", args);
    }

    public TTableDescriptor recv_getTableDescriptor() throws TIOError, org.apache.thrift.TException
    {
      getTableDescriptor_result result = new getTableDescriptor_result();
      receiveBase(result, "getTableDescriptor");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTableDescriptor failed: unknown result");
    }

    public java.util.List<TTableDescriptor> getTableDescriptors(java.util.List<TTableName> tables) throws TIOError, org.apache.thrift.TException
    {
      send_getTableDescriptors(tables);
      return recv_getTableDescriptors();
    }

    public void send_getTableDescriptors(java.util.List<TTableName> tables) throws org.apache.thrift.TException
    {
      getTableDescriptors_args args = new getTableDescriptors_args();
      args.setTables(tables);
      sendBase("getTableDescriptors", args);
    }

    public java.util.List<TTableDescriptor> recv_getTableDescriptors() throws TIOError, org.apache.thrift.TException
    {
      getTableDescriptors_result result = new getTableDescriptors_result();
      receiveBase(result, "getTableDescriptors");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTableDescriptors failed: unknown result");
    }

    public boolean tableExists(TTableName tableName) throws TIOError, org.apache.thrift.TException
    {
      send_tableExists(tableName);
      return recv_tableExists();
    }

    public void send_tableExists(TTableName tableName) throws org.apache.thrift.TException
    {
      tableExists_args args = new tableExists_args();
      args.setTableName(tableName);
      sendBase("tableExists", args);
    }

    public boolean recv_tableExists() throws TIOError, org.apache.thrift.TException
    {
      tableExists_result result = new tableExists_result();
      receiveBase(result, "tableExists");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "tableExists failed: unknown result");
    }

    public java.util.List<TTableDescriptor> getTableDescriptorsByPattern(java.lang.String regex, boolean includeSysTables) throws TIOError, org.apache.thrift.TException
    {
      send_getTableDescriptorsByPattern(regex, includeSysTables);
      return recv_getTableDescriptorsByPattern();
    }

    public void send_getTableDescriptorsByPattern(java.lang.String regex, boolean includeSysTables) throws org.apache.thrift.TException
    {
      getTableDescriptorsByPattern_args args = new getTableDescriptorsByPattern_args();
      args.setRegex(regex);
      args.setIncludeSysTables(includeSysTables);
      sendBase("getTableDescriptorsByPattern", args);
    }

    public java.util.List<TTableDescriptor> recv_getTableDescriptorsByPattern() throws TIOError, org.apache.thrift.TException
    {
      getTableDescriptorsByPattern_result result = new getTableDescriptorsByPattern_result();
      receiveBase(result, "getTableDescriptorsByPattern");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTableDescriptorsByPattern failed: unknown result");
    }

    public java.util.List<TTableDescriptor> getTableDescriptorsByNamespace(java.lang.String name) throws TIOError, org.apache.thrift.TException
    {
      send_getTableDescriptorsByNamespace(name);
      return recv_getTableDescriptorsByNamespace();
    }

    public void send_getTableDescriptorsByNamespace(java.lang.String name) throws org.apache.thrift.TException
    {
      getTableDescriptorsByNamespace_args args = new getTableDescriptorsByNamespace_args();
      args.setName(name);
      sendBase("getTableDescriptorsByNamespace", args);
    }

    public java.util.List<TTableDescriptor> recv_getTableDescriptorsByNamespace() throws TIOError, org.apache.thrift.TException
    {
      getTableDescriptorsByNamespace_result result = new getTableDescriptorsByNamespace_result();
      receiveBase(result, "getTableDescriptorsByNamespace");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTableDescriptorsByNamespace failed: unknown result");
    }

    public java.util.List<TTableName> getTableNamesByPattern(java.lang.String regex, boolean includeSysTables) throws TIOError, org.apache.thrift.TException
    {
      send_getTableNamesByPattern(regex, includeSysTables);
      return recv_getTableNamesByPattern();
    }

    public void send_getTableNamesByPattern(java.lang.String regex, boolean includeSysTables) throws org.apache.thrift.TException
    {
      getTableNamesByPattern_args args = new getTableNamesByPattern_args();
      args.setRegex(regex);
      args.setIncludeSysTables(includeSysTables);
      sendBase("getTableNamesByPattern", args);
    }

    public java.util.List<TTableName> recv_getTableNamesByPattern() throws TIOError, org.apache.thrift.TException
    {
      getTableNamesByPattern_result result = new getTableNamesByPattern_result();
      receiveBase(result, "getTableNamesByPattern");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTableNamesByPattern failed: unknown result");
    }

    public java.util.List<TTableName> getTableNamesByNamespace(java.lang.String name) throws TIOError, org.apache.thrift.TException
    {
      send_getTableNamesByNamespace(name);
      return recv_getTableNamesByNamespace();
    }

    public void send_getTableNamesByNamespace(java.lang.String name) throws org.apache.thrift.TException
    {
      getTableNamesByNamespace_args args = new getTableNamesByNamespace_args();
      args.setName(name);
      sendBase("getTableNamesByNamespace", args);
    }

    public java.util.List<TTableName> recv_getTableNamesByNamespace() throws TIOError, org.apache.thrift.TException
    {
      getTableNamesByNamespace_result result = new getTableNamesByNamespace_result();
      receiveBase(result, "getTableNamesByNamespace");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getTableNamesByNamespace failed: unknown result");
    }

    public void createTable(TTableDescriptor desc, java.util.List<java.nio.ByteBuffer> splitKeys) throws TIOError, org.apache.thrift.TException
    {
      send_createTable(desc, splitKeys);
      recv_createTable();
    }

    public void send_createTable(TTableDescriptor desc, java.util.List<java.nio.ByteBuffer> splitKeys) throws org.apache.thrift.TException
    {
      createTable_args args = new createTable_args();
      args.setDesc(desc);
      args.setSplitKeys(splitKeys);
      sendBase("createTable", args);
    }

    public void recv_createTable() throws TIOError, org.apache.thrift.TException
    {
      createTable_result result = new createTable_result();
      receiveBase(result, "createTable");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void deleteTable(TTableName tableName) throws TIOError, org.apache.thrift.TException
    {
      send_deleteTable(tableName);
      recv_deleteTable();
    }

    public void send_deleteTable(TTableName tableName) throws org.apache.thrift.TException
    {
      deleteTable_args args = new deleteTable_args();
      args.setTableName(tableName);
      sendBase("deleteTable", args);
    }

    public void recv_deleteTable() throws TIOError, org.apache.thrift.TException
    {
      deleteTable_result result = new deleteTable_result();
      receiveBase(result, "deleteTable");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void truncateTable(TTableName tableName, boolean preserveSplits) throws TIOError, org.apache.thrift.TException
    {
      send_truncateTable(tableName, preserveSplits);
      recv_truncateTable();
    }

    public void send_truncateTable(TTableName tableName, boolean preserveSplits) throws org.apache.thrift.TException
    {
      truncateTable_args args = new truncateTable_args();
      args.setTableName(tableName);
      args.setPreserveSplits(preserveSplits);
      sendBase("truncateTable", args);
    }

    public void recv_truncateTable() throws TIOError, org.apache.thrift.TException
    {
      truncateTable_result result = new truncateTable_result();
      receiveBase(result, "truncateTable");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void enableTable(TTableName tableName) throws TIOError, org.apache.thrift.TException
    {
      send_enableTable(tableName);
      recv_enableTable();
    }

    public void send_enableTable(TTableName tableName) throws org.apache.thrift.TException
    {
      enableTable_args args = new enableTable_args();
      args.setTableName(tableName);
      sendBase("enableTable", args);
    }

    public void recv_enableTable() throws TIOError, org.apache.thrift.TException
    {
      enableTable_result result = new enableTable_result();
      receiveBase(result, "enableTable");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void disableTable(TTableName tableName) throws TIOError, org.apache.thrift.TException
    {
      send_disableTable(tableName);
      recv_disableTable();
    }

    public void send_disableTable(TTableName tableName) throws org.apache.thrift.TException
    {
      disableTable_args args = new disableTable_args();
      args.setTableName(tableName);
      sendBase("disableTable", args);
    }

    public void recv_disableTable() throws TIOError, org.apache.thrift.TException
    {
      disableTable_result result = new disableTable_result();
      receiveBase(result, "disableTable");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public boolean isTableEnabled(TTableName tableName) throws TIOError, org.apache.thrift.TException
    {
      send_isTableEnabled(tableName);
      return recv_isTableEnabled();
    }

    public void send_isTableEnabled(TTableName tableName) throws org.apache.thrift.TException
    {
      isTableEnabled_args args = new isTableEnabled_args();
      args.setTableName(tableName);
      sendBase("isTableEnabled", args);
    }

    public boolean recv_isTableEnabled() throws TIOError, org.apache.thrift.TException
    {
      isTableEnabled_result result = new isTableEnabled_result();
      receiveBase(result, "isTableEnabled");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isTableEnabled failed: unknown result");
    }

    public boolean isTableDisabled(TTableName tableName) throws TIOError, org.apache.thrift.TException
    {
      send_isTableDisabled(tableName);
      return recv_isTableDisabled();
    }

    public void send_isTableDisabled(TTableName tableName) throws org.apache.thrift.TException
    {
      isTableDisabled_args args = new isTableDisabled_args();
      args.setTableName(tableName);
      sendBase("isTableDisabled", args);
    }

    public boolean recv_isTableDisabled() throws TIOError, org.apache.thrift.TException
    {
      isTableDisabled_result result = new isTableDisabled_result();
      receiveBase(result, "isTableDisabled");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isTableDisabled failed: unknown result");
    }

    public boolean isTableAvailable(TTableName tableName) throws TIOError, org.apache.thrift.TException
    {
      send_isTableAvailable(tableName);
      return recv_isTableAvailable();
    }

    public void send_isTableAvailable(TTableName tableName) throws org.apache.thrift.TException
    {
      isTableAvailable_args args = new isTableAvailable_args();
      args.setTableName(tableName);
      sendBase("isTableAvailable", args);
    }

    public boolean recv_isTableAvailable() throws TIOError, org.apache.thrift.TException
    {
      isTableAvailable_result result = new isTableAvailable_result();
      receiveBase(result, "isTableAvailable");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isTableAvailable failed: unknown result");
    }

    public boolean isTableAvailableWithSplit(TTableName tableName, java.util.List<java.nio.ByteBuffer> splitKeys) throws TIOError, org.apache.thrift.TException
    {
      send_isTableAvailableWithSplit(tableName, splitKeys);
      return recv_isTableAvailableWithSplit();
    }

    public void send_isTableAvailableWithSplit(TTableName tableName, java.util.List<java.nio.ByteBuffer> splitKeys) throws org.apache.thrift.TException
    {
      isTableAvailableWithSplit_args args = new isTableAvailableWithSplit_args();
      args.setTableName(tableName);
      args.setSplitKeys(splitKeys);
      sendBase("isTableAvailableWithSplit", args);
    }

    public boolean recv_isTableAvailableWithSplit() throws TIOError, org.apache.thrift.TException
    {
      isTableAvailableWithSplit_result result = new isTableAvailableWithSplit_result();
      receiveBase(result, "isTableAvailableWithSplit");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "isTableAvailableWithSplit failed: unknown result");
    }

    public void addColumnFamily(TTableName tableName, TColumnFamilyDescriptor column) throws TIOError, org.apache.thrift.TException
    {
      send_addColumnFamily(tableName, column);
      recv_addColumnFamily();
    }

    public void send_addColumnFamily(TTableName tableName, TColumnFamilyDescriptor column) throws org.apache.thrift.TException
    {
      addColumnFamily_args args = new addColumnFamily_args();
      args.setTableName(tableName);
      args.setColumn(column);
      sendBase("addColumnFamily", args);
    }

    public void recv_addColumnFamily() throws TIOError, org.apache.thrift.TException
    {
      addColumnFamily_result result = new addColumnFamily_result();
      receiveBase(result, "addColumnFamily");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void deleteColumnFamily(TTableName tableName, java.nio.ByteBuffer column) throws TIOError, org.apache.thrift.TException
    {
      send_deleteColumnFamily(tableName, column);
      recv_deleteColumnFamily();
    }

    public void send_deleteColumnFamily(TTableName tableName, java.nio.ByteBuffer column) throws org.apache.thrift.TException
    {
      deleteColumnFamily_args args = new deleteColumnFamily_args();
      args.setTableName(tableName);
      args.setColumn(column);
      sendBase("deleteColumnFamily", args);
    }

    public void recv_deleteColumnFamily() throws TIOError, org.apache.thrift.TException
    {
      deleteColumnFamily_result result = new deleteColumnFamily_result();
      receiveBase(result, "deleteColumnFamily");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void modifyColumnFamily(TTableName tableName, TColumnFamilyDescriptor column) throws TIOError, org.apache.thrift.TException
    {
      send_modifyColumnFamily(tableName, column);
      recv_modifyColumnFamily();
    }

    public void send_modifyColumnFamily(TTableName tableName, TColumnFamilyDescriptor column) throws org.apache.thrift.TException
    {
      modifyColumnFamily_args args = new modifyColumnFamily_args();
      args.setTableName(tableName);
      args.setColumn(column);
      sendBase("modifyColumnFamily", args);
    }

    public void recv_modifyColumnFamily() throws TIOError, org.apache.thrift.TException
    {
      modifyColumnFamily_result result = new modifyColumnFamily_result();
      receiveBase(result, "modifyColumnFamily");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void modifyTable(TTableDescriptor desc) throws TIOError, org.apache.thrift.TException
    {
      send_modifyTable(desc);
      recv_modifyTable();
    }

    public void send_modifyTable(TTableDescriptor desc) throws org.apache.thrift.TException
    {
      modifyTable_args args = new modifyTable_args();
      args.setDesc(desc);
      sendBase("modifyTable", args);
    }

    public void recv_modifyTable() throws TIOError, org.apache.thrift.TException
    {
      modifyTable_result result = new modifyTable_result();
      receiveBase(result, "modifyTable");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void createNamespace(TNamespaceDescriptor namespaceDesc) throws TIOError, org.apache.thrift.TException
    {
      send_createNamespace(namespaceDesc);
      recv_createNamespace();
    }

    public void send_createNamespace(TNamespaceDescriptor namespaceDesc) throws org.apache.thrift.TException
    {
      createNamespace_args args = new createNamespace_args();
      args.setNamespaceDesc(namespaceDesc);
      sendBase("createNamespace", args);
    }

    public void recv_createNamespace() throws TIOError, org.apache.thrift.TException
    {
      createNamespace_result result = new createNamespace_result();
      receiveBase(result, "createNamespace");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void modifyNamespace(TNamespaceDescriptor namespaceDesc) throws TIOError, org.apache.thrift.TException
    {
      send_modifyNamespace(namespaceDesc);
      recv_modifyNamespace();
    }

    public void send_modifyNamespace(TNamespaceDescriptor namespaceDesc) throws org.apache.thrift.TException
    {
      modifyNamespace_args args = new modifyNamespace_args();
      args.setNamespaceDesc(namespaceDesc);
      sendBase("modifyNamespace", args);
    }

    public void recv_modifyNamespace() throws TIOError, org.apache.thrift.TException
    {
      modifyNamespace_result result = new modifyNamespace_result();
      receiveBase(result, "modifyNamespace");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public void deleteNamespace(java.lang.String name) throws TIOError, org.apache.thrift.TException
    {
      send_deleteNamespace(name);
      recv_deleteNamespace();
    }

    public void send_deleteNamespace(java.lang.String name) throws org.apache.thrift.TException
    {
      deleteNamespace_args args = new deleteNamespace_args();
      args.setName(name);
      sendBase("deleteNamespace", args);
    }

    public void recv_deleteNamespace() throws TIOError, org.apache.thrift.TException
    {
      deleteNamespace_result result = new deleteNamespace_result();
      receiveBase(result, "deleteNamespace");
      if (result.io != null) {
        throw result.io;
      }
      return;
    }

    public TNamespaceDescriptor getNamespaceDescriptor(java.lang.String name) throws TIOError, org.apache.thrift.TException
    {
      send_getNamespaceDescriptor(name);
      return recv_getNamespaceDescriptor();
    }

    public void send_getNamespaceDescriptor(java.lang.String name) throws org.apache.thrift.TException
    {
      getNamespaceDescriptor_args args = new getNamespaceDescriptor_args();
      args.setName(name);
      sendBase("getNamespaceDescriptor", args);
    }

    public TNamespaceDescriptor recv_getNamespaceDescriptor() throws TIOError, org.apache.thrift.TException
    {
      getNamespaceDescriptor_result result = new getNamespaceDescriptor_result();
      receiveBase(result, "getNamespaceDescriptor");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getNamespaceDescriptor failed: unknown result");
    }

    public java.util.List<TNamespaceDescriptor> listNamespaceDescriptors() throws TIOError, org.apache.thrift.TException
    {
      send_listNamespaceDescriptors();
      return recv_listNamespaceDescriptors();
    }

    public void send_listNamespaceDescriptors() throws org.apache.thrift.TException
    {
      listNamespaceDescriptors_args args = new listNamespaceDescriptors_args();
      sendBase("listNamespaceDescriptors", args);
    }

    public java.util.List<TNamespaceDescriptor> recv_listNamespaceDescriptors() throws TIOError, org.apache.thrift.TException
    {
      listNamespaceDescriptors_result result = new listNamespaceDescriptors_result();
      receiveBase(result, "listNamespaceDescriptors");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "listNamespaceDescriptors failed: unknown result");
    }

    public java.util.List<java.lang.String> listNamespaces() throws TIOError, org.apache.thrift.TException
    {
      send_listNamespaces();
      return recv_listNamespaces();
    }

    public void send_listNamespaces() throws org.apache.thrift.TException
    {
      listNamespaces_args args = new listNamespaces_args();
      sendBase("listNamespaces", args);
    }

    public java.util.List<java.lang.String> recv_listNamespaces() throws TIOError, org.apache.thrift.TException
    {
      listNamespaces_result result = new listNamespaces_result();
      receiveBase(result, "listNamespaces");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "listNamespaces failed: unknown result");
    }

    public TThriftServerType getThriftServerType() throws org.apache.thrift.TException
    {
      send_getThriftServerType();
      return recv_getThriftServerType();
    }

    public void send_getThriftServerType() throws org.apache.thrift.TException
    {
      getThriftServerType_args args = new getThriftServerType_args();
      sendBase("getThriftServerType", args);
    }

    public TThriftServerType recv_getThriftServerType() throws org.apache.thrift.TException
    {
      getThriftServerType_result result = new getThriftServerType_result();
      receiveBase(result, "getThriftServerType");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getThriftServerType failed: unknown result");
    }

    public java.util.List<TOnlineLogRecord> getSlowLogResponses(java.util.Set<TServerName> serverNames, TLogQueryFilter logQueryFilter) throws TIOError, org.apache.thrift.TException
    {
      send_getSlowLogResponses(serverNames, logQueryFilter);
      return recv_getSlowLogResponses();
    }

    public void send_getSlowLogResponses(java.util.Set<TServerName> serverNames, TLogQueryFilter logQueryFilter) throws org.apache.thrift.TException
    {
      getSlowLogResponses_args args = new getSlowLogResponses_args();
      args.setServerNames(serverNames);
      args.setLogQueryFilter(logQueryFilter);
      sendBase("getSlowLogResponses", args);
    }

    public java.util.List<TOnlineLogRecord> recv_getSlowLogResponses() throws TIOError, org.apache.thrift.TException
    {
      getSlowLogResponses_result result = new getSlowLogResponses_result();
      receiveBase(result, "getSlowLogResponses");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getSlowLogResponses failed: unknown result");
    }

    public java.util.List<java.lang.Boolean> clearSlowLogResponses(java.util.Set<TServerName> serverNames) throws TIOError, org.apache.thrift.TException
    {
      send_clearSlowLogResponses(serverNames);
      return recv_clearSlowLogResponses();
    }

    public void send_clearSlowLogResponses(java.util.Set<TServerName> serverNames) throws org.apache.thrift.TException
    {
      clearSlowLogResponses_args args = new clearSlowLogResponses_args();
      args.setServerNames(serverNames);
      sendBase("clearSlowLogResponses", args);
    }

    public java.util.List<java.lang.Boolean> recv_clearSlowLogResponses() throws TIOError, org.apache.thrift.TException
    {
      clearSlowLogResponses_result result = new clearSlowLogResponses_result();
      receiveBase(result, "clearSlowLogResponses");
      if (result.isSetSuccess()) {
        return result.success;
      }
      if (result.io != null) {
        throw result.io;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "clearSlowLogResponses failed: unknown result");
    }

    public java.lang.String getClusterId() throws org.apache.thrift.TException
    {
      send_getClusterId();
      return recv_getClusterId();
    }

    public void send_getClusterId() throws org.apache.thrift.TException
    {
      getClusterId_args args = new getClusterId_args();
      sendBase("getClusterId", args);
    }

    public java.lang.String recv_getClusterId() throws org.apache.thrift.TException
    {
      getClusterId_result result = new getClusterId_result();
      receiveBase(result, "getClusterId");
      if (result.isSetSuccess()) {
        return result.success;
      }
      throw new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.MISSING_RESULT, "getClusterId failed: unknown result");
    }

  }
  public static class AsyncClient extends org.apache.thrift.async.TAsyncClient implements AsyncIface {
    public static class Factory implements org.apache.thrift.async.TAsyncClientFactory<AsyncClient> {
      private org.apache.thrift.async.TAsyncClientManager clientManager;
      private org.apache.thrift.protocol.TProtocolFactory protocolFactory;
      public Factory(org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.protocol.TProtocolFactory protocolFactory) {
        this.clientManager = clientManager;
        this.protocolFactory = protocolFactory;
      }
      public AsyncClient getAsyncClient(org.apache.thrift.transport.TNonblockingTransport transport) {
        return new AsyncClient(protocolFactory, clientManager, transport);
      }
    }

    public AsyncClient(org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.async.TAsyncClientManager clientManager, org.apache.thrift.transport.TNonblockingTransport transport) {
      super(protocolFactory, clientManager, transport);
    }

    public void exists(java.nio.ByteBuffer table, TGet tget, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      exists_call method_call = new exists_call(table, tget, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class exists_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Boolean> {
      private java.nio.ByteBuffer table;
      private TGet tget;
      public exists_call(java.nio.ByteBuffer table, TGet tget, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
        this.tget = tget;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("exists", org.apache.thrift.protocol.TMessageType.CALL, 0));
        exists_args args = new exists_args();
        args.setTable(table);
        args.setTget(tget);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Boolean getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_exists();
      }
    }

    public void existsAll(java.nio.ByteBuffer table, java.util.List<TGet> tgets, org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.Boolean>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      existsAll_call method_call = new existsAll_call(table, tgets, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class existsAll_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<java.lang.Boolean>> {
      private java.nio.ByteBuffer table;
      private java.util.List<TGet> tgets;
      public existsAll_call(java.nio.ByteBuffer table, java.util.List<TGet> tgets, org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.Boolean>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
        this.tgets = tgets;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("existsAll", org.apache.thrift.protocol.TMessageType.CALL, 0));
        existsAll_args args = new existsAll_args();
        args.setTable(table);
        args.setTgets(tgets);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<java.lang.Boolean> getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_existsAll();
      }
    }

    public void get(java.nio.ByteBuffer table, TGet tget, org.apache.thrift.async.AsyncMethodCallback<TResult> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      get_call method_call = new get_call(table, tget, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class get_call extends org.apache.thrift.async.TAsyncMethodCall<TResult> {
      private java.nio.ByteBuffer table;
      private TGet tget;
      public get_call(java.nio.ByteBuffer table, TGet tget, org.apache.thrift.async.AsyncMethodCallback<TResult> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
        this.tget = tget;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("get", org.apache.thrift.protocol.TMessageType.CALL, 0));
        get_args args = new get_args();
        args.setTable(table);
        args.setTget(tget);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TResult getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_get();
      }
    }

    public void getMultiple(java.nio.ByteBuffer table, java.util.List<TGet> tgets, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getMultiple_call method_call = new getMultiple_call(table, tgets, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getMultiple_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TResult>> {
      private java.nio.ByteBuffer table;
      private java.util.List<TGet> tgets;
      public getMultiple_call(java.nio.ByteBuffer table, java.util.List<TGet> tgets, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
        this.tgets = tgets;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getMultiple", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getMultiple_args args = new getMultiple_args();
        args.setTable(table);
        args.setTgets(tgets);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TResult> getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getMultiple();
      }
    }

    public void put(java.nio.ByteBuffer table, TPut tput, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      put_call method_call = new put_call(table, tput, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class put_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer table;
      private TPut tput;
      public put_call(java.nio.ByteBuffer table, TPut tput, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
        this.tput = tput;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("put", org.apache.thrift.protocol.TMessageType.CALL, 0));
        put_args args = new put_args();
        args.setTable(table);
        args.setTput(tput);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void checkAndPut(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, java.nio.ByteBuffer value, TPut tput, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      checkAndPut_call method_call = new checkAndPut_call(table, row, family, qualifier, value, tput, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class checkAndPut_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Boolean> {
      private java.nio.ByteBuffer table;
      private java.nio.ByteBuffer row;
      private java.nio.ByteBuffer family;
      private java.nio.ByteBuffer qualifier;
      private java.nio.ByteBuffer value;
      private TPut tput;
      public checkAndPut_call(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, java.nio.ByteBuffer value, TPut tput, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
        this.row = row;
        this.family = family;
        this.qualifier = qualifier;
        this.value = value;
        this.tput = tput;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("checkAndPut", org.apache.thrift.protocol.TMessageType.CALL, 0));
        checkAndPut_args args = new checkAndPut_args();
        args.setTable(table);
        args.setRow(row);
        args.setFamily(family);
        args.setQualifier(qualifier);
        args.setValue(value);
        args.setTput(tput);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Boolean getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_checkAndPut();
      }
    }

    public void putMultiple(java.nio.ByteBuffer table, java.util.List<TPut> tputs, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      putMultiple_call method_call = new putMultiple_call(table, tputs, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class putMultiple_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer table;
      private java.util.List<TPut> tputs;
      public putMultiple_call(java.nio.ByteBuffer table, java.util.List<TPut> tputs, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
        this.tputs = tputs;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("putMultiple", org.apache.thrift.protocol.TMessageType.CALL, 0));
        putMultiple_args args = new putMultiple_args();
        args.setTable(table);
        args.setTputs(tputs);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void deleteSingle(java.nio.ByteBuffer table, TDelete tdelete, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteSingle_call method_call = new deleteSingle_call(table, tdelete, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteSingle_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer table;
      private TDelete tdelete;
      public deleteSingle_call(java.nio.ByteBuffer table, TDelete tdelete, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
        this.tdelete = tdelete;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteSingle", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteSingle_args args = new deleteSingle_args();
        args.setTable(table);
        args.setTdelete(tdelete);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void deleteMultiple(java.nio.ByteBuffer table, java.util.List<TDelete> tdeletes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TDelete>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteMultiple_call method_call = new deleteMultiple_call(table, tdeletes, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteMultiple_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TDelete>> {
      private java.nio.ByteBuffer table;
      private java.util.List<TDelete> tdeletes;
      public deleteMultiple_call(java.nio.ByteBuffer table, java.util.List<TDelete> tdeletes, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TDelete>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
        this.tdeletes = tdeletes;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteMultiple", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteMultiple_args args = new deleteMultiple_args();
        args.setTable(table);
        args.setTdeletes(tdeletes);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TDelete> getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_deleteMultiple();
      }
    }

    public void checkAndDelete(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, java.nio.ByteBuffer value, TDelete tdelete, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      checkAndDelete_call method_call = new checkAndDelete_call(table, row, family, qualifier, value, tdelete, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class checkAndDelete_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Boolean> {
      private java.nio.ByteBuffer table;
      private java.nio.ByteBuffer row;
      private java.nio.ByteBuffer family;
      private java.nio.ByteBuffer qualifier;
      private java.nio.ByteBuffer value;
      private TDelete tdelete;
      public checkAndDelete_call(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, java.nio.ByteBuffer value, TDelete tdelete, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
        this.row = row;
        this.family = family;
        this.qualifier = qualifier;
        this.value = value;
        this.tdelete = tdelete;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("checkAndDelete", org.apache.thrift.protocol.TMessageType.CALL, 0));
        checkAndDelete_args args = new checkAndDelete_args();
        args.setTable(table);
        args.setRow(row);
        args.setFamily(family);
        args.setQualifier(qualifier);
        args.setValue(value);
        args.setTdelete(tdelete);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Boolean getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_checkAndDelete();
      }
    }

    public void increment(java.nio.ByteBuffer table, TIncrement tincrement, org.apache.thrift.async.AsyncMethodCallback<TResult> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      increment_call method_call = new increment_call(table, tincrement, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class increment_call extends org.apache.thrift.async.TAsyncMethodCall<TResult> {
      private java.nio.ByteBuffer table;
      private TIncrement tincrement;
      public increment_call(java.nio.ByteBuffer table, TIncrement tincrement, org.apache.thrift.async.AsyncMethodCallback<TResult> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
        this.tincrement = tincrement;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("increment", org.apache.thrift.protocol.TMessageType.CALL, 0));
        increment_args args = new increment_args();
        args.setTable(table);
        args.setTincrement(tincrement);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TResult getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_increment();
      }
    }

    public void append(java.nio.ByteBuffer table, TAppend tappend, org.apache.thrift.async.AsyncMethodCallback<TResult> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      append_call method_call = new append_call(table, tappend, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class append_call extends org.apache.thrift.async.TAsyncMethodCall<TResult> {
      private java.nio.ByteBuffer table;
      private TAppend tappend;
      public append_call(java.nio.ByteBuffer table, TAppend tappend, org.apache.thrift.async.AsyncMethodCallback<TResult> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
        this.tappend = tappend;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("append", org.apache.thrift.protocol.TMessageType.CALL, 0));
        append_args args = new append_args();
        args.setTable(table);
        args.setTappend(tappend);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TResult getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_append();
      }
    }

    public void openScanner(java.nio.ByteBuffer table, TScan tscan, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      openScanner_call method_call = new openScanner_call(table, tscan, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class openScanner_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Integer> {
      private java.nio.ByteBuffer table;
      private TScan tscan;
      public openScanner_call(java.nio.ByteBuffer table, TScan tscan, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
        this.tscan = tscan;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("openScanner", org.apache.thrift.protocol.TMessageType.CALL, 0));
        openScanner_args args = new openScanner_args();
        args.setTable(table);
        args.setTscan(tscan);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Integer getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_openScanner();
      }
    }

    public void getScannerRows(int scannerId, int numRows, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getScannerRows_call method_call = new getScannerRows_call(scannerId, numRows, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getScannerRows_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TResult>> {
      private int scannerId;
      private int numRows;
      public getScannerRows_call(int scannerId, int numRows, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.scannerId = scannerId;
        this.numRows = numRows;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getScannerRows", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getScannerRows_args args = new getScannerRows_args();
        args.setScannerId(scannerId);
        args.setNumRows(numRows);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TResult> getResult() throws TIOError, TIllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getScannerRows();
      }
    }

    public void closeScanner(int scannerId, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      closeScanner_call method_call = new closeScanner_call(scannerId, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class closeScanner_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private int scannerId;
      public closeScanner_call(int scannerId, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.scannerId = scannerId;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("closeScanner", org.apache.thrift.protocol.TMessageType.CALL, 0));
        closeScanner_args args = new closeScanner_args();
        args.setScannerId(scannerId);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws TIOError, TIllegalArgument, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void mutateRow(java.nio.ByteBuffer table, TRowMutations trowMutations, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      mutateRow_call method_call = new mutateRow_call(table, trowMutations, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class mutateRow_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.nio.ByteBuffer table;
      private TRowMutations trowMutations;
      public mutateRow_call(java.nio.ByteBuffer table, TRowMutations trowMutations, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
        this.trowMutations = trowMutations;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("mutateRow", org.apache.thrift.protocol.TMessageType.CALL, 0));
        mutateRow_args args = new mutateRow_args();
        args.setTable(table);
        args.setTrowMutations(trowMutations);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void getScannerResults(java.nio.ByteBuffer table, TScan tscan, int numRows, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getScannerResults_call method_call = new getScannerResults_call(table, tscan, numRows, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getScannerResults_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TResult>> {
      private java.nio.ByteBuffer table;
      private TScan tscan;
      private int numRows;
      public getScannerResults_call(java.nio.ByteBuffer table, TScan tscan, int numRows, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
        this.tscan = tscan;
        this.numRows = numRows;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getScannerResults", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getScannerResults_args args = new getScannerResults_args();
        args.setTable(table);
        args.setTscan(tscan);
        args.setNumRows(numRows);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TResult> getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getScannerResults();
      }
    }

    public void getRegionLocation(java.nio.ByteBuffer table, java.nio.ByteBuffer row, boolean reload, org.apache.thrift.async.AsyncMethodCallback<THRegionLocation> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getRegionLocation_call method_call = new getRegionLocation_call(table, row, reload, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getRegionLocation_call extends org.apache.thrift.async.TAsyncMethodCall<THRegionLocation> {
      private java.nio.ByteBuffer table;
      private java.nio.ByteBuffer row;
      private boolean reload;
      public getRegionLocation_call(java.nio.ByteBuffer table, java.nio.ByteBuffer row, boolean reload, org.apache.thrift.async.AsyncMethodCallback<THRegionLocation> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
        this.row = row;
        this.reload = reload;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getRegionLocation", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getRegionLocation_args args = new getRegionLocation_args();
        args.setTable(table);
        args.setRow(row);
        args.setReload(reload);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public THRegionLocation getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getRegionLocation();
      }
    }

    public void getAllRegionLocations(java.nio.ByteBuffer table, org.apache.thrift.async.AsyncMethodCallback<java.util.List<THRegionLocation>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getAllRegionLocations_call method_call = new getAllRegionLocations_call(table, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getAllRegionLocations_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<THRegionLocation>> {
      private java.nio.ByteBuffer table;
      public getAllRegionLocations_call(java.nio.ByteBuffer table, org.apache.thrift.async.AsyncMethodCallback<java.util.List<THRegionLocation>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getAllRegionLocations", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getAllRegionLocations_args args = new getAllRegionLocations_args();
        args.setTable(table);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<THRegionLocation> getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getAllRegionLocations();
      }
    }

    public void checkAndMutate(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, TCompareOp compareOp, java.nio.ByteBuffer value, TRowMutations rowMutations, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      checkAndMutate_call method_call = new checkAndMutate_call(table, row, family, qualifier, compareOp, value, rowMutations, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class checkAndMutate_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Boolean> {
      private java.nio.ByteBuffer table;
      private java.nio.ByteBuffer row;
      private java.nio.ByteBuffer family;
      private java.nio.ByteBuffer qualifier;
      private TCompareOp compareOp;
      private java.nio.ByteBuffer value;
      private TRowMutations rowMutations;
      public checkAndMutate_call(java.nio.ByteBuffer table, java.nio.ByteBuffer row, java.nio.ByteBuffer family, java.nio.ByteBuffer qualifier, TCompareOp compareOp, java.nio.ByteBuffer value, TRowMutations rowMutations, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
        this.row = row;
        this.family = family;
        this.qualifier = qualifier;
        this.compareOp = compareOp;
        this.value = value;
        this.rowMutations = rowMutations;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("checkAndMutate", org.apache.thrift.protocol.TMessageType.CALL, 0));
        checkAndMutate_args args = new checkAndMutate_args();
        args.setTable(table);
        args.setRow(row);
        args.setFamily(family);
        args.setQualifier(qualifier);
        args.setCompareOp(compareOp);
        args.setValue(value);
        args.setRowMutations(rowMutations);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Boolean getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_checkAndMutate();
      }
    }

    public void getTableDescriptor(TTableName table, org.apache.thrift.async.AsyncMethodCallback<TTableDescriptor> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTableDescriptor_call method_call = new getTableDescriptor_call(table, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTableDescriptor_call extends org.apache.thrift.async.TAsyncMethodCall<TTableDescriptor> {
      private TTableName table;
      public getTableDescriptor_call(TTableName table, org.apache.thrift.async.AsyncMethodCallback<TTableDescriptor> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.table = table;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTableDescriptor", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTableDescriptor_args args = new getTableDescriptor_args();
        args.setTable(table);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TTableDescriptor getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTableDescriptor();
      }
    }

    public void getTableDescriptors(java.util.List<TTableName> tables, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTableDescriptors_call method_call = new getTableDescriptors_call(tables, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTableDescriptors_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TTableDescriptor>> {
      private java.util.List<TTableName> tables;
      public getTableDescriptors_call(java.util.List<TTableName> tables, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tables = tables;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTableDescriptors", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTableDescriptors_args args = new getTableDescriptors_args();
        args.setTables(tables);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TTableDescriptor> getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTableDescriptors();
      }
    }

    public void tableExists(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      tableExists_call method_call = new tableExists_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class tableExists_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Boolean> {
      private TTableName tableName;
      public tableExists_call(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("tableExists", org.apache.thrift.protocol.TMessageType.CALL, 0));
        tableExists_args args = new tableExists_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Boolean getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_tableExists();
      }
    }

    public void getTableDescriptorsByPattern(java.lang.String regex, boolean includeSysTables, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTableDescriptorsByPattern_call method_call = new getTableDescriptorsByPattern_call(regex, includeSysTables, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTableDescriptorsByPattern_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TTableDescriptor>> {
      private java.lang.String regex;
      private boolean includeSysTables;
      public getTableDescriptorsByPattern_call(java.lang.String regex, boolean includeSysTables, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.regex = regex;
        this.includeSysTables = includeSysTables;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTableDescriptorsByPattern", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTableDescriptorsByPattern_args args = new getTableDescriptorsByPattern_args();
        args.setRegex(regex);
        args.setIncludeSysTables(includeSysTables);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TTableDescriptor> getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTableDescriptorsByPattern();
      }
    }

    public void getTableDescriptorsByNamespace(java.lang.String name, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTableDescriptorsByNamespace_call method_call = new getTableDescriptorsByNamespace_call(name, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTableDescriptorsByNamespace_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TTableDescriptor>> {
      private java.lang.String name;
      public getTableDescriptorsByNamespace_call(java.lang.String name, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTableDescriptorsByNamespace", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTableDescriptorsByNamespace_args args = new getTableDescriptorsByNamespace_args();
        args.setName(name);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TTableDescriptor> getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTableDescriptorsByNamespace();
      }
    }

    public void getTableNamesByPattern(java.lang.String regex, boolean includeSysTables, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableName>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTableNamesByPattern_call method_call = new getTableNamesByPattern_call(regex, includeSysTables, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTableNamesByPattern_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TTableName>> {
      private java.lang.String regex;
      private boolean includeSysTables;
      public getTableNamesByPattern_call(java.lang.String regex, boolean includeSysTables, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableName>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.regex = regex;
        this.includeSysTables = includeSysTables;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTableNamesByPattern", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTableNamesByPattern_args args = new getTableNamesByPattern_args();
        args.setRegex(regex);
        args.setIncludeSysTables(includeSysTables);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TTableName> getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTableNamesByPattern();
      }
    }

    public void getTableNamesByNamespace(java.lang.String name, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableName>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getTableNamesByNamespace_call method_call = new getTableNamesByNamespace_call(name, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getTableNamesByNamespace_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TTableName>> {
      private java.lang.String name;
      public getTableNamesByNamespace_call(java.lang.String name, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableName>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getTableNamesByNamespace", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getTableNamesByNamespace_args args = new getTableNamesByNamespace_args();
        args.setName(name);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TTableName> getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getTableNamesByNamespace();
      }
    }

    public void createTable(TTableDescriptor desc, java.util.List<java.nio.ByteBuffer> splitKeys, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createTable_call method_call = new createTable_call(desc, splitKeys, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createTable_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private TTableDescriptor desc;
      private java.util.List<java.nio.ByteBuffer> splitKeys;
      public createTable_call(TTableDescriptor desc, java.util.List<java.nio.ByteBuffer> splitKeys, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.desc = desc;
        this.splitKeys = splitKeys;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createTable_args args = new createTable_args();
        args.setDesc(desc);
        args.setSplitKeys(splitKeys);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void deleteTable(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteTable_call method_call = new deleteTable_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteTable_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private TTableName tableName;
      public deleteTable_call(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteTable_args args = new deleteTable_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void truncateTable(TTableName tableName, boolean preserveSplits, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      truncateTable_call method_call = new truncateTable_call(tableName, preserveSplits, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class truncateTable_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private TTableName tableName;
      private boolean preserveSplits;
      public truncateTable_call(TTableName tableName, boolean preserveSplits, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.preserveSplits = preserveSplits;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("truncateTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        truncateTable_args args = new truncateTable_args();
        args.setTableName(tableName);
        args.setPreserveSplits(preserveSplits);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void enableTable(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      enableTable_call method_call = new enableTable_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class enableTable_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private TTableName tableName;
      public enableTable_call(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("enableTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        enableTable_args args = new enableTable_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void disableTable(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      disableTable_call method_call = new disableTable_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class disableTable_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private TTableName tableName;
      public disableTable_call(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("disableTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        disableTable_args args = new disableTable_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void isTableEnabled(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isTableEnabled_call method_call = new isTableEnabled_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isTableEnabled_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Boolean> {
      private TTableName tableName;
      public isTableEnabled_call(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isTableEnabled", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isTableEnabled_args args = new isTableEnabled_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Boolean getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isTableEnabled();
      }
    }

    public void isTableDisabled(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isTableDisabled_call method_call = new isTableDisabled_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isTableDisabled_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Boolean> {
      private TTableName tableName;
      public isTableDisabled_call(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isTableDisabled", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isTableDisabled_args args = new isTableDisabled_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Boolean getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isTableDisabled();
      }
    }

    public void isTableAvailable(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isTableAvailable_call method_call = new isTableAvailable_call(tableName, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isTableAvailable_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Boolean> {
      private TTableName tableName;
      public isTableAvailable_call(TTableName tableName, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isTableAvailable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isTableAvailable_args args = new isTableAvailable_args();
        args.setTableName(tableName);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Boolean getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isTableAvailable();
      }
    }

    public void isTableAvailableWithSplit(TTableName tableName, java.util.List<java.nio.ByteBuffer> splitKeys, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      isTableAvailableWithSplit_call method_call = new isTableAvailableWithSplit_call(tableName, splitKeys, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class isTableAvailableWithSplit_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.Boolean> {
      private TTableName tableName;
      private java.util.List<java.nio.ByteBuffer> splitKeys;
      public isTableAvailableWithSplit_call(TTableName tableName, java.util.List<java.nio.ByteBuffer> splitKeys, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.splitKeys = splitKeys;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("isTableAvailableWithSplit", org.apache.thrift.protocol.TMessageType.CALL, 0));
        isTableAvailableWithSplit_args args = new isTableAvailableWithSplit_args();
        args.setTableName(tableName);
        args.setSplitKeys(splitKeys);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.Boolean getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_isTableAvailableWithSplit();
      }
    }

    public void addColumnFamily(TTableName tableName, TColumnFamilyDescriptor column, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      addColumnFamily_call method_call = new addColumnFamily_call(tableName, column, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class addColumnFamily_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private TTableName tableName;
      private TColumnFamilyDescriptor column;
      public addColumnFamily_call(TTableName tableName, TColumnFamilyDescriptor column, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.column = column;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("addColumnFamily", org.apache.thrift.protocol.TMessageType.CALL, 0));
        addColumnFamily_args args = new addColumnFamily_args();
        args.setTableName(tableName);
        args.setColumn(column);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void deleteColumnFamily(TTableName tableName, java.nio.ByteBuffer column, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteColumnFamily_call method_call = new deleteColumnFamily_call(tableName, column, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteColumnFamily_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private TTableName tableName;
      private java.nio.ByteBuffer column;
      public deleteColumnFamily_call(TTableName tableName, java.nio.ByteBuffer column, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.column = column;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteColumnFamily", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteColumnFamily_args args = new deleteColumnFamily_args();
        args.setTableName(tableName);
        args.setColumn(column);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void modifyColumnFamily(TTableName tableName, TColumnFamilyDescriptor column, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      modifyColumnFamily_call method_call = new modifyColumnFamily_call(tableName, column, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class modifyColumnFamily_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private TTableName tableName;
      private TColumnFamilyDescriptor column;
      public modifyColumnFamily_call(TTableName tableName, TColumnFamilyDescriptor column, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.tableName = tableName;
        this.column = column;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("modifyColumnFamily", org.apache.thrift.protocol.TMessageType.CALL, 0));
        modifyColumnFamily_args args = new modifyColumnFamily_args();
        args.setTableName(tableName);
        args.setColumn(column);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void modifyTable(TTableDescriptor desc, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      modifyTable_call method_call = new modifyTable_call(desc, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class modifyTable_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private TTableDescriptor desc;
      public modifyTable_call(TTableDescriptor desc, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.desc = desc;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("modifyTable", org.apache.thrift.protocol.TMessageType.CALL, 0));
        modifyTable_args args = new modifyTable_args();
        args.setDesc(desc);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void createNamespace(TNamespaceDescriptor namespaceDesc, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      createNamespace_call method_call = new createNamespace_call(namespaceDesc, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class createNamespace_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private TNamespaceDescriptor namespaceDesc;
      public createNamespace_call(TNamespaceDescriptor namespaceDesc, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.namespaceDesc = namespaceDesc;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("createNamespace", org.apache.thrift.protocol.TMessageType.CALL, 0));
        createNamespace_args args = new createNamespace_args();
        args.setNamespaceDesc(namespaceDesc);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void modifyNamespace(TNamespaceDescriptor namespaceDesc, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      modifyNamespace_call method_call = new modifyNamespace_call(namespaceDesc, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class modifyNamespace_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private TNamespaceDescriptor namespaceDesc;
      public modifyNamespace_call(TNamespaceDescriptor namespaceDesc, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.namespaceDesc = namespaceDesc;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("modifyNamespace", org.apache.thrift.protocol.TMessageType.CALL, 0));
        modifyNamespace_args args = new modifyNamespace_args();
        args.setNamespaceDesc(namespaceDesc);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void deleteNamespace(java.lang.String name, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      deleteNamespace_call method_call = new deleteNamespace_call(name, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class deleteNamespace_call extends org.apache.thrift.async.TAsyncMethodCall<Void> {
      private java.lang.String name;
      public deleteNamespace_call(java.lang.String name, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("deleteNamespace", org.apache.thrift.protocol.TMessageType.CALL, 0));
        deleteNamespace_args args = new deleteNamespace_args();
        args.setName(name);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public Void getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return null;
      }
    }

    public void getNamespaceDescriptor(java.lang.String name, org.apache.thrift.async.AsyncMethodCallback<TNamespaceDescriptor> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getNamespaceDescriptor_call method_call = new getNamespaceDescriptor_call(name, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getNamespaceDescriptor_call extends org.apache.thrift.async.TAsyncMethodCall<TNamespaceDescriptor> {
      private java.lang.String name;
      public getNamespaceDescriptor_call(java.lang.String name, org.apache.thrift.async.AsyncMethodCallback<TNamespaceDescriptor> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.name = name;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getNamespaceDescriptor", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getNamespaceDescriptor_args args = new getNamespaceDescriptor_args();
        args.setName(name);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TNamespaceDescriptor getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getNamespaceDescriptor();
      }
    }

    public void listNamespaceDescriptors(org.apache.thrift.async.AsyncMethodCallback<java.util.List<TNamespaceDescriptor>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      listNamespaceDescriptors_call method_call = new listNamespaceDescriptors_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class listNamespaceDescriptors_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TNamespaceDescriptor>> {
      public listNamespaceDescriptors_call(org.apache.thrift.async.AsyncMethodCallback<java.util.List<TNamespaceDescriptor>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("listNamespaceDescriptors", org.apache.thrift.protocol.TMessageType.CALL, 0));
        listNamespaceDescriptors_args args = new listNamespaceDescriptors_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TNamespaceDescriptor> getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_listNamespaceDescriptors();
      }
    }

    public void listNamespaces(org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.String>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      listNamespaces_call method_call = new listNamespaces_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class listNamespaces_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<java.lang.String>> {
      public listNamespaces_call(org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.String>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("listNamespaces", org.apache.thrift.protocol.TMessageType.CALL, 0));
        listNamespaces_args args = new listNamespaces_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<java.lang.String> getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_listNamespaces();
      }
    }

    public void getThriftServerType(org.apache.thrift.async.AsyncMethodCallback<TThriftServerType> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getThriftServerType_call method_call = new getThriftServerType_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getThriftServerType_call extends org.apache.thrift.async.TAsyncMethodCall<TThriftServerType> {
      public getThriftServerType_call(org.apache.thrift.async.AsyncMethodCallback<TThriftServerType> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getThriftServerType", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getThriftServerType_args args = new getThriftServerType_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public TThriftServerType getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getThriftServerType();
      }
    }

    public void getSlowLogResponses(java.util.Set<TServerName> serverNames, TLogQueryFilter logQueryFilter, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TOnlineLogRecord>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getSlowLogResponses_call method_call = new getSlowLogResponses_call(serverNames, logQueryFilter, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getSlowLogResponses_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<TOnlineLogRecord>> {
      private java.util.Set<TServerName> serverNames;
      private TLogQueryFilter logQueryFilter;
      public getSlowLogResponses_call(java.util.Set<TServerName> serverNames, TLogQueryFilter logQueryFilter, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TOnlineLogRecord>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.serverNames = serverNames;
        this.logQueryFilter = logQueryFilter;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getSlowLogResponses", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getSlowLogResponses_args args = new getSlowLogResponses_args();
        args.setServerNames(serverNames);
        args.setLogQueryFilter(logQueryFilter);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<TOnlineLogRecord> getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getSlowLogResponses();
      }
    }

    public void clearSlowLogResponses(java.util.Set<TServerName> serverNames, org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.Boolean>> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      clearSlowLogResponses_call method_call = new clearSlowLogResponses_call(serverNames, resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class clearSlowLogResponses_call extends org.apache.thrift.async.TAsyncMethodCall<java.util.List<java.lang.Boolean>> {
      private java.util.Set<TServerName> serverNames;
      public clearSlowLogResponses_call(java.util.Set<TServerName> serverNames, org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.Boolean>> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
        this.serverNames = serverNames;
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("clearSlowLogResponses", org.apache.thrift.protocol.TMessageType.CALL, 0));
        clearSlowLogResponses_args args = new clearSlowLogResponses_args();
        args.setServerNames(serverNames);
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.util.List<java.lang.Boolean> getResult() throws TIOError, org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_clearSlowLogResponses();
      }
    }

    public void getClusterId(org.apache.thrift.async.AsyncMethodCallback<java.lang.String> resultHandler) throws org.apache.thrift.TException {
      checkReady();
      getClusterId_call method_call = new getClusterId_call(resultHandler, this, ___protocolFactory, ___transport);
      this.___currentMethod = method_call;
      ___manager.call(method_call);
    }

    public static class getClusterId_call extends org.apache.thrift.async.TAsyncMethodCall<java.lang.String> {
      public getClusterId_call(org.apache.thrift.async.AsyncMethodCallback<java.lang.String> resultHandler, org.apache.thrift.async.TAsyncClient client, org.apache.thrift.protocol.TProtocolFactory protocolFactory, org.apache.thrift.transport.TNonblockingTransport transport) throws org.apache.thrift.TException {
        super(client, protocolFactory, transport, resultHandler, false);
      }

      public void write_args(org.apache.thrift.protocol.TProtocol prot) throws org.apache.thrift.TException {
        prot.writeMessageBegin(new org.apache.thrift.protocol.TMessage("getClusterId", org.apache.thrift.protocol.TMessageType.CALL, 0));
        getClusterId_args args = new getClusterId_args();
        args.write(prot);
        prot.writeMessageEnd();
      }

      public java.lang.String getResult() throws org.apache.thrift.TException {
        if (getState() != org.apache.thrift.async.TAsyncMethodCall.State.RESPONSE_READ) {
          throw new java.lang.IllegalStateException("Method call not finished!");
        }
        org.apache.thrift.transport.TMemoryInputTransport memoryTransport = new org.apache.thrift.transport.TMemoryInputTransport(getFrameBuffer().array());
        org.apache.thrift.protocol.TProtocol prot = client.getProtocolFactory().getProtocol(memoryTransport);
        return (new Client(prot)).recv_getClusterId();
      }
    }

  }

  public static class Processor<I extends Iface> extends org.apache.thrift.TBaseProcessor<I> implements org.apache.thrift.TProcessor {
    private static final org.slf4j.Logger _LOGGER = org.slf4j.LoggerFactory.getLogger(Processor.class.getName());
    public Processor(I iface) {
      super(iface, getProcessMap(new java.util.HashMap<java.lang.String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>>()));
    }

    protected Processor(I iface, java.util.Map<java.lang.String, org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends Iface> java.util.Map<java.lang.String,  org.apache.thrift.ProcessFunction<I, ? extends org.apache.thrift.TBase>> getProcessMap(java.util.Map<java.lang.String, org.apache.thrift.ProcessFunction<I, ? extends  org.apache.thrift.TBase>> processMap) {
      processMap.put("exists", new exists());
      processMap.put("existsAll", new existsAll());
      processMap.put("get", new get());
      processMap.put("getMultiple", new getMultiple());
      processMap.put("put", new put());
      processMap.put("checkAndPut", new checkAndPut());
      processMap.put("putMultiple", new putMultiple());
      processMap.put("deleteSingle", new deleteSingle());
      processMap.put("deleteMultiple", new deleteMultiple());
      processMap.put("checkAndDelete", new checkAndDelete());
      processMap.put("increment", new increment());
      processMap.put("append", new append());
      processMap.put("openScanner", new openScanner());
      processMap.put("getScannerRows", new getScannerRows());
      processMap.put("closeScanner", new closeScanner());
      processMap.put("mutateRow", new mutateRow());
      processMap.put("getScannerResults", new getScannerResults());
      processMap.put("getRegionLocation", new getRegionLocation());
      processMap.put("getAllRegionLocations", new getAllRegionLocations());
      processMap.put("checkAndMutate", new checkAndMutate());
      processMap.put("getTableDescriptor", new getTableDescriptor());
      processMap.put("getTableDescriptors", new getTableDescriptors());
      processMap.put("tableExists", new tableExists());
      processMap.put("getTableDescriptorsByPattern", new getTableDescriptorsByPattern());
      processMap.put("getTableDescriptorsByNamespace", new getTableDescriptorsByNamespace());
      processMap.put("getTableNamesByPattern", new getTableNamesByPattern());
      processMap.put("getTableNamesByNamespace", new getTableNamesByNamespace());
      processMap.put("createTable", new createTable());
      processMap.put("deleteTable", new deleteTable());
      processMap.put("truncateTable", new truncateTable());
      processMap.put("enableTable", new enableTable());
      processMap.put("disableTable", new disableTable());
      processMap.put("isTableEnabled", new isTableEnabled());
      processMap.put("isTableDisabled", new isTableDisabled());
      processMap.put("isTableAvailable", new isTableAvailable());
      processMap.put("isTableAvailableWithSplit", new isTableAvailableWithSplit());
      processMap.put("addColumnFamily", new addColumnFamily());
      processMap.put("deleteColumnFamily", new deleteColumnFamily());
      processMap.put("modifyColumnFamily", new modifyColumnFamily());
      processMap.put("modifyTable", new modifyTable());
      processMap.put("createNamespace", new createNamespace());
      processMap.put("modifyNamespace", new modifyNamespace());
      processMap.put("deleteNamespace", new deleteNamespace());
      processMap.put("getNamespaceDescriptor", new getNamespaceDescriptor());
      processMap.put("listNamespaceDescriptors", new listNamespaceDescriptors());
      processMap.put("listNamespaces", new listNamespaces());
      processMap.put("getThriftServerType", new getThriftServerType());
      processMap.put("getSlowLogResponses", new getSlowLogResponses());
      processMap.put("clearSlowLogResponses", new clearSlowLogResponses());
      processMap.put("getClusterId", new getClusterId());
      return processMap;
    }

    public static class exists<I extends Iface> extends org.apache.thrift.ProcessFunction<I, exists_args> {
      public exists() {
        super("exists");
      }

      public exists_args getEmptyArgsInstance() {
        return new exists_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public exists_result getResult(I iface, exists_args args) throws org.apache.thrift.TException {
        exists_result result = new exists_result();
        try {
          result.success = iface.exists(args.table, args.tget);
          result.setSuccessIsSet(true);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class existsAll<I extends Iface> extends org.apache.thrift.ProcessFunction<I, existsAll_args> {
      public existsAll() {
        super("existsAll");
      }

      public existsAll_args getEmptyArgsInstance() {
        return new existsAll_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public existsAll_result getResult(I iface, existsAll_args args) throws org.apache.thrift.TException {
        existsAll_result result = new existsAll_result();
        try {
          result.success = iface.existsAll(args.table, args.tgets);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class get<I extends Iface> extends org.apache.thrift.ProcessFunction<I, get_args> {
      public get() {
        super("get");
      }

      public get_args getEmptyArgsInstance() {
        return new get_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public get_result getResult(I iface, get_args args) throws org.apache.thrift.TException {
        get_result result = new get_result();
        try {
          result.success = iface.get(args.table, args.tget);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getMultiple<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getMultiple_args> {
      public getMultiple() {
        super("getMultiple");
      }

      public getMultiple_args getEmptyArgsInstance() {
        return new getMultiple_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getMultiple_result getResult(I iface, getMultiple_args args) throws org.apache.thrift.TException {
        getMultiple_result result = new getMultiple_result();
        try {
          result.success = iface.getMultiple(args.table, args.tgets);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class put<I extends Iface> extends org.apache.thrift.ProcessFunction<I, put_args> {
      public put() {
        super("put");
      }

      public put_args getEmptyArgsInstance() {
        return new put_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public put_result getResult(I iface, put_args args) throws org.apache.thrift.TException {
        put_result result = new put_result();
        try {
          iface.put(args.table, args.tput);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class checkAndPut<I extends Iface> extends org.apache.thrift.ProcessFunction<I, checkAndPut_args> {
      public checkAndPut() {
        super("checkAndPut");
      }

      public checkAndPut_args getEmptyArgsInstance() {
        return new checkAndPut_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public checkAndPut_result getResult(I iface, checkAndPut_args args) throws org.apache.thrift.TException {
        checkAndPut_result result = new checkAndPut_result();
        try {
          result.success = iface.checkAndPut(args.table, args.row, args.family, args.qualifier, args.value, args.tput);
          result.setSuccessIsSet(true);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class putMultiple<I extends Iface> extends org.apache.thrift.ProcessFunction<I, putMultiple_args> {
      public putMultiple() {
        super("putMultiple");
      }

      public putMultiple_args getEmptyArgsInstance() {
        return new putMultiple_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public putMultiple_result getResult(I iface, putMultiple_args args) throws org.apache.thrift.TException {
        putMultiple_result result = new putMultiple_result();
        try {
          iface.putMultiple(args.table, args.tputs);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class deleteSingle<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteSingle_args> {
      public deleteSingle() {
        super("deleteSingle");
      }

      public deleteSingle_args getEmptyArgsInstance() {
        return new deleteSingle_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public deleteSingle_result getResult(I iface, deleteSingle_args args) throws org.apache.thrift.TException {
        deleteSingle_result result = new deleteSingle_result();
        try {
          iface.deleteSingle(args.table, args.tdelete);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class deleteMultiple<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteMultiple_args> {
      public deleteMultiple() {
        super("deleteMultiple");
      }

      public deleteMultiple_args getEmptyArgsInstance() {
        return new deleteMultiple_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public deleteMultiple_result getResult(I iface, deleteMultiple_args args) throws org.apache.thrift.TException {
        deleteMultiple_result result = new deleteMultiple_result();
        try {
          result.success = iface.deleteMultiple(args.table, args.tdeletes);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class checkAndDelete<I extends Iface> extends org.apache.thrift.ProcessFunction<I, checkAndDelete_args> {
      public checkAndDelete() {
        super("checkAndDelete");
      }

      public checkAndDelete_args getEmptyArgsInstance() {
        return new checkAndDelete_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public checkAndDelete_result getResult(I iface, checkAndDelete_args args) throws org.apache.thrift.TException {
        checkAndDelete_result result = new checkAndDelete_result();
        try {
          result.success = iface.checkAndDelete(args.table, args.row, args.family, args.qualifier, args.value, args.tdelete);
          result.setSuccessIsSet(true);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class increment<I extends Iface> extends org.apache.thrift.ProcessFunction<I, increment_args> {
      public increment() {
        super("increment");
      }

      public increment_args getEmptyArgsInstance() {
        return new increment_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public increment_result getResult(I iface, increment_args args) throws org.apache.thrift.TException {
        increment_result result = new increment_result();
        try {
          result.success = iface.increment(args.table, args.tincrement);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class append<I extends Iface> extends org.apache.thrift.ProcessFunction<I, append_args> {
      public append() {
        super("append");
      }

      public append_args getEmptyArgsInstance() {
        return new append_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public append_result getResult(I iface, append_args args) throws org.apache.thrift.TException {
        append_result result = new append_result();
        try {
          result.success = iface.append(args.table, args.tappend);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class openScanner<I extends Iface> extends org.apache.thrift.ProcessFunction<I, openScanner_args> {
      public openScanner() {
        super("openScanner");
      }

      public openScanner_args getEmptyArgsInstance() {
        return new openScanner_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public openScanner_result getResult(I iface, openScanner_args args) throws org.apache.thrift.TException {
        openScanner_result result = new openScanner_result();
        try {
          result.success = iface.openScanner(args.table, args.tscan);
          result.setSuccessIsSet(true);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getScannerRows<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getScannerRows_args> {
      public getScannerRows() {
        super("getScannerRows");
      }

      public getScannerRows_args getEmptyArgsInstance() {
        return new getScannerRows_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getScannerRows_result getResult(I iface, getScannerRows_args args) throws org.apache.thrift.TException {
        getScannerRows_result result = new getScannerRows_result();
        try {
          result.success = iface.getScannerRows(args.scannerId, args.numRows);
        } catch (TIOError io) {
          result.io = io;
        } catch (TIllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class closeScanner<I extends Iface> extends org.apache.thrift.ProcessFunction<I, closeScanner_args> {
      public closeScanner() {
        super("closeScanner");
      }

      public closeScanner_args getEmptyArgsInstance() {
        return new closeScanner_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public closeScanner_result getResult(I iface, closeScanner_args args) throws org.apache.thrift.TException {
        closeScanner_result result = new closeScanner_result();
        try {
          iface.closeScanner(args.scannerId);
        } catch (TIOError io) {
          result.io = io;
        } catch (TIllegalArgument ia) {
          result.ia = ia;
        }
        return result;
      }
    }

    public static class mutateRow<I extends Iface> extends org.apache.thrift.ProcessFunction<I, mutateRow_args> {
      public mutateRow() {
        super("mutateRow");
      }

      public mutateRow_args getEmptyArgsInstance() {
        return new mutateRow_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public mutateRow_result getResult(I iface, mutateRow_args args) throws org.apache.thrift.TException {
        mutateRow_result result = new mutateRow_result();
        try {
          iface.mutateRow(args.table, args.trowMutations);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getScannerResults<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getScannerResults_args> {
      public getScannerResults() {
        super("getScannerResults");
      }

      public getScannerResults_args getEmptyArgsInstance() {
        return new getScannerResults_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getScannerResults_result getResult(I iface, getScannerResults_args args) throws org.apache.thrift.TException {
        getScannerResults_result result = new getScannerResults_result();
        try {
          result.success = iface.getScannerResults(args.table, args.tscan, args.numRows);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getRegionLocation<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getRegionLocation_args> {
      public getRegionLocation() {
        super("getRegionLocation");
      }

      public getRegionLocation_args getEmptyArgsInstance() {
        return new getRegionLocation_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getRegionLocation_result getResult(I iface, getRegionLocation_args args) throws org.apache.thrift.TException {
        getRegionLocation_result result = new getRegionLocation_result();
        try {
          result.success = iface.getRegionLocation(args.table, args.row, args.reload);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getAllRegionLocations<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getAllRegionLocations_args> {
      public getAllRegionLocations() {
        super("getAllRegionLocations");
      }

      public getAllRegionLocations_args getEmptyArgsInstance() {
        return new getAllRegionLocations_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getAllRegionLocations_result getResult(I iface, getAllRegionLocations_args args) throws org.apache.thrift.TException {
        getAllRegionLocations_result result = new getAllRegionLocations_result();
        try {
          result.success = iface.getAllRegionLocations(args.table);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class checkAndMutate<I extends Iface> extends org.apache.thrift.ProcessFunction<I, checkAndMutate_args> {
      public checkAndMutate() {
        super("checkAndMutate");
      }

      public checkAndMutate_args getEmptyArgsInstance() {
        return new checkAndMutate_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public checkAndMutate_result getResult(I iface, checkAndMutate_args args) throws org.apache.thrift.TException {
        checkAndMutate_result result = new checkAndMutate_result();
        try {
          result.success = iface.checkAndMutate(args.table, args.row, args.family, args.qualifier, args.compareOp, args.value, args.rowMutations);
          result.setSuccessIsSet(true);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getTableDescriptor<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTableDescriptor_args> {
      public getTableDescriptor() {
        super("getTableDescriptor");
      }

      public getTableDescriptor_args getEmptyArgsInstance() {
        return new getTableDescriptor_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getTableDescriptor_result getResult(I iface, getTableDescriptor_args args) throws org.apache.thrift.TException {
        getTableDescriptor_result result = new getTableDescriptor_result();
        try {
          result.success = iface.getTableDescriptor(args.table);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getTableDescriptors<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTableDescriptors_args> {
      public getTableDescriptors() {
        super("getTableDescriptors");
      }

      public getTableDescriptors_args getEmptyArgsInstance() {
        return new getTableDescriptors_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getTableDescriptors_result getResult(I iface, getTableDescriptors_args args) throws org.apache.thrift.TException {
        getTableDescriptors_result result = new getTableDescriptors_result();
        try {
          result.success = iface.getTableDescriptors(args.tables);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class tableExists<I extends Iface> extends org.apache.thrift.ProcessFunction<I, tableExists_args> {
      public tableExists() {
        super("tableExists");
      }

      public tableExists_args getEmptyArgsInstance() {
        return new tableExists_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public tableExists_result getResult(I iface, tableExists_args args) throws org.apache.thrift.TException {
        tableExists_result result = new tableExists_result();
        try {
          result.success = iface.tableExists(args.tableName);
          result.setSuccessIsSet(true);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getTableDescriptorsByPattern<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTableDescriptorsByPattern_args> {
      public getTableDescriptorsByPattern() {
        super("getTableDescriptorsByPattern");
      }

      public getTableDescriptorsByPattern_args getEmptyArgsInstance() {
        return new getTableDescriptorsByPattern_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getTableDescriptorsByPattern_result getResult(I iface, getTableDescriptorsByPattern_args args) throws org.apache.thrift.TException {
        getTableDescriptorsByPattern_result result = new getTableDescriptorsByPattern_result();
        try {
          result.success = iface.getTableDescriptorsByPattern(args.regex, args.includeSysTables);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getTableDescriptorsByNamespace<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTableDescriptorsByNamespace_args> {
      public getTableDescriptorsByNamespace() {
        super("getTableDescriptorsByNamespace");
      }

      public getTableDescriptorsByNamespace_args getEmptyArgsInstance() {
        return new getTableDescriptorsByNamespace_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getTableDescriptorsByNamespace_result getResult(I iface, getTableDescriptorsByNamespace_args args) throws org.apache.thrift.TException {
        getTableDescriptorsByNamespace_result result = new getTableDescriptorsByNamespace_result();
        try {
          result.success = iface.getTableDescriptorsByNamespace(args.name);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getTableNamesByPattern<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTableNamesByPattern_args> {
      public getTableNamesByPattern() {
        super("getTableNamesByPattern");
      }

      public getTableNamesByPattern_args getEmptyArgsInstance() {
        return new getTableNamesByPattern_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getTableNamesByPattern_result getResult(I iface, getTableNamesByPattern_args args) throws org.apache.thrift.TException {
        getTableNamesByPattern_result result = new getTableNamesByPattern_result();
        try {
          result.success = iface.getTableNamesByPattern(args.regex, args.includeSysTables);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getTableNamesByNamespace<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getTableNamesByNamespace_args> {
      public getTableNamesByNamespace() {
        super("getTableNamesByNamespace");
      }

      public getTableNamesByNamespace_args getEmptyArgsInstance() {
        return new getTableNamesByNamespace_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getTableNamesByNamespace_result getResult(I iface, getTableNamesByNamespace_args args) throws org.apache.thrift.TException {
        getTableNamesByNamespace_result result = new getTableNamesByNamespace_result();
        try {
          result.success = iface.getTableNamesByNamespace(args.name);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class createTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createTable_args> {
      public createTable() {
        super("createTable");
      }

      public createTable_args getEmptyArgsInstance() {
        return new createTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public createTable_result getResult(I iface, createTable_args args) throws org.apache.thrift.TException {
        createTable_result result = new createTable_result();
        try {
          iface.createTable(args.desc, args.splitKeys);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class deleteTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteTable_args> {
      public deleteTable() {
        super("deleteTable");
      }

      public deleteTable_args getEmptyArgsInstance() {
        return new deleteTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public deleteTable_result getResult(I iface, deleteTable_args args) throws org.apache.thrift.TException {
        deleteTable_result result = new deleteTable_result();
        try {
          iface.deleteTable(args.tableName);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class truncateTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, truncateTable_args> {
      public truncateTable() {
        super("truncateTable");
      }

      public truncateTable_args getEmptyArgsInstance() {
        return new truncateTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public truncateTable_result getResult(I iface, truncateTable_args args) throws org.apache.thrift.TException {
        truncateTable_result result = new truncateTable_result();
        try {
          iface.truncateTable(args.tableName, args.preserveSplits);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class enableTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, enableTable_args> {
      public enableTable() {
        super("enableTable");
      }

      public enableTable_args getEmptyArgsInstance() {
        return new enableTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public enableTable_result getResult(I iface, enableTable_args args) throws org.apache.thrift.TException {
        enableTable_result result = new enableTable_result();
        try {
          iface.enableTable(args.tableName);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class disableTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, disableTable_args> {
      public disableTable() {
        super("disableTable");
      }

      public disableTable_args getEmptyArgsInstance() {
        return new disableTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public disableTable_result getResult(I iface, disableTable_args args) throws org.apache.thrift.TException {
        disableTable_result result = new disableTable_result();
        try {
          iface.disableTable(args.tableName);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class isTableEnabled<I extends Iface> extends org.apache.thrift.ProcessFunction<I, isTableEnabled_args> {
      public isTableEnabled() {
        super("isTableEnabled");
      }

      public isTableEnabled_args getEmptyArgsInstance() {
        return new isTableEnabled_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public isTableEnabled_result getResult(I iface, isTableEnabled_args args) throws org.apache.thrift.TException {
        isTableEnabled_result result = new isTableEnabled_result();
        try {
          result.success = iface.isTableEnabled(args.tableName);
          result.setSuccessIsSet(true);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class isTableDisabled<I extends Iface> extends org.apache.thrift.ProcessFunction<I, isTableDisabled_args> {
      public isTableDisabled() {
        super("isTableDisabled");
      }

      public isTableDisabled_args getEmptyArgsInstance() {
        return new isTableDisabled_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public isTableDisabled_result getResult(I iface, isTableDisabled_args args) throws org.apache.thrift.TException {
        isTableDisabled_result result = new isTableDisabled_result();
        try {
          result.success = iface.isTableDisabled(args.tableName);
          result.setSuccessIsSet(true);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class isTableAvailable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, isTableAvailable_args> {
      public isTableAvailable() {
        super("isTableAvailable");
      }

      public isTableAvailable_args getEmptyArgsInstance() {
        return new isTableAvailable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public isTableAvailable_result getResult(I iface, isTableAvailable_args args) throws org.apache.thrift.TException {
        isTableAvailable_result result = new isTableAvailable_result();
        try {
          result.success = iface.isTableAvailable(args.tableName);
          result.setSuccessIsSet(true);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class isTableAvailableWithSplit<I extends Iface> extends org.apache.thrift.ProcessFunction<I, isTableAvailableWithSplit_args> {
      public isTableAvailableWithSplit() {
        super("isTableAvailableWithSplit");
      }

      public isTableAvailableWithSplit_args getEmptyArgsInstance() {
        return new isTableAvailableWithSplit_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public isTableAvailableWithSplit_result getResult(I iface, isTableAvailableWithSplit_args args) throws org.apache.thrift.TException {
        isTableAvailableWithSplit_result result = new isTableAvailableWithSplit_result();
        try {
          result.success = iface.isTableAvailableWithSplit(args.tableName, args.splitKeys);
          result.setSuccessIsSet(true);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class addColumnFamily<I extends Iface> extends org.apache.thrift.ProcessFunction<I, addColumnFamily_args> {
      public addColumnFamily() {
        super("addColumnFamily");
      }

      public addColumnFamily_args getEmptyArgsInstance() {
        return new addColumnFamily_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public addColumnFamily_result getResult(I iface, addColumnFamily_args args) throws org.apache.thrift.TException {
        addColumnFamily_result result = new addColumnFamily_result();
        try {
          iface.addColumnFamily(args.tableName, args.column);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class deleteColumnFamily<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteColumnFamily_args> {
      public deleteColumnFamily() {
        super("deleteColumnFamily");
      }

      public deleteColumnFamily_args getEmptyArgsInstance() {
        return new deleteColumnFamily_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public deleteColumnFamily_result getResult(I iface, deleteColumnFamily_args args) throws org.apache.thrift.TException {
        deleteColumnFamily_result result = new deleteColumnFamily_result();
        try {
          iface.deleteColumnFamily(args.tableName, args.column);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class modifyColumnFamily<I extends Iface> extends org.apache.thrift.ProcessFunction<I, modifyColumnFamily_args> {
      public modifyColumnFamily() {
        super("modifyColumnFamily");
      }

      public modifyColumnFamily_args getEmptyArgsInstance() {
        return new modifyColumnFamily_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public modifyColumnFamily_result getResult(I iface, modifyColumnFamily_args args) throws org.apache.thrift.TException {
        modifyColumnFamily_result result = new modifyColumnFamily_result();
        try {
          iface.modifyColumnFamily(args.tableName, args.column);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class modifyTable<I extends Iface> extends org.apache.thrift.ProcessFunction<I, modifyTable_args> {
      public modifyTable() {
        super("modifyTable");
      }

      public modifyTable_args getEmptyArgsInstance() {
        return new modifyTable_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public modifyTable_result getResult(I iface, modifyTable_args args) throws org.apache.thrift.TException {
        modifyTable_result result = new modifyTable_result();
        try {
          iface.modifyTable(args.desc);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class createNamespace<I extends Iface> extends org.apache.thrift.ProcessFunction<I, createNamespace_args> {
      public createNamespace() {
        super("createNamespace");
      }

      public createNamespace_args getEmptyArgsInstance() {
        return new createNamespace_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public createNamespace_result getResult(I iface, createNamespace_args args) throws org.apache.thrift.TException {
        createNamespace_result result = new createNamespace_result();
        try {
          iface.createNamespace(args.namespaceDesc);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class modifyNamespace<I extends Iface> extends org.apache.thrift.ProcessFunction<I, modifyNamespace_args> {
      public modifyNamespace() {
        super("modifyNamespace");
      }

      public modifyNamespace_args getEmptyArgsInstance() {
        return new modifyNamespace_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public modifyNamespace_result getResult(I iface, modifyNamespace_args args) throws org.apache.thrift.TException {
        modifyNamespace_result result = new modifyNamespace_result();
        try {
          iface.modifyNamespace(args.namespaceDesc);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class deleteNamespace<I extends Iface> extends org.apache.thrift.ProcessFunction<I, deleteNamespace_args> {
      public deleteNamespace() {
        super("deleteNamespace");
      }

      public deleteNamespace_args getEmptyArgsInstance() {
        return new deleteNamespace_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public deleteNamespace_result getResult(I iface, deleteNamespace_args args) throws org.apache.thrift.TException {
        deleteNamespace_result result = new deleteNamespace_result();
        try {
          iface.deleteNamespace(args.name);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getNamespaceDescriptor<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getNamespaceDescriptor_args> {
      public getNamespaceDescriptor() {
        super("getNamespaceDescriptor");
      }

      public getNamespaceDescriptor_args getEmptyArgsInstance() {
        return new getNamespaceDescriptor_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getNamespaceDescriptor_result getResult(I iface, getNamespaceDescriptor_args args) throws org.apache.thrift.TException {
        getNamespaceDescriptor_result result = new getNamespaceDescriptor_result();
        try {
          result.success = iface.getNamespaceDescriptor(args.name);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class listNamespaceDescriptors<I extends Iface> extends org.apache.thrift.ProcessFunction<I, listNamespaceDescriptors_args> {
      public listNamespaceDescriptors() {
        super("listNamespaceDescriptors");
      }

      public listNamespaceDescriptors_args getEmptyArgsInstance() {
        return new listNamespaceDescriptors_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public listNamespaceDescriptors_result getResult(I iface, listNamespaceDescriptors_args args) throws org.apache.thrift.TException {
        listNamespaceDescriptors_result result = new listNamespaceDescriptors_result();
        try {
          result.success = iface.listNamespaceDescriptors();
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class listNamespaces<I extends Iface> extends org.apache.thrift.ProcessFunction<I, listNamespaces_args> {
      public listNamespaces() {
        super("listNamespaces");
      }

      public listNamespaces_args getEmptyArgsInstance() {
        return new listNamespaces_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public listNamespaces_result getResult(I iface, listNamespaces_args args) throws org.apache.thrift.TException {
        listNamespaces_result result = new listNamespaces_result();
        try {
          result.success = iface.listNamespaces();
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getThriftServerType<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getThriftServerType_args> {
      public getThriftServerType() {
        super("getThriftServerType");
      }

      public getThriftServerType_args getEmptyArgsInstance() {
        return new getThriftServerType_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getThriftServerType_result getResult(I iface, getThriftServerType_args args) throws org.apache.thrift.TException {
        getThriftServerType_result result = new getThriftServerType_result();
        result.success = iface.getThriftServerType();
        return result;
      }
    }

    public static class getSlowLogResponses<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getSlowLogResponses_args> {
      public getSlowLogResponses() {
        super("getSlowLogResponses");
      }

      public getSlowLogResponses_args getEmptyArgsInstance() {
        return new getSlowLogResponses_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getSlowLogResponses_result getResult(I iface, getSlowLogResponses_args args) throws org.apache.thrift.TException {
        getSlowLogResponses_result result = new getSlowLogResponses_result();
        try {
          result.success = iface.getSlowLogResponses(args.serverNames, args.logQueryFilter);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class clearSlowLogResponses<I extends Iface> extends org.apache.thrift.ProcessFunction<I, clearSlowLogResponses_args> {
      public clearSlowLogResponses() {
        super("clearSlowLogResponses");
      }

      public clearSlowLogResponses_args getEmptyArgsInstance() {
        return new clearSlowLogResponses_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public clearSlowLogResponses_result getResult(I iface, clearSlowLogResponses_args args) throws org.apache.thrift.TException {
        clearSlowLogResponses_result result = new clearSlowLogResponses_result();
        try {
          result.success = iface.clearSlowLogResponses(args.serverNames);
        } catch (TIOError io) {
          result.io = io;
        }
        return result;
      }
    }

    public static class getClusterId<I extends Iface> extends org.apache.thrift.ProcessFunction<I, getClusterId_args> {
      public getClusterId() {
        super("getClusterId");
      }

      public getClusterId_args getEmptyArgsInstance() {
        return new getClusterId_args();
      }

      protected boolean isOneway() {
        return false;
      }

      @Override
      protected boolean rethrowUnhandledExceptions() {
        return false;
      }

      public getClusterId_result getResult(I iface, getClusterId_args args) throws org.apache.thrift.TException {
        getClusterId_result result = new getClusterId_result();
        result.success = iface.getClusterId();
        return result;
      }
    }

  }

  public static class AsyncProcessor<I extends AsyncIface> extends org.apache.thrift.TBaseAsyncProcessor<I> {
    private static final org.slf4j.Logger _LOGGER = org.slf4j.LoggerFactory.getLogger(AsyncProcessor.class.getName());
    public AsyncProcessor(I iface) {
      super(iface, getProcessMap(new java.util.HashMap<java.lang.String, org.apache.thrift.AsyncProcessFunction<I, ? extends org.apache.thrift.TBase, ?>>()));
    }

    protected AsyncProcessor(I iface, java.util.Map<java.lang.String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      super(iface, getProcessMap(processMap));
    }

    private static <I extends AsyncIface> java.util.Map<java.lang.String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase,?>> getProcessMap(java.util.Map<java.lang.String,  org.apache.thrift.AsyncProcessFunction<I, ? extends  org.apache.thrift.TBase, ?>> processMap) {
      processMap.put("exists", new exists());
      processMap.put("existsAll", new existsAll());
      processMap.put("get", new get());
      processMap.put("getMultiple", new getMultiple());
      processMap.put("put", new put());
      processMap.put("checkAndPut", new checkAndPut());
      processMap.put("putMultiple", new putMultiple());
      processMap.put("deleteSingle", new deleteSingle());
      processMap.put("deleteMultiple", new deleteMultiple());
      processMap.put("checkAndDelete", new checkAndDelete());
      processMap.put("increment", new increment());
      processMap.put("append", new append());
      processMap.put("openScanner", new openScanner());
      processMap.put("getScannerRows", new getScannerRows());
      processMap.put("closeScanner", new closeScanner());
      processMap.put("mutateRow", new mutateRow());
      processMap.put("getScannerResults", new getScannerResults());
      processMap.put("getRegionLocation", new getRegionLocation());
      processMap.put("getAllRegionLocations", new getAllRegionLocations());
      processMap.put("checkAndMutate", new checkAndMutate());
      processMap.put("getTableDescriptor", new getTableDescriptor());
      processMap.put("getTableDescriptors", new getTableDescriptors());
      processMap.put("tableExists", new tableExists());
      processMap.put("getTableDescriptorsByPattern", new getTableDescriptorsByPattern());
      processMap.put("getTableDescriptorsByNamespace", new getTableDescriptorsByNamespace());
      processMap.put("getTableNamesByPattern", new getTableNamesByPattern());
      processMap.put("getTableNamesByNamespace", new getTableNamesByNamespace());
      processMap.put("createTable", new createTable());
      processMap.put("deleteTable", new deleteTable());
      processMap.put("truncateTable", new truncateTable());
      processMap.put("enableTable", new enableTable());
      processMap.put("disableTable", new disableTable());
      processMap.put("isTableEnabled", new isTableEnabled());
      processMap.put("isTableDisabled", new isTableDisabled());
      processMap.put("isTableAvailable", new isTableAvailable());
      processMap.put("isTableAvailableWithSplit", new isTableAvailableWithSplit());
      processMap.put("addColumnFamily", new addColumnFamily());
      processMap.put("deleteColumnFamily", new deleteColumnFamily());
      processMap.put("modifyColumnFamily", new modifyColumnFamily());
      processMap.put("modifyTable", new modifyTable());
      processMap.put("createNamespace", new createNamespace());
      processMap.put("modifyNamespace", new modifyNamespace());
      processMap.put("deleteNamespace", new deleteNamespace());
      processMap.put("getNamespaceDescriptor", new getNamespaceDescriptor());
      processMap.put("listNamespaceDescriptors", new listNamespaceDescriptors());
      processMap.put("listNamespaces", new listNamespaces());
      processMap.put("getThriftServerType", new getThriftServerType());
      processMap.put("getSlowLogResponses", new getSlowLogResponses());
      processMap.put("clearSlowLogResponses", new clearSlowLogResponses());
      processMap.put("getClusterId", new getClusterId());
      return processMap;
    }

    public static class exists<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, exists_args, java.lang.Boolean> {
      public exists() {
        super("exists");
      }

      public exists_args getEmptyArgsInstance() {
        return new exists_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean>() { 
          public void onComplete(java.lang.Boolean o) {
            exists_result result = new exists_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            exists_result result = new exists_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, exists_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
        iface.exists(args.table, args.tget,resultHandler);
      }
    }

    public static class existsAll<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, existsAll_args, java.util.List<java.lang.Boolean>> {
      public existsAll() {
        super("existsAll");
      }

      public existsAll_args getEmptyArgsInstance() {
        return new existsAll_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.Boolean>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.Boolean>>() { 
          public void onComplete(java.util.List<java.lang.Boolean> o) {
            existsAll_result result = new existsAll_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            existsAll_result result = new existsAll_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, existsAll_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.Boolean>> resultHandler) throws org.apache.thrift.TException {
        iface.existsAll(args.table, args.tgets,resultHandler);
      }
    }

    public static class get<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, get_args, TResult> {
      public get() {
        super("get");
      }

      public get_args getEmptyArgsInstance() {
        return new get_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<TResult> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<TResult>() { 
          public void onComplete(TResult o) {
            get_result result = new get_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            get_result result = new get_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, get_args args, org.apache.thrift.async.AsyncMethodCallback<TResult> resultHandler) throws org.apache.thrift.TException {
        iface.get(args.table, args.tget,resultHandler);
      }
    }

    public static class getMultiple<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getMultiple_args, java.util.List<TResult>> {
      public getMultiple() {
        super("getMultiple");
      }

      public getMultiple_args getEmptyArgsInstance() {
        return new getMultiple_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>>() { 
          public void onComplete(java.util.List<TResult> o) {
            getMultiple_result result = new getMultiple_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getMultiple_result result = new getMultiple_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getMultiple_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>> resultHandler) throws org.apache.thrift.TException {
        iface.getMultiple(args.table, args.tgets,resultHandler);
      }
    }

    public static class put<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, put_args, Void> {
      public put() {
        super("put");
      }

      public put_args getEmptyArgsInstance() {
        return new put_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            put_result result = new put_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            put_result result = new put_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, put_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.put(args.table, args.tput,resultHandler);
      }
    }

    public static class checkAndPut<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, checkAndPut_args, java.lang.Boolean> {
      public checkAndPut() {
        super("checkAndPut");
      }

      public checkAndPut_args getEmptyArgsInstance() {
        return new checkAndPut_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean>() { 
          public void onComplete(java.lang.Boolean o) {
            checkAndPut_result result = new checkAndPut_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            checkAndPut_result result = new checkAndPut_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, checkAndPut_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
        iface.checkAndPut(args.table, args.row, args.family, args.qualifier, args.value, args.tput,resultHandler);
      }
    }

    public static class putMultiple<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, putMultiple_args, Void> {
      public putMultiple() {
        super("putMultiple");
      }

      public putMultiple_args getEmptyArgsInstance() {
        return new putMultiple_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            putMultiple_result result = new putMultiple_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            putMultiple_result result = new putMultiple_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, putMultiple_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.putMultiple(args.table, args.tputs,resultHandler);
      }
    }

    public static class deleteSingle<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteSingle_args, Void> {
      public deleteSingle() {
        super("deleteSingle");
      }

      public deleteSingle_args getEmptyArgsInstance() {
        return new deleteSingle_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            deleteSingle_result result = new deleteSingle_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            deleteSingle_result result = new deleteSingle_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteSingle_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.deleteSingle(args.table, args.tdelete,resultHandler);
      }
    }

    public static class deleteMultiple<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteMultiple_args, java.util.List<TDelete>> {
      public deleteMultiple() {
        super("deleteMultiple");
      }

      public deleteMultiple_args getEmptyArgsInstance() {
        return new deleteMultiple_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TDelete>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TDelete>>() { 
          public void onComplete(java.util.List<TDelete> o) {
            deleteMultiple_result result = new deleteMultiple_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            deleteMultiple_result result = new deleteMultiple_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteMultiple_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TDelete>> resultHandler) throws org.apache.thrift.TException {
        iface.deleteMultiple(args.table, args.tdeletes,resultHandler);
      }
    }

    public static class checkAndDelete<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, checkAndDelete_args, java.lang.Boolean> {
      public checkAndDelete() {
        super("checkAndDelete");
      }

      public checkAndDelete_args getEmptyArgsInstance() {
        return new checkAndDelete_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean>() { 
          public void onComplete(java.lang.Boolean o) {
            checkAndDelete_result result = new checkAndDelete_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            checkAndDelete_result result = new checkAndDelete_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, checkAndDelete_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
        iface.checkAndDelete(args.table, args.row, args.family, args.qualifier, args.value, args.tdelete,resultHandler);
      }
    }

    public static class increment<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, increment_args, TResult> {
      public increment() {
        super("increment");
      }

      public increment_args getEmptyArgsInstance() {
        return new increment_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<TResult> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<TResult>() { 
          public void onComplete(TResult o) {
            increment_result result = new increment_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            increment_result result = new increment_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, increment_args args, org.apache.thrift.async.AsyncMethodCallback<TResult> resultHandler) throws org.apache.thrift.TException {
        iface.increment(args.table, args.tincrement,resultHandler);
      }
    }

    public static class append<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, append_args, TResult> {
      public append() {
        super("append");
      }

      public append_args getEmptyArgsInstance() {
        return new append_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<TResult> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<TResult>() { 
          public void onComplete(TResult o) {
            append_result result = new append_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            append_result result = new append_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, append_args args, org.apache.thrift.async.AsyncMethodCallback<TResult> resultHandler) throws org.apache.thrift.TException {
        iface.append(args.table, args.tappend,resultHandler);
      }
    }

    public static class openScanner<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, openScanner_args, java.lang.Integer> {
      public openScanner() {
        super("openScanner");
      }

      public openScanner_args getEmptyArgsInstance() {
        return new openScanner_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer>() { 
          public void onComplete(java.lang.Integer o) {
            openScanner_result result = new openScanner_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            openScanner_result result = new openScanner_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, openScanner_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Integer> resultHandler) throws org.apache.thrift.TException {
        iface.openScanner(args.table, args.tscan,resultHandler);
      }
    }

    public static class getScannerRows<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getScannerRows_args, java.util.List<TResult>> {
      public getScannerRows() {
        super("getScannerRows");
      }

      public getScannerRows_args getEmptyArgsInstance() {
        return new getScannerRows_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>>() { 
          public void onComplete(java.util.List<TResult> o) {
            getScannerRows_result result = new getScannerRows_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getScannerRows_result result = new getScannerRows_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof TIllegalArgument) {
              result.ia = (TIllegalArgument) e;
              result.setIaIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getScannerRows_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>> resultHandler) throws org.apache.thrift.TException {
        iface.getScannerRows(args.scannerId, args.numRows,resultHandler);
      }
    }

    public static class closeScanner<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, closeScanner_args, Void> {
      public closeScanner() {
        super("closeScanner");
      }

      public closeScanner_args getEmptyArgsInstance() {
        return new closeScanner_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            closeScanner_result result = new closeScanner_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            closeScanner_result result = new closeScanner_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof TIllegalArgument) {
              result.ia = (TIllegalArgument) e;
              result.setIaIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, closeScanner_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.closeScanner(args.scannerId,resultHandler);
      }
    }

    public static class mutateRow<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, mutateRow_args, Void> {
      public mutateRow() {
        super("mutateRow");
      }

      public mutateRow_args getEmptyArgsInstance() {
        return new mutateRow_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            mutateRow_result result = new mutateRow_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            mutateRow_result result = new mutateRow_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, mutateRow_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.mutateRow(args.table, args.trowMutations,resultHandler);
      }
    }

    public static class getScannerResults<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getScannerResults_args, java.util.List<TResult>> {
      public getScannerResults() {
        super("getScannerResults");
      }

      public getScannerResults_args getEmptyArgsInstance() {
        return new getScannerResults_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>>() { 
          public void onComplete(java.util.List<TResult> o) {
            getScannerResults_result result = new getScannerResults_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getScannerResults_result result = new getScannerResults_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getScannerResults_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TResult>> resultHandler) throws org.apache.thrift.TException {
        iface.getScannerResults(args.table, args.tscan, args.numRows,resultHandler);
      }
    }

    public static class getRegionLocation<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getRegionLocation_args, THRegionLocation> {
      public getRegionLocation() {
        super("getRegionLocation");
      }

      public getRegionLocation_args getEmptyArgsInstance() {
        return new getRegionLocation_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<THRegionLocation> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<THRegionLocation>() { 
          public void onComplete(THRegionLocation o) {
            getRegionLocation_result result = new getRegionLocation_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getRegionLocation_result result = new getRegionLocation_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getRegionLocation_args args, org.apache.thrift.async.AsyncMethodCallback<THRegionLocation> resultHandler) throws org.apache.thrift.TException {
        iface.getRegionLocation(args.table, args.row, args.reload,resultHandler);
      }
    }

    public static class getAllRegionLocations<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getAllRegionLocations_args, java.util.List<THRegionLocation>> {
      public getAllRegionLocations() {
        super("getAllRegionLocations");
      }

      public getAllRegionLocations_args getEmptyArgsInstance() {
        return new getAllRegionLocations_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<THRegionLocation>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<THRegionLocation>>() { 
          public void onComplete(java.util.List<THRegionLocation> o) {
            getAllRegionLocations_result result = new getAllRegionLocations_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getAllRegionLocations_result result = new getAllRegionLocations_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getAllRegionLocations_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<THRegionLocation>> resultHandler) throws org.apache.thrift.TException {
        iface.getAllRegionLocations(args.table,resultHandler);
      }
    }

    public static class checkAndMutate<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, checkAndMutate_args, java.lang.Boolean> {
      public checkAndMutate() {
        super("checkAndMutate");
      }

      public checkAndMutate_args getEmptyArgsInstance() {
        return new checkAndMutate_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean>() { 
          public void onComplete(java.lang.Boolean o) {
            checkAndMutate_result result = new checkAndMutate_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            checkAndMutate_result result = new checkAndMutate_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, checkAndMutate_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
        iface.checkAndMutate(args.table, args.row, args.family, args.qualifier, args.compareOp, args.value, args.rowMutations,resultHandler);
      }
    }

    public static class getTableDescriptor<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTableDescriptor_args, TTableDescriptor> {
      public getTableDescriptor() {
        super("getTableDescriptor");
      }

      public getTableDescriptor_args getEmptyArgsInstance() {
        return new getTableDescriptor_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<TTableDescriptor> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<TTableDescriptor>() { 
          public void onComplete(TTableDescriptor o) {
            getTableDescriptor_result result = new getTableDescriptor_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getTableDescriptor_result result = new getTableDescriptor_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTableDescriptor_args args, org.apache.thrift.async.AsyncMethodCallback<TTableDescriptor> resultHandler) throws org.apache.thrift.TException {
        iface.getTableDescriptor(args.table,resultHandler);
      }
    }

    public static class getTableDescriptors<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTableDescriptors_args, java.util.List<TTableDescriptor>> {
      public getTableDescriptors() {
        super("getTableDescriptors");
      }

      public getTableDescriptors_args getEmptyArgsInstance() {
        return new getTableDescriptors_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>>() { 
          public void onComplete(java.util.List<TTableDescriptor> o) {
            getTableDescriptors_result result = new getTableDescriptors_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getTableDescriptors_result result = new getTableDescriptors_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTableDescriptors_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>> resultHandler) throws org.apache.thrift.TException {
        iface.getTableDescriptors(args.tables,resultHandler);
      }
    }

    public static class tableExists<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, tableExists_args, java.lang.Boolean> {
      public tableExists() {
        super("tableExists");
      }

      public tableExists_args getEmptyArgsInstance() {
        return new tableExists_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean>() { 
          public void onComplete(java.lang.Boolean o) {
            tableExists_result result = new tableExists_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            tableExists_result result = new tableExists_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, tableExists_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
        iface.tableExists(args.tableName,resultHandler);
      }
    }

    public static class getTableDescriptorsByPattern<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTableDescriptorsByPattern_args, java.util.List<TTableDescriptor>> {
      public getTableDescriptorsByPattern() {
        super("getTableDescriptorsByPattern");
      }

      public getTableDescriptorsByPattern_args getEmptyArgsInstance() {
        return new getTableDescriptorsByPattern_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>>() { 
          public void onComplete(java.util.List<TTableDescriptor> o) {
            getTableDescriptorsByPattern_result result = new getTableDescriptorsByPattern_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getTableDescriptorsByPattern_result result = new getTableDescriptorsByPattern_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTableDescriptorsByPattern_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>> resultHandler) throws org.apache.thrift.TException {
        iface.getTableDescriptorsByPattern(args.regex, args.includeSysTables,resultHandler);
      }
    }

    public static class getTableDescriptorsByNamespace<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTableDescriptorsByNamespace_args, java.util.List<TTableDescriptor>> {
      public getTableDescriptorsByNamespace() {
        super("getTableDescriptorsByNamespace");
      }

      public getTableDescriptorsByNamespace_args getEmptyArgsInstance() {
        return new getTableDescriptorsByNamespace_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>>() { 
          public void onComplete(java.util.List<TTableDescriptor> o) {
            getTableDescriptorsByNamespace_result result = new getTableDescriptorsByNamespace_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getTableDescriptorsByNamespace_result result = new getTableDescriptorsByNamespace_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTableDescriptorsByNamespace_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableDescriptor>> resultHandler) throws org.apache.thrift.TException {
        iface.getTableDescriptorsByNamespace(args.name,resultHandler);
      }
    }

    public static class getTableNamesByPattern<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTableNamesByPattern_args, java.util.List<TTableName>> {
      public getTableNamesByPattern() {
        super("getTableNamesByPattern");
      }

      public getTableNamesByPattern_args getEmptyArgsInstance() {
        return new getTableNamesByPattern_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableName>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableName>>() { 
          public void onComplete(java.util.List<TTableName> o) {
            getTableNamesByPattern_result result = new getTableNamesByPattern_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getTableNamesByPattern_result result = new getTableNamesByPattern_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTableNamesByPattern_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableName>> resultHandler) throws org.apache.thrift.TException {
        iface.getTableNamesByPattern(args.regex, args.includeSysTables,resultHandler);
      }
    }

    public static class getTableNamesByNamespace<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getTableNamesByNamespace_args, java.util.List<TTableName>> {
      public getTableNamesByNamespace() {
        super("getTableNamesByNamespace");
      }

      public getTableNamesByNamespace_args getEmptyArgsInstance() {
        return new getTableNamesByNamespace_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableName>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableName>>() { 
          public void onComplete(java.util.List<TTableName> o) {
            getTableNamesByNamespace_result result = new getTableNamesByNamespace_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getTableNamesByNamespace_result result = new getTableNamesByNamespace_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getTableNamesByNamespace_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TTableName>> resultHandler) throws org.apache.thrift.TException {
        iface.getTableNamesByNamespace(args.name,resultHandler);
      }
    }

    public static class createTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createTable_args, Void> {
      public createTable() {
        super("createTable");
      }

      public createTable_args getEmptyArgsInstance() {
        return new createTable_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            createTable_result result = new createTable_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            createTable_result result = new createTable_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.createTable(args.desc, args.splitKeys,resultHandler);
      }
    }

    public static class deleteTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteTable_args, Void> {
      public deleteTable() {
        super("deleteTable");
      }

      public deleteTable_args getEmptyArgsInstance() {
        return new deleteTable_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            deleteTable_result result = new deleteTable_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            deleteTable_result result = new deleteTable_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.deleteTable(args.tableName,resultHandler);
      }
    }

    public static class truncateTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, truncateTable_args, Void> {
      public truncateTable() {
        super("truncateTable");
      }

      public truncateTable_args getEmptyArgsInstance() {
        return new truncateTable_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            truncateTable_result result = new truncateTable_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            truncateTable_result result = new truncateTable_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, truncateTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.truncateTable(args.tableName, args.preserveSplits,resultHandler);
      }
    }

    public static class enableTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, enableTable_args, Void> {
      public enableTable() {
        super("enableTable");
      }

      public enableTable_args getEmptyArgsInstance() {
        return new enableTable_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            enableTable_result result = new enableTable_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            enableTable_result result = new enableTable_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, enableTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.enableTable(args.tableName,resultHandler);
      }
    }

    public static class disableTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, disableTable_args, Void> {
      public disableTable() {
        super("disableTable");
      }

      public disableTable_args getEmptyArgsInstance() {
        return new disableTable_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            disableTable_result result = new disableTable_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            disableTable_result result = new disableTable_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, disableTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.disableTable(args.tableName,resultHandler);
      }
    }

    public static class isTableEnabled<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, isTableEnabled_args, java.lang.Boolean> {
      public isTableEnabled() {
        super("isTableEnabled");
      }

      public isTableEnabled_args getEmptyArgsInstance() {
        return new isTableEnabled_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean>() { 
          public void onComplete(java.lang.Boolean o) {
            isTableEnabled_result result = new isTableEnabled_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            isTableEnabled_result result = new isTableEnabled_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, isTableEnabled_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
        iface.isTableEnabled(args.tableName,resultHandler);
      }
    }

    public static class isTableDisabled<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, isTableDisabled_args, java.lang.Boolean> {
      public isTableDisabled() {
        super("isTableDisabled");
      }

      public isTableDisabled_args getEmptyArgsInstance() {
        return new isTableDisabled_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean>() { 
          public void onComplete(java.lang.Boolean o) {
            isTableDisabled_result result = new isTableDisabled_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            isTableDisabled_result result = new isTableDisabled_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, isTableDisabled_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
        iface.isTableDisabled(args.tableName,resultHandler);
      }
    }

    public static class isTableAvailable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, isTableAvailable_args, java.lang.Boolean> {
      public isTableAvailable() {
        super("isTableAvailable");
      }

      public isTableAvailable_args getEmptyArgsInstance() {
        return new isTableAvailable_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean>() { 
          public void onComplete(java.lang.Boolean o) {
            isTableAvailable_result result = new isTableAvailable_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            isTableAvailable_result result = new isTableAvailable_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, isTableAvailable_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
        iface.isTableAvailable(args.tableName,resultHandler);
      }
    }

    public static class isTableAvailableWithSplit<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, isTableAvailableWithSplit_args, java.lang.Boolean> {
      public isTableAvailableWithSplit() {
        super("isTableAvailableWithSplit");
      }

      public isTableAvailableWithSplit_args getEmptyArgsInstance() {
        return new isTableAvailableWithSplit_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean>() { 
          public void onComplete(java.lang.Boolean o) {
            isTableAvailableWithSplit_result result = new isTableAvailableWithSplit_result();
            result.success = o;
            result.setSuccessIsSet(true);
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            isTableAvailableWithSplit_result result = new isTableAvailableWithSplit_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, isTableAvailableWithSplit_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.Boolean> resultHandler) throws org.apache.thrift.TException {
        iface.isTableAvailableWithSplit(args.tableName, args.splitKeys,resultHandler);
      }
    }

    public static class addColumnFamily<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, addColumnFamily_args, Void> {
      public addColumnFamily() {
        super("addColumnFamily");
      }

      public addColumnFamily_args getEmptyArgsInstance() {
        return new addColumnFamily_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            addColumnFamily_result result = new addColumnFamily_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            addColumnFamily_result result = new addColumnFamily_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, addColumnFamily_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.addColumnFamily(args.tableName, args.column,resultHandler);
      }
    }

    public static class deleteColumnFamily<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteColumnFamily_args, Void> {
      public deleteColumnFamily() {
        super("deleteColumnFamily");
      }

      public deleteColumnFamily_args getEmptyArgsInstance() {
        return new deleteColumnFamily_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            deleteColumnFamily_result result = new deleteColumnFamily_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            deleteColumnFamily_result result = new deleteColumnFamily_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteColumnFamily_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.deleteColumnFamily(args.tableName, args.column,resultHandler);
      }
    }

    public static class modifyColumnFamily<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, modifyColumnFamily_args, Void> {
      public modifyColumnFamily() {
        super("modifyColumnFamily");
      }

      public modifyColumnFamily_args getEmptyArgsInstance() {
        return new modifyColumnFamily_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            modifyColumnFamily_result result = new modifyColumnFamily_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            modifyColumnFamily_result result = new modifyColumnFamily_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, modifyColumnFamily_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.modifyColumnFamily(args.tableName, args.column,resultHandler);
      }
    }

    public static class modifyTable<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, modifyTable_args, Void> {
      public modifyTable() {
        super("modifyTable");
      }

      public modifyTable_args getEmptyArgsInstance() {
        return new modifyTable_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            modifyTable_result result = new modifyTable_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            modifyTable_result result = new modifyTable_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, modifyTable_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.modifyTable(args.desc,resultHandler);
      }
    }

    public static class createNamespace<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, createNamespace_args, Void> {
      public createNamespace() {
        super("createNamespace");
      }

      public createNamespace_args getEmptyArgsInstance() {
        return new createNamespace_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            createNamespace_result result = new createNamespace_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            createNamespace_result result = new createNamespace_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, createNamespace_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.createNamespace(args.namespaceDesc,resultHandler);
      }
    }

    public static class modifyNamespace<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, modifyNamespace_args, Void> {
      public modifyNamespace() {
        super("modifyNamespace");
      }

      public modifyNamespace_args getEmptyArgsInstance() {
        return new modifyNamespace_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            modifyNamespace_result result = new modifyNamespace_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            modifyNamespace_result result = new modifyNamespace_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, modifyNamespace_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.modifyNamespace(args.namespaceDesc,resultHandler);
      }
    }

    public static class deleteNamespace<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, deleteNamespace_args, Void> {
      public deleteNamespace() {
        super("deleteNamespace");
      }

      public deleteNamespace_args getEmptyArgsInstance() {
        return new deleteNamespace_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<Void> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<Void>() { 
          public void onComplete(Void o) {
            deleteNamespace_result result = new deleteNamespace_result();
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            deleteNamespace_result result = new deleteNamespace_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, deleteNamespace_args args, org.apache.thrift.async.AsyncMethodCallback<Void> resultHandler) throws org.apache.thrift.TException {
        iface.deleteNamespace(args.name,resultHandler);
      }
    }

    public static class getNamespaceDescriptor<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getNamespaceDescriptor_args, TNamespaceDescriptor> {
      public getNamespaceDescriptor() {
        super("getNamespaceDescriptor");
      }

      public getNamespaceDescriptor_args getEmptyArgsInstance() {
        return new getNamespaceDescriptor_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<TNamespaceDescriptor> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<TNamespaceDescriptor>() { 
          public void onComplete(TNamespaceDescriptor o) {
            getNamespaceDescriptor_result result = new getNamespaceDescriptor_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getNamespaceDescriptor_result result = new getNamespaceDescriptor_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getNamespaceDescriptor_args args, org.apache.thrift.async.AsyncMethodCallback<TNamespaceDescriptor> resultHandler) throws org.apache.thrift.TException {
        iface.getNamespaceDescriptor(args.name,resultHandler);
      }
    }

    public static class listNamespaceDescriptors<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, listNamespaceDescriptors_args, java.util.List<TNamespaceDescriptor>> {
      public listNamespaceDescriptors() {
        super("listNamespaceDescriptors");
      }

      public listNamespaceDescriptors_args getEmptyArgsInstance() {
        return new listNamespaceDescriptors_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TNamespaceDescriptor>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TNamespaceDescriptor>>() { 
          public void onComplete(java.util.List<TNamespaceDescriptor> o) {
            listNamespaceDescriptors_result result = new listNamespaceDescriptors_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            listNamespaceDescriptors_result result = new listNamespaceDescriptors_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, listNamespaceDescriptors_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TNamespaceDescriptor>> resultHandler) throws org.apache.thrift.TException {
        iface.listNamespaceDescriptors(resultHandler);
      }
    }

    public static class listNamespaces<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, listNamespaces_args, java.util.List<java.lang.String>> {
      public listNamespaces() {
        super("listNamespaces");
      }

      public listNamespaces_args getEmptyArgsInstance() {
        return new listNamespaces_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.String>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.String>>() { 
          public void onComplete(java.util.List<java.lang.String> o) {
            listNamespaces_result result = new listNamespaces_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            listNamespaces_result result = new listNamespaces_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, listNamespaces_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.String>> resultHandler) throws org.apache.thrift.TException {
        iface.listNamespaces(resultHandler);
      }
    }

    public static class getThriftServerType<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getThriftServerType_args, TThriftServerType> {
      public getThriftServerType() {
        super("getThriftServerType");
      }

      public getThriftServerType_args getEmptyArgsInstance() {
        return new getThriftServerType_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<TThriftServerType> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<TThriftServerType>() { 
          public void onComplete(TThriftServerType o) {
            getThriftServerType_result result = new getThriftServerType_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getThriftServerType_result result = new getThriftServerType_result();
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getThriftServerType_args args, org.apache.thrift.async.AsyncMethodCallback<TThriftServerType> resultHandler) throws org.apache.thrift.TException {
        iface.getThriftServerType(resultHandler);
      }
    }

    public static class getSlowLogResponses<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getSlowLogResponses_args, java.util.List<TOnlineLogRecord>> {
      public getSlowLogResponses() {
        super("getSlowLogResponses");
      }

      public getSlowLogResponses_args getEmptyArgsInstance() {
        return new getSlowLogResponses_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<TOnlineLogRecord>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<TOnlineLogRecord>>() { 
          public void onComplete(java.util.List<TOnlineLogRecord> o) {
            getSlowLogResponses_result result = new getSlowLogResponses_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getSlowLogResponses_result result = new getSlowLogResponses_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getSlowLogResponses_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<TOnlineLogRecord>> resultHandler) throws org.apache.thrift.TException {
        iface.getSlowLogResponses(args.serverNames, args.logQueryFilter,resultHandler);
      }
    }

    public static class clearSlowLogResponses<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, clearSlowLogResponses_args, java.util.List<java.lang.Boolean>> {
      public clearSlowLogResponses() {
        super("clearSlowLogResponses");
      }

      public clearSlowLogResponses_args getEmptyArgsInstance() {
        return new clearSlowLogResponses_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.Boolean>> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.Boolean>>() { 
          public void onComplete(java.util.List<java.lang.Boolean> o) {
            clearSlowLogResponses_result result = new clearSlowLogResponses_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            clearSlowLogResponses_result result = new clearSlowLogResponses_result();
            if (e instanceof TIOError) {
              result.io = (TIOError) e;
              result.setIoIsSet(true);
              msg = result;
            } else if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, clearSlowLogResponses_args args, org.apache.thrift.async.AsyncMethodCallback<java.util.List<java.lang.Boolean>> resultHandler) throws org.apache.thrift.TException {
        iface.clearSlowLogResponses(args.serverNames,resultHandler);
      }
    }

    public static class getClusterId<I extends AsyncIface> extends org.apache.thrift.AsyncProcessFunction<I, getClusterId_args, java.lang.String> {
      public getClusterId() {
        super("getClusterId");
      }

      public getClusterId_args getEmptyArgsInstance() {
        return new getClusterId_args();
      }

      public org.apache.thrift.async.AsyncMethodCallback<java.lang.String> getResultHandler(final org.apache.thrift.server.AbstractNonblockingServer.AsyncFrameBuffer fb, final int seqid) {
        final org.apache.thrift.AsyncProcessFunction fcall = this;
        return new org.apache.thrift.async.AsyncMethodCallback<java.lang.String>() { 
          public void onComplete(java.lang.String o) {
            getClusterId_result result = new getClusterId_result();
            result.success = o;
            try {
              fcall.sendResponse(fb, result, org.apache.thrift.protocol.TMessageType.REPLY,seqid);
            } catch (org.apache.thrift.transport.TTransportException e) {
              _LOGGER.error("TTransportException writing to internal frame buffer", e);
              fb.close();
            } catch (java.lang.Exception e) {
              _LOGGER.error("Exception writing to internal frame buffer", e);
              onError(e);
            }
          }
          public void onError(java.lang.Exception e) {
            byte msgType = org.apache.thrift.protocol.TMessageType.REPLY;
            org.apache.thrift.TSerializable msg;
            getClusterId_result result = new getClusterId_result();
            if (e instanceof org.apache.thrift.transport.TTransportException) {
              _LOGGER.error("TTransportException inside handler", e);
              fb.close();
              return;
            } else if (e instanceof org.apache.thrift.TApplicationException) {
              _LOGGER.error("TApplicationException inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = (org.apache.thrift.TApplicationException)e;
            } else {
              _LOGGER.error("Exception inside handler", e);
              msgType = org.apache.thrift.protocol.TMessageType.EXCEPTION;
              msg = new org.apache.thrift.TApplicationException(org.apache.thrift.TApplicationException.INTERNAL_ERROR, e.getMessage());
            }
            try {
              fcall.sendResponse(fb,msg,msgType,seqid);
            } catch (java.lang.Exception ex) {
              _LOGGER.error("Exception writing to internal frame buffer", ex);
              fb.close();
            }
          }
        };
      }

      protected boolean isOneway() {
        return false;
      }

      public void start(I iface, getClusterId_args args, org.apache.thrift.async.AsyncMethodCallback<java.lang.String> resultHandler) throws org.apache.thrift.TException {
        iface.getClusterId(resultHandler);
      }
    }

  }

  public static class exists_args implements org.apache.thrift.TBase<exists_args, exists_args._Fields>, java.io.Serializable, Cloneable, Comparable<exists_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("exists_args");

    private static final org.apache.thrift.protocol.TField TABLE_FIELD_DESC = new org.apache.thrift.protocol.TField("table", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TGET_FIELD_DESC = new org.apache.thrift.protocol.TField("tget", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new exists_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new exists_argsTupleSchemeFactory();

    /**
     * the table to check on
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table; // required
    /**
     * the TGet to check for
     */
    public @org.apache.thrift.annotation.Nullable TGet tget; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * the table to check on
       */
      TABLE((short)1, "table"),
      /**
       * the TGet to check for
       */
      TGET((short)2, "tget");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE
            return TABLE;
          case 2: // TGET
            return TGET;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE, new org.apache.thrift.meta_data.FieldMetaData("table", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TGET, new org.apache.thrift.meta_data.FieldMetaData("tget", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TGet.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(exists_args.class, metaDataMap);
    }

    public exists_args() {
    }

    public exists_args(
      java.nio.ByteBuffer table,
      TGet tget)
    {
      this();
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      this.tget = tget;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public exists_args(exists_args other) {
      if (other.isSetTable()) {
        this.table = org.apache.thrift.TBaseHelper.copyBinary(other.table);
      }
      if (other.isSetTget()) {
        this.tget = new TGet(other.tget);
      }
    }

    public exists_args deepCopy() {
      return new exists_args(this);
    }

    @Override
    public void clear() {
      this.table = null;
      this.tget = null;
    }

    /**
     * the table to check on
     */
    public byte[] getTable() {
      setTable(org.apache.thrift.TBaseHelper.rightSize(table));
      return table == null ? null : table.array();
    }

    public java.nio.ByteBuffer bufferForTable() {
      return org.apache.thrift.TBaseHelper.copyBinary(table);
    }

    /**
     * the table to check on
     */
    public exists_args setTable(byte[] table) {
      this.table = table == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(table.clone());
      return this;
    }

    public exists_args setTable(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table) {
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      return this;
    }

    public void unsetTable() {
      this.table = null;
    }

    /** Returns true if field table is set (has been assigned a value) and false otherwise */
    public boolean isSetTable() {
      return this.table != null;
    }

    public void setTableIsSet(boolean value) {
      if (!value) {
        this.table = null;
      }
    }

    /**
     * the TGet to check for
     */
    @org.apache.thrift.annotation.Nullable
    public TGet getTget() {
      return this.tget;
    }

    /**
     * the TGet to check for
     */
    public exists_args setTget(@org.apache.thrift.annotation.Nullable TGet tget) {
      this.tget = tget;
      return this;
    }

    public void unsetTget() {
      this.tget = null;
    }

    /** Returns true if field tget is set (has been assigned a value) and false otherwise */
    public boolean isSetTget() {
      return this.tget != null;
    }

    public void setTgetIsSet(boolean value) {
      if (!value) {
        this.tget = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE:
        if (value == null) {
          unsetTable();
        } else {
          if (value instanceof byte[]) {
            setTable((byte[])value);
          } else {
            setTable((java.nio.ByteBuffer)value);
          }
        }
        break;

      case TGET:
        if (value == null) {
          unsetTget();
        } else {
          setTget((TGet)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE:
        return getTable();

      case TGET:
        return getTget();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE:
        return isSetTable();
      case TGET:
        return isSetTget();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof exists_args)
        return this.equals((exists_args)that);
      return false;
    }

    public boolean equals(exists_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_table = true && this.isSetTable();
      boolean that_present_table = true && that.isSetTable();
      if (this_present_table || that_present_table) {
        if (!(this_present_table && that_present_table))
          return false;
        if (!this.table.equals(that.table))
          return false;
      }

      boolean this_present_tget = true && this.isSetTget();
      boolean that_present_tget = true && that.isSetTget();
      if (this_present_tget || that_present_tget) {
        if (!(this_present_tget && that_present_tget))
          return false;
        if (!this.tget.equals(that.tget))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTable()) ? 131071 : 524287);
      if (isSetTable())
        hashCode = hashCode * 8191 + table.hashCode();

      hashCode = hashCode * 8191 + ((isSetTget()) ? 131071 : 524287);
      if (isSetTget())
        hashCode = hashCode * 8191 + tget.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(exists_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTable(), other.isSetTable());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTable()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.table, other.table);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTget(), other.isSetTget());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTget()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tget, other.tget);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("exists_args(");
      boolean first = true;

      sb.append("table:");
      if (this.table == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.table, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tget:");
      if (this.tget == null) {
        sb.append("null");
      } else {
        sb.append(this.tget);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (table == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'table' was not present! Struct: " + toString());
      }
      if (tget == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'tget' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
      if (tget != null) {
        tget.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class exists_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public exists_argsStandardScheme getScheme() {
        return new exists_argsStandardScheme();
      }
    }

    private static class exists_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<exists_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, exists_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.table = iprot.readBinary();
                struct.setTableIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TGET
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tget = new TGet();
                struct.tget.read(iprot);
                struct.setTgetIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, exists_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.table != null) {
          oprot.writeFieldBegin(TABLE_FIELD_DESC);
          oprot.writeBinary(struct.table);
          oprot.writeFieldEnd();
        }
        if (struct.tget != null) {
          oprot.writeFieldBegin(TGET_FIELD_DESC);
          struct.tget.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class exists_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public exists_argsTupleScheme getScheme() {
        return new exists_argsTupleScheme();
      }
    }

    private static class exists_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<exists_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, exists_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        oprot.writeBinary(struct.table);
        struct.tget.write(oprot);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, exists_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        struct.table = iprot.readBinary();
        struct.setTableIsSet(true);
        struct.tget = new TGet();
        struct.tget.read(iprot);
        struct.setTgetIsSet(true);
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class exists_result implements org.apache.thrift.TBase<exists_result, exists_result._Fields>, java.io.Serializable, Cloneable, Comparable<exists_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("exists_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new exists_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new exists_resultTupleSchemeFactory();

    public boolean success; // required
    public @org.apache.thrift.annotation.Nullable TIOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(exists_result.class, metaDataMap);
    }

    public exists_result() {
    }

    public exists_result(
      boolean success,
      TIOError io)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public exists_result(exists_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetIo()) {
        this.io = new TIOError(other.io);
      }
    }

    public exists_result deepCopy() {
      return new exists_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.io = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public exists_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    @org.apache.thrift.annotation.Nullable
    public TIOError getIo() {
      return this.io;
    }

    public exists_result setIo(@org.apache.thrift.annotation.Nullable TIOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.lang.Boolean)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((TIOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof exists_result)
        return this.equals((exists_result)that);
      return false;
    }

    public boolean equals(exists_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((success) ? 131071 : 524287);

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(exists_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetIo(), other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("exists_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class exists_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public exists_resultStandardScheme getScheme() {
        return new exists_resultStandardScheme();
      }
    }

    private static class exists_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<exists_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, exists_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new TIOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, exists_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class exists_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public exists_resultTupleScheme getScheme() {
        return new exists_resultTupleScheme();
      }
    }

    private static class exists_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<exists_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, exists_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, exists_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new TIOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class existsAll_args implements org.apache.thrift.TBase<existsAll_args, existsAll_args._Fields>, java.io.Serializable, Cloneable, Comparable<existsAll_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("existsAll_args");

    private static final org.apache.thrift.protocol.TField TABLE_FIELD_DESC = new org.apache.thrift.protocol.TField("table", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TGETS_FIELD_DESC = new org.apache.thrift.protocol.TField("tgets", org.apache.thrift.protocol.TType.LIST, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new existsAll_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new existsAll_argsTupleSchemeFactory();

    /**
     * the table to check on
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table; // required
    /**
     * a list of TGets to check for
     */
    public @org.apache.thrift.annotation.Nullable java.util.List<TGet> tgets; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * the table to check on
       */
      TABLE((short)1, "table"),
      /**
       * a list of TGets to check for
       */
      TGETS((short)2, "tgets");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE
            return TABLE;
          case 2: // TGETS
            return TGETS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE, new org.apache.thrift.meta_data.FieldMetaData("table", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TGETS, new org.apache.thrift.meta_data.FieldMetaData("tgets", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TGet.class))));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(existsAll_args.class, metaDataMap);
    }

    public existsAll_args() {
    }

    public existsAll_args(
      java.nio.ByteBuffer table,
      java.util.List<TGet> tgets)
    {
      this();
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      this.tgets = tgets;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public existsAll_args(existsAll_args other) {
      if (other.isSetTable()) {
        this.table = org.apache.thrift.TBaseHelper.copyBinary(other.table);
      }
      if (other.isSetTgets()) {
        java.util.List<TGet> __this__tgets = new java.util.ArrayList<TGet>(other.tgets.size());
        for (TGet other_element : other.tgets) {
          __this__tgets.add(new TGet(other_element));
        }
        this.tgets = __this__tgets;
      }
    }

    public existsAll_args deepCopy() {
      return new existsAll_args(this);
    }

    @Override
    public void clear() {
      this.table = null;
      this.tgets = null;
    }

    /**
     * the table to check on
     */
    public byte[] getTable() {
      setTable(org.apache.thrift.TBaseHelper.rightSize(table));
      return table == null ? null : table.array();
    }

    public java.nio.ByteBuffer bufferForTable() {
      return org.apache.thrift.TBaseHelper.copyBinary(table);
    }

    /**
     * the table to check on
     */
    public existsAll_args setTable(byte[] table) {
      this.table = table == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(table.clone());
      return this;
    }

    public existsAll_args setTable(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table) {
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      return this;
    }

    public void unsetTable() {
      this.table = null;
    }

    /** Returns true if field table is set (has been assigned a value) and false otherwise */
    public boolean isSetTable() {
      return this.table != null;
    }

    public void setTableIsSet(boolean value) {
      if (!value) {
        this.table = null;
      }
    }

    public int getTgetsSize() {
      return (this.tgets == null) ? 0 : this.tgets.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<TGet> getTgetsIterator() {
      return (this.tgets == null) ? null : this.tgets.iterator();
    }

    public void addToTgets(TGet elem) {
      if (this.tgets == null) {
        this.tgets = new java.util.ArrayList<TGet>();
      }
      this.tgets.add(elem);
    }

    /**
     * a list of TGets to check for
     */
    @org.apache.thrift.annotation.Nullable
    public java.util.List<TGet> getTgets() {
      return this.tgets;
    }

    /**
     * a list of TGets to check for
     */
    public existsAll_args setTgets(@org.apache.thrift.annotation.Nullable java.util.List<TGet> tgets) {
      this.tgets = tgets;
      return this;
    }

    public void unsetTgets() {
      this.tgets = null;
    }

    /** Returns true if field tgets is set (has been assigned a value) and false otherwise */
    public boolean isSetTgets() {
      return this.tgets != null;
    }

    public void setTgetsIsSet(boolean value) {
      if (!value) {
        this.tgets = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE:
        if (value == null) {
          unsetTable();
        } else {
          if (value instanceof byte[]) {
            setTable((byte[])value);
          } else {
            setTable((java.nio.ByteBuffer)value);
          }
        }
        break;

      case TGETS:
        if (value == null) {
          unsetTgets();
        } else {
          setTgets((java.util.List<TGet>)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE:
        return getTable();

      case TGETS:
        return getTgets();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE:
        return isSetTable();
      case TGETS:
        return isSetTgets();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof existsAll_args)
        return this.equals((existsAll_args)that);
      return false;
    }

    public boolean equals(existsAll_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_table = true && this.isSetTable();
      boolean that_present_table = true && that.isSetTable();
      if (this_present_table || that_present_table) {
        if (!(this_present_table && that_present_table))
          return false;
        if (!this.table.equals(that.table))
          return false;
      }

      boolean this_present_tgets = true && this.isSetTgets();
      boolean that_present_tgets = true && that.isSetTgets();
      if (this_present_tgets || that_present_tgets) {
        if (!(this_present_tgets && that_present_tgets))
          return false;
        if (!this.tgets.equals(that.tgets))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTable()) ? 131071 : 524287);
      if (isSetTable())
        hashCode = hashCode * 8191 + table.hashCode();

      hashCode = hashCode * 8191 + ((isSetTgets()) ? 131071 : 524287);
      if (isSetTgets())
        hashCode = hashCode * 8191 + tgets.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(existsAll_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTable(), other.isSetTable());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTable()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.table, other.table);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTgets(), other.isSetTgets());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTgets()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tgets, other.tgets);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("existsAll_args(");
      boolean first = true;

      sb.append("table:");
      if (this.table == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.table, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tgets:");
      if (this.tgets == null) {
        sb.append("null");
      } else {
        sb.append(this.tgets);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (table == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'table' was not present! Struct: " + toString());
      }
      if (tgets == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'tgets' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class existsAll_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public existsAll_argsStandardScheme getScheme() {
        return new existsAll_argsStandardScheme();
      }
    }

    private static class existsAll_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<existsAll_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, existsAll_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.table = iprot.readBinary();
                struct.setTableIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TGETS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list190 = iprot.readListBegin();
                  struct.tgets = new java.util.ArrayList<TGet>(_list190.size);
                  @org.apache.thrift.annotation.Nullable TGet _elem191;
                  for (int _i192 = 0; _i192 < _list190.size; ++_i192)
                  {
                    _elem191 = new TGet();
                    _elem191.read(iprot);
                    struct.tgets.add(_elem191);
                  }
                  iprot.readListEnd();
                }
                struct.setTgetsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, existsAll_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.table != null) {
          oprot.writeFieldBegin(TABLE_FIELD_DESC);
          oprot.writeBinary(struct.table);
          oprot.writeFieldEnd();
        }
        if (struct.tgets != null) {
          oprot.writeFieldBegin(TGETS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.tgets.size()));
            for (TGet _iter193 : struct.tgets)
            {
              _iter193.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class existsAll_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public existsAll_argsTupleScheme getScheme() {
        return new existsAll_argsTupleScheme();
      }
    }

    private static class existsAll_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<existsAll_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, existsAll_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        oprot.writeBinary(struct.table);
        {
          oprot.writeI32(struct.tgets.size());
          for (TGet _iter194 : struct.tgets)
          {
            _iter194.write(oprot);
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, existsAll_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        struct.table = iprot.readBinary();
        struct.setTableIsSet(true);
        {
          org.apache.thrift.protocol.TList _list195 = iprot.readListBegin(org.apache.thrift.protocol.TType.STRUCT);
          struct.tgets = new java.util.ArrayList<TGet>(_list195.size);
          @org.apache.thrift.annotation.Nullable TGet _elem196;
          for (int _i197 = 0; _i197 < _list195.size; ++_i197)
          {
            _elem196 = new TGet();
            _elem196.read(iprot);
            struct.tgets.add(_elem196);
          }
        }
        struct.setTgetsIsSet(true);
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class existsAll_result implements org.apache.thrift.TBase<existsAll_result, existsAll_result._Fields>, java.io.Serializable, Cloneable, Comparable<existsAll_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("existsAll_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new existsAll_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new existsAll_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.util.List<java.lang.Boolean> success; // required
    public @org.apache.thrift.annotation.Nullable TIOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(existsAll_result.class, metaDataMap);
    }

    public existsAll_result() {
    }

    public existsAll_result(
      java.util.List<java.lang.Boolean> success,
      TIOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public existsAll_result(existsAll_result other) {
      if (other.isSetSuccess()) {
        java.util.List<java.lang.Boolean> __this__success = new java.util.ArrayList<java.lang.Boolean>(other.success);
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new TIOError(other.io);
      }
    }

    public existsAll_result deepCopy() {
      return new existsAll_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<java.lang.Boolean> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(boolean elem) {
      if (this.success == null) {
        this.success = new java.util.ArrayList<java.lang.Boolean>();
      }
      this.success.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<java.lang.Boolean> getSuccess() {
      return this.success;
    }

    public existsAll_result setSuccess(@org.apache.thrift.annotation.Nullable java.util.List<java.lang.Boolean> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public TIOError getIo() {
      return this.io;
    }

    public existsAll_result setIo(@org.apache.thrift.annotation.Nullable TIOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.util.List<java.lang.Boolean>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((TIOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof existsAll_result)
        return this.equals((existsAll_result)that);
      return false;
    }

    public boolean equals(existsAll_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(existsAll_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetIo(), other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("existsAll_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class existsAll_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public existsAll_resultStandardScheme getScheme() {
        return new existsAll_resultStandardScheme();
      }
    }

    private static class existsAll_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<existsAll_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, existsAll_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list198 = iprot.readListBegin();
                  struct.success = new java.util.ArrayList<java.lang.Boolean>(_list198.size);
                  boolean _elem199;
                  for (int _i200 = 0; _i200 < _list198.size; ++_i200)
                  {
                    _elem199 = iprot.readBool();
                    struct.success.add(_elem199);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new TIOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, existsAll_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.BOOL, struct.success.size()));
            for (boolean _iter201 : struct.success)
            {
              oprot.writeBool(_iter201);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class existsAll_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public existsAll_resultTupleScheme getScheme() {
        return new existsAll_resultTupleScheme();
      }
    }

    private static class existsAll_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<existsAll_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, existsAll_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (boolean _iter202 : struct.success)
            {
              oprot.writeBool(_iter202);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, existsAll_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list203 = iprot.readListBegin(org.apache.thrift.protocol.TType.BOOL);
            struct.success = new java.util.ArrayList<java.lang.Boolean>(_list203.size);
            boolean _elem204;
            for (int _i205 = 0; _i205 < _list203.size; ++_i205)
            {
              _elem204 = iprot.readBool();
              struct.success.add(_elem204);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new TIOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class get_args implements org.apache.thrift.TBase<get_args, get_args._Fields>, java.io.Serializable, Cloneable, Comparable<get_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_args");

    private static final org.apache.thrift.protocol.TField TABLE_FIELD_DESC = new org.apache.thrift.protocol.TField("table", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TGET_FIELD_DESC = new org.apache.thrift.protocol.TField("tget", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new get_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new get_argsTupleSchemeFactory();

    /**
     * the table to get from
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table; // required
    /**
     * the TGet to fetch
     */
    public @org.apache.thrift.annotation.Nullable TGet tget; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * the table to get from
       */
      TABLE((short)1, "table"),
      /**
       * the TGet to fetch
       */
      TGET((short)2, "tget");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE
            return TABLE;
          case 2: // TGET
            return TGET;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE, new org.apache.thrift.meta_data.FieldMetaData("table", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TGET, new org.apache.thrift.meta_data.FieldMetaData("tget", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TGet.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_args.class, metaDataMap);
    }

    public get_args() {
    }

    public get_args(
      java.nio.ByteBuffer table,
      TGet tget)
    {
      this();
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      this.tget = tget;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_args(get_args other) {
      if (other.isSetTable()) {
        this.table = org.apache.thrift.TBaseHelper.copyBinary(other.table);
      }
      if (other.isSetTget()) {
        this.tget = new TGet(other.tget);
      }
    }

    public get_args deepCopy() {
      return new get_args(this);
    }

    @Override
    public void clear() {
      this.table = null;
      this.tget = null;
    }

    /**
     * the table to get from
     */
    public byte[] getTable() {
      setTable(org.apache.thrift.TBaseHelper.rightSize(table));
      return table == null ? null : table.array();
    }

    public java.nio.ByteBuffer bufferForTable() {
      return org.apache.thrift.TBaseHelper.copyBinary(table);
    }

    /**
     * the table to get from
     */
    public get_args setTable(byte[] table) {
      this.table = table == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(table.clone());
      return this;
    }

    public get_args setTable(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table) {
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      return this;
    }

    public void unsetTable() {
      this.table = null;
    }

    /** Returns true if field table is set (has been assigned a value) and false otherwise */
    public boolean isSetTable() {
      return this.table != null;
    }

    public void setTableIsSet(boolean value) {
      if (!value) {
        this.table = null;
      }
    }

    /**
     * the TGet to fetch
     */
    @org.apache.thrift.annotation.Nullable
    public TGet getTget() {
      return this.tget;
    }

    /**
     * the TGet to fetch
     */
    public get_args setTget(@org.apache.thrift.annotation.Nullable TGet tget) {
      this.tget = tget;
      return this;
    }

    public void unsetTget() {
      this.tget = null;
    }

    /** Returns true if field tget is set (has been assigned a value) and false otherwise */
    public boolean isSetTget() {
      return this.tget != null;
    }

    public void setTgetIsSet(boolean value) {
      if (!value) {
        this.tget = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE:
        if (value == null) {
          unsetTable();
        } else {
          if (value instanceof byte[]) {
            setTable((byte[])value);
          } else {
            setTable((java.nio.ByteBuffer)value);
          }
        }
        break;

      case TGET:
        if (value == null) {
          unsetTget();
        } else {
          setTget((TGet)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE:
        return getTable();

      case TGET:
        return getTget();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE:
        return isSetTable();
      case TGET:
        return isSetTget();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof get_args)
        return this.equals((get_args)that);
      return false;
    }

    public boolean equals(get_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_table = true && this.isSetTable();
      boolean that_present_table = true && that.isSetTable();
      if (this_present_table || that_present_table) {
        if (!(this_present_table && that_present_table))
          return false;
        if (!this.table.equals(that.table))
          return false;
      }

      boolean this_present_tget = true && this.isSetTget();
      boolean that_present_tget = true && that.isSetTget();
      if (this_present_tget || that_present_tget) {
        if (!(this_present_tget && that_present_tget))
          return false;
        if (!this.tget.equals(that.tget))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTable()) ? 131071 : 524287);
      if (isSetTable())
        hashCode = hashCode * 8191 + table.hashCode();

      hashCode = hashCode * 8191 + ((isSetTget()) ? 131071 : 524287);
      if (isSetTget())
        hashCode = hashCode * 8191 + tget.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(get_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTable(), other.isSetTable());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTable()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.table, other.table);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTget(), other.isSetTget());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTget()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tget, other.tget);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("get_args(");
      boolean first = true;

      sb.append("table:");
      if (this.table == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.table, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tget:");
      if (this.tget == null) {
        sb.append("null");
      } else {
        sb.append(this.tget);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (table == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'table' was not present! Struct: " + toString());
      }
      if (tget == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'tget' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
      if (tget != null) {
        tget.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class get_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public get_argsStandardScheme getScheme() {
        return new get_argsStandardScheme();
      }
    }

    private static class get_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<get_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, get_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.table = iprot.readBinary();
                struct.setTableIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TGET
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tget = new TGet();
                struct.tget.read(iprot);
                struct.setTgetIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, get_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.table != null) {
          oprot.writeFieldBegin(TABLE_FIELD_DESC);
          oprot.writeBinary(struct.table);
          oprot.writeFieldEnd();
        }
        if (struct.tget != null) {
          oprot.writeFieldBegin(TGET_FIELD_DESC);
          struct.tget.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class get_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public get_argsTupleScheme getScheme() {
        return new get_argsTupleScheme();
      }
    }

    private static class get_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<get_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, get_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        oprot.writeBinary(struct.table);
        struct.tget.write(oprot);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, get_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        struct.table = iprot.readBinary();
        struct.setTableIsSet(true);
        struct.tget = new TGet();
        struct.tget.read(iprot);
        struct.setTgetIsSet(true);
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class get_result implements org.apache.thrift.TBase<get_result, get_result._Fields>, java.io.Serializable, Cloneable, Comparable<get_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("get_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new get_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new get_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable TResult success; // required
    public @org.apache.thrift.annotation.Nullable TIOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TResult.class)));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(get_result.class, metaDataMap);
    }

    public get_result() {
    }

    public get_result(
      TResult success,
      TIOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public get_result(get_result other) {
      if (other.isSetSuccess()) {
        this.success = new TResult(other.success);
      }
      if (other.isSetIo()) {
        this.io = new TIOError(other.io);
      }
    }

    public get_result deepCopy() {
      return new get_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    @org.apache.thrift.annotation.Nullable
    public TResult getSuccess() {
      return this.success;
    }

    public get_result setSuccess(@org.apache.thrift.annotation.Nullable TResult success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public TIOError getIo() {
      return this.io;
    }

    public get_result setIo(@org.apache.thrift.annotation.Nullable TIOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((TResult)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((TIOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof get_result)
        return this.equals((get_result)that);
      return false;
    }

    public boolean equals(get_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(get_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetIo(), other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("get_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class get_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public get_resultStandardScheme getScheme() {
        return new get_resultStandardScheme();
      }
    }

    private static class get_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<get_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, get_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new TResult();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new TIOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, get_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class get_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public get_resultTupleScheme getScheme() {
        return new get_resultTupleScheme();
      }
    }

    private static class get_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<get_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, get_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, get_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new TResult();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new TIOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getMultiple_args implements org.apache.thrift.TBase<getMultiple_args, getMultiple_args._Fields>, java.io.Serializable, Cloneable, Comparable<getMultiple_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getMultiple_args");

    private static final org.apache.thrift.protocol.TField TABLE_FIELD_DESC = new org.apache.thrift.protocol.TField("table", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TGETS_FIELD_DESC = new org.apache.thrift.protocol.TField("tgets", org.apache.thrift.protocol.TType.LIST, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getMultiple_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getMultiple_argsTupleSchemeFactory();

    /**
     * the table to get from
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table; // required
    /**
     * a list of TGets to fetch, the Result list
     * will have the Results at corresponding positions
     * or null if there was an error
     */
    public @org.apache.thrift.annotation.Nullable java.util.List<TGet> tgets; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * the table to get from
       */
      TABLE((short)1, "table"),
      /**
       * a list of TGets to fetch, the Result list
       * will have the Results at corresponding positions
       * or null if there was an error
       */
      TGETS((short)2, "tgets");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE
            return TABLE;
          case 2: // TGETS
            return TGETS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE, new org.apache.thrift.meta_data.FieldMetaData("table", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TGETS, new org.apache.thrift.meta_data.FieldMetaData("tgets", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TGet.class))));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getMultiple_args.class, metaDataMap);
    }

    public getMultiple_args() {
    }

    public getMultiple_args(
      java.nio.ByteBuffer table,
      java.util.List<TGet> tgets)
    {
      this();
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      this.tgets = tgets;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getMultiple_args(getMultiple_args other) {
      if (other.isSetTable()) {
        this.table = org.apache.thrift.TBaseHelper.copyBinary(other.table);
      }
      if (other.isSetTgets()) {
        java.util.List<TGet> __this__tgets = new java.util.ArrayList<TGet>(other.tgets.size());
        for (TGet other_element : other.tgets) {
          __this__tgets.add(new TGet(other_element));
        }
        this.tgets = __this__tgets;
      }
    }

    public getMultiple_args deepCopy() {
      return new getMultiple_args(this);
    }

    @Override
    public void clear() {
      this.table = null;
      this.tgets = null;
    }

    /**
     * the table to get from
     */
    public byte[] getTable() {
      setTable(org.apache.thrift.TBaseHelper.rightSize(table));
      return table == null ? null : table.array();
    }

    public java.nio.ByteBuffer bufferForTable() {
      return org.apache.thrift.TBaseHelper.copyBinary(table);
    }

    /**
     * the table to get from
     */
    public getMultiple_args setTable(byte[] table) {
      this.table = table == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(table.clone());
      return this;
    }

    public getMultiple_args setTable(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table) {
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      return this;
    }

    public void unsetTable() {
      this.table = null;
    }

    /** Returns true if field table is set (has been assigned a value) and false otherwise */
    public boolean isSetTable() {
      return this.table != null;
    }

    public void setTableIsSet(boolean value) {
      if (!value) {
        this.table = null;
      }
    }

    public int getTgetsSize() {
      return (this.tgets == null) ? 0 : this.tgets.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<TGet> getTgetsIterator() {
      return (this.tgets == null) ? null : this.tgets.iterator();
    }

    public void addToTgets(TGet elem) {
      if (this.tgets == null) {
        this.tgets = new java.util.ArrayList<TGet>();
      }
      this.tgets.add(elem);
    }

    /**
     * a list of TGets to fetch, the Result list
     * will have the Results at corresponding positions
     * or null if there was an error
     */
    @org.apache.thrift.annotation.Nullable
    public java.util.List<TGet> getTgets() {
      return this.tgets;
    }

    /**
     * a list of TGets to fetch, the Result list
     * will have the Results at corresponding positions
     * or null if there was an error
     */
    public getMultiple_args setTgets(@org.apache.thrift.annotation.Nullable java.util.List<TGet> tgets) {
      this.tgets = tgets;
      return this;
    }

    public void unsetTgets() {
      this.tgets = null;
    }

    /** Returns true if field tgets is set (has been assigned a value) and false otherwise */
    public boolean isSetTgets() {
      return this.tgets != null;
    }

    public void setTgetsIsSet(boolean value) {
      if (!value) {
        this.tgets = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE:
        if (value == null) {
          unsetTable();
        } else {
          if (value instanceof byte[]) {
            setTable((byte[])value);
          } else {
            setTable((java.nio.ByteBuffer)value);
          }
        }
        break;

      case TGETS:
        if (value == null) {
          unsetTgets();
        } else {
          setTgets((java.util.List<TGet>)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE:
        return getTable();

      case TGETS:
        return getTgets();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE:
        return isSetTable();
      case TGETS:
        return isSetTgets();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof getMultiple_args)
        return this.equals((getMultiple_args)that);
      return false;
    }

    public boolean equals(getMultiple_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_table = true && this.isSetTable();
      boolean that_present_table = true && that.isSetTable();
      if (this_present_table || that_present_table) {
        if (!(this_present_table && that_present_table))
          return false;
        if (!this.table.equals(that.table))
          return false;
      }

      boolean this_present_tgets = true && this.isSetTgets();
      boolean that_present_tgets = true && that.isSetTgets();
      if (this_present_tgets || that_present_tgets) {
        if (!(this_present_tgets && that_present_tgets))
          return false;
        if (!this.tgets.equals(that.tgets))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTable()) ? 131071 : 524287);
      if (isSetTable())
        hashCode = hashCode * 8191 + table.hashCode();

      hashCode = hashCode * 8191 + ((isSetTgets()) ? 131071 : 524287);
      if (isSetTgets())
        hashCode = hashCode * 8191 + tgets.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getMultiple_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTable(), other.isSetTable());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTable()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.table, other.table);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTgets(), other.isSetTgets());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTgets()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tgets, other.tgets);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getMultiple_args(");
      boolean first = true;

      sb.append("table:");
      if (this.table == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.table, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tgets:");
      if (this.tgets == null) {
        sb.append("null");
      } else {
        sb.append(this.tgets);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (table == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'table' was not present! Struct: " + toString());
      }
      if (tgets == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'tgets' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getMultiple_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getMultiple_argsStandardScheme getScheme() {
        return new getMultiple_argsStandardScheme();
      }
    }

    private static class getMultiple_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<getMultiple_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getMultiple_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.table = iprot.readBinary();
                struct.setTableIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TGETS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list206 = iprot.readListBegin();
                  struct.tgets = new java.util.ArrayList<TGet>(_list206.size);
                  @org.apache.thrift.annotation.Nullable TGet _elem207;
                  for (int _i208 = 0; _i208 < _list206.size; ++_i208)
                  {
                    _elem207 = new TGet();
                    _elem207.read(iprot);
                    struct.tgets.add(_elem207);
                  }
                  iprot.readListEnd();
                }
                struct.setTgetsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getMultiple_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.table != null) {
          oprot.writeFieldBegin(TABLE_FIELD_DESC);
          oprot.writeBinary(struct.table);
          oprot.writeFieldEnd();
        }
        if (struct.tgets != null) {
          oprot.writeFieldBegin(TGETS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.tgets.size()));
            for (TGet _iter209 : struct.tgets)
            {
              _iter209.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getMultiple_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getMultiple_argsTupleScheme getScheme() {
        return new getMultiple_argsTupleScheme();
      }
    }

    private static class getMultiple_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<getMultiple_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getMultiple_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        oprot.writeBinary(struct.table);
        {
          oprot.writeI32(struct.tgets.size());
          for (TGet _iter210 : struct.tgets)
          {
            _iter210.write(oprot);
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getMultiple_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        struct.table = iprot.readBinary();
        struct.setTableIsSet(true);
        {
          org.apache.thrift.protocol.TList _list211 = iprot.readListBegin(org.apache.thrift.protocol.TType.STRUCT);
          struct.tgets = new java.util.ArrayList<TGet>(_list211.size);
          @org.apache.thrift.annotation.Nullable TGet _elem212;
          for (int _i213 = 0; _i213 < _list211.size; ++_i213)
          {
            _elem212 = new TGet();
            _elem212.read(iprot);
            struct.tgets.add(_elem212);
          }
        }
        struct.setTgetsIsSet(true);
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getMultiple_result implements org.apache.thrift.TBase<getMultiple_result, getMultiple_result._Fields>, java.io.Serializable, Cloneable, Comparable<getMultiple_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getMultiple_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getMultiple_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getMultiple_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.util.List<TResult> success; // required
    public @org.apache.thrift.annotation.Nullable TIOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TResult.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getMultiple_result.class, metaDataMap);
    }

    public getMultiple_result() {
    }

    public getMultiple_result(
      java.util.List<TResult> success,
      TIOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getMultiple_result(getMultiple_result other) {
      if (other.isSetSuccess()) {
        java.util.List<TResult> __this__success = new java.util.ArrayList<TResult>(other.success.size());
        for (TResult other_element : other.success) {
          __this__success.add(new TResult(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new TIOError(other.io);
      }
    }

    public getMultiple_result deepCopy() {
      return new getMultiple_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<TResult> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TResult elem) {
      if (this.success == null) {
        this.success = new java.util.ArrayList<TResult>();
      }
      this.success.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<TResult> getSuccess() {
      return this.success;
    }

    public getMultiple_result setSuccess(@org.apache.thrift.annotation.Nullable java.util.List<TResult> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public TIOError getIo() {
      return this.io;
    }

    public getMultiple_result setIo(@org.apache.thrift.annotation.Nullable TIOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.util.List<TResult>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((TIOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof getMultiple_result)
        return this.equals((getMultiple_result)that);
      return false;
    }

    public boolean equals(getMultiple_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getMultiple_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetIo(), other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getMultiple_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getMultiple_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getMultiple_resultStandardScheme getScheme() {
        return new getMultiple_resultStandardScheme();
      }
    }

    private static class getMultiple_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<getMultiple_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getMultiple_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list214 = iprot.readListBegin();
                  struct.success = new java.util.ArrayList<TResult>(_list214.size);
                  @org.apache.thrift.annotation.Nullable TResult _elem215;
                  for (int _i216 = 0; _i216 < _list214.size; ++_i216)
                  {
                    _elem215 = new TResult();
                    _elem215.read(iprot);
                    struct.success.add(_elem215);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new TIOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getMultiple_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TResult _iter217 : struct.success)
            {
              _iter217.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getMultiple_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getMultiple_resultTupleScheme getScheme() {
        return new getMultiple_resultTupleScheme();
      }
    }

    private static class getMultiple_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<getMultiple_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getMultiple_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TResult _iter218 : struct.success)
            {
              _iter218.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getMultiple_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list219 = iprot.readListBegin(org.apache.thrift.protocol.TType.STRUCT);
            struct.success = new java.util.ArrayList<TResult>(_list219.size);
            @org.apache.thrift.annotation.Nullable TResult _elem220;
            for (int _i221 = 0; _i221 < _list219.size; ++_i221)
            {
              _elem220 = new TResult();
              _elem220.read(iprot);
              struct.success.add(_elem220);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new TIOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class put_args implements org.apache.thrift.TBase<put_args, put_args._Fields>, java.io.Serializable, Cloneable, Comparable<put_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("put_args");

    private static final org.apache.thrift.protocol.TField TABLE_FIELD_DESC = new org.apache.thrift.protocol.TField("table", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TPUT_FIELD_DESC = new org.apache.thrift.protocol.TField("tput", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new put_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new put_argsTupleSchemeFactory();

    /**
     * the table to put data in
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table; // required
    /**
     * the TPut to put
     */
    public @org.apache.thrift.annotation.Nullable TPut tput; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * the table to put data in
       */
      TABLE((short)1, "table"),
      /**
       * the TPut to put
       */
      TPUT((short)2, "tput");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE
            return TABLE;
          case 2: // TPUT
            return TPUT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE, new org.apache.thrift.meta_data.FieldMetaData("table", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TPUT, new org.apache.thrift.meta_data.FieldMetaData("tput", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TPut.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(put_args.class, metaDataMap);
    }

    public put_args() {
    }

    public put_args(
      java.nio.ByteBuffer table,
      TPut tput)
    {
      this();
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      this.tput = tput;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public put_args(put_args other) {
      if (other.isSetTable()) {
        this.table = org.apache.thrift.TBaseHelper.copyBinary(other.table);
      }
      if (other.isSetTput()) {
        this.tput = new TPut(other.tput);
      }
    }

    public put_args deepCopy() {
      return new put_args(this);
    }

    @Override
    public void clear() {
      this.table = null;
      this.tput = null;
    }

    /**
     * the table to put data in
     */
    public byte[] getTable() {
      setTable(org.apache.thrift.TBaseHelper.rightSize(table));
      return table == null ? null : table.array();
    }

    public java.nio.ByteBuffer bufferForTable() {
      return org.apache.thrift.TBaseHelper.copyBinary(table);
    }

    /**
     * the table to put data in
     */
    public put_args setTable(byte[] table) {
      this.table = table == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(table.clone());
      return this;
    }

    public put_args setTable(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table) {
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      return this;
    }

    public void unsetTable() {
      this.table = null;
    }

    /** Returns true if field table is set (has been assigned a value) and false otherwise */
    public boolean isSetTable() {
      return this.table != null;
    }

    public void setTableIsSet(boolean value) {
      if (!value) {
        this.table = null;
      }
    }

    /**
     * the TPut to put
     */
    @org.apache.thrift.annotation.Nullable
    public TPut getTput() {
      return this.tput;
    }

    /**
     * the TPut to put
     */
    public put_args setTput(@org.apache.thrift.annotation.Nullable TPut tput) {
      this.tput = tput;
      return this;
    }

    public void unsetTput() {
      this.tput = null;
    }

    /** Returns true if field tput is set (has been assigned a value) and false otherwise */
    public boolean isSetTput() {
      return this.tput != null;
    }

    public void setTputIsSet(boolean value) {
      if (!value) {
        this.tput = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE:
        if (value == null) {
          unsetTable();
        } else {
          if (value instanceof byte[]) {
            setTable((byte[])value);
          } else {
            setTable((java.nio.ByteBuffer)value);
          }
        }
        break;

      case TPUT:
        if (value == null) {
          unsetTput();
        } else {
          setTput((TPut)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE:
        return getTable();

      case TPUT:
        return getTput();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE:
        return isSetTable();
      case TPUT:
        return isSetTput();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof put_args)
        return this.equals((put_args)that);
      return false;
    }

    public boolean equals(put_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_table = true && this.isSetTable();
      boolean that_present_table = true && that.isSetTable();
      if (this_present_table || that_present_table) {
        if (!(this_present_table && that_present_table))
          return false;
        if (!this.table.equals(that.table))
          return false;
      }

      boolean this_present_tput = true && this.isSetTput();
      boolean that_present_tput = true && that.isSetTput();
      if (this_present_tput || that_present_tput) {
        if (!(this_present_tput && that_present_tput))
          return false;
        if (!this.tput.equals(that.tput))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTable()) ? 131071 : 524287);
      if (isSetTable())
        hashCode = hashCode * 8191 + table.hashCode();

      hashCode = hashCode * 8191 + ((isSetTput()) ? 131071 : 524287);
      if (isSetTput())
        hashCode = hashCode * 8191 + tput.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(put_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTable(), other.isSetTable());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTable()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.table, other.table);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTput(), other.isSetTput());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTput()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tput, other.tput);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("put_args(");
      boolean first = true;

      sb.append("table:");
      if (this.table == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.table, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tput:");
      if (this.tput == null) {
        sb.append("null");
      } else {
        sb.append(this.tput);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (table == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'table' was not present! Struct: " + toString());
      }
      if (tput == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'tput' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
      if (tput != null) {
        tput.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class put_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public put_argsStandardScheme getScheme() {
        return new put_argsStandardScheme();
      }
    }

    private static class put_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<put_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, put_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.table = iprot.readBinary();
                struct.setTableIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TPUT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tput = new TPut();
                struct.tput.read(iprot);
                struct.setTputIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, put_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.table != null) {
          oprot.writeFieldBegin(TABLE_FIELD_DESC);
          oprot.writeBinary(struct.table);
          oprot.writeFieldEnd();
        }
        if (struct.tput != null) {
          oprot.writeFieldBegin(TPUT_FIELD_DESC);
          struct.tput.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class put_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public put_argsTupleScheme getScheme() {
        return new put_argsTupleScheme();
      }
    }

    private static class put_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<put_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, put_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        oprot.writeBinary(struct.table);
        struct.tput.write(oprot);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, put_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        struct.table = iprot.readBinary();
        struct.setTableIsSet(true);
        struct.tput = new TPut();
        struct.tput.read(iprot);
        struct.setTputIsSet(true);
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class put_result implements org.apache.thrift.TBase<put_result, put_result._Fields>, java.io.Serializable, Cloneable, Comparable<put_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("put_result");

    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new put_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new put_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable TIOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(put_result.class, metaDataMap);
    }

    public put_result() {
    }

    public put_result(
      TIOError io)
    {
      this();
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public put_result(put_result other) {
      if (other.isSetIo()) {
        this.io = new TIOError(other.io);
      }
    }

    public put_result deepCopy() {
      return new put_result(this);
    }

    @Override
    public void clear() {
      this.io = null;
    }

    @org.apache.thrift.annotation.Nullable
    public TIOError getIo() {
      return this.io;
    }

    public put_result setIo(@org.apache.thrift.annotation.Nullable TIOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((TIOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof put_result)
        return this.equals((put_result)that);
      return false;
    }

    public boolean equals(put_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(put_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetIo(), other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("put_result(");
      boolean first = true;

      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class put_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public put_resultStandardScheme getScheme() {
        return new put_resultStandardScheme();
      }
    }

    private static class put_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<put_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, put_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new TIOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, put_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class put_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public put_resultTupleScheme getScheme() {
        return new put_resultTupleScheme();
      }
    }

    private static class put_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<put_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, put_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetIo()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, put_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.io = new TIOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class checkAndPut_args implements org.apache.thrift.TBase<checkAndPut_args, checkAndPut_args._Fields>, java.io.Serializable, Cloneable, Comparable<checkAndPut_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("checkAndPut_args");

    private static final org.apache.thrift.protocol.TField TABLE_FIELD_DESC = new org.apache.thrift.protocol.TField("table", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField FAMILY_FIELD_DESC = new org.apache.thrift.protocol.TField("family", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField QUALIFIER_FIELD_DESC = new org.apache.thrift.protocol.TField("qualifier", org.apache.thrift.protocol.TType.STRING, (short)4);
    private static final org.apache.thrift.protocol.TField VALUE_FIELD_DESC = new org.apache.thrift.protocol.TField("value", org.apache.thrift.protocol.TType.STRING, (short)5);
    private static final org.apache.thrift.protocol.TField TPUT_FIELD_DESC = new org.apache.thrift.protocol.TField("tput", org.apache.thrift.protocol.TType.STRUCT, (short)6);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new checkAndPut_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new checkAndPut_argsTupleSchemeFactory();

    /**
     * to check in and put to
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table; // required
    /**
     * row to check
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row; // required
    /**
     * column family to check
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer family; // required
    /**
     * column qualifier to check
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer qualifier; // required
    /**
     * the expected value, if not provided the
     * check is for the non-existence of the
     * column in question
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer value; // required
    /**
     * the TPut to put if the check succeeds
     */
    public @org.apache.thrift.annotation.Nullable TPut tput; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * to check in and put to
       */
      TABLE((short)1, "table"),
      /**
       * row to check
       */
      ROW((short)2, "row"),
      /**
       * column family to check
       */
      FAMILY((short)3, "family"),
      /**
       * column qualifier to check
       */
      QUALIFIER((short)4, "qualifier"),
      /**
       * the expected value, if not provided the
       * check is for the non-existence of the
       * column in question
       */
      VALUE((short)5, "value"),
      /**
       * the TPut to put if the check succeeds
       */
      TPUT((short)6, "tput");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE
            return TABLE;
          case 2: // ROW
            return ROW;
          case 3: // FAMILY
            return FAMILY;
          case 4: // QUALIFIER
            return QUALIFIER;
          case 5: // VALUE
            return VALUE;
          case 6: // TPUT
            return TPUT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE, new org.apache.thrift.meta_data.FieldMetaData("table", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.ROW, new org.apache.thrift.meta_data.FieldMetaData("row", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.FAMILY, new org.apache.thrift.meta_data.FieldMetaData("family", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.QUALIFIER, new org.apache.thrift.meta_data.FieldMetaData("qualifier", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.VALUE, new org.apache.thrift.meta_data.FieldMetaData("value", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TPUT, new org.apache.thrift.meta_data.FieldMetaData("tput", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TPut.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(checkAndPut_args.class, metaDataMap);
    }

    public checkAndPut_args() {
    }

    public checkAndPut_args(
      java.nio.ByteBuffer table,
      java.nio.ByteBuffer row,
      java.nio.ByteBuffer family,
      java.nio.ByteBuffer qualifier,
      java.nio.ByteBuffer value,
      TPut tput)
    {
      this();
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      this.family = org.apache.thrift.TBaseHelper.copyBinary(family);
      this.qualifier = org.apache.thrift.TBaseHelper.copyBinary(qualifier);
      this.value = org.apache.thrift.TBaseHelper.copyBinary(value);
      this.tput = tput;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public checkAndPut_args(checkAndPut_args other) {
      if (other.isSetTable()) {
        this.table = org.apache.thrift.TBaseHelper.copyBinary(other.table);
      }
      if (other.isSetRow()) {
        this.row = org.apache.thrift.TBaseHelper.copyBinary(other.row);
      }
      if (other.isSetFamily()) {
        this.family = org.apache.thrift.TBaseHelper.copyBinary(other.family);
      }
      if (other.isSetQualifier()) {
        this.qualifier = org.apache.thrift.TBaseHelper.copyBinary(other.qualifier);
      }
      if (other.isSetValue()) {
        this.value = org.apache.thrift.TBaseHelper.copyBinary(other.value);
      }
      if (other.isSetTput()) {
        this.tput = new TPut(other.tput);
      }
    }

    public checkAndPut_args deepCopy() {
      return new checkAndPut_args(this);
    }

    @Override
    public void clear() {
      this.table = null;
      this.row = null;
      this.family = null;
      this.qualifier = null;
      this.value = null;
      this.tput = null;
    }

    /**
     * to check in and put to
     */
    public byte[] getTable() {
      setTable(org.apache.thrift.TBaseHelper.rightSize(table));
      return table == null ? null : table.array();
    }

    public java.nio.ByteBuffer bufferForTable() {
      return org.apache.thrift.TBaseHelper.copyBinary(table);
    }

    /**
     * to check in and put to
     */
    public checkAndPut_args setTable(byte[] table) {
      this.table = table == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(table.clone());
      return this;
    }

    public checkAndPut_args setTable(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table) {
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      return this;
    }

    public void unsetTable() {
      this.table = null;
    }

    /** Returns true if field table is set (has been assigned a value) and false otherwise */
    public boolean isSetTable() {
      return this.table != null;
    }

    public void setTableIsSet(boolean value) {
      if (!value) {
        this.table = null;
      }
    }

    /**
     * row to check
     */
    public byte[] getRow() {
      setRow(org.apache.thrift.TBaseHelper.rightSize(row));
      return row == null ? null : row.array();
    }

    public java.nio.ByteBuffer bufferForRow() {
      return org.apache.thrift.TBaseHelper.copyBinary(row);
    }

    /**
     * row to check
     */
    public checkAndPut_args setRow(byte[] row) {
      this.row = row == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(row.clone());
      return this;
    }

    public checkAndPut_args setRow(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row) {
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      return this;
    }

    public void unsetRow() {
      this.row = null;
    }

    /** Returns true if field row is set (has been assigned a value) and false otherwise */
    public boolean isSetRow() {
      return this.row != null;
    }

    public void setRowIsSet(boolean value) {
      if (!value) {
        this.row = null;
      }
    }

    /**
     * column family to check
     */
    public byte[] getFamily() {
      setFamily(org.apache.thrift.TBaseHelper.rightSize(family));
      return family == null ? null : family.array();
    }

    public java.nio.ByteBuffer bufferForFamily() {
      return org.apache.thrift.TBaseHelper.copyBinary(family);
    }

    /**
     * column family to check
     */
    public checkAndPut_args setFamily(byte[] family) {
      this.family = family == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(family.clone());
      return this;
    }

    public checkAndPut_args setFamily(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer family) {
      this.family = org.apache.thrift.TBaseHelper.copyBinary(family);
      return this;
    }

    public void unsetFamily() {
      this.family = null;
    }

    /** Returns true if field family is set (has been assigned a value) and false otherwise */
    public boolean isSetFamily() {
      return this.family != null;
    }

    public void setFamilyIsSet(boolean value) {
      if (!value) {
        this.family = null;
      }
    }

    /**
     * column qualifier to check
     */
    public byte[] getQualifier() {
      setQualifier(org.apache.thrift.TBaseHelper.rightSize(qualifier));
      return qualifier == null ? null : qualifier.array();
    }

    public java.nio.ByteBuffer bufferForQualifier() {
      return org.apache.thrift.TBaseHelper.copyBinary(qualifier);
    }

    /**
     * column qualifier to check
     */
    public checkAndPut_args setQualifier(byte[] qualifier) {
      this.qualifier = qualifier == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(qualifier.clone());
      return this;
    }

    public checkAndPut_args setQualifier(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer qualifier) {
      this.qualifier = org.apache.thrift.TBaseHelper.copyBinary(qualifier);
      return this;
    }

    public void unsetQualifier() {
      this.qualifier = null;
    }

    /** Returns true if field qualifier is set (has been assigned a value) and false otherwise */
    public boolean isSetQualifier() {
      return this.qualifier != null;
    }

    public void setQualifierIsSet(boolean value) {
      if (!value) {
        this.qualifier = null;
      }
    }

    /**
     * the expected value, if not provided the
     * check is for the non-existence of the
     * column in question
     */
    public byte[] getValue() {
      setValue(org.apache.thrift.TBaseHelper.rightSize(value));
      return value == null ? null : value.array();
    }

    public java.nio.ByteBuffer bufferForValue() {
      return org.apache.thrift.TBaseHelper.copyBinary(value);
    }

    /**
     * the expected value, if not provided the
     * check is for the non-existence of the
     * column in question
     */
    public checkAndPut_args setValue(byte[] value) {
      this.value = value == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(value.clone());
      return this;
    }

    public checkAndPut_args setValue(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer value) {
      this.value = org.apache.thrift.TBaseHelper.copyBinary(value);
      return this;
    }

    public void unsetValue() {
      this.value = null;
    }

    /** Returns true if field value is set (has been assigned a value) and false otherwise */
    public boolean isSetValue() {
      return this.value != null;
    }

    public void setValueIsSet(boolean value) {
      if (!value) {
        this.value = null;
      }
    }

    /**
     * the TPut to put if the check succeeds
     */
    @org.apache.thrift.annotation.Nullable
    public TPut getTput() {
      return this.tput;
    }

    /**
     * the TPut to put if the check succeeds
     */
    public checkAndPut_args setTput(@org.apache.thrift.annotation.Nullable TPut tput) {
      this.tput = tput;
      return this;
    }

    public void unsetTput() {
      this.tput = null;
    }

    /** Returns true if field tput is set (has been assigned a value) and false otherwise */
    public boolean isSetTput() {
      return this.tput != null;
    }

    public void setTputIsSet(boolean value) {
      if (!value) {
        this.tput = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE:
        if (value == null) {
          unsetTable();
        } else {
          if (value instanceof byte[]) {
            setTable((byte[])value);
          } else {
            setTable((java.nio.ByteBuffer)value);
          }
        }
        break;

      case ROW:
        if (value == null) {
          unsetRow();
        } else {
          if (value instanceof byte[]) {
            setRow((byte[])value);
          } else {
            setRow((java.nio.ByteBuffer)value);
          }
        }
        break;

      case FAMILY:
        if (value == null) {
          unsetFamily();
        } else {
          if (value instanceof byte[]) {
            setFamily((byte[])value);
          } else {
            setFamily((java.nio.ByteBuffer)value);
          }
        }
        break;

      case QUALIFIER:
        if (value == null) {
          unsetQualifier();
        } else {
          if (value instanceof byte[]) {
            setQualifier((byte[])value);
          } else {
            setQualifier((java.nio.ByteBuffer)value);
          }
        }
        break;

      case VALUE:
        if (value == null) {
          unsetValue();
        } else {
          if (value instanceof byte[]) {
            setValue((byte[])value);
          } else {
            setValue((java.nio.ByteBuffer)value);
          }
        }
        break;

      case TPUT:
        if (value == null) {
          unsetTput();
        } else {
          setTput((TPut)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE:
        return getTable();

      case ROW:
        return getRow();

      case FAMILY:
        return getFamily();

      case QUALIFIER:
        return getQualifier();

      case VALUE:
        return getValue();

      case TPUT:
        return getTput();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE:
        return isSetTable();
      case ROW:
        return isSetRow();
      case FAMILY:
        return isSetFamily();
      case QUALIFIER:
        return isSetQualifier();
      case VALUE:
        return isSetValue();
      case TPUT:
        return isSetTput();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof checkAndPut_args)
        return this.equals((checkAndPut_args)that);
      return false;
    }

    public boolean equals(checkAndPut_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_table = true && this.isSetTable();
      boolean that_present_table = true && that.isSetTable();
      if (this_present_table || that_present_table) {
        if (!(this_present_table && that_present_table))
          return false;
        if (!this.table.equals(that.table))
          return false;
      }

      boolean this_present_row = true && this.isSetRow();
      boolean that_present_row = true && that.isSetRow();
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!this.row.equals(that.row))
          return false;
      }

      boolean this_present_family = true && this.isSetFamily();
      boolean that_present_family = true && that.isSetFamily();
      if (this_present_family || that_present_family) {
        if (!(this_present_family && that_present_family))
          return false;
        if (!this.family.equals(that.family))
          return false;
      }

      boolean this_present_qualifier = true && this.isSetQualifier();
      boolean that_present_qualifier = true && that.isSetQualifier();
      if (this_present_qualifier || that_present_qualifier) {
        if (!(this_present_qualifier && that_present_qualifier))
          return false;
        if (!this.qualifier.equals(that.qualifier))
          return false;
      }

      boolean this_present_value = true && this.isSetValue();
      boolean that_present_value = true && that.isSetValue();
      if (this_present_value || that_present_value) {
        if (!(this_present_value && that_present_value))
          return false;
        if (!this.value.equals(that.value))
          return false;
      }

      boolean this_present_tput = true && this.isSetTput();
      boolean that_present_tput = true && that.isSetTput();
      if (this_present_tput || that_present_tput) {
        if (!(this_present_tput && that_present_tput))
          return false;
        if (!this.tput.equals(that.tput))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTable()) ? 131071 : 524287);
      if (isSetTable())
        hashCode = hashCode * 8191 + table.hashCode();

      hashCode = hashCode * 8191 + ((isSetRow()) ? 131071 : 524287);
      if (isSetRow())
        hashCode = hashCode * 8191 + row.hashCode();

      hashCode = hashCode * 8191 + ((isSetFamily()) ? 131071 : 524287);
      if (isSetFamily())
        hashCode = hashCode * 8191 + family.hashCode();

      hashCode = hashCode * 8191 + ((isSetQualifier()) ? 131071 : 524287);
      if (isSetQualifier())
        hashCode = hashCode * 8191 + qualifier.hashCode();

      hashCode = hashCode * 8191 + ((isSetValue()) ? 131071 : 524287);
      if (isSetValue())
        hashCode = hashCode * 8191 + value.hashCode();

      hashCode = hashCode * 8191 + ((isSetTput()) ? 131071 : 524287);
      if (isSetTput())
        hashCode = hashCode * 8191 + tput.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(checkAndPut_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTable(), other.isSetTable());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTable()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.table, other.table);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetRow(), other.isSetRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.row, other.row);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetFamily(), other.isSetFamily());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFamily()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.family, other.family);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetQualifier(), other.isSetQualifier());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetQualifier()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.qualifier, other.qualifier);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetValue(), other.isSetValue());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetValue()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.value, other.value);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTput(), other.isSetTput());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTput()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tput, other.tput);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("checkAndPut_args(");
      boolean first = true;

      sb.append("table:");
      if (this.table == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.table, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("row:");
      if (this.row == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.row, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("family:");
      if (this.family == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.family, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("qualifier:");
      if (this.qualifier == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.qualifier, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("value:");
      if (this.value == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.value, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tput:");
      if (this.tput == null) {
        sb.append("null");
      } else {
        sb.append(this.tput);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (table == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'table' was not present! Struct: " + toString());
      }
      if (row == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'row' was not present! Struct: " + toString());
      }
      if (family == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'family' was not present! Struct: " + toString());
      }
      if (qualifier == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'qualifier' was not present! Struct: " + toString());
      }
      if (tput == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'tput' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
      if (tput != null) {
        tput.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class checkAndPut_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public checkAndPut_argsStandardScheme getScheme() {
        return new checkAndPut_argsStandardScheme();
      }
    }

    private static class checkAndPut_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<checkAndPut_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, checkAndPut_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.table = iprot.readBinary();
                struct.setTableIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // FAMILY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.family = iprot.readBinary();
                struct.setFamilyIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // QUALIFIER
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.qualifier = iprot.readBinary();
                struct.setQualifierIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // VALUE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.value = iprot.readBinary();
                struct.setValueIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // TPUT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tput = new TPut();
                struct.tput.read(iprot);
                struct.setTputIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, checkAndPut_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.table != null) {
          oprot.writeFieldBegin(TABLE_FIELD_DESC);
          oprot.writeBinary(struct.table);
          oprot.writeFieldEnd();
        }
        if (struct.row != null) {
          oprot.writeFieldBegin(ROW_FIELD_DESC);
          oprot.writeBinary(struct.row);
          oprot.writeFieldEnd();
        }
        if (struct.family != null) {
          oprot.writeFieldBegin(FAMILY_FIELD_DESC);
          oprot.writeBinary(struct.family);
          oprot.writeFieldEnd();
        }
        if (struct.qualifier != null) {
          oprot.writeFieldBegin(QUALIFIER_FIELD_DESC);
          oprot.writeBinary(struct.qualifier);
          oprot.writeFieldEnd();
        }
        if (struct.value != null) {
          oprot.writeFieldBegin(VALUE_FIELD_DESC);
          oprot.writeBinary(struct.value);
          oprot.writeFieldEnd();
        }
        if (struct.tput != null) {
          oprot.writeFieldBegin(TPUT_FIELD_DESC);
          struct.tput.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class checkAndPut_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public checkAndPut_argsTupleScheme getScheme() {
        return new checkAndPut_argsTupleScheme();
      }
    }

    private static class checkAndPut_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<checkAndPut_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, checkAndPut_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        oprot.writeBinary(struct.table);
        oprot.writeBinary(struct.row);
        oprot.writeBinary(struct.family);
        oprot.writeBinary(struct.qualifier);
        struct.tput.write(oprot);
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetValue()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetValue()) {
          oprot.writeBinary(struct.value);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, checkAndPut_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        struct.table = iprot.readBinary();
        struct.setTableIsSet(true);
        struct.row = iprot.readBinary();
        struct.setRowIsSet(true);
        struct.family = iprot.readBinary();
        struct.setFamilyIsSet(true);
        struct.qualifier = iprot.readBinary();
        struct.setQualifierIsSet(true);
        struct.tput = new TPut();
        struct.tput.read(iprot);
        struct.setTputIsSet(true);
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.value = iprot.readBinary();
          struct.setValueIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class checkAndPut_result implements org.apache.thrift.TBase<checkAndPut_result, checkAndPut_result._Fields>, java.io.Serializable, Cloneable, Comparable<checkAndPut_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("checkAndPut_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new checkAndPut_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new checkAndPut_resultTupleSchemeFactory();

    public boolean success; // required
    public @org.apache.thrift.annotation.Nullable TIOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(checkAndPut_result.class, metaDataMap);
    }

    public checkAndPut_result() {
    }

    public checkAndPut_result(
      boolean success,
      TIOError io)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public checkAndPut_result(checkAndPut_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetIo()) {
        this.io = new TIOError(other.io);
      }
    }

    public checkAndPut_result deepCopy() {
      return new checkAndPut_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.io = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public checkAndPut_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    @org.apache.thrift.annotation.Nullable
    public TIOError getIo() {
      return this.io;
    }

    public checkAndPut_result setIo(@org.apache.thrift.annotation.Nullable TIOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.lang.Boolean)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((TIOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof checkAndPut_result)
        return this.equals((checkAndPut_result)that);
      return false;
    }

    public boolean equals(checkAndPut_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((success) ? 131071 : 524287);

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(checkAndPut_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetIo(), other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("checkAndPut_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class checkAndPut_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public checkAndPut_resultStandardScheme getScheme() {
        return new checkAndPut_resultStandardScheme();
      }
    }

    private static class checkAndPut_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<checkAndPut_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, checkAndPut_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new TIOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, checkAndPut_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class checkAndPut_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public checkAndPut_resultTupleScheme getScheme() {
        return new checkAndPut_resultTupleScheme();
      }
    }

    private static class checkAndPut_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<checkAndPut_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, checkAndPut_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, checkAndPut_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new TIOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class putMultiple_args implements org.apache.thrift.TBase<putMultiple_args, putMultiple_args._Fields>, java.io.Serializable, Cloneable, Comparable<putMultiple_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("putMultiple_args");

    private static final org.apache.thrift.protocol.TField TABLE_FIELD_DESC = new org.apache.thrift.protocol.TField("table", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TPUTS_FIELD_DESC = new org.apache.thrift.protocol.TField("tputs", org.apache.thrift.protocol.TType.LIST, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new putMultiple_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new putMultiple_argsTupleSchemeFactory();

    /**
     * the table to put data in
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table; // required
    /**
     * a list of TPuts to commit
     */
    public @org.apache.thrift.annotation.Nullable java.util.List<TPut> tputs; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * the table to put data in
       */
      TABLE((short)1, "table"),
      /**
       * a list of TPuts to commit
       */
      TPUTS((short)2, "tputs");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE
            return TABLE;
          case 2: // TPUTS
            return TPUTS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE, new org.apache.thrift.meta_data.FieldMetaData("table", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TPUTS, new org.apache.thrift.meta_data.FieldMetaData("tputs", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TPut.class))));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(putMultiple_args.class, metaDataMap);
    }

    public putMultiple_args() {
    }

    public putMultiple_args(
      java.nio.ByteBuffer table,
      java.util.List<TPut> tputs)
    {
      this();
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      this.tputs = tputs;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public putMultiple_args(putMultiple_args other) {
      if (other.isSetTable()) {
        this.table = org.apache.thrift.TBaseHelper.copyBinary(other.table);
      }
      if (other.isSetTputs()) {
        java.util.List<TPut> __this__tputs = new java.util.ArrayList<TPut>(other.tputs.size());
        for (TPut other_element : other.tputs) {
          __this__tputs.add(new TPut(other_element));
        }
        this.tputs = __this__tputs;
      }
    }

    public putMultiple_args deepCopy() {
      return new putMultiple_args(this);
    }

    @Override
    public void clear() {
      this.table = null;
      this.tputs = null;
    }

    /**
     * the table to put data in
     */
    public byte[] getTable() {
      setTable(org.apache.thrift.TBaseHelper.rightSize(table));
      return table == null ? null : table.array();
    }

    public java.nio.ByteBuffer bufferForTable() {
      return org.apache.thrift.TBaseHelper.copyBinary(table);
    }

    /**
     * the table to put data in
     */
    public putMultiple_args setTable(byte[] table) {
      this.table = table == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(table.clone());
      return this;
    }

    public putMultiple_args setTable(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table) {
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      return this;
    }

    public void unsetTable() {
      this.table = null;
    }

    /** Returns true if field table is set (has been assigned a value) and false otherwise */
    public boolean isSetTable() {
      return this.table != null;
    }

    public void setTableIsSet(boolean value) {
      if (!value) {
        this.table = null;
      }
    }

    public int getTputsSize() {
      return (this.tputs == null) ? 0 : this.tputs.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<TPut> getTputsIterator() {
      return (this.tputs == null) ? null : this.tputs.iterator();
    }

    public void addToTputs(TPut elem) {
      if (this.tputs == null) {
        this.tputs = new java.util.ArrayList<TPut>();
      }
      this.tputs.add(elem);
    }

    /**
     * a list of TPuts to commit
     */
    @org.apache.thrift.annotation.Nullable
    public java.util.List<TPut> getTputs() {
      return this.tputs;
    }

    /**
     * a list of TPuts to commit
     */
    public putMultiple_args setTputs(@org.apache.thrift.annotation.Nullable java.util.List<TPut> tputs) {
      this.tputs = tputs;
      return this;
    }

    public void unsetTputs() {
      this.tputs = null;
    }

    /** Returns true if field tputs is set (has been assigned a value) and false otherwise */
    public boolean isSetTputs() {
      return this.tputs != null;
    }

    public void setTputsIsSet(boolean value) {
      if (!value) {
        this.tputs = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE:
        if (value == null) {
          unsetTable();
        } else {
          if (value instanceof byte[]) {
            setTable((byte[])value);
          } else {
            setTable((java.nio.ByteBuffer)value);
          }
        }
        break;

      case TPUTS:
        if (value == null) {
          unsetTputs();
        } else {
          setTputs((java.util.List<TPut>)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE:
        return getTable();

      case TPUTS:
        return getTputs();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE:
        return isSetTable();
      case TPUTS:
        return isSetTputs();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof putMultiple_args)
        return this.equals((putMultiple_args)that);
      return false;
    }

    public boolean equals(putMultiple_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_table = true && this.isSetTable();
      boolean that_present_table = true && that.isSetTable();
      if (this_present_table || that_present_table) {
        if (!(this_present_table && that_present_table))
          return false;
        if (!this.table.equals(that.table))
          return false;
      }

      boolean this_present_tputs = true && this.isSetTputs();
      boolean that_present_tputs = true && that.isSetTputs();
      if (this_present_tputs || that_present_tputs) {
        if (!(this_present_tputs && that_present_tputs))
          return false;
        if (!this.tputs.equals(that.tputs))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTable()) ? 131071 : 524287);
      if (isSetTable())
        hashCode = hashCode * 8191 + table.hashCode();

      hashCode = hashCode * 8191 + ((isSetTputs()) ? 131071 : 524287);
      if (isSetTputs())
        hashCode = hashCode * 8191 + tputs.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(putMultiple_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTable(), other.isSetTable());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTable()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.table, other.table);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTputs(), other.isSetTputs());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTputs()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tputs, other.tputs);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("putMultiple_args(");
      boolean first = true;

      sb.append("table:");
      if (this.table == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.table, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tputs:");
      if (this.tputs == null) {
        sb.append("null");
      } else {
        sb.append(this.tputs);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (table == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'table' was not present! Struct: " + toString());
      }
      if (tputs == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'tputs' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class putMultiple_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public putMultiple_argsStandardScheme getScheme() {
        return new putMultiple_argsStandardScheme();
      }
    }

    private static class putMultiple_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<putMultiple_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, putMultiple_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.table = iprot.readBinary();
                struct.setTableIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TPUTS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list222 = iprot.readListBegin();
                  struct.tputs = new java.util.ArrayList<TPut>(_list222.size);
                  @org.apache.thrift.annotation.Nullable TPut _elem223;
                  for (int _i224 = 0; _i224 < _list222.size; ++_i224)
                  {
                    _elem223 = new TPut();
                    _elem223.read(iprot);
                    struct.tputs.add(_elem223);
                  }
                  iprot.readListEnd();
                }
                struct.setTputsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, putMultiple_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.table != null) {
          oprot.writeFieldBegin(TABLE_FIELD_DESC);
          oprot.writeBinary(struct.table);
          oprot.writeFieldEnd();
        }
        if (struct.tputs != null) {
          oprot.writeFieldBegin(TPUTS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.tputs.size()));
            for (TPut _iter225 : struct.tputs)
            {
              _iter225.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class putMultiple_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public putMultiple_argsTupleScheme getScheme() {
        return new putMultiple_argsTupleScheme();
      }
    }

    private static class putMultiple_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<putMultiple_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, putMultiple_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        oprot.writeBinary(struct.table);
        {
          oprot.writeI32(struct.tputs.size());
          for (TPut _iter226 : struct.tputs)
          {
            _iter226.write(oprot);
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, putMultiple_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        struct.table = iprot.readBinary();
        struct.setTableIsSet(true);
        {
          org.apache.thrift.protocol.TList _list227 = iprot.readListBegin(org.apache.thrift.protocol.TType.STRUCT);
          struct.tputs = new java.util.ArrayList<TPut>(_list227.size);
          @org.apache.thrift.annotation.Nullable TPut _elem228;
          for (int _i229 = 0; _i229 < _list227.size; ++_i229)
          {
            _elem228 = new TPut();
            _elem228.read(iprot);
            struct.tputs.add(_elem228);
          }
        }
        struct.setTputsIsSet(true);
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class putMultiple_result implements org.apache.thrift.TBase<putMultiple_result, putMultiple_result._Fields>, java.io.Serializable, Cloneable, Comparable<putMultiple_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("putMultiple_result");

    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new putMultiple_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new putMultiple_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable TIOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(putMultiple_result.class, metaDataMap);
    }

    public putMultiple_result() {
    }

    public putMultiple_result(
      TIOError io)
    {
      this();
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public putMultiple_result(putMultiple_result other) {
      if (other.isSetIo()) {
        this.io = new TIOError(other.io);
      }
    }

    public putMultiple_result deepCopy() {
      return new putMultiple_result(this);
    }

    @Override
    public void clear() {
      this.io = null;
    }

    @org.apache.thrift.annotation.Nullable
    public TIOError getIo() {
      return this.io;
    }

    public putMultiple_result setIo(@org.apache.thrift.annotation.Nullable TIOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((TIOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof putMultiple_result)
        return this.equals((putMultiple_result)that);
      return false;
    }

    public boolean equals(putMultiple_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(putMultiple_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetIo(), other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("putMultiple_result(");
      boolean first = true;

      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class putMultiple_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public putMultiple_resultStandardScheme getScheme() {
        return new putMultiple_resultStandardScheme();
      }
    }

    private static class putMultiple_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<putMultiple_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, putMultiple_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new TIOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, putMultiple_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class putMultiple_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public putMultiple_resultTupleScheme getScheme() {
        return new putMultiple_resultTupleScheme();
      }
    }

    private static class putMultiple_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<putMultiple_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, putMultiple_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetIo()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, putMultiple_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.io = new TIOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class deleteSingle_args implements org.apache.thrift.TBase<deleteSingle_args, deleteSingle_args._Fields>, java.io.Serializable, Cloneable, Comparable<deleteSingle_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deleteSingle_args");

    private static final org.apache.thrift.protocol.TField TABLE_FIELD_DESC = new org.apache.thrift.protocol.TField("table", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TDELETE_FIELD_DESC = new org.apache.thrift.protocol.TField("tdelete", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new deleteSingle_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new deleteSingle_argsTupleSchemeFactory();

    /**
     * the table to delete from
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table; // required
    /**
     * the TDelete to delete
     */
    public @org.apache.thrift.annotation.Nullable TDelete tdelete; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * the table to delete from
       */
      TABLE((short)1, "table"),
      /**
       * the TDelete to delete
       */
      TDELETE((short)2, "tdelete");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE
            return TABLE;
          case 2: // TDELETE
            return TDELETE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE, new org.apache.thrift.meta_data.FieldMetaData("table", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TDELETE, new org.apache.thrift.meta_data.FieldMetaData("tdelete", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TDelete.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deleteSingle_args.class, metaDataMap);
    }

    public deleteSingle_args() {
    }

    public deleteSingle_args(
      java.nio.ByteBuffer table,
      TDelete tdelete)
    {
      this();
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      this.tdelete = tdelete;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deleteSingle_args(deleteSingle_args other) {
      if (other.isSetTable()) {
        this.table = org.apache.thrift.TBaseHelper.copyBinary(other.table);
      }
      if (other.isSetTdelete()) {
        this.tdelete = new TDelete(other.tdelete);
      }
    }

    public deleteSingle_args deepCopy() {
      return new deleteSingle_args(this);
    }

    @Override
    public void clear() {
      this.table = null;
      this.tdelete = null;
    }

    /**
     * the table to delete from
     */
    public byte[] getTable() {
      setTable(org.apache.thrift.TBaseHelper.rightSize(table));
      return table == null ? null : table.array();
    }

    public java.nio.ByteBuffer bufferForTable() {
      return org.apache.thrift.TBaseHelper.copyBinary(table);
    }

    /**
     * the table to delete from
     */
    public deleteSingle_args setTable(byte[] table) {
      this.table = table == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(table.clone());
      return this;
    }

    public deleteSingle_args setTable(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table) {
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      return this;
    }

    public void unsetTable() {
      this.table = null;
    }

    /** Returns true if field table is set (has been assigned a value) and false otherwise */
    public boolean isSetTable() {
      return this.table != null;
    }

    public void setTableIsSet(boolean value) {
      if (!value) {
        this.table = null;
      }
    }

    /**
     * the TDelete to delete
     */
    @org.apache.thrift.annotation.Nullable
    public TDelete getTdelete() {
      return this.tdelete;
    }

    /**
     * the TDelete to delete
     */
    public deleteSingle_args setTdelete(@org.apache.thrift.annotation.Nullable TDelete tdelete) {
      this.tdelete = tdelete;
      return this;
    }

    public void unsetTdelete() {
      this.tdelete = null;
    }

    /** Returns true if field tdelete is set (has been assigned a value) and false otherwise */
    public boolean isSetTdelete() {
      return this.tdelete != null;
    }

    public void setTdeleteIsSet(boolean value) {
      if (!value) {
        this.tdelete = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE:
        if (value == null) {
          unsetTable();
        } else {
          if (value instanceof byte[]) {
            setTable((byte[])value);
          } else {
            setTable((java.nio.ByteBuffer)value);
          }
        }
        break;

      case TDELETE:
        if (value == null) {
          unsetTdelete();
        } else {
          setTdelete((TDelete)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE:
        return getTable();

      case TDELETE:
        return getTdelete();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE:
        return isSetTable();
      case TDELETE:
        return isSetTdelete();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof deleteSingle_args)
        return this.equals((deleteSingle_args)that);
      return false;
    }

    public boolean equals(deleteSingle_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_table = true && this.isSetTable();
      boolean that_present_table = true && that.isSetTable();
      if (this_present_table || that_present_table) {
        if (!(this_present_table && that_present_table))
          return false;
        if (!this.table.equals(that.table))
          return false;
      }

      boolean this_present_tdelete = true && this.isSetTdelete();
      boolean that_present_tdelete = true && that.isSetTdelete();
      if (this_present_tdelete || that_present_tdelete) {
        if (!(this_present_tdelete && that_present_tdelete))
          return false;
        if (!this.tdelete.equals(that.tdelete))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTable()) ? 131071 : 524287);
      if (isSetTable())
        hashCode = hashCode * 8191 + table.hashCode();

      hashCode = hashCode * 8191 + ((isSetTdelete()) ? 131071 : 524287);
      if (isSetTdelete())
        hashCode = hashCode * 8191 + tdelete.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(deleteSingle_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTable(), other.isSetTable());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTable()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.table, other.table);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTdelete(), other.isSetTdelete());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTdelete()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tdelete, other.tdelete);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("deleteSingle_args(");
      boolean first = true;

      sb.append("table:");
      if (this.table == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.table, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tdelete:");
      if (this.tdelete == null) {
        sb.append("null");
      } else {
        sb.append(this.tdelete);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (table == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'table' was not present! Struct: " + toString());
      }
      if (tdelete == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'tdelete' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
      if (tdelete != null) {
        tdelete.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deleteSingle_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public deleteSingle_argsStandardScheme getScheme() {
        return new deleteSingle_argsStandardScheme();
      }
    }

    private static class deleteSingle_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<deleteSingle_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deleteSingle_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.table = iprot.readBinary();
                struct.setTableIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TDELETE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tdelete = new TDelete();
                struct.tdelete.read(iprot);
                struct.setTdeleteIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deleteSingle_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.table != null) {
          oprot.writeFieldBegin(TABLE_FIELD_DESC);
          oprot.writeBinary(struct.table);
          oprot.writeFieldEnd();
        }
        if (struct.tdelete != null) {
          oprot.writeFieldBegin(TDELETE_FIELD_DESC);
          struct.tdelete.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deleteSingle_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public deleteSingle_argsTupleScheme getScheme() {
        return new deleteSingle_argsTupleScheme();
      }
    }

    private static class deleteSingle_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<deleteSingle_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deleteSingle_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        oprot.writeBinary(struct.table);
        struct.tdelete.write(oprot);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deleteSingle_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        struct.table = iprot.readBinary();
        struct.setTableIsSet(true);
        struct.tdelete = new TDelete();
        struct.tdelete.read(iprot);
        struct.setTdeleteIsSet(true);
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class deleteSingle_result implements org.apache.thrift.TBase<deleteSingle_result, deleteSingle_result._Fields>, java.io.Serializable, Cloneable, Comparable<deleteSingle_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deleteSingle_result");

    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new deleteSingle_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new deleteSingle_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable TIOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deleteSingle_result.class, metaDataMap);
    }

    public deleteSingle_result() {
    }

    public deleteSingle_result(
      TIOError io)
    {
      this();
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deleteSingle_result(deleteSingle_result other) {
      if (other.isSetIo()) {
        this.io = new TIOError(other.io);
      }
    }

    public deleteSingle_result deepCopy() {
      return new deleteSingle_result(this);
    }

    @Override
    public void clear() {
      this.io = null;
    }

    @org.apache.thrift.annotation.Nullable
    public TIOError getIo() {
      return this.io;
    }

    public deleteSingle_result setIo(@org.apache.thrift.annotation.Nullable TIOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((TIOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof deleteSingle_result)
        return this.equals((deleteSingle_result)that);
      return false;
    }

    public boolean equals(deleteSingle_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(deleteSingle_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetIo(), other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("deleteSingle_result(");
      boolean first = true;

      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deleteSingle_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public deleteSingle_resultStandardScheme getScheme() {
        return new deleteSingle_resultStandardScheme();
      }
    }

    private static class deleteSingle_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<deleteSingle_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deleteSingle_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new TIOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deleteSingle_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deleteSingle_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public deleteSingle_resultTupleScheme getScheme() {
        return new deleteSingle_resultTupleScheme();
      }
    }

    private static class deleteSingle_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<deleteSingle_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deleteSingle_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetIo()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deleteSingle_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.io = new TIOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class deleteMultiple_args implements org.apache.thrift.TBase<deleteMultiple_args, deleteMultiple_args._Fields>, java.io.Serializable, Cloneable, Comparable<deleteMultiple_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deleteMultiple_args");

    private static final org.apache.thrift.protocol.TField TABLE_FIELD_DESC = new org.apache.thrift.protocol.TField("table", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TDELETES_FIELD_DESC = new org.apache.thrift.protocol.TField("tdeletes", org.apache.thrift.protocol.TType.LIST, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new deleteMultiple_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new deleteMultiple_argsTupleSchemeFactory();

    /**
     * the table to delete from
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table; // required
    /**
     * list of TDeletes to delete
     */
    public @org.apache.thrift.annotation.Nullable java.util.List<TDelete> tdeletes; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * the table to delete from
       */
      TABLE((short)1, "table"),
      /**
       * list of TDeletes to delete
       */
      TDELETES((short)2, "tdeletes");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE
            return TABLE;
          case 2: // TDELETES
            return TDELETES;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE, new org.apache.thrift.meta_data.FieldMetaData("table", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TDELETES, new org.apache.thrift.meta_data.FieldMetaData("tdeletes", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TDelete.class))));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deleteMultiple_args.class, metaDataMap);
    }

    public deleteMultiple_args() {
    }

    public deleteMultiple_args(
      java.nio.ByteBuffer table,
      java.util.List<TDelete> tdeletes)
    {
      this();
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      this.tdeletes = tdeletes;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deleteMultiple_args(deleteMultiple_args other) {
      if (other.isSetTable()) {
        this.table = org.apache.thrift.TBaseHelper.copyBinary(other.table);
      }
      if (other.isSetTdeletes()) {
        java.util.List<TDelete> __this__tdeletes = new java.util.ArrayList<TDelete>(other.tdeletes.size());
        for (TDelete other_element : other.tdeletes) {
          __this__tdeletes.add(new TDelete(other_element));
        }
        this.tdeletes = __this__tdeletes;
      }
    }

    public deleteMultiple_args deepCopy() {
      return new deleteMultiple_args(this);
    }

    @Override
    public void clear() {
      this.table = null;
      this.tdeletes = null;
    }

    /**
     * the table to delete from
     */
    public byte[] getTable() {
      setTable(org.apache.thrift.TBaseHelper.rightSize(table));
      return table == null ? null : table.array();
    }

    public java.nio.ByteBuffer bufferForTable() {
      return org.apache.thrift.TBaseHelper.copyBinary(table);
    }

    /**
     * the table to delete from
     */
    public deleteMultiple_args setTable(byte[] table) {
      this.table = table == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(table.clone());
      return this;
    }

    public deleteMultiple_args setTable(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table) {
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      return this;
    }

    public void unsetTable() {
      this.table = null;
    }

    /** Returns true if field table is set (has been assigned a value) and false otherwise */
    public boolean isSetTable() {
      return this.table != null;
    }

    public void setTableIsSet(boolean value) {
      if (!value) {
        this.table = null;
      }
    }

    public int getTdeletesSize() {
      return (this.tdeletes == null) ? 0 : this.tdeletes.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<TDelete> getTdeletesIterator() {
      return (this.tdeletes == null) ? null : this.tdeletes.iterator();
    }

    public void addToTdeletes(TDelete elem) {
      if (this.tdeletes == null) {
        this.tdeletes = new java.util.ArrayList<TDelete>();
      }
      this.tdeletes.add(elem);
    }

    /**
     * list of TDeletes to delete
     */
    @org.apache.thrift.annotation.Nullable
    public java.util.List<TDelete> getTdeletes() {
      return this.tdeletes;
    }

    /**
     * list of TDeletes to delete
     */
    public deleteMultiple_args setTdeletes(@org.apache.thrift.annotation.Nullable java.util.List<TDelete> tdeletes) {
      this.tdeletes = tdeletes;
      return this;
    }

    public void unsetTdeletes() {
      this.tdeletes = null;
    }

    /** Returns true if field tdeletes is set (has been assigned a value) and false otherwise */
    public boolean isSetTdeletes() {
      return this.tdeletes != null;
    }

    public void setTdeletesIsSet(boolean value) {
      if (!value) {
        this.tdeletes = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE:
        if (value == null) {
          unsetTable();
        } else {
          if (value instanceof byte[]) {
            setTable((byte[])value);
          } else {
            setTable((java.nio.ByteBuffer)value);
          }
        }
        break;

      case TDELETES:
        if (value == null) {
          unsetTdeletes();
        } else {
          setTdeletes((java.util.List<TDelete>)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE:
        return getTable();

      case TDELETES:
        return getTdeletes();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE:
        return isSetTable();
      case TDELETES:
        return isSetTdeletes();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof deleteMultiple_args)
        return this.equals((deleteMultiple_args)that);
      return false;
    }

    public boolean equals(deleteMultiple_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_table = true && this.isSetTable();
      boolean that_present_table = true && that.isSetTable();
      if (this_present_table || that_present_table) {
        if (!(this_present_table && that_present_table))
          return false;
        if (!this.table.equals(that.table))
          return false;
      }

      boolean this_present_tdeletes = true && this.isSetTdeletes();
      boolean that_present_tdeletes = true && that.isSetTdeletes();
      if (this_present_tdeletes || that_present_tdeletes) {
        if (!(this_present_tdeletes && that_present_tdeletes))
          return false;
        if (!this.tdeletes.equals(that.tdeletes))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTable()) ? 131071 : 524287);
      if (isSetTable())
        hashCode = hashCode * 8191 + table.hashCode();

      hashCode = hashCode * 8191 + ((isSetTdeletes()) ? 131071 : 524287);
      if (isSetTdeletes())
        hashCode = hashCode * 8191 + tdeletes.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(deleteMultiple_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTable(), other.isSetTable());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTable()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.table, other.table);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTdeletes(), other.isSetTdeletes());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTdeletes()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tdeletes, other.tdeletes);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("deleteMultiple_args(");
      boolean first = true;

      sb.append("table:");
      if (this.table == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.table, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tdeletes:");
      if (this.tdeletes == null) {
        sb.append("null");
      } else {
        sb.append(this.tdeletes);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (table == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'table' was not present! Struct: " + toString());
      }
      if (tdeletes == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'tdeletes' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deleteMultiple_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public deleteMultiple_argsStandardScheme getScheme() {
        return new deleteMultiple_argsStandardScheme();
      }
    }

    private static class deleteMultiple_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<deleteMultiple_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deleteMultiple_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.table = iprot.readBinary();
                struct.setTableIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TDELETES
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list230 = iprot.readListBegin();
                  struct.tdeletes = new java.util.ArrayList<TDelete>(_list230.size);
                  @org.apache.thrift.annotation.Nullable TDelete _elem231;
                  for (int _i232 = 0; _i232 < _list230.size; ++_i232)
                  {
                    _elem231 = new TDelete();
                    _elem231.read(iprot);
                    struct.tdeletes.add(_elem231);
                  }
                  iprot.readListEnd();
                }
                struct.setTdeletesIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deleteMultiple_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.table != null) {
          oprot.writeFieldBegin(TABLE_FIELD_DESC);
          oprot.writeBinary(struct.table);
          oprot.writeFieldEnd();
        }
        if (struct.tdeletes != null) {
          oprot.writeFieldBegin(TDELETES_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.tdeletes.size()));
            for (TDelete _iter233 : struct.tdeletes)
            {
              _iter233.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deleteMultiple_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public deleteMultiple_argsTupleScheme getScheme() {
        return new deleteMultiple_argsTupleScheme();
      }
    }

    private static class deleteMultiple_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<deleteMultiple_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deleteMultiple_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        oprot.writeBinary(struct.table);
        {
          oprot.writeI32(struct.tdeletes.size());
          for (TDelete _iter234 : struct.tdeletes)
          {
            _iter234.write(oprot);
          }
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deleteMultiple_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        struct.table = iprot.readBinary();
        struct.setTableIsSet(true);
        {
          org.apache.thrift.protocol.TList _list235 = iprot.readListBegin(org.apache.thrift.protocol.TType.STRUCT);
          struct.tdeletes = new java.util.ArrayList<TDelete>(_list235.size);
          @org.apache.thrift.annotation.Nullable TDelete _elem236;
          for (int _i237 = 0; _i237 < _list235.size; ++_i237)
          {
            _elem236 = new TDelete();
            _elem236.read(iprot);
            struct.tdeletes.add(_elem236);
          }
        }
        struct.setTdeletesIsSet(true);
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class deleteMultiple_result implements org.apache.thrift.TBase<deleteMultiple_result, deleteMultiple_result._Fields>, java.io.Serializable, Cloneable, Comparable<deleteMultiple_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("deleteMultiple_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new deleteMultiple_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new deleteMultiple_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.util.List<TDelete> success; // required
    public @org.apache.thrift.annotation.Nullable TIOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TDelete.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(deleteMultiple_result.class, metaDataMap);
    }

    public deleteMultiple_result() {
    }

    public deleteMultiple_result(
      java.util.List<TDelete> success,
      TIOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public deleteMultiple_result(deleteMultiple_result other) {
      if (other.isSetSuccess()) {
        java.util.List<TDelete> __this__success = new java.util.ArrayList<TDelete>(other.success.size());
        for (TDelete other_element : other.success) {
          __this__success.add(new TDelete(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new TIOError(other.io);
      }
    }

    public deleteMultiple_result deepCopy() {
      return new deleteMultiple_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<TDelete> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TDelete elem) {
      if (this.success == null) {
        this.success = new java.util.ArrayList<TDelete>();
      }
      this.success.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<TDelete> getSuccess() {
      return this.success;
    }

    public deleteMultiple_result setSuccess(@org.apache.thrift.annotation.Nullable java.util.List<TDelete> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public TIOError getIo() {
      return this.io;
    }

    public deleteMultiple_result setIo(@org.apache.thrift.annotation.Nullable TIOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.util.List<TDelete>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((TIOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof deleteMultiple_result)
        return this.equals((deleteMultiple_result)that);
      return false;
    }

    public boolean equals(deleteMultiple_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(deleteMultiple_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetIo(), other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("deleteMultiple_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class deleteMultiple_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public deleteMultiple_resultStandardScheme getScheme() {
        return new deleteMultiple_resultStandardScheme();
      }
    }

    private static class deleteMultiple_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<deleteMultiple_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, deleteMultiple_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list238 = iprot.readListBegin();
                  struct.success = new java.util.ArrayList<TDelete>(_list238.size);
                  @org.apache.thrift.annotation.Nullable TDelete _elem239;
                  for (int _i240 = 0; _i240 < _list238.size; ++_i240)
                  {
                    _elem239 = new TDelete();
                    _elem239.read(iprot);
                    struct.success.add(_elem239);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new TIOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, deleteMultiple_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TDelete _iter241 : struct.success)
            {
              _iter241.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class deleteMultiple_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public deleteMultiple_resultTupleScheme getScheme() {
        return new deleteMultiple_resultTupleScheme();
      }
    }

    private static class deleteMultiple_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<deleteMultiple_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, deleteMultiple_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TDelete _iter242 : struct.success)
            {
              _iter242.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, deleteMultiple_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list243 = iprot.readListBegin(org.apache.thrift.protocol.TType.STRUCT);
            struct.success = new java.util.ArrayList<TDelete>(_list243.size);
            @org.apache.thrift.annotation.Nullable TDelete _elem244;
            for (int _i245 = 0; _i245 < _list243.size; ++_i245)
            {
              _elem244 = new TDelete();
              _elem244.read(iprot);
              struct.success.add(_elem244);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new TIOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class checkAndDelete_args implements org.apache.thrift.TBase<checkAndDelete_args, checkAndDelete_args._Fields>, java.io.Serializable, Cloneable, Comparable<checkAndDelete_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("checkAndDelete_args");

    private static final org.apache.thrift.protocol.TField TABLE_FIELD_DESC = new org.apache.thrift.protocol.TField("table", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField FAMILY_FIELD_DESC = new org.apache.thrift.protocol.TField("family", org.apache.thrift.protocol.TType.STRING, (short)3);
    private static final org.apache.thrift.protocol.TField QUALIFIER_FIELD_DESC = new org.apache.thrift.protocol.TField("qualifier", org.apache.thrift.protocol.TType.STRING, (short)4);
    private static final org.apache.thrift.protocol.TField VALUE_FIELD_DESC = new org.apache.thrift.protocol.TField("value", org.apache.thrift.protocol.TType.STRING, (short)5);
    private static final org.apache.thrift.protocol.TField TDELETE_FIELD_DESC = new org.apache.thrift.protocol.TField("tdelete", org.apache.thrift.protocol.TType.STRUCT, (short)6);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new checkAndDelete_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new checkAndDelete_argsTupleSchemeFactory();

    /**
     * to check in and delete from
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table; // required
    /**
     * row to check
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row; // required
    /**
     * column family to check
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer family; // required
    /**
     * column qualifier to check
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer qualifier; // required
    /**
     * the expected value, if not provided the
     * check is for the non-existence of the
     * column in question
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer value; // required
    /**
     * the TDelete to execute if the check succeeds
     */
    public @org.apache.thrift.annotation.Nullable TDelete tdelete; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * to check in and delete from
       */
      TABLE((short)1, "table"),
      /**
       * row to check
       */
      ROW((short)2, "row"),
      /**
       * column family to check
       */
      FAMILY((short)3, "family"),
      /**
       * column qualifier to check
       */
      QUALIFIER((short)4, "qualifier"),
      /**
       * the expected value, if not provided the
       * check is for the non-existence of the
       * column in question
       */
      VALUE((short)5, "value"),
      /**
       * the TDelete to execute if the check succeeds
       */
      TDELETE((short)6, "tdelete");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE
            return TABLE;
          case 2: // ROW
            return ROW;
          case 3: // FAMILY
            return FAMILY;
          case 4: // QUALIFIER
            return QUALIFIER;
          case 5: // VALUE
            return VALUE;
          case 6: // TDELETE
            return TDELETE;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE, new org.apache.thrift.meta_data.FieldMetaData("table", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.ROW, new org.apache.thrift.meta_data.FieldMetaData("row", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.FAMILY, new org.apache.thrift.meta_data.FieldMetaData("family", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.QUALIFIER, new org.apache.thrift.meta_data.FieldMetaData("qualifier", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.VALUE, new org.apache.thrift.meta_data.FieldMetaData("value", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TDELETE, new org.apache.thrift.meta_data.FieldMetaData("tdelete", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TDelete.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(checkAndDelete_args.class, metaDataMap);
    }

    public checkAndDelete_args() {
    }

    public checkAndDelete_args(
      java.nio.ByteBuffer table,
      java.nio.ByteBuffer row,
      java.nio.ByteBuffer family,
      java.nio.ByteBuffer qualifier,
      java.nio.ByteBuffer value,
      TDelete tdelete)
    {
      this();
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      this.family = org.apache.thrift.TBaseHelper.copyBinary(family);
      this.qualifier = org.apache.thrift.TBaseHelper.copyBinary(qualifier);
      this.value = org.apache.thrift.TBaseHelper.copyBinary(value);
      this.tdelete = tdelete;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public checkAndDelete_args(checkAndDelete_args other) {
      if (other.isSetTable()) {
        this.table = org.apache.thrift.TBaseHelper.copyBinary(other.table);
      }
      if (other.isSetRow()) {
        this.row = org.apache.thrift.TBaseHelper.copyBinary(other.row);
      }
      if (other.isSetFamily()) {
        this.family = org.apache.thrift.TBaseHelper.copyBinary(other.family);
      }
      if (other.isSetQualifier()) {
        this.qualifier = org.apache.thrift.TBaseHelper.copyBinary(other.qualifier);
      }
      if (other.isSetValue()) {
        this.value = org.apache.thrift.TBaseHelper.copyBinary(other.value);
      }
      if (other.isSetTdelete()) {
        this.tdelete = new TDelete(other.tdelete);
      }
    }

    public checkAndDelete_args deepCopy() {
      return new checkAndDelete_args(this);
    }

    @Override
    public void clear() {
      this.table = null;
      this.row = null;
      this.family = null;
      this.qualifier = null;
      this.value = null;
      this.tdelete = null;
    }

    /**
     * to check in and delete from
     */
    public byte[] getTable() {
      setTable(org.apache.thrift.TBaseHelper.rightSize(table));
      return table == null ? null : table.array();
    }

    public java.nio.ByteBuffer bufferForTable() {
      return org.apache.thrift.TBaseHelper.copyBinary(table);
    }

    /**
     * to check in and delete from
     */
    public checkAndDelete_args setTable(byte[] table) {
      this.table = table == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(table.clone());
      return this;
    }

    public checkAndDelete_args setTable(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table) {
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      return this;
    }

    public void unsetTable() {
      this.table = null;
    }

    /** Returns true if field table is set (has been assigned a value) and false otherwise */
    public boolean isSetTable() {
      return this.table != null;
    }

    public void setTableIsSet(boolean value) {
      if (!value) {
        this.table = null;
      }
    }

    /**
     * row to check
     */
    public byte[] getRow() {
      setRow(org.apache.thrift.TBaseHelper.rightSize(row));
      return row == null ? null : row.array();
    }

    public java.nio.ByteBuffer bufferForRow() {
      return org.apache.thrift.TBaseHelper.copyBinary(row);
    }

    /**
     * row to check
     */
    public checkAndDelete_args setRow(byte[] row) {
      this.row = row == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(row.clone());
      return this;
    }

    public checkAndDelete_args setRow(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row) {
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      return this;
    }

    public void unsetRow() {
      this.row = null;
    }

    /** Returns true if field row is set (has been assigned a value) and false otherwise */
    public boolean isSetRow() {
      return this.row != null;
    }

    public void setRowIsSet(boolean value) {
      if (!value) {
        this.row = null;
      }
    }

    /**
     * column family to check
     */
    public byte[] getFamily() {
      setFamily(org.apache.thrift.TBaseHelper.rightSize(family));
      return family == null ? null : family.array();
    }

    public java.nio.ByteBuffer bufferForFamily() {
      return org.apache.thrift.TBaseHelper.copyBinary(family);
    }

    /**
     * column family to check
     */
    public checkAndDelete_args setFamily(byte[] family) {
      this.family = family == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(family.clone());
      return this;
    }

    public checkAndDelete_args setFamily(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer family) {
      this.family = org.apache.thrift.TBaseHelper.copyBinary(family);
      return this;
    }

    public void unsetFamily() {
      this.family = null;
    }

    /** Returns true if field family is set (has been assigned a value) and false otherwise */
    public boolean isSetFamily() {
      return this.family != null;
    }

    public void setFamilyIsSet(boolean value) {
      if (!value) {
        this.family = null;
      }
    }

    /**
     * column qualifier to check
     */
    public byte[] getQualifier() {
      setQualifier(org.apache.thrift.TBaseHelper.rightSize(qualifier));
      return qualifier == null ? null : qualifier.array();
    }

    public java.nio.ByteBuffer bufferForQualifier() {
      return org.apache.thrift.TBaseHelper.copyBinary(qualifier);
    }

    /**
     * column qualifier to check
     */
    public checkAndDelete_args setQualifier(byte[] qualifier) {
      this.qualifier = qualifier == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(qualifier.clone());
      return this;
    }

    public checkAndDelete_args setQualifier(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer qualifier) {
      this.qualifier = org.apache.thrift.TBaseHelper.copyBinary(qualifier);
      return this;
    }

    public void unsetQualifier() {
      this.qualifier = null;
    }

    /** Returns true if field qualifier is set (has been assigned a value) and false otherwise */
    public boolean isSetQualifier() {
      return this.qualifier != null;
    }

    public void setQualifierIsSet(boolean value) {
      if (!value) {
        this.qualifier = null;
      }
    }

    /**
     * the expected value, if not provided the
     * check is for the non-existence of the
     * column in question
     */
    public byte[] getValue() {
      setValue(org.apache.thrift.TBaseHelper.rightSize(value));
      return value == null ? null : value.array();
    }

    public java.nio.ByteBuffer bufferForValue() {
      return org.apache.thrift.TBaseHelper.copyBinary(value);
    }

    /**
     * the expected value, if not provided the
     * check is for the non-existence of the
     * column in question
     */
    public checkAndDelete_args setValue(byte[] value) {
      this.value = value == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(value.clone());
      return this;
    }

    public checkAndDelete_args setValue(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer value) {
      this.value = org.apache.thrift.TBaseHelper.copyBinary(value);
      return this;
    }

    public void unsetValue() {
      this.value = null;
    }

    /** Returns true if field value is set (has been assigned a value) and false otherwise */
    public boolean isSetValue() {
      return this.value != null;
    }

    public void setValueIsSet(boolean value) {
      if (!value) {
        this.value = null;
      }
    }

    /**
     * the TDelete to execute if the check succeeds
     */
    @org.apache.thrift.annotation.Nullable
    public TDelete getTdelete() {
      return this.tdelete;
    }

    /**
     * the TDelete to execute if the check succeeds
     */
    public checkAndDelete_args setTdelete(@org.apache.thrift.annotation.Nullable TDelete tdelete) {
      this.tdelete = tdelete;
      return this;
    }

    public void unsetTdelete() {
      this.tdelete = null;
    }

    /** Returns true if field tdelete is set (has been assigned a value) and false otherwise */
    public boolean isSetTdelete() {
      return this.tdelete != null;
    }

    public void setTdeleteIsSet(boolean value) {
      if (!value) {
        this.tdelete = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE:
        if (value == null) {
          unsetTable();
        } else {
          if (value instanceof byte[]) {
            setTable((byte[])value);
          } else {
            setTable((java.nio.ByteBuffer)value);
          }
        }
        break;

      case ROW:
        if (value == null) {
          unsetRow();
        } else {
          if (value instanceof byte[]) {
            setRow((byte[])value);
          } else {
            setRow((java.nio.ByteBuffer)value);
          }
        }
        break;

      case FAMILY:
        if (value == null) {
          unsetFamily();
        } else {
          if (value instanceof byte[]) {
            setFamily((byte[])value);
          } else {
            setFamily((java.nio.ByteBuffer)value);
          }
        }
        break;

      case QUALIFIER:
        if (value == null) {
          unsetQualifier();
        } else {
          if (value instanceof byte[]) {
            setQualifier((byte[])value);
          } else {
            setQualifier((java.nio.ByteBuffer)value);
          }
        }
        break;

      case VALUE:
        if (value == null) {
          unsetValue();
        } else {
          if (value instanceof byte[]) {
            setValue((byte[])value);
          } else {
            setValue((java.nio.ByteBuffer)value);
          }
        }
        break;

      case TDELETE:
        if (value == null) {
          unsetTdelete();
        } else {
          setTdelete((TDelete)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE:
        return getTable();

      case ROW:
        return getRow();

      case FAMILY:
        return getFamily();

      case QUALIFIER:
        return getQualifier();

      case VALUE:
        return getValue();

      case TDELETE:
        return getTdelete();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE:
        return isSetTable();
      case ROW:
        return isSetRow();
      case FAMILY:
        return isSetFamily();
      case QUALIFIER:
        return isSetQualifier();
      case VALUE:
        return isSetValue();
      case TDELETE:
        return isSetTdelete();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof checkAndDelete_args)
        return this.equals((checkAndDelete_args)that);
      return false;
    }

    public boolean equals(checkAndDelete_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_table = true && this.isSetTable();
      boolean that_present_table = true && that.isSetTable();
      if (this_present_table || that_present_table) {
        if (!(this_present_table && that_present_table))
          return false;
        if (!this.table.equals(that.table))
          return false;
      }

      boolean this_present_row = true && this.isSetRow();
      boolean that_present_row = true && that.isSetRow();
      if (this_present_row || that_present_row) {
        if (!(this_present_row && that_present_row))
          return false;
        if (!this.row.equals(that.row))
          return false;
      }

      boolean this_present_family = true && this.isSetFamily();
      boolean that_present_family = true && that.isSetFamily();
      if (this_present_family || that_present_family) {
        if (!(this_present_family && that_present_family))
          return false;
        if (!this.family.equals(that.family))
          return false;
      }

      boolean this_present_qualifier = true && this.isSetQualifier();
      boolean that_present_qualifier = true && that.isSetQualifier();
      if (this_present_qualifier || that_present_qualifier) {
        if (!(this_present_qualifier && that_present_qualifier))
          return false;
        if (!this.qualifier.equals(that.qualifier))
          return false;
      }

      boolean this_present_value = true && this.isSetValue();
      boolean that_present_value = true && that.isSetValue();
      if (this_present_value || that_present_value) {
        if (!(this_present_value && that_present_value))
          return false;
        if (!this.value.equals(that.value))
          return false;
      }

      boolean this_present_tdelete = true && this.isSetTdelete();
      boolean that_present_tdelete = true && that.isSetTdelete();
      if (this_present_tdelete || that_present_tdelete) {
        if (!(this_present_tdelete && that_present_tdelete))
          return false;
        if (!this.tdelete.equals(that.tdelete))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTable()) ? 131071 : 524287);
      if (isSetTable())
        hashCode = hashCode * 8191 + table.hashCode();

      hashCode = hashCode * 8191 + ((isSetRow()) ? 131071 : 524287);
      if (isSetRow())
        hashCode = hashCode * 8191 + row.hashCode();

      hashCode = hashCode * 8191 + ((isSetFamily()) ? 131071 : 524287);
      if (isSetFamily())
        hashCode = hashCode * 8191 + family.hashCode();

      hashCode = hashCode * 8191 + ((isSetQualifier()) ? 131071 : 524287);
      if (isSetQualifier())
        hashCode = hashCode * 8191 + qualifier.hashCode();

      hashCode = hashCode * 8191 + ((isSetValue()) ? 131071 : 524287);
      if (isSetValue())
        hashCode = hashCode * 8191 + value.hashCode();

      hashCode = hashCode * 8191 + ((isSetTdelete()) ? 131071 : 524287);
      if (isSetTdelete())
        hashCode = hashCode * 8191 + tdelete.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(checkAndDelete_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTable(), other.isSetTable());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTable()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.table, other.table);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetRow(), other.isSetRow());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetRow()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.row, other.row);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetFamily(), other.isSetFamily());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetFamily()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.family, other.family);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetQualifier(), other.isSetQualifier());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetQualifier()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.qualifier, other.qualifier);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetValue(), other.isSetValue());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetValue()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.value, other.value);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTdelete(), other.isSetTdelete());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTdelete()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tdelete, other.tdelete);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("checkAndDelete_args(");
      boolean first = true;

      sb.append("table:");
      if (this.table == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.table, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("row:");
      if (this.row == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.row, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("family:");
      if (this.family == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.family, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("qualifier:");
      if (this.qualifier == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.qualifier, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("value:");
      if (this.value == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.value, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tdelete:");
      if (this.tdelete == null) {
        sb.append("null");
      } else {
        sb.append(this.tdelete);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (table == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'table' was not present! Struct: " + toString());
      }
      if (row == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'row' was not present! Struct: " + toString());
      }
      if (family == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'family' was not present! Struct: " + toString());
      }
      if (qualifier == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'qualifier' was not present! Struct: " + toString());
      }
      if (tdelete == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'tdelete' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
      if (tdelete != null) {
        tdelete.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class checkAndDelete_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public checkAndDelete_argsStandardScheme getScheme() {
        return new checkAndDelete_argsStandardScheme();
      }
    }

    private static class checkAndDelete_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<checkAndDelete_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, checkAndDelete_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.table = iprot.readBinary();
                struct.setTableIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // ROW
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.row = iprot.readBinary();
                struct.setRowIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // FAMILY
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.family = iprot.readBinary();
                struct.setFamilyIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 4: // QUALIFIER
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.qualifier = iprot.readBinary();
                struct.setQualifierIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 5: // VALUE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.value = iprot.readBinary();
                struct.setValueIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 6: // TDELETE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tdelete = new TDelete();
                struct.tdelete.read(iprot);
                struct.setTdeleteIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, checkAndDelete_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.table != null) {
          oprot.writeFieldBegin(TABLE_FIELD_DESC);
          oprot.writeBinary(struct.table);
          oprot.writeFieldEnd();
        }
        if (struct.row != null) {
          oprot.writeFieldBegin(ROW_FIELD_DESC);
          oprot.writeBinary(struct.row);
          oprot.writeFieldEnd();
        }
        if (struct.family != null) {
          oprot.writeFieldBegin(FAMILY_FIELD_DESC);
          oprot.writeBinary(struct.family);
          oprot.writeFieldEnd();
        }
        if (struct.qualifier != null) {
          oprot.writeFieldBegin(QUALIFIER_FIELD_DESC);
          oprot.writeBinary(struct.qualifier);
          oprot.writeFieldEnd();
        }
        if (struct.value != null) {
          oprot.writeFieldBegin(VALUE_FIELD_DESC);
          oprot.writeBinary(struct.value);
          oprot.writeFieldEnd();
        }
        if (struct.tdelete != null) {
          oprot.writeFieldBegin(TDELETE_FIELD_DESC);
          struct.tdelete.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class checkAndDelete_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public checkAndDelete_argsTupleScheme getScheme() {
        return new checkAndDelete_argsTupleScheme();
      }
    }

    private static class checkAndDelete_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<checkAndDelete_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, checkAndDelete_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        oprot.writeBinary(struct.table);
        oprot.writeBinary(struct.row);
        oprot.writeBinary(struct.family);
        oprot.writeBinary(struct.qualifier);
        struct.tdelete.write(oprot);
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetValue()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetValue()) {
          oprot.writeBinary(struct.value);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, checkAndDelete_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        struct.table = iprot.readBinary();
        struct.setTableIsSet(true);
        struct.row = iprot.readBinary();
        struct.setRowIsSet(true);
        struct.family = iprot.readBinary();
        struct.setFamilyIsSet(true);
        struct.qualifier = iprot.readBinary();
        struct.setQualifierIsSet(true);
        struct.tdelete = new TDelete();
        struct.tdelete.read(iprot);
        struct.setTdeleteIsSet(true);
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.value = iprot.readBinary();
          struct.setValueIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class checkAndDelete_result implements org.apache.thrift.TBase<checkAndDelete_result, checkAndDelete_result._Fields>, java.io.Serializable, Cloneable, Comparable<checkAndDelete_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("checkAndDelete_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.BOOL, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new checkAndDelete_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new checkAndDelete_resultTupleSchemeFactory();

    public boolean success; // required
    public @org.apache.thrift.annotation.Nullable TIOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(checkAndDelete_result.class, metaDataMap);
    }

    public checkAndDelete_result() {
    }

    public checkAndDelete_result(
      boolean success,
      TIOError io)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public checkAndDelete_result(checkAndDelete_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetIo()) {
        this.io = new TIOError(other.io);
      }
    }

    public checkAndDelete_result deepCopy() {
      return new checkAndDelete_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = false;
      this.io = null;
    }

    public boolean isSuccess() {
      return this.success;
    }

    public checkAndDelete_result setSuccess(boolean success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    @org.apache.thrift.annotation.Nullable
    public TIOError getIo() {
      return this.io;
    }

    public checkAndDelete_result setIo(@org.apache.thrift.annotation.Nullable TIOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.lang.Boolean)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((TIOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return isSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof checkAndDelete_result)
        return this.equals((checkAndDelete_result)that);
      return false;
    }

    public boolean equals(checkAndDelete_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((success) ? 131071 : 524287);

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(checkAndDelete_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetIo(), other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("checkAndDelete_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class checkAndDelete_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public checkAndDelete_resultStandardScheme getScheme() {
        return new checkAndDelete_resultStandardScheme();
      }
    }

    private static class checkAndDelete_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<checkAndDelete_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, checkAndDelete_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.BOOL) {
                struct.success = iprot.readBool();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new TIOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, checkAndDelete_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeBool(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class checkAndDelete_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public checkAndDelete_resultTupleScheme getScheme() {
        return new checkAndDelete_resultTupleScheme();
      }
    }

    private static class checkAndDelete_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<checkAndDelete_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, checkAndDelete_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeBool(struct.success);
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, checkAndDelete_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readBool();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new TIOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class increment_args implements org.apache.thrift.TBase<increment_args, increment_args._Fields>, java.io.Serializable, Cloneable, Comparable<increment_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("increment_args");

    private static final org.apache.thrift.protocol.TField TABLE_FIELD_DESC = new org.apache.thrift.protocol.TField("table", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TINCREMENT_FIELD_DESC = new org.apache.thrift.protocol.TField("tincrement", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new increment_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new increment_argsTupleSchemeFactory();

    /**
     * the table to increment the value on
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table; // required
    /**
     * the TIncrement to increment
     */
    public @org.apache.thrift.annotation.Nullable TIncrement tincrement; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * the table to increment the value on
       */
      TABLE((short)1, "table"),
      /**
       * the TIncrement to increment
       */
      TINCREMENT((short)2, "tincrement");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE
            return TABLE;
          case 2: // TINCREMENT
            return TINCREMENT;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE, new org.apache.thrift.meta_data.FieldMetaData("table", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TINCREMENT, new org.apache.thrift.meta_data.FieldMetaData("tincrement", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIncrement.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(increment_args.class, metaDataMap);
    }

    public increment_args() {
    }

    public increment_args(
      java.nio.ByteBuffer table,
      TIncrement tincrement)
    {
      this();
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      this.tincrement = tincrement;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public increment_args(increment_args other) {
      if (other.isSetTable()) {
        this.table = org.apache.thrift.TBaseHelper.copyBinary(other.table);
      }
      if (other.isSetTincrement()) {
        this.tincrement = new TIncrement(other.tincrement);
      }
    }

    public increment_args deepCopy() {
      return new increment_args(this);
    }

    @Override
    public void clear() {
      this.table = null;
      this.tincrement = null;
    }

    /**
     * the table to increment the value on
     */
    public byte[] getTable() {
      setTable(org.apache.thrift.TBaseHelper.rightSize(table));
      return table == null ? null : table.array();
    }

    public java.nio.ByteBuffer bufferForTable() {
      return org.apache.thrift.TBaseHelper.copyBinary(table);
    }

    /**
     * the table to increment the value on
     */
    public increment_args setTable(byte[] table) {
      this.table = table == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(table.clone());
      return this;
    }

    public increment_args setTable(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table) {
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      return this;
    }

    public void unsetTable() {
      this.table = null;
    }

    /** Returns true if field table is set (has been assigned a value) and false otherwise */
    public boolean isSetTable() {
      return this.table != null;
    }

    public void setTableIsSet(boolean value) {
      if (!value) {
        this.table = null;
      }
    }

    /**
     * the TIncrement to increment
     */
    @org.apache.thrift.annotation.Nullable
    public TIncrement getTincrement() {
      return this.tincrement;
    }

    /**
     * the TIncrement to increment
     */
    public increment_args setTincrement(@org.apache.thrift.annotation.Nullable TIncrement tincrement) {
      this.tincrement = tincrement;
      return this;
    }

    public void unsetTincrement() {
      this.tincrement = null;
    }

    /** Returns true if field tincrement is set (has been assigned a value) and false otherwise */
    public boolean isSetTincrement() {
      return this.tincrement != null;
    }

    public void setTincrementIsSet(boolean value) {
      if (!value) {
        this.tincrement = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE:
        if (value == null) {
          unsetTable();
        } else {
          if (value instanceof byte[]) {
            setTable((byte[])value);
          } else {
            setTable((java.nio.ByteBuffer)value);
          }
        }
        break;

      case TINCREMENT:
        if (value == null) {
          unsetTincrement();
        } else {
          setTincrement((TIncrement)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE:
        return getTable();

      case TINCREMENT:
        return getTincrement();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE:
        return isSetTable();
      case TINCREMENT:
        return isSetTincrement();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof increment_args)
        return this.equals((increment_args)that);
      return false;
    }

    public boolean equals(increment_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_table = true && this.isSetTable();
      boolean that_present_table = true && that.isSetTable();
      if (this_present_table || that_present_table) {
        if (!(this_present_table && that_present_table))
          return false;
        if (!this.table.equals(that.table))
          return false;
      }

      boolean this_present_tincrement = true && this.isSetTincrement();
      boolean that_present_tincrement = true && that.isSetTincrement();
      if (this_present_tincrement || that_present_tincrement) {
        if (!(this_present_tincrement && that_present_tincrement))
          return false;
        if (!this.tincrement.equals(that.tincrement))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTable()) ? 131071 : 524287);
      if (isSetTable())
        hashCode = hashCode * 8191 + table.hashCode();

      hashCode = hashCode * 8191 + ((isSetTincrement()) ? 131071 : 524287);
      if (isSetTincrement())
        hashCode = hashCode * 8191 + tincrement.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(increment_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTable(), other.isSetTable());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTable()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.table, other.table);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTincrement(), other.isSetTincrement());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTincrement()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tincrement, other.tincrement);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("increment_args(");
      boolean first = true;

      sb.append("table:");
      if (this.table == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.table, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tincrement:");
      if (this.tincrement == null) {
        sb.append("null");
      } else {
        sb.append(this.tincrement);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (table == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'table' was not present! Struct: " + toString());
      }
      if (tincrement == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'tincrement' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
      if (tincrement != null) {
        tincrement.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class increment_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public increment_argsStandardScheme getScheme() {
        return new increment_argsStandardScheme();
      }
    }

    private static class increment_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<increment_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, increment_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.table = iprot.readBinary();
                struct.setTableIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TINCREMENT
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tincrement = new TIncrement();
                struct.tincrement.read(iprot);
                struct.setTincrementIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, increment_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.table != null) {
          oprot.writeFieldBegin(TABLE_FIELD_DESC);
          oprot.writeBinary(struct.table);
          oprot.writeFieldEnd();
        }
        if (struct.tincrement != null) {
          oprot.writeFieldBegin(TINCREMENT_FIELD_DESC);
          struct.tincrement.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class increment_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public increment_argsTupleScheme getScheme() {
        return new increment_argsTupleScheme();
      }
    }

    private static class increment_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<increment_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, increment_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        oprot.writeBinary(struct.table);
        struct.tincrement.write(oprot);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, increment_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        struct.table = iprot.readBinary();
        struct.setTableIsSet(true);
        struct.tincrement = new TIncrement();
        struct.tincrement.read(iprot);
        struct.setTincrementIsSet(true);
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class increment_result implements org.apache.thrift.TBase<increment_result, increment_result._Fields>, java.io.Serializable, Cloneable, Comparable<increment_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("increment_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new increment_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new increment_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable TResult success; // required
    public @org.apache.thrift.annotation.Nullable TIOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TResult.class)));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(increment_result.class, metaDataMap);
    }

    public increment_result() {
    }

    public increment_result(
      TResult success,
      TIOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public increment_result(increment_result other) {
      if (other.isSetSuccess()) {
        this.success = new TResult(other.success);
      }
      if (other.isSetIo()) {
        this.io = new TIOError(other.io);
      }
    }

    public increment_result deepCopy() {
      return new increment_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    @org.apache.thrift.annotation.Nullable
    public TResult getSuccess() {
      return this.success;
    }

    public increment_result setSuccess(@org.apache.thrift.annotation.Nullable TResult success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public TIOError getIo() {
      return this.io;
    }

    public increment_result setIo(@org.apache.thrift.annotation.Nullable TIOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((TResult)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((TIOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof increment_result)
        return this.equals((increment_result)that);
      return false;
    }

    public boolean equals(increment_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(increment_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetIo(), other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("increment_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class increment_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public increment_resultStandardScheme getScheme() {
        return new increment_resultStandardScheme();
      }
    }

    private static class increment_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<increment_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, increment_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new TResult();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new TIOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, increment_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class increment_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public increment_resultTupleScheme getScheme() {
        return new increment_resultTupleScheme();
      }
    }

    private static class increment_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<increment_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, increment_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, increment_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new TResult();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new TIOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class append_args implements org.apache.thrift.TBase<append_args, append_args._Fields>, java.io.Serializable, Cloneable, Comparable<append_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("append_args");

    private static final org.apache.thrift.protocol.TField TABLE_FIELD_DESC = new org.apache.thrift.protocol.TField("table", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TAPPEND_FIELD_DESC = new org.apache.thrift.protocol.TField("tappend", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new append_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new append_argsTupleSchemeFactory();

    /**
     * the table to append the value on
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table; // required
    /**
     * the TAppend to append
     */
    public @org.apache.thrift.annotation.Nullable TAppend tappend; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * the table to append the value on
       */
      TABLE((short)1, "table"),
      /**
       * the TAppend to append
       */
      TAPPEND((short)2, "tappend");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE
            return TABLE;
          case 2: // TAPPEND
            return TAPPEND;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE, new org.apache.thrift.meta_data.FieldMetaData("table", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TAPPEND, new org.apache.thrift.meta_data.FieldMetaData("tappend", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TAppend.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(append_args.class, metaDataMap);
    }

    public append_args() {
    }

    public append_args(
      java.nio.ByteBuffer table,
      TAppend tappend)
    {
      this();
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      this.tappend = tappend;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public append_args(append_args other) {
      if (other.isSetTable()) {
        this.table = org.apache.thrift.TBaseHelper.copyBinary(other.table);
      }
      if (other.isSetTappend()) {
        this.tappend = new TAppend(other.tappend);
      }
    }

    public append_args deepCopy() {
      return new append_args(this);
    }

    @Override
    public void clear() {
      this.table = null;
      this.tappend = null;
    }

    /**
     * the table to append the value on
     */
    public byte[] getTable() {
      setTable(org.apache.thrift.TBaseHelper.rightSize(table));
      return table == null ? null : table.array();
    }

    public java.nio.ByteBuffer bufferForTable() {
      return org.apache.thrift.TBaseHelper.copyBinary(table);
    }

    /**
     * the table to append the value on
     */
    public append_args setTable(byte[] table) {
      this.table = table == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(table.clone());
      return this;
    }

    public append_args setTable(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table) {
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      return this;
    }

    public void unsetTable() {
      this.table = null;
    }

    /** Returns true if field table is set (has been assigned a value) and false otherwise */
    public boolean isSetTable() {
      return this.table != null;
    }

    public void setTableIsSet(boolean value) {
      if (!value) {
        this.table = null;
      }
    }

    /**
     * the TAppend to append
     */
    @org.apache.thrift.annotation.Nullable
    public TAppend getTappend() {
      return this.tappend;
    }

    /**
     * the TAppend to append
     */
    public append_args setTappend(@org.apache.thrift.annotation.Nullable TAppend tappend) {
      this.tappend = tappend;
      return this;
    }

    public void unsetTappend() {
      this.tappend = null;
    }

    /** Returns true if field tappend is set (has been assigned a value) and false otherwise */
    public boolean isSetTappend() {
      return this.tappend != null;
    }

    public void setTappendIsSet(boolean value) {
      if (!value) {
        this.tappend = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE:
        if (value == null) {
          unsetTable();
        } else {
          if (value instanceof byte[]) {
            setTable((byte[])value);
          } else {
            setTable((java.nio.ByteBuffer)value);
          }
        }
        break;

      case TAPPEND:
        if (value == null) {
          unsetTappend();
        } else {
          setTappend((TAppend)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE:
        return getTable();

      case TAPPEND:
        return getTappend();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE:
        return isSetTable();
      case TAPPEND:
        return isSetTappend();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof append_args)
        return this.equals((append_args)that);
      return false;
    }

    public boolean equals(append_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_table = true && this.isSetTable();
      boolean that_present_table = true && that.isSetTable();
      if (this_present_table || that_present_table) {
        if (!(this_present_table && that_present_table))
          return false;
        if (!this.table.equals(that.table))
          return false;
      }

      boolean this_present_tappend = true && this.isSetTappend();
      boolean that_present_tappend = true && that.isSetTappend();
      if (this_present_tappend || that_present_tappend) {
        if (!(this_present_tappend && that_present_tappend))
          return false;
        if (!this.tappend.equals(that.tappend))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTable()) ? 131071 : 524287);
      if (isSetTable())
        hashCode = hashCode * 8191 + table.hashCode();

      hashCode = hashCode * 8191 + ((isSetTappend()) ? 131071 : 524287);
      if (isSetTappend())
        hashCode = hashCode * 8191 + tappend.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(append_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTable(), other.isSetTable());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTable()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.table, other.table);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTappend(), other.isSetTappend());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTappend()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tappend, other.tappend);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("append_args(");
      boolean first = true;

      sb.append("table:");
      if (this.table == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.table, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tappend:");
      if (this.tappend == null) {
        sb.append("null");
      } else {
        sb.append(this.tappend);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (table == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'table' was not present! Struct: " + toString());
      }
      if (tappend == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'tappend' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
      if (tappend != null) {
        tappend.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class append_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public append_argsStandardScheme getScheme() {
        return new append_argsStandardScheme();
      }
    }

    private static class append_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<append_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, append_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.table = iprot.readBinary();
                struct.setTableIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TAPPEND
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tappend = new TAppend();
                struct.tappend.read(iprot);
                struct.setTappendIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, append_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.table != null) {
          oprot.writeFieldBegin(TABLE_FIELD_DESC);
          oprot.writeBinary(struct.table);
          oprot.writeFieldEnd();
        }
        if (struct.tappend != null) {
          oprot.writeFieldBegin(TAPPEND_FIELD_DESC);
          struct.tappend.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class append_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public append_argsTupleScheme getScheme() {
        return new append_argsTupleScheme();
      }
    }

    private static class append_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<append_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, append_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        oprot.writeBinary(struct.table);
        struct.tappend.write(oprot);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, append_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        struct.table = iprot.readBinary();
        struct.setTableIsSet(true);
        struct.tappend = new TAppend();
        struct.tappend.read(iprot);
        struct.setTappendIsSet(true);
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class append_result implements org.apache.thrift.TBase<append_result, append_result._Fields>, java.io.Serializable, Cloneable, Comparable<append_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("append_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.STRUCT, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new append_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new append_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable TResult success; // required
    public @org.apache.thrift.annotation.Nullable TIOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TResult.class)));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(append_result.class, metaDataMap);
    }

    public append_result() {
    }

    public append_result(
      TResult success,
      TIOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public append_result(append_result other) {
      if (other.isSetSuccess()) {
        this.success = new TResult(other.success);
      }
      if (other.isSetIo()) {
        this.io = new TIOError(other.io);
      }
    }

    public append_result deepCopy() {
      return new append_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    @org.apache.thrift.annotation.Nullable
    public TResult getSuccess() {
      return this.success;
    }

    public append_result setSuccess(@org.apache.thrift.annotation.Nullable TResult success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public TIOError getIo() {
      return this.io;
    }

    public append_result setIo(@org.apache.thrift.annotation.Nullable TIOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((TResult)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((TIOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof append_result)
        return this.equals((append_result)that);
      return false;
    }

    public boolean equals(append_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(append_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetIo(), other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("append_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
      if (success != null) {
        success.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class append_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public append_resultStandardScheme getScheme() {
        return new append_resultStandardScheme();
      }
    }

    private static class append_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<append_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, append_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.success = new TResult();
                struct.success.read(iprot);
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new TIOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, append_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          struct.success.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class append_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public append_resultTupleScheme getScheme() {
        return new append_resultTupleScheme();
      }
    }

    private static class append_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<append_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, append_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          struct.success.write(oprot);
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, append_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = new TResult();
          struct.success.read(iprot);
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new TIOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class openScanner_args implements org.apache.thrift.TBase<openScanner_args, openScanner_args._Fields>, java.io.Serializable, Cloneable, Comparable<openScanner_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("openScanner_args");

    private static final org.apache.thrift.protocol.TField TABLE_FIELD_DESC = new org.apache.thrift.protocol.TField("table", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TSCAN_FIELD_DESC = new org.apache.thrift.protocol.TField("tscan", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new openScanner_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new openScanner_argsTupleSchemeFactory();

    /**
     * the table to get the Scanner for
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table; // required
    /**
     * the scan object to get a Scanner for
     */
    public @org.apache.thrift.annotation.Nullable TScan tscan; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * the table to get the Scanner for
       */
      TABLE((short)1, "table"),
      /**
       * the scan object to get a Scanner for
       */
      TSCAN((short)2, "tscan");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE
            return TABLE;
          case 2: // TSCAN
            return TSCAN;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE, new org.apache.thrift.meta_data.FieldMetaData("table", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TSCAN, new org.apache.thrift.meta_data.FieldMetaData("tscan", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TScan.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(openScanner_args.class, metaDataMap);
    }

    public openScanner_args() {
    }

    public openScanner_args(
      java.nio.ByteBuffer table,
      TScan tscan)
    {
      this();
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      this.tscan = tscan;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public openScanner_args(openScanner_args other) {
      if (other.isSetTable()) {
        this.table = org.apache.thrift.TBaseHelper.copyBinary(other.table);
      }
      if (other.isSetTscan()) {
        this.tscan = new TScan(other.tscan);
      }
    }

    public openScanner_args deepCopy() {
      return new openScanner_args(this);
    }

    @Override
    public void clear() {
      this.table = null;
      this.tscan = null;
    }

    /**
     * the table to get the Scanner for
     */
    public byte[] getTable() {
      setTable(org.apache.thrift.TBaseHelper.rightSize(table));
      return table == null ? null : table.array();
    }

    public java.nio.ByteBuffer bufferForTable() {
      return org.apache.thrift.TBaseHelper.copyBinary(table);
    }

    /**
     * the table to get the Scanner for
     */
    public openScanner_args setTable(byte[] table) {
      this.table = table == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(table.clone());
      return this;
    }

    public openScanner_args setTable(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table) {
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      return this;
    }

    public void unsetTable() {
      this.table = null;
    }

    /** Returns true if field table is set (has been assigned a value) and false otherwise */
    public boolean isSetTable() {
      return this.table != null;
    }

    public void setTableIsSet(boolean value) {
      if (!value) {
        this.table = null;
      }
    }

    /**
     * the scan object to get a Scanner for
     */
    @org.apache.thrift.annotation.Nullable
    public TScan getTscan() {
      return this.tscan;
    }

    /**
     * the scan object to get a Scanner for
     */
    public openScanner_args setTscan(@org.apache.thrift.annotation.Nullable TScan tscan) {
      this.tscan = tscan;
      return this;
    }

    public void unsetTscan() {
      this.tscan = null;
    }

    /** Returns true if field tscan is set (has been assigned a value) and false otherwise */
    public boolean isSetTscan() {
      return this.tscan != null;
    }

    public void setTscanIsSet(boolean value) {
      if (!value) {
        this.tscan = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE:
        if (value == null) {
          unsetTable();
        } else {
          if (value instanceof byte[]) {
            setTable((byte[])value);
          } else {
            setTable((java.nio.ByteBuffer)value);
          }
        }
        break;

      case TSCAN:
        if (value == null) {
          unsetTscan();
        } else {
          setTscan((TScan)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE:
        return getTable();

      case TSCAN:
        return getTscan();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE:
        return isSetTable();
      case TSCAN:
        return isSetTscan();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof openScanner_args)
        return this.equals((openScanner_args)that);
      return false;
    }

    public boolean equals(openScanner_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_table = true && this.isSetTable();
      boolean that_present_table = true && that.isSetTable();
      if (this_present_table || that_present_table) {
        if (!(this_present_table && that_present_table))
          return false;
        if (!this.table.equals(that.table))
          return false;
      }

      boolean this_present_tscan = true && this.isSetTscan();
      boolean that_present_tscan = true && that.isSetTscan();
      if (this_present_tscan || that_present_tscan) {
        if (!(this_present_tscan && that_present_tscan))
          return false;
        if (!this.tscan.equals(that.tscan))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTable()) ? 131071 : 524287);
      if (isSetTable())
        hashCode = hashCode * 8191 + table.hashCode();

      hashCode = hashCode * 8191 + ((isSetTscan()) ? 131071 : 524287);
      if (isSetTscan())
        hashCode = hashCode * 8191 + tscan.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(openScanner_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTable(), other.isSetTable());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTable()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.table, other.table);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTscan(), other.isSetTscan());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTscan()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tscan, other.tscan);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("openScanner_args(");
      boolean first = true;

      sb.append("table:");
      if (this.table == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.table, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tscan:");
      if (this.tscan == null) {
        sb.append("null");
      } else {
        sb.append(this.tscan);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (table == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'table' was not present! Struct: " + toString());
      }
      if (tscan == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'tscan' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
      if (tscan != null) {
        tscan.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class openScanner_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public openScanner_argsStandardScheme getScheme() {
        return new openScanner_argsStandardScheme();
      }
    }

    private static class openScanner_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<openScanner_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, openScanner_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.table = iprot.readBinary();
                struct.setTableIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TSCAN
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tscan = new TScan();
                struct.tscan.read(iprot);
                struct.setTscanIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, openScanner_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.table != null) {
          oprot.writeFieldBegin(TABLE_FIELD_DESC);
          oprot.writeBinary(struct.table);
          oprot.writeFieldEnd();
        }
        if (struct.tscan != null) {
          oprot.writeFieldBegin(TSCAN_FIELD_DESC);
          struct.tscan.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class openScanner_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public openScanner_argsTupleScheme getScheme() {
        return new openScanner_argsTupleScheme();
      }
    }

    private static class openScanner_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<openScanner_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, openScanner_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        oprot.writeBinary(struct.table);
        struct.tscan.write(oprot);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, openScanner_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        struct.table = iprot.readBinary();
        struct.setTableIsSet(true);
        struct.tscan = new TScan();
        struct.tscan.read(iprot);
        struct.setTscanIsSet(true);
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class openScanner_result implements org.apache.thrift.TBase<openScanner_result, openScanner_result._Fields>, java.io.Serializable, Cloneable, Comparable<openScanner_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("openScanner_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.I32, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new openScanner_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new openScanner_resultTupleSchemeFactory();

    public int success; // required
    public @org.apache.thrift.annotation.Nullable TIOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SUCCESS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(openScanner_result.class, metaDataMap);
    }

    public openScanner_result() {
    }

    public openScanner_result(
      int success,
      TIOError io)
    {
      this();
      this.success = success;
      setSuccessIsSet(true);
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public openScanner_result(openScanner_result other) {
      __isset_bitfield = other.__isset_bitfield;
      this.success = other.success;
      if (other.isSetIo()) {
        this.io = new TIOError(other.io);
      }
    }

    public openScanner_result deepCopy() {
      return new openScanner_result(this);
    }

    @Override
    public void clear() {
      setSuccessIsSet(false);
      this.success = 0;
      this.io = null;
    }

    public int getSuccess() {
      return this.success;
    }

    public openScanner_result setSuccess(int success) {
      this.success = success;
      setSuccessIsSet(true);
      return this;
    }

    public void unsetSuccess() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SUCCESS_ISSET_ID);
    }

    public void setSuccessIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SUCCESS_ISSET_ID, value);
    }

    @org.apache.thrift.annotation.Nullable
    public TIOError getIo() {
      return this.io;
    }

    public openScanner_result setIo(@org.apache.thrift.annotation.Nullable TIOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.lang.Integer)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((TIOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof openScanner_result)
        return this.equals((openScanner_result)that);
      return false;
    }

    public boolean equals(openScanner_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + success;

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(openScanner_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetIo(), other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("openScanner_result(");
      boolean first = true;

      sb.append("success:");
      sb.append(this.success);
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class openScanner_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public openScanner_resultStandardScheme getScheme() {
        return new openScanner_resultStandardScheme();
      }
    }

    private static class openScanner_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<openScanner_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, openScanner_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.success = iprot.readI32();
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new TIOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, openScanner_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.isSetSuccess()) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          oprot.writeI32(struct.success);
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class openScanner_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public openScanner_resultTupleScheme getScheme() {
        return new openScanner_resultTupleScheme();
      }
    }

    private static class openScanner_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<openScanner_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, openScanner_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          oprot.writeI32(struct.success);
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, openScanner_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.success = iprot.readI32();
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new TIOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getScannerRows_args implements org.apache.thrift.TBase<getScannerRows_args, getScannerRows_args._Fields>, java.io.Serializable, Cloneable, Comparable<getScannerRows_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getScannerRows_args");

    private static final org.apache.thrift.protocol.TField SCANNER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("scannerId", org.apache.thrift.protocol.TType.I32, (short)1);
    private static final org.apache.thrift.protocol.TField NUM_ROWS_FIELD_DESC = new org.apache.thrift.protocol.TField("numRows", org.apache.thrift.protocol.TType.I32, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getScannerRows_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getScannerRows_argsTupleSchemeFactory();

    /**
     * the Id of the Scanner to return rows from. This is an Id returned from the openScanner function.
     */
    public int scannerId; // required
    /**
     * number of rows to return
     */
    public int numRows; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * the Id of the Scanner to return rows from. This is an Id returned from the openScanner function.
       */
      SCANNER_ID((short)1, "scannerId"),
      /**
       * number of rows to return
       */
      NUM_ROWS((short)2, "numRows");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SCANNER_ID
            return SCANNER_ID;
          case 2: // NUM_ROWS
            return NUM_ROWS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SCANNERID_ISSET_ID = 0;
    private static final int __NUMROWS_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SCANNER_ID, new org.apache.thrift.meta_data.FieldMetaData("scannerId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      tmpMap.put(_Fields.NUM_ROWS, new org.apache.thrift.meta_data.FieldMetaData("numRows", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getScannerRows_args.class, metaDataMap);
    }

    public getScannerRows_args() {
      this.numRows = 1;

    }

    public getScannerRows_args(
      int scannerId,
      int numRows)
    {
      this();
      this.scannerId = scannerId;
      setScannerIdIsSet(true);
      this.numRows = numRows;
      setNumRowsIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getScannerRows_args(getScannerRows_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.scannerId = other.scannerId;
      this.numRows = other.numRows;
    }

    public getScannerRows_args deepCopy() {
      return new getScannerRows_args(this);
    }

    @Override
    public void clear() {
      setScannerIdIsSet(false);
      this.scannerId = 0;
      this.numRows = 1;

    }

    /**
     * the Id of the Scanner to return rows from. This is an Id returned from the openScanner function.
     */
    public int getScannerId() {
      return this.scannerId;
    }

    /**
     * the Id of the Scanner to return rows from. This is an Id returned from the openScanner function.
     */
    public getScannerRows_args setScannerId(int scannerId) {
      this.scannerId = scannerId;
      setScannerIdIsSet(true);
      return this;
    }

    public void unsetScannerId() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SCANNERID_ISSET_ID);
    }

    /** Returns true if field scannerId is set (has been assigned a value) and false otherwise */
    public boolean isSetScannerId() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SCANNERID_ISSET_ID);
    }

    public void setScannerIdIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SCANNERID_ISSET_ID, value);
    }

    /**
     * number of rows to return
     */
    public int getNumRows() {
      return this.numRows;
    }

    /**
     * number of rows to return
     */
    public getScannerRows_args setNumRows(int numRows) {
      this.numRows = numRows;
      setNumRowsIsSet(true);
      return this;
    }

    public void unsetNumRows() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __NUMROWS_ISSET_ID);
    }

    /** Returns true if field numRows is set (has been assigned a value) and false otherwise */
    public boolean isSetNumRows() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __NUMROWS_ISSET_ID);
    }

    public void setNumRowsIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __NUMROWS_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SCANNER_ID:
        if (value == null) {
          unsetScannerId();
        } else {
          setScannerId((java.lang.Integer)value);
        }
        break;

      case NUM_ROWS:
        if (value == null) {
          unsetNumRows();
        } else {
          setNumRows((java.lang.Integer)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SCANNER_ID:
        return getScannerId();

      case NUM_ROWS:
        return getNumRows();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SCANNER_ID:
        return isSetScannerId();
      case NUM_ROWS:
        return isSetNumRows();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof getScannerRows_args)
        return this.equals((getScannerRows_args)that);
      return false;
    }

    public boolean equals(getScannerRows_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_scannerId = true;
      boolean that_present_scannerId = true;
      if (this_present_scannerId || that_present_scannerId) {
        if (!(this_present_scannerId && that_present_scannerId))
          return false;
        if (this.scannerId != that.scannerId)
          return false;
      }

      boolean this_present_numRows = true;
      boolean that_present_numRows = true;
      if (this_present_numRows || that_present_numRows) {
        if (!(this_present_numRows && that_present_numRows))
          return false;
        if (this.numRows != that.numRows)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + scannerId;

      hashCode = hashCode * 8191 + numRows;

      return hashCode;
    }

    @Override
    public int compareTo(getScannerRows_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetScannerId(), other.isSetScannerId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetScannerId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.scannerId, other.scannerId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetNumRows(), other.isSetNumRows());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNumRows()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.numRows, other.numRows);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getScannerRows_args(");
      boolean first = true;

      sb.append("scannerId:");
      sb.append(this.scannerId);
      first = false;
      if (!first) sb.append(", ");
      sb.append("numRows:");
      sb.append(this.numRows);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // alas, we cannot check 'scannerId' because it's a primitive and you chose the non-beans generator.
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getScannerRows_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getScannerRows_argsStandardScheme getScheme() {
        return new getScannerRows_argsStandardScheme();
      }
    }

    private static class getScannerRows_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<getScannerRows_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getScannerRows_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SCANNER_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.scannerId = iprot.readI32();
                struct.setScannerIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // NUM_ROWS
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.numRows = iprot.readI32();
                struct.setNumRowsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        if (!struct.isSetScannerId()) {
          throw new org.apache.thrift.protocol.TProtocolException("Required field 'scannerId' was not found in serialized data! Struct: " + toString());
        }
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getScannerRows_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(SCANNER_ID_FIELD_DESC);
        oprot.writeI32(struct.scannerId);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(NUM_ROWS_FIELD_DESC);
        oprot.writeI32(struct.numRows);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getScannerRows_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getScannerRows_argsTupleScheme getScheme() {
        return new getScannerRows_argsTupleScheme();
      }
    }

    private static class getScannerRows_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<getScannerRows_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getScannerRows_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        oprot.writeI32(struct.scannerId);
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetNumRows()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetNumRows()) {
          oprot.writeI32(struct.numRows);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getScannerRows_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        struct.scannerId = iprot.readI32();
        struct.setScannerIdIsSet(true);
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.numRows = iprot.readI32();
          struct.setNumRowsIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getScannerRows_result implements org.apache.thrift.TBase<getScannerRows_result, getScannerRows_result._Fields>, java.io.Serializable, Cloneable, Comparable<getScannerRows_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getScannerRows_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField IA_FIELD_DESC = new org.apache.thrift.protocol.TField("ia", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getScannerRows_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getScannerRows_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.util.List<TResult> success; // required
    public @org.apache.thrift.annotation.Nullable TIOError io; // required
    /**
     * if the scannerId is invalid
     */
    public @org.apache.thrift.annotation.Nullable TIllegalArgument ia; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io"),
      /**
       * if the scannerId is invalid
       */
      IA((short)2, "ia");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          case 2: // IA
            return IA;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TResult.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIOError.class)));
      tmpMap.put(_Fields.IA, new org.apache.thrift.meta_data.FieldMetaData("ia", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIllegalArgument.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getScannerRows_result.class, metaDataMap);
    }

    public getScannerRows_result() {
    }

    public getScannerRows_result(
      java.util.List<TResult> success,
      TIOError io,
      TIllegalArgument ia)
    {
      this();
      this.success = success;
      this.io = io;
      this.ia = ia;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getScannerRows_result(getScannerRows_result other) {
      if (other.isSetSuccess()) {
        java.util.List<TResult> __this__success = new java.util.ArrayList<TResult>(other.success.size());
        for (TResult other_element : other.success) {
          __this__success.add(new TResult(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new TIOError(other.io);
      }
      if (other.isSetIa()) {
        this.ia = new TIllegalArgument(other.ia);
      }
    }

    public getScannerRows_result deepCopy() {
      return new getScannerRows_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
      this.ia = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<TResult> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TResult elem) {
      if (this.success == null) {
        this.success = new java.util.ArrayList<TResult>();
      }
      this.success.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<TResult> getSuccess() {
      return this.success;
    }

    public getScannerRows_result setSuccess(@org.apache.thrift.annotation.Nullable java.util.List<TResult> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public TIOError getIo() {
      return this.io;
    }

    public getScannerRows_result setIo(@org.apache.thrift.annotation.Nullable TIOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    /**
     * if the scannerId is invalid
     */
    @org.apache.thrift.annotation.Nullable
    public TIllegalArgument getIa() {
      return this.ia;
    }

    /**
     * if the scannerId is invalid
     */
    public getScannerRows_result setIa(@org.apache.thrift.annotation.Nullable TIllegalArgument ia) {
      this.ia = ia;
      return this;
    }

    public void unsetIa() {
      this.ia = null;
    }

    /** Returns true if field ia is set (has been assigned a value) and false otherwise */
    public boolean isSetIa() {
      return this.ia != null;
    }

    public void setIaIsSet(boolean value) {
      if (!value) {
        this.ia = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.util.List<TResult>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((TIOError)value);
        }
        break;

      case IA:
        if (value == null) {
          unsetIa();
        } else {
          setIa((TIllegalArgument)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      case IA:
        return getIa();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      case IA:
        return isSetIa();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof getScannerRows_result)
        return this.equals((getScannerRows_result)that);
      return false;
    }

    public boolean equals(getScannerRows_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      boolean this_present_ia = true && this.isSetIa();
      boolean that_present_ia = true && that.isSetIa();
      if (this_present_ia || that_present_ia) {
        if (!(this_present_ia && that_present_ia))
          return false;
        if (!this.ia.equals(that.ia))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      hashCode = hashCode * 8191 + ((isSetIa()) ? 131071 : 524287);
      if (isSetIa())
        hashCode = hashCode * 8191 + ia.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getScannerRows_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetIo(), other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetIa(), other.isSetIa());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIa()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ia, other.ia);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getScannerRows_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ia:");
      if (this.ia == null) {
        sb.append("null");
      } else {
        sb.append(this.ia);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getScannerRows_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getScannerRows_resultStandardScheme getScheme() {
        return new getScannerRows_resultStandardScheme();
      }
    }

    private static class getScannerRows_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<getScannerRows_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getScannerRows_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list246 = iprot.readListBegin();
                  struct.success = new java.util.ArrayList<TResult>(_list246.size);
                  @org.apache.thrift.annotation.Nullable TResult _elem247;
                  for (int _i248 = 0; _i248 < _list246.size; ++_i248)
                  {
                    _elem247 = new TResult();
                    _elem247.read(iprot);
                    struct.success.add(_elem247);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new TIOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // IA
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ia = new TIllegalArgument();
                struct.ia.read(iprot);
                struct.setIaIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getScannerRows_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TResult _iter249 : struct.success)
            {
              _iter249.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ia != null) {
          oprot.writeFieldBegin(IA_FIELD_DESC);
          struct.ia.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getScannerRows_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getScannerRows_resultTupleScheme getScheme() {
        return new getScannerRows_resultTupleScheme();
      }
    }

    private static class getScannerRows_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<getScannerRows_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getScannerRows_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        if (struct.isSetIa()) {
          optionals.set(2);
        }
        oprot.writeBitSet(optionals, 3);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TResult _iter250 : struct.success)
            {
              _iter250.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
        if (struct.isSetIa()) {
          struct.ia.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getScannerRows_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(3);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list251 = iprot.readListBegin(org.apache.thrift.protocol.TType.STRUCT);
            struct.success = new java.util.ArrayList<TResult>(_list251.size);
            @org.apache.thrift.annotation.Nullable TResult _elem252;
            for (int _i253 = 0; _i253 < _list251.size; ++_i253)
            {
              _elem252 = new TResult();
              _elem252.read(iprot);
              struct.success.add(_elem252);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new TIOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
        if (incoming.get(2)) {
          struct.ia = new TIllegalArgument();
          struct.ia.read(iprot);
          struct.setIaIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class closeScanner_args implements org.apache.thrift.TBase<closeScanner_args, closeScanner_args._Fields>, java.io.Serializable, Cloneable, Comparable<closeScanner_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("closeScanner_args");

    private static final org.apache.thrift.protocol.TField SCANNER_ID_FIELD_DESC = new org.apache.thrift.protocol.TField("scannerId", org.apache.thrift.protocol.TType.I32, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new closeScanner_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new closeScanner_argsTupleSchemeFactory();

    /**
     * the Id of the Scanner to close *
     */
    public int scannerId; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * the Id of the Scanner to close *
       */
      SCANNER_ID((short)1, "scannerId");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // SCANNER_ID
            return SCANNER_ID;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __SCANNERID_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SCANNER_ID, new org.apache.thrift.meta_data.FieldMetaData("scannerId", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(closeScanner_args.class, metaDataMap);
    }

    public closeScanner_args() {
    }

    public closeScanner_args(
      int scannerId)
    {
      this();
      this.scannerId = scannerId;
      setScannerIdIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public closeScanner_args(closeScanner_args other) {
      __isset_bitfield = other.__isset_bitfield;
      this.scannerId = other.scannerId;
    }

    public closeScanner_args deepCopy() {
      return new closeScanner_args(this);
    }

    @Override
    public void clear() {
      setScannerIdIsSet(false);
      this.scannerId = 0;
    }

    /**
     * the Id of the Scanner to close *
     */
    public int getScannerId() {
      return this.scannerId;
    }

    /**
     * the Id of the Scanner to close *
     */
    public closeScanner_args setScannerId(int scannerId) {
      this.scannerId = scannerId;
      setScannerIdIsSet(true);
      return this;
    }

    public void unsetScannerId() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __SCANNERID_ISSET_ID);
    }

    /** Returns true if field scannerId is set (has been assigned a value) and false otherwise */
    public boolean isSetScannerId() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __SCANNERID_ISSET_ID);
    }

    public void setScannerIdIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __SCANNERID_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SCANNER_ID:
        if (value == null) {
          unsetScannerId();
        } else {
          setScannerId((java.lang.Integer)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SCANNER_ID:
        return getScannerId();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SCANNER_ID:
        return isSetScannerId();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof closeScanner_args)
        return this.equals((closeScanner_args)that);
      return false;
    }

    public boolean equals(closeScanner_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_scannerId = true;
      boolean that_present_scannerId = true;
      if (this_present_scannerId || that_present_scannerId) {
        if (!(this_present_scannerId && that_present_scannerId))
          return false;
        if (this.scannerId != that.scannerId)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + scannerId;

      return hashCode;
    }

    @Override
    public int compareTo(closeScanner_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetScannerId(), other.isSetScannerId());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetScannerId()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.scannerId, other.scannerId);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("closeScanner_args(");
      boolean first = true;

      sb.append("scannerId:");
      sb.append(this.scannerId);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // alas, we cannot check 'scannerId' because it's a primitive and you chose the non-beans generator.
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class closeScanner_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public closeScanner_argsStandardScheme getScheme() {
        return new closeScanner_argsStandardScheme();
      }
    }

    private static class closeScanner_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<closeScanner_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, closeScanner_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // SCANNER_ID
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.scannerId = iprot.readI32();
                struct.setScannerIdIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        if (!struct.isSetScannerId()) {
          throw new org.apache.thrift.protocol.TProtocolException("Required field 'scannerId' was not found in serialized data! Struct: " + toString());
        }
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, closeScanner_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(SCANNER_ID_FIELD_DESC);
        oprot.writeI32(struct.scannerId);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class closeScanner_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public closeScanner_argsTupleScheme getScheme() {
        return new closeScanner_argsTupleScheme();
      }
    }

    private static class closeScanner_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<closeScanner_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, closeScanner_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        oprot.writeI32(struct.scannerId);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, closeScanner_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        struct.scannerId = iprot.readI32();
        struct.setScannerIdIsSet(true);
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class closeScanner_result implements org.apache.thrift.TBase<closeScanner_result, closeScanner_result._Fields>, java.io.Serializable, Cloneable, Comparable<closeScanner_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("closeScanner_result");

    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);
    private static final org.apache.thrift.protocol.TField IA_FIELD_DESC = new org.apache.thrift.protocol.TField("ia", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new closeScanner_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new closeScanner_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable TIOError io; // required
    /**
     * if the scannerId is invalid
     */
    public @org.apache.thrift.annotation.Nullable TIllegalArgument ia; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IO((short)1, "io"),
      /**
       * if the scannerId is invalid
       */
      IA((short)2, "ia");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IO
            return IO;
          case 2: // IA
            return IA;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIOError.class)));
      tmpMap.put(_Fields.IA, new org.apache.thrift.meta_data.FieldMetaData("ia", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIllegalArgument.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(closeScanner_result.class, metaDataMap);
    }

    public closeScanner_result() {
    }

    public closeScanner_result(
      TIOError io,
      TIllegalArgument ia)
    {
      this();
      this.io = io;
      this.ia = ia;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public closeScanner_result(closeScanner_result other) {
      if (other.isSetIo()) {
        this.io = new TIOError(other.io);
      }
      if (other.isSetIa()) {
        this.ia = new TIllegalArgument(other.ia);
      }
    }

    public closeScanner_result deepCopy() {
      return new closeScanner_result(this);
    }

    @Override
    public void clear() {
      this.io = null;
      this.ia = null;
    }

    @org.apache.thrift.annotation.Nullable
    public TIOError getIo() {
      return this.io;
    }

    public closeScanner_result setIo(@org.apache.thrift.annotation.Nullable TIOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    /**
     * if the scannerId is invalid
     */
    @org.apache.thrift.annotation.Nullable
    public TIllegalArgument getIa() {
      return this.ia;
    }

    /**
     * if the scannerId is invalid
     */
    public closeScanner_result setIa(@org.apache.thrift.annotation.Nullable TIllegalArgument ia) {
      this.ia = ia;
      return this;
    }

    public void unsetIa() {
      this.ia = null;
    }

    /** Returns true if field ia is set (has been assigned a value) and false otherwise */
    public boolean isSetIa() {
      return this.ia != null;
    }

    public void setIaIsSet(boolean value) {
      if (!value) {
        this.ia = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((TIOError)value);
        }
        break;

      case IA:
        if (value == null) {
          unsetIa();
        } else {
          setIa((TIllegalArgument)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case IO:
        return getIo();

      case IA:
        return getIa();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case IO:
        return isSetIo();
      case IA:
        return isSetIa();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof closeScanner_result)
        return this.equals((closeScanner_result)that);
      return false;
    }

    public boolean equals(closeScanner_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      boolean this_present_ia = true && this.isSetIa();
      boolean that_present_ia = true && that.isSetIa();
      if (this_present_ia || that_present_ia) {
        if (!(this_present_ia && that_present_ia))
          return false;
        if (!this.ia.equals(that.ia))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      hashCode = hashCode * 8191 + ((isSetIa()) ? 131071 : 524287);
      if (isSetIa())
        hashCode = hashCode * 8191 + ia.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(closeScanner_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetIo(), other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetIa(), other.isSetIa());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIa()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.ia, other.ia);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("closeScanner_result(");
      boolean first = true;

      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("ia:");
      if (this.ia == null) {
        sb.append("null");
      } else {
        sb.append(this.ia);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class closeScanner_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public closeScanner_resultStandardScheme getScheme() {
        return new closeScanner_resultStandardScheme();
      }
    }

    private static class closeScanner_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<closeScanner_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, closeScanner_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new TIOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // IA
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.ia = new TIllegalArgument();
                struct.ia.read(iprot);
                struct.setIaIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, closeScanner_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        if (struct.ia != null) {
          oprot.writeFieldBegin(IA_FIELD_DESC);
          struct.ia.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class closeScanner_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public closeScanner_resultTupleScheme getScheme() {
        return new closeScanner_resultTupleScheme();
      }
    }

    private static class closeScanner_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<closeScanner_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, closeScanner_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetIo()) {
          optionals.set(0);
        }
        if (struct.isSetIa()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
        if (struct.isSetIa()) {
          struct.ia.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, closeScanner_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          struct.io = new TIOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
        if (incoming.get(1)) {
          struct.ia = new TIllegalArgument();
          struct.ia.read(iprot);
          struct.setIaIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class mutateRow_args implements org.apache.thrift.TBase<mutateRow_args, mutateRow_args._Fields>, java.io.Serializable, Cloneable, Comparable<mutateRow_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("mutateRow_args");

    private static final org.apache.thrift.protocol.TField TABLE_FIELD_DESC = new org.apache.thrift.protocol.TField("table", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TROW_MUTATIONS_FIELD_DESC = new org.apache.thrift.protocol.TField("trowMutations", org.apache.thrift.protocol.TType.STRUCT, (short)2);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new mutateRow_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new mutateRow_argsTupleSchemeFactory();

    /**
     * table to apply the mutations
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table; // required
    /**
     * mutations to apply
     */
    public @org.apache.thrift.annotation.Nullable TRowMutations trowMutations; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * table to apply the mutations
       */
      TABLE((short)1, "table"),
      /**
       * mutations to apply
       */
      TROW_MUTATIONS((short)2, "trowMutations");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE
            return TABLE;
          case 2: // TROW_MUTATIONS
            return TROW_MUTATIONS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE, new org.apache.thrift.meta_data.FieldMetaData("table", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TROW_MUTATIONS, new org.apache.thrift.meta_data.FieldMetaData("trowMutations", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TRowMutations.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(mutateRow_args.class, metaDataMap);
    }

    public mutateRow_args() {
    }

    public mutateRow_args(
      java.nio.ByteBuffer table,
      TRowMutations trowMutations)
    {
      this();
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      this.trowMutations = trowMutations;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public mutateRow_args(mutateRow_args other) {
      if (other.isSetTable()) {
        this.table = org.apache.thrift.TBaseHelper.copyBinary(other.table);
      }
      if (other.isSetTrowMutations()) {
        this.trowMutations = new TRowMutations(other.trowMutations);
      }
    }

    public mutateRow_args deepCopy() {
      return new mutateRow_args(this);
    }

    @Override
    public void clear() {
      this.table = null;
      this.trowMutations = null;
    }

    /**
     * table to apply the mutations
     */
    public byte[] getTable() {
      setTable(org.apache.thrift.TBaseHelper.rightSize(table));
      return table == null ? null : table.array();
    }

    public java.nio.ByteBuffer bufferForTable() {
      return org.apache.thrift.TBaseHelper.copyBinary(table);
    }

    /**
     * table to apply the mutations
     */
    public mutateRow_args setTable(byte[] table) {
      this.table = table == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(table.clone());
      return this;
    }

    public mutateRow_args setTable(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table) {
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      return this;
    }

    public void unsetTable() {
      this.table = null;
    }

    /** Returns true if field table is set (has been assigned a value) and false otherwise */
    public boolean isSetTable() {
      return this.table != null;
    }

    public void setTableIsSet(boolean value) {
      if (!value) {
        this.table = null;
      }
    }

    /**
     * mutations to apply
     */
    @org.apache.thrift.annotation.Nullable
    public TRowMutations getTrowMutations() {
      return this.trowMutations;
    }

    /**
     * mutations to apply
     */
    public mutateRow_args setTrowMutations(@org.apache.thrift.annotation.Nullable TRowMutations trowMutations) {
      this.trowMutations = trowMutations;
      return this;
    }

    public void unsetTrowMutations() {
      this.trowMutations = null;
    }

    /** Returns true if field trowMutations is set (has been assigned a value) and false otherwise */
    public boolean isSetTrowMutations() {
      return this.trowMutations != null;
    }

    public void setTrowMutationsIsSet(boolean value) {
      if (!value) {
        this.trowMutations = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE:
        if (value == null) {
          unsetTable();
        } else {
          if (value instanceof byte[]) {
            setTable((byte[])value);
          } else {
            setTable((java.nio.ByteBuffer)value);
          }
        }
        break;

      case TROW_MUTATIONS:
        if (value == null) {
          unsetTrowMutations();
        } else {
          setTrowMutations((TRowMutations)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE:
        return getTable();

      case TROW_MUTATIONS:
        return getTrowMutations();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE:
        return isSetTable();
      case TROW_MUTATIONS:
        return isSetTrowMutations();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof mutateRow_args)
        return this.equals((mutateRow_args)that);
      return false;
    }

    public boolean equals(mutateRow_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_table = true && this.isSetTable();
      boolean that_present_table = true && that.isSetTable();
      if (this_present_table || that_present_table) {
        if (!(this_present_table && that_present_table))
          return false;
        if (!this.table.equals(that.table))
          return false;
      }

      boolean this_present_trowMutations = true && this.isSetTrowMutations();
      boolean that_present_trowMutations = true && that.isSetTrowMutations();
      if (this_present_trowMutations || that_present_trowMutations) {
        if (!(this_present_trowMutations && that_present_trowMutations))
          return false;
        if (!this.trowMutations.equals(that.trowMutations))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTable()) ? 131071 : 524287);
      if (isSetTable())
        hashCode = hashCode * 8191 + table.hashCode();

      hashCode = hashCode * 8191 + ((isSetTrowMutations()) ? 131071 : 524287);
      if (isSetTrowMutations())
        hashCode = hashCode * 8191 + trowMutations.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(mutateRow_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTable(), other.isSetTable());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTable()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.table, other.table);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTrowMutations(), other.isSetTrowMutations());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTrowMutations()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.trowMutations, other.trowMutations);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("mutateRow_args(");
      boolean first = true;

      sb.append("table:");
      if (this.table == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.table, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("trowMutations:");
      if (this.trowMutations == null) {
        sb.append("null");
      } else {
        sb.append(this.trowMutations);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (table == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'table' was not present! Struct: " + toString());
      }
      if (trowMutations == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'trowMutations' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
      if (trowMutations != null) {
        trowMutations.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class mutateRow_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public mutateRow_argsStandardScheme getScheme() {
        return new mutateRow_argsStandardScheme();
      }
    }

    private static class mutateRow_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<mutateRow_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, mutateRow_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.table = iprot.readBinary();
                struct.setTableIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TROW_MUTATIONS
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.trowMutations = new TRowMutations();
                struct.trowMutations.read(iprot);
                struct.setTrowMutationsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, mutateRow_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.table != null) {
          oprot.writeFieldBegin(TABLE_FIELD_DESC);
          oprot.writeBinary(struct.table);
          oprot.writeFieldEnd();
        }
        if (struct.trowMutations != null) {
          oprot.writeFieldBegin(TROW_MUTATIONS_FIELD_DESC);
          struct.trowMutations.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class mutateRow_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public mutateRow_argsTupleScheme getScheme() {
        return new mutateRow_argsTupleScheme();
      }
    }

    private static class mutateRow_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<mutateRow_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, mutateRow_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        oprot.writeBinary(struct.table);
        struct.trowMutations.write(oprot);
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, mutateRow_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        struct.table = iprot.readBinary();
        struct.setTableIsSet(true);
        struct.trowMutations = new TRowMutations();
        struct.trowMutations.read(iprot);
        struct.setTrowMutationsIsSet(true);
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class mutateRow_result implements org.apache.thrift.TBase<mutateRow_result, mutateRow_result._Fields>, java.io.Serializable, Cloneable, Comparable<mutateRow_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("mutateRow_result");

    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new mutateRow_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new mutateRow_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable TIOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(mutateRow_result.class, metaDataMap);
    }

    public mutateRow_result() {
    }

    public mutateRow_result(
      TIOError io)
    {
      this();
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public mutateRow_result(mutateRow_result other) {
      if (other.isSetIo()) {
        this.io = new TIOError(other.io);
      }
    }

    public mutateRow_result deepCopy() {
      return new mutateRow_result(this);
    }

    @Override
    public void clear() {
      this.io = null;
    }

    @org.apache.thrift.annotation.Nullable
    public TIOError getIo() {
      return this.io;
    }

    public mutateRow_result setIo(@org.apache.thrift.annotation.Nullable TIOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((TIOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof mutateRow_result)
        return this.equals((mutateRow_result)that);
      return false;
    }

    public boolean equals(mutateRow_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(mutateRow_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetIo(), other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("mutateRow_result(");
      boolean first = true;

      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class mutateRow_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public mutateRow_resultStandardScheme getScheme() {
        return new mutateRow_resultStandardScheme();
      }
    }

    private static class mutateRow_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<mutateRow_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, mutateRow_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new TIOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, mutateRow_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class mutateRow_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public mutateRow_resultTupleScheme getScheme() {
        return new mutateRow_resultTupleScheme();
      }
    }

    private static class mutateRow_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<mutateRow_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, mutateRow_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetIo()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, mutateRow_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.io = new TIOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getScannerResults_args implements org.apache.thrift.TBase<getScannerResults_args, getScannerResults_args._Fields>, java.io.Serializable, Cloneable, Comparable<getScannerResults_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getScannerResults_args");

    private static final org.apache.thrift.protocol.TField TABLE_FIELD_DESC = new org.apache.thrift.protocol.TField("table", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField TSCAN_FIELD_DESC = new org.apache.thrift.protocol.TField("tscan", org.apache.thrift.protocol.TType.STRUCT, (short)2);
    private static final org.apache.thrift.protocol.TField NUM_ROWS_FIELD_DESC = new org.apache.thrift.protocol.TField("numRows", org.apache.thrift.protocol.TType.I32, (short)3);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getScannerResults_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getScannerResults_argsTupleSchemeFactory();

    /**
     * the table to get the Scanner for
     */
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table; // required
    /**
     * the scan object to get a Scanner for
     */
    public @org.apache.thrift.annotation.Nullable TScan tscan; // required
    /**
     * number of rows to return
     */
    public int numRows; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      /**
       * the table to get the Scanner for
       */
      TABLE((short)1, "table"),
      /**
       * the scan object to get a Scanner for
       */
      TSCAN((short)2, "tscan"),
      /**
       * number of rows to return
       */
      NUM_ROWS((short)3, "numRows");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE
            return TABLE;
          case 2: // TSCAN
            return TSCAN;
          case 3: // NUM_ROWS
            return NUM_ROWS;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __NUMROWS_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE, new org.apache.thrift.meta_data.FieldMetaData("table", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.TSCAN, new org.apache.thrift.meta_data.FieldMetaData("tscan", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TScan.class)));
      tmpMap.put(_Fields.NUM_ROWS, new org.apache.thrift.meta_data.FieldMetaData("numRows", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getScannerResults_args.class, metaDataMap);
    }

    public getScannerResults_args() {
      this.numRows = 1;

    }

    public getScannerResults_args(
      java.nio.ByteBuffer table,
      TScan tscan,
      int numRows)
    {
      this();
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      this.tscan = tscan;
      this.numRows = numRows;
      setNumRowsIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getScannerResults_args(getScannerResults_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTable()) {
        this.table = org.apache.thrift.TBaseHelper.copyBinary(other.table);
      }
      if (other.isSetTscan()) {
        this.tscan = new TScan(other.tscan);
      }
      this.numRows = other.numRows;
    }

    public getScannerResults_args deepCopy() {
      return new getScannerResults_args(this);
    }

    @Override
    public void clear() {
      this.table = null;
      this.tscan = null;
      this.numRows = 1;

    }

    /**
     * the table to get the Scanner for
     */
    public byte[] getTable() {
      setTable(org.apache.thrift.TBaseHelper.rightSize(table));
      return table == null ? null : table.array();
    }

    public java.nio.ByteBuffer bufferForTable() {
      return org.apache.thrift.TBaseHelper.copyBinary(table);
    }

    /**
     * the table to get the Scanner for
     */
    public getScannerResults_args setTable(byte[] table) {
      this.table = table == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(table.clone());
      return this;
    }

    public getScannerResults_args setTable(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table) {
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      return this;
    }

    public void unsetTable() {
      this.table = null;
    }

    /** Returns true if field table is set (has been assigned a value) and false otherwise */
    public boolean isSetTable() {
      return this.table != null;
    }

    public void setTableIsSet(boolean value) {
      if (!value) {
        this.table = null;
      }
    }

    /**
     * the scan object to get a Scanner for
     */
    @org.apache.thrift.annotation.Nullable
    public TScan getTscan() {
      return this.tscan;
    }

    /**
     * the scan object to get a Scanner for
     */
    public getScannerResults_args setTscan(@org.apache.thrift.annotation.Nullable TScan tscan) {
      this.tscan = tscan;
      return this;
    }

    public void unsetTscan() {
      this.tscan = null;
    }

    /** Returns true if field tscan is set (has been assigned a value) and false otherwise */
    public boolean isSetTscan() {
      return this.tscan != null;
    }

    public void setTscanIsSet(boolean value) {
      if (!value) {
        this.tscan = null;
      }
    }

    /**
     * number of rows to return
     */
    public int getNumRows() {
      return this.numRows;
    }

    /**
     * number of rows to return
     */
    public getScannerResults_args setNumRows(int numRows) {
      this.numRows = numRows;
      setNumRowsIsSet(true);
      return this;
    }

    public void unsetNumRows() {
      __isset_bitfield = org.apache.thrift.EncodingUtils.clearBit(__isset_bitfield, __NUMROWS_ISSET_ID);
    }

    /** Returns true if field numRows is set (has been assigned a value) and false otherwise */
    public boolean isSetNumRows() {
      return org.apache.thrift.EncodingUtils.testBit(__isset_bitfield, __NUMROWS_ISSET_ID);
    }

    public void setNumRowsIsSet(boolean value) {
      __isset_bitfield = org.apache.thrift.EncodingUtils.setBit(__isset_bitfield, __NUMROWS_ISSET_ID, value);
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case TABLE:
        if (value == null) {
          unsetTable();
        } else {
          if (value instanceof byte[]) {
            setTable((byte[])value);
          } else {
            setTable((java.nio.ByteBuffer)value);
          }
        }
        break;

      case TSCAN:
        if (value == null) {
          unsetTscan();
        } else {
          setTscan((TScan)value);
        }
        break;

      case NUM_ROWS:
        if (value == null) {
          unsetNumRows();
        } else {
          setNumRows((java.lang.Integer)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case TABLE:
        return getTable();

      case TSCAN:
        return getTscan();

      case NUM_ROWS:
        return getNumRows();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case TABLE:
        return isSetTable();
      case TSCAN:
        return isSetTscan();
      case NUM_ROWS:
        return isSetNumRows();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof getScannerResults_args)
        return this.equals((getScannerResults_args)that);
      return false;
    }

    public boolean equals(getScannerResults_args that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_table = true && this.isSetTable();
      boolean that_present_table = true && that.isSetTable();
      if (this_present_table || that_present_table) {
        if (!(this_present_table && that_present_table))
          return false;
        if (!this.table.equals(that.table))
          return false;
      }

      boolean this_present_tscan = true && this.isSetTscan();
      boolean that_present_tscan = true && that.isSetTscan();
      if (this_present_tscan || that_present_tscan) {
        if (!(this_present_tscan && that_present_tscan))
          return false;
        if (!this.tscan.equals(that.tscan))
          return false;
      }

      boolean this_present_numRows = true;
      boolean that_present_numRows = true;
      if (this_present_numRows || that_present_numRows) {
        if (!(this_present_numRows && that_present_numRows))
          return false;
        if (this.numRows != that.numRows)
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetTable()) ? 131071 : 524287);
      if (isSetTable())
        hashCode = hashCode * 8191 + table.hashCode();

      hashCode = hashCode * 8191 + ((isSetTscan()) ? 131071 : 524287);
      if (isSetTscan())
        hashCode = hashCode * 8191 + tscan.hashCode();

      hashCode = hashCode * 8191 + numRows;

      return hashCode;
    }

    @Override
    public int compareTo(getScannerResults_args other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetTable(), other.isSetTable());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTable()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.table, other.table);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetTscan(), other.isSetTscan());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetTscan()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.tscan, other.tscan);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetNumRows(), other.isSetNumRows());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetNumRows()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.numRows, other.numRows);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
    }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getScannerResults_args(");
      boolean first = true;

      sb.append("table:");
      if (this.table == null) {
        sb.append("null");
      } else {
        org.apache.thrift.TBaseHelper.toString(this.table, sb);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("tscan:");
      if (this.tscan == null) {
        sb.append("null");
      } else {
        sb.append(this.tscan);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("numRows:");
      sb.append(this.numRows);
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      if (table == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'table' was not present! Struct: " + toString());
      }
      if (tscan == null) {
        throw new org.apache.thrift.protocol.TProtocolException("Required field 'tscan' was not present! Struct: " + toString());
      }
      // check for sub-struct validity
      if (tscan != null) {
        tscan.validate();
      }
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
        __isset_bitfield = 0;
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getScannerResults_argsStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getScannerResults_argsStandardScheme getScheme() {
        return new getScannerResults_argsStandardScheme();
      }
    }

    private static class getScannerResults_argsStandardScheme extends org.apache.thrift.scheme.StandardScheme<getScannerResults_args> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getScannerResults_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 1: // TABLE
              if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
                struct.table = iprot.readBinary();
                struct.setTableIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 2: // TSCAN
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.tscan = new TScan();
                struct.tscan.read(iprot);
                struct.setTscanIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 3: // NUM_ROWS
              if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
                struct.numRows = iprot.readI32();
                struct.setNumRowsIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getScannerResults_args struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.table != null) {
          oprot.writeFieldBegin(TABLE_FIELD_DESC);
          oprot.writeBinary(struct.table);
          oprot.writeFieldEnd();
        }
        if (struct.tscan != null) {
          oprot.writeFieldBegin(TSCAN_FIELD_DESC);
          struct.tscan.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(NUM_ROWS_FIELD_DESC);
        oprot.writeI32(struct.numRows);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getScannerResults_argsTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getScannerResults_argsTupleScheme getScheme() {
        return new getScannerResults_argsTupleScheme();
      }
    }

    private static class getScannerResults_argsTupleScheme extends org.apache.thrift.scheme.TupleScheme<getScannerResults_args> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getScannerResults_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        oprot.writeBinary(struct.table);
        struct.tscan.write(oprot);
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetNumRows()) {
          optionals.set(0);
        }
        oprot.writeBitSet(optionals, 1);
        if (struct.isSetNumRows()) {
          oprot.writeI32(struct.numRows);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getScannerResults_args struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        struct.table = iprot.readBinary();
        struct.setTableIsSet(true);
        struct.tscan = new TScan();
        struct.tscan.read(iprot);
        struct.setTscanIsSet(true);
        java.util.BitSet incoming = iprot.readBitSet(1);
        if (incoming.get(0)) {
          struct.numRows = iprot.readI32();
          struct.setNumRowsIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getScannerResults_result implements org.apache.thrift.TBase<getScannerResults_result, getScannerResults_result._Fields>, java.io.Serializable, Cloneable, Comparable<getScannerResults_result>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getScannerResults_result");

    private static final org.apache.thrift.protocol.TField SUCCESS_FIELD_DESC = new org.apache.thrift.protocol.TField("success", org.apache.thrift.protocol.TType.LIST, (short)0);
    private static final org.apache.thrift.protocol.TField IO_FIELD_DESC = new org.apache.thrift.protocol.TField("io", org.apache.thrift.protocol.TType.STRUCT, (short)1);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getScannerResults_resultStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getScannerResults_resultTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.util.List<TResult> success; // required
    public @org.apache.thrift.annotation.Nullable TIOError io; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      SUCCESS((short)0, "success"),
      IO((short)1, "io");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 0: // SUCCESS
            return SUCCESS;
          case 1: // IO
            return IO;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.SUCCESS, new org.apache.thrift.meta_data.FieldMetaData("success", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.ListMetaData(org.apache.thrift.protocol.TType.LIST, 
              new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TResult.class))));
      tmpMap.put(_Fields.IO, new org.apache.thrift.meta_data.FieldMetaData("io", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TIOError.class)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getScannerResults_result.class, metaDataMap);
    }

    public getScannerResults_result() {
    }

    public getScannerResults_result(
      java.util.List<TResult> success,
      TIOError io)
    {
      this();
      this.success = success;
      this.io = io;
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getScannerResults_result(getScannerResults_result other) {
      if (other.isSetSuccess()) {
        java.util.List<TResult> __this__success = new java.util.ArrayList<TResult>(other.success.size());
        for (TResult other_element : other.success) {
          __this__success.add(new TResult(other_element));
        }
        this.success = __this__success;
      }
      if (other.isSetIo()) {
        this.io = new TIOError(other.io);
      }
    }

    public getScannerResults_result deepCopy() {
      return new getScannerResults_result(this);
    }

    @Override
    public void clear() {
      this.success = null;
      this.io = null;
    }

    public int getSuccessSize() {
      return (this.success == null) ? 0 : this.success.size();
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.Iterator<TResult> getSuccessIterator() {
      return (this.success == null) ? null : this.success.iterator();
    }

    public void addToSuccess(TResult elem) {
      if (this.success == null) {
        this.success = new java.util.ArrayList<TResult>();
      }
      this.success.add(elem);
    }

    @org.apache.thrift.annotation.Nullable
    public java.util.List<TResult> getSuccess() {
      return this.success;
    }

    public getScannerResults_result setSuccess(@org.apache.thrift.annotation.Nullable java.util.List<TResult> success) {
      this.success = success;
      return this;
    }

    public void unsetSuccess() {
      this.success = null;
    }

    /** Returns true if field success is set (has been assigned a value) and false otherwise */
    public boolean isSetSuccess() {
      return this.success != null;
    }

    public void setSuccessIsSet(boolean value) {
      if (!value) {
        this.success = null;
      }
    }

    @org.apache.thrift.annotation.Nullable
    public TIOError getIo() {
      return this.io;
    }

    public getScannerResults_result setIo(@org.apache.thrift.annotation.Nullable TIOError io) {
      this.io = io;
      return this;
    }

    public void unsetIo() {
      this.io = null;
    }

    /** Returns true if field io is set (has been assigned a value) and false otherwise */
    public boolean isSetIo() {
      return this.io != null;
    }

    public void setIoIsSet(boolean value) {
      if (!value) {
        this.io = null;
      }
    }

    public void setFieldValue(_Fields field, @org.apache.thrift.annotation.Nullable java.lang.Object value) {
      switch (field) {
      case SUCCESS:
        if (value == null) {
          unsetSuccess();
        } else {
          setSuccess((java.util.List<TResult>)value);
        }
        break;

      case IO:
        if (value == null) {
          unsetIo();
        } else {
          setIo((TIOError)value);
        }
        break;

      }
    }

    @org.apache.thrift.annotation.Nullable
    public java.lang.Object getFieldValue(_Fields field) {
      switch (field) {
      case SUCCESS:
        return getSuccess();

      case IO:
        return getIo();

      }
      throw new java.lang.IllegalStateException();
    }

    /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
    public boolean isSet(_Fields field) {
      if (field == null) {
        throw new java.lang.IllegalArgumentException();
      }

      switch (field) {
      case SUCCESS:
        return isSetSuccess();
      case IO:
        return isSetIo();
      }
      throw new java.lang.IllegalStateException();
    }

    @Override
    public boolean equals(java.lang.Object that) {
      if (that instanceof getScannerResults_result)
        return this.equals((getScannerResults_result)that);
      return false;
    }

    public boolean equals(getScannerResults_result that) {
      if (that == null)
        return false;
      if (this == that)
        return true;

      boolean this_present_success = true && this.isSetSuccess();
      boolean that_present_success = true && that.isSetSuccess();
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_io = true && this.isSetIo();
      boolean that_present_io = true && that.isSetIo();
      if (this_present_io || that_present_io) {
        if (!(this_present_io && that_present_io))
          return false;
        if (!this.io.equals(that.io))
          return false;
      }

      return true;
    }

    @Override
    public int hashCode() {
      int hashCode = 1;

      hashCode = hashCode * 8191 + ((isSetSuccess()) ? 131071 : 524287);
      if (isSetSuccess())
        hashCode = hashCode * 8191 + success.hashCode();

      hashCode = hashCode * 8191 + ((isSetIo()) ? 131071 : 524287);
      if (isSetIo())
        hashCode = hashCode * 8191 + io.hashCode();

      return hashCode;
    }

    @Override
    public int compareTo(getScannerResults_result other) {
      if (!getClass().equals(other.getClass())) {
        return getClass().getName().compareTo(other.getClass().getName());
      }

      int lastComparison = 0;

      lastComparison = java.lang.Boolean.compare(isSetSuccess(), other.isSetSuccess());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetSuccess()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.success, other.success);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      lastComparison = java.lang.Boolean.compare(isSetIo(), other.isSetIo());
      if (lastComparison != 0) {
        return lastComparison;
      }
      if (isSetIo()) {
        lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.io, other.io);
        if (lastComparison != 0) {
          return lastComparison;
        }
      }
      return 0;
    }

    @org.apache.thrift.annotation.Nullable
    public _Fields fieldForId(int fieldId) {
      return _Fields.findByThriftId(fieldId);
    }

    public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
      scheme(iprot).read(iprot, this);
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
      scheme(oprot).write(oprot, this);
      }

    @Override
    public java.lang.String toString() {
      java.lang.StringBuilder sb = new java.lang.StringBuilder("getScannerResults_result(");
      boolean first = true;

      sb.append("success:");
      if (this.success == null) {
        sb.append("null");
      } else {
        sb.append(this.success);
      }
      first = false;
      if (!first) sb.append(", ");
      sb.append("io:");
      if (this.io == null) {
        sb.append("null");
      } else {
        sb.append(this.io);
      }
      first = false;
      sb.append(")");
      return sb.toString();
    }

    public void validate() throws org.apache.thrift.TException {
      // check for required fields
      // check for sub-struct validity
    }

    private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
      try {
        write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, java.lang.ClassNotFoundException {
      try {
        read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
      } catch (org.apache.thrift.TException te) {
        throw new java.io.IOException(te);
      }
    }

    private static class getScannerResults_resultStandardSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getScannerResults_resultStandardScheme getScheme() {
        return new getScannerResults_resultStandardScheme();
      }
    }

    private static class getScannerResults_resultStandardScheme extends org.apache.thrift.scheme.StandardScheme<getScannerResults_result> {

      public void read(org.apache.thrift.protocol.TProtocol iprot, getScannerResults_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TField schemeField;
        iprot.readStructBegin();
        while (true)
        {
          schemeField = iprot.readFieldBegin();
          if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
            break;
          }
          switch (schemeField.id) {
            case 0: // SUCCESS
              if (schemeField.type == org.apache.thrift.protocol.TType.LIST) {
                {
                  org.apache.thrift.protocol.TList _list254 = iprot.readListBegin();
                  struct.success = new java.util.ArrayList<TResult>(_list254.size);
                  @org.apache.thrift.annotation.Nullable TResult _elem255;
                  for (int _i256 = 0; _i256 < _list254.size; ++_i256)
                  {
                    _elem255 = new TResult();
                    _elem255.read(iprot);
                    struct.success.add(_elem255);
                  }
                  iprot.readListEnd();
                }
                struct.setSuccessIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            case 1: // IO
              if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
                struct.io = new TIOError();
                struct.io.read(iprot);
                struct.setIoIsSet(true);
              } else { 
                org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
              }
              break;
            default:
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
          }
          iprot.readFieldEnd();
        }
        iprot.readStructEnd();

        // check for required fields of primitive type, which can't be checked in the validate method
        struct.validate();
      }

      public void write(org.apache.thrift.protocol.TProtocol oprot, getScannerResults_result struct) throws org.apache.thrift.TException {
        struct.validate();

        oprot.writeStructBegin(STRUCT_DESC);
        if (struct.success != null) {
          oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
          {
            oprot.writeListBegin(new org.apache.thrift.protocol.TList(org.apache.thrift.protocol.TType.STRUCT, struct.success.size()));
            for (TResult _iter257 : struct.success)
            {
              _iter257.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
        if (struct.io != null) {
          oprot.writeFieldBegin(IO_FIELD_DESC);
          struct.io.write(oprot);
          oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
      }

    }

    private static class getScannerResults_resultTupleSchemeFactory implements org.apache.thrift.scheme.SchemeFactory {
      public getScannerResults_resultTupleScheme getScheme() {
        return new getScannerResults_resultTupleScheme();
      }
    }

    private static class getScannerResults_resultTupleScheme extends org.apache.thrift.scheme.TupleScheme<getScannerResults_result> {

      @Override
      public void write(org.apache.thrift.protocol.TProtocol prot, getScannerResults_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol oprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet optionals = new java.util.BitSet();
        if (struct.isSetSuccess()) {
          optionals.set(0);
        }
        if (struct.isSetIo()) {
          optionals.set(1);
        }
        oprot.writeBitSet(optionals, 2);
        if (struct.isSetSuccess()) {
          {
            oprot.writeI32(struct.success.size());
            for (TResult _iter258 : struct.success)
            {
              _iter258.write(oprot);
            }
          }
        }
        if (struct.isSetIo()) {
          struct.io.write(oprot);
        }
      }

      @Override
      public void read(org.apache.thrift.protocol.TProtocol prot, getScannerResults_result struct) throws org.apache.thrift.TException {
        org.apache.thrift.protocol.TTupleProtocol iprot = (org.apache.thrift.protocol.TTupleProtocol) prot;
        java.util.BitSet incoming = iprot.readBitSet(2);
        if (incoming.get(0)) {
          {
            org.apache.thrift.protocol.TList _list259 = iprot.readListBegin(org.apache.thrift.protocol.TType.STRUCT);
            struct.success = new java.util.ArrayList<TResult>(_list259.size);
            @org.apache.thrift.annotation.Nullable TResult _elem260;
            for (int _i261 = 0; _i261 < _list259.size; ++_i261)
            {
              _elem260 = new TResult();
              _elem260.read(iprot);
              struct.success.add(_elem260);
            }
          }
          struct.setSuccessIsSet(true);
        }
        if (incoming.get(1)) {
          struct.io = new TIOError();
          struct.io.read(iprot);
          struct.setIoIsSet(true);
        }
      }
    }

    private static <S extends org.apache.thrift.scheme.IScheme> S scheme(org.apache.thrift.protocol.TProtocol proto) {
      return (org.apache.thrift.scheme.StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }
  }

  public static class getRegionLocation_args implements org.apache.thrift.TBase<getRegionLocation_args, getRegionLocation_args._Fields>, java.io.Serializable, Cloneable, Comparable<getRegionLocation_args>   {
    private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("getRegionLocation_args");

    private static final org.apache.thrift.protocol.TField TABLE_FIELD_DESC = new org.apache.thrift.protocol.TField("table", org.apache.thrift.protocol.TType.STRING, (short)1);
    private static final org.apache.thrift.protocol.TField ROW_FIELD_DESC = new org.apache.thrift.protocol.TField("row", org.apache.thrift.protocol.TType.STRING, (short)2);
    private static final org.apache.thrift.protocol.TField RELOAD_FIELD_DESC = new org.apache.thrift.protocol.TField("reload", org.apache.thrift.protocol.TType.BOOL, (short)3);

    private static final org.apache.thrift.scheme.SchemeFactory STANDARD_SCHEME_FACTORY = new getRegionLocation_argsStandardSchemeFactory();
    private static final org.apache.thrift.scheme.SchemeFactory TUPLE_SCHEME_FACTORY = new getRegionLocation_argsTupleSchemeFactory();

    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table; // required
    public @org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row; // required
    public boolean reload; // required

    /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
    public enum _Fields implements org.apache.thrift.TFieldIdEnum {
      TABLE((short)1, "table"),
      ROW((short)2, "row"),
      RELOAD((short)3, "reload");

      private static final java.util.Map<java.lang.String, _Fields> byName = new java.util.HashMap<java.lang.String, _Fields>();

      static {
        for (_Fields field : java.util.EnumSet.allOf(_Fields.class)) {
          byName.put(field.getFieldName(), field);
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByThriftId(int fieldId) {
        switch(fieldId) {
          case 1: // TABLE
            return TABLE;
          case 2: // ROW
            return ROW;
          case 3: // RELOAD
            return RELOAD;
          default:
            return null;
        }
      }

      /**
       * Find the _Fields constant that matches fieldId, throwing an exception
       * if it is not found.
       */
      public static _Fields findByThriftIdOrThrow(int fieldId) {
        _Fields fields = findByThriftId(fieldId);
        if (fields == null) throw new java.lang.IllegalArgumentException("Field " + fieldId + " doesn't exist!");
        return fields;
      }

      /**
       * Find the _Fields constant that matches name, or null if its not found.
       */
      @org.apache.thrift.annotation.Nullable
      public static _Fields findByName(java.lang.String name) {
        return byName.get(name);
      }

      private final short _thriftId;
      private final java.lang.String _fieldName;

      _Fields(short thriftId, java.lang.String fieldName) {
        _thriftId = thriftId;
        _fieldName = fieldName;
      }

      public short getThriftFieldId() {
        return _thriftId;
      }

      public java.lang.String getFieldName() {
        return _fieldName;
      }
    }

    // isset id assignments
    private static final int __RELOAD_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    public static final java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
    static {
      java.util.Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new java.util.EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
      tmpMap.put(_Fields.TABLE, new org.apache.thrift.meta_data.FieldMetaData("table", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.ROW, new org.apache.thrift.meta_data.FieldMetaData("row", org.apache.thrift.TFieldRequirementType.REQUIRED, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING          , true)));
      tmpMap.put(_Fields.RELOAD, new org.apache.thrift.meta_data.FieldMetaData("reload", org.apache.thrift.TFieldRequirementType.DEFAULT, 
          new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.BOOL)));
      metaDataMap = java.util.Collections.unmodifiableMap(tmpMap);
      org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(getRegionLocation_args.class, metaDataMap);
    }

    public getRegionLocation_args() {
    }

    public getRegionLocation_args(
      java.nio.ByteBuffer table,
      java.nio.ByteBuffer row,
      boolean reload)
    {
      this();
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      this.row = org.apache.thrift.TBaseHelper.copyBinary(row);
      this.reload = reload;
      setReloadIsSet(true);
    }

    /**
     * Performs a deep copy on <i>other</i>.
     */
    public getRegionLocation_args(getRegionLocation_args other) {
      __isset_bitfield = other.__isset_bitfield;
      if (other.isSetTable()) {
        this.table = org.apache.thrift.TBaseHelper.copyBinary(other.table);
      }
      if (other.isSetRow()) {
        this.row = org.apache.thrift.TBaseHelper.copyBinary(other.row);
      }
      this.reload = other.reload;
    }

    public getRegionLocation_args deepCopy() {
      return new getRegionLocation_args(this);
    }

    @Override
    public void clear() {
      this.table = null;
      this.row = null;
      setReloadIsSet(false);
      this.reload = false;
    }

    public byte[] getTable() {
      setTable(org.apache.thrift.TBaseHelper.rightSize(table));
      return table == null ? null : table.array();
    }

    public java.nio.ByteBuffer bufferForTable() {
      return org.apache.thrift.TBaseHelper.copyBinary(table);
    }

    public getRegionLocation_args setTable(byte[] table) {
      this.table = table == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(table.clone());
      return this;
    }

    public getRegionLocation_args setTable(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer table) {
      this.table = org.apache.thrift.TBaseHelper.copyBinary(table);
      return this;
    }

    public void unsetTable() {
      this.table = null;
    }

    /** Returns true if field table is set (has been assigned a value) and false otherwise */
    public boolean isSetTable() {
      return this.table != null;
    }

    public void setTableIsSet(boolean value) {
      if (!value) {
        this.table = null;
      }
    }

    public byte[] getRow() {
      setRow(org.apache.thrift.TBaseHelper.rightSize(row));
      return row == null ? null : row.array();
    }

    public java.nio.ByteBuffer bufferForRow() {
      return org.apache.thrift.TBaseHelper.copyBinary(row);
    }

    public getRegionLocation_args setRow(byte[] row) {
      this.row = row == null ? (java.nio.ByteBuffer)null     : java.nio.ByteBuffer.wrap(row.clone());
      return this;
    }

    public getRegionLocation_args setRow(@org.apache.thrift.annotation.Nullable java.nio.ByteBuffer row) {
      t