/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap.user;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.ldap.ConnectedLDAPConfiguration;
import org.apache.guacamole.auth.ldap.ObjectQueryService;
import org.apache.guacamole.auth.ldap.conf.LDAPConfiguration;
import org.apache.guacamole.auth.ldap.conf.LDAPGuacamoleProperties;
import org.apache.guacamole.auth.ldap.user.LDAPAuthenticatedUser;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.simple.SimpleUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserService {
    private static final Logger logger = LoggerFactory.getLogger(UserService.class);
    @Inject
    private ObjectQueryService queryService;

    public Map<String, User> getUsers(LDAPAuthenticatedUser user) throws GuacamoleException {
        ConnectedLDAPConfiguration config = user.getLDAPConfiguration();
        Collection<String> usernameAttrs = config.getUsernameAttributes();
        HashSet<String> attributes = new HashSet<String>(usernameAttrs);
        attributes.addAll(config.getAttributes());
        List<Entry> results = this.queryService.search(config, config.getLDAPConnection(), config.getUserBaseDN(), config.getUserSearchFilter(), usernameAttrs, null, attributes);
        return this.queryService.asMap(results, entry -> {
            try {
                String username = this.queryService.getIdentifier((Entry)entry, (Collection<String>)attributes);
                if (username == null) {
                    logger.warn("User \"{}\" is missing a username attribute and will be ignored.", (Object)entry.getDn().toString());
                    return null;
                }
                return new SimpleUser(username);
            }
            catch (LdapInvalidAttributeValueException e) {
                return null;
            }
        });
    }

    public List<Dn> getUserDNs(LDAPConfiguration config, LdapNetworkConnection ldapConnection, String username) throws GuacamoleException {
        List<Entry> results = this.queryService.search(config, ldapConnection, config.getUserBaseDN(), config.getUserSearchFilter(), config.getUsernameAttributes(), username, Collections.singletonList("dn"));
        ArrayList<Dn> userDNs = new ArrayList<Dn>(results.size());
        results.forEach(entry -> userDNs.add(entry.getDn()));
        return userDNs;
    }

    public Dn deriveUserDN(LDAPConfiguration config, String username) throws GuacamoleException {
        ArrayList<String> usernameAttributes = new ArrayList<String>(config.getUsernameAttributes());
        if (usernameAttributes.size() != 1) {
            logger.warn(String.format("Cannot directly derive user DN when multiple username attributes are specified. Please define an LDAP search DN using the \"%s\" property in your \"guacamole.properties\".", LDAPGuacamoleProperties.LDAP_SEARCH_BIND_DN.getName()));
            return null;
        }
        try {
            return new Dn(new Rdn((String)usernameAttributes.get(0), username), config.getUserBaseDN());
        }
        catch (LdapInvalidAttributeValueException | LdapInvalidDnException e) {
            throw new GuacamoleServerException("Error trying to derive user DN.", e);
        }
    }
}

