/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.internal.PdxInstanceFactoryImpl;
import org.apache.geode.pdx.internal.json.JSONToPdxMapper;
import org.apache.geode.pdx.internal.json.PdxListHelper;
import org.apache.logging.log4j.Logger;

public class PdxInstanceHelper
implements JSONToPdxMapper {
    private static final Logger logger = LogService.getLogger();
    JSONToPdxMapper m_parent;
    PdxInstanceFactoryImpl m_pdxInstanceFactory;
    PdxInstance m_pdxInstance;
    String m_PdxName;
    private Set<String> identityFields;

    private InternalCache getCache() {
        return (InternalCache)CacheFactory.getAnyInstance();
    }

    public PdxInstanceHelper(String className, JSONToPdxMapper parent, String ... identityFields) {
        InternalCache cache = this.getCache();
        if (logger.isTraceEnabled()) {
            logger.trace("ClassName {}", (Object)className);
        }
        this.m_PdxName = className;
        this.m_parent = parent;
        this.m_pdxInstanceFactory = (PdxInstanceFactoryImpl)cache.createPdxInstanceFactory("__GEMFIRE_JSON", false);
        this.initializeIdentityFields(identityFields);
    }

    public void initializeIdentityFields(String ... identityFields) {
        this.identityFields = new HashSet<String>();
        for (String identityField : identityFields) {
            this.identityFields.add(identityField);
        }
    }

    @Override
    public JSONToPdxMapper getParent() {
        return this.m_parent;
    }

    @Override
    public void setPdxFieldName(String name) {
        if (logger.isTraceEnabled()) {
            logger.trace("setPdxClassName : {}", (Object)name);
        }
        this.m_PdxName = name;
    }

    @Override
    public void addStringField(String fieldName, String value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addStringField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, value);
        this.addIdentityField(fieldName);
    }

    @Override
    public void addByteField(String fieldName, byte value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addByteField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeByte(fieldName, value);
        this.addIdentityField(fieldName);
    }

    @Override
    public void addShortField(String fieldName, short value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addShortField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeShort(fieldName, value);
        this.addIdentityField(fieldName);
    }

    @Override
    public void addIntField(String fieldName, int value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addIntField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeInt(fieldName, value);
        this.addIdentityField(fieldName);
    }

    @Override
    public void addLongField(String fieldName, long value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addLongField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeLong(fieldName, value);
        this.addIdentityField(fieldName);
    }

    @Override
    public void addBigDecimalField(String fieldName, BigDecimal value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBigDecimalField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, value);
        this.addIdentityField(fieldName);
    }

    @Override
    public void addBigIntegerField(String fieldName, BigInteger value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBigIntegerField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, value);
        this.addIdentityField(fieldName);
    }

    @Override
    public void addBooleanField(String fieldName, boolean value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBooleanField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeBoolean(fieldName, value);
        this.addIdentityField(fieldName);
    }

    @Override
    public void addFloatField(String fieldName, float value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addFloatField fieldName: {}; value: {}", (Object)fieldName, (Object)Float.valueOf(value));
        }
        this.m_pdxInstanceFactory.writeFloat(fieldName, value);
        this.addIdentityField(fieldName);
    }

    @Override
    public void addDoubleField(String fieldName, double value) {
        if (logger.isTraceEnabled()) {
            logger.trace("addDoubleField fieldName: {}; value: {}", (Object)fieldName, (Object)value);
        }
        this.m_pdxInstanceFactory.writeDouble(fieldName, value);
        this.addIdentityField(fieldName);
    }

    @Override
    public void addNullField(String fieldName) {
        if (logger.isTraceEnabled()) {
            logger.trace("addNullField fieldName: {}; value: NULL", (Object)fieldName);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, null);
        this.addIdentityField(fieldName);
    }

    @Override
    public void addListField(String fieldName, PdxListHelper list) {
        if (logger.isTraceEnabled()) {
            logger.trace("addListField fieldName: {}", (Object)fieldName);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, list.getList());
        this.addIdentityField(fieldName);
    }

    @Override
    public void endListField(String fieldName) {
        if (logger.isTraceEnabled()) {
            logger.trace("endListField fieldName: {}", (Object)fieldName);
        }
    }

    @Override
    public void addObjectField(String fieldName, Object member) {
        if (logger.isTraceEnabled()) {
            logger.trace("addObjectField fieldName: {}", (Object)fieldName);
        }
        if (fieldName == null) {
            throw new IllegalStateException("addObjectField:Object should have fieldname");
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, member);
    }

    @Override
    public void endObjectField(String fieldName) {
        if (logger.isTraceEnabled()) {
            logger.trace("endObjectField fieldName: {}", (Object)fieldName);
        }
        this.m_pdxInstance = this.m_pdxInstanceFactory.create();
    }

    private void addIdentityField(String fieldName) {
        if (this.identityFields.contains(fieldName)) {
            this.m_pdxInstanceFactory.markIdentityField(fieldName);
        }
    }

    @Override
    public PdxInstance getPdxInstance() {
        return this.m_pdxInstance;
    }

    @Override
    public String getPdxFieldName() {
        return this.m_PdxName;
    }
}

