/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util.redaction;

import java.util.function.Function;
import java.util.regex.Matcher;
import org.apache.geode.internal.util.redaction.ParserRegex;
import org.apache.geode.internal.util.redaction.RedactionStrategy;

class RegexRedactionStrategy
implements RedactionStrategy {
    private final Function<String, Boolean> isSensitive;
    private final String redacted;

    RegexRedactionStrategy(Function<String, Boolean> isSensitive, String redacted) {
        this.isSensitive = isSensitive;
        this.redacted = redacted;
    }

    @Override
    public String redact(String string) {
        Matcher matcher = ParserRegex.getPattern().matcher(string);
        while (matcher.find()) {
            String option = matcher.group(2);
            if (!this.isSensitive.apply(option).booleanValue()) continue;
            String leadingBoundary = matcher.group(1);
            String separator = matcher.group(3);
            String withRedaction = leadingBoundary + option + separator + this.redacted;
            string = string.replace(matcher.group(), withRedaction);
        }
        return string;
    }
}

