/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.internal.process.ProcessUtils;
import org.apache.geode.internal.statistics.LocalStatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsImpl;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public abstract class AbstractStatisticsFactory
implements StatisticsFactory,
StatisticsManager {
    private final String name;
    private final CopyOnWriteArrayList<Statistics> statsList;
    private int statsListModCount = 0;
    private long statsListUniqueId = 1L;
    private final Object statsListUniqueIdLock;
    private final StatisticsTypeFactory tf;
    private final long startTime;

    public AbstractStatisticsFactory(long id, String name, long startTime) {
        this.name = name;
        this.startTime = startTime;
        this.statsList = new CopyOnWriteArrayList();
        this.statsListUniqueIdLock = new Object();
        this.tf = StatisticsTypeFactoryImpl.singleton();
    }

    public void close() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPid() {
        return ProcessUtils.identifyPidAsUnchecked();
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getStatListModCount() {
        return this.statsListModCount;
    }

    @Override
    public List<Statistics> getStatsList() {
        return this.statsList;
    }

    @Override
    public int getStatisticsCount() {
        int result = 0;
        CopyOnWriteArrayList<Statistics> statsList = this.statsList;
        if (statsList != null) {
            result = statsList.size();
        }
        return result;
    }

    @Override
    public boolean statisticsExists(long id) {
        CopyOnWriteArrayList<Statistics> statsList = this.statsList;
        for (Statistics s : statsList) {
            if (s.getUniqueId() != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public Statistics[] getStatistics() {
        CopyOnWriteArrayList<Statistics> statsList = this.statsList;
        return statsList.toArray(new Statistics[statsList.size()]);
    }

    @Override
    public Statistics createStatistics(StatisticsType type) {
        return this.createOsStatistics(type, null, 0L, 0);
    }

    @Override
    public Statistics createStatistics(StatisticsType type, String textId) {
        return this.createOsStatistics(type, textId, 0L, 0);
    }

    @Override
    public Statistics createStatistics(StatisticsType type, String textId, long numericId) {
        return this.createOsStatistics(type, textId, 0L, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statistics createOsStatistics(StatisticsType type, String textId, long numericId, int osStatFlags) {
        long myUniqueId;
        Object object = this.statsListUniqueIdLock;
        synchronized (object) {
            myUniqueId = this.statsListUniqueId++;
        }
        LocalStatisticsImpl result = new LocalStatisticsImpl(type, textId, numericId, myUniqueId, false, osStatFlags, this);
        CopyOnWriteArrayList<Statistics> copyOnWriteArrayList = this.statsList;
        synchronized (copyOnWriteArrayList) {
            this.statsList.add(result);
            ++this.statsListModCount;
        }
        return result;
    }

    @Override
    public Statistics[] findStatisticsByType(StatisticsType type) {
        ArrayList<Statistics> hits = new ArrayList<Statistics>();
        for (Statistics s : this.statsList) {
            if (type != s.getType()) continue;
            hits.add(s);
        }
        Statistics[] result = new Statistics[hits.size()];
        return hits.toArray(result);
    }

    @Override
    public Statistics[] findStatisticsByTextId(String textId) {
        ArrayList<Statistics> hits = new ArrayList<Statistics>();
        for (Statistics s : this.statsList) {
            if (!s.getTextId().equals(textId)) continue;
            hits.add(s);
        }
        Statistics[] result = new Statistics[hits.size()];
        return hits.toArray(result);
    }

    @Override
    public Statistics[] findStatisticsByNumericId(long numericId) {
        ArrayList<Statistics> hits = new ArrayList<Statistics>();
        for (Statistics s : this.statsList) {
            if (numericId != s.getNumericId()) continue;
            hits.add(s);
        }
        Statistics[] result = new Statistics[hits.size()];
        return hits.toArray(result);
    }

    @Override
    public Statistics findStatisticsByUniqueId(long uniqueId) {
        for (Statistics s : this.statsList) {
            if (uniqueId != s.getUniqueId()) continue;
            return s;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyStatistics(Statistics stats) {
        CopyOnWriteArrayList<Statistics> copyOnWriteArrayList = this.statsList;
        synchronized (copyOnWriteArrayList) {
            if (this.statsList.remove(stats)) {
                ++this.statsListModCount;
            }
        }
    }

    @Override
    public Statistics createAtomicStatistics(StatisticsType type) {
        return this.createAtomicStatistics(type, null, 0L);
    }

    @Override
    public Statistics createAtomicStatistics(StatisticsType type, String textId) {
        return this.createAtomicStatistics(type, textId, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statistics createAtomicStatistics(StatisticsType type, String textId, long numericId) {
        long myUniqueId;
        Object object = this.statsListUniqueIdLock;
        synchronized (object) {
            myUniqueId = this.statsListUniqueId++;
        }
        Statistics result = StatisticsImpl.createAtomicNoOS(type, textId, numericId, myUniqueId, this);
        CopyOnWriteArrayList<Statistics> copyOnWriteArrayList = this.statsList;
        synchronized (copyOnWriteArrayList) {
            this.statsList.add(result);
            ++this.statsListModCount;
        }
        return result;
    }

    @Override
    public StatisticsType createType(String name, String description, StatisticDescriptor[] stats) {
        return this.tf.createType(name, description, stats);
    }

    @Override
    public StatisticsType findType(String name) {
        return this.tf.findType(name);
    }

    @Override
    public StatisticsType[] createTypesFromXml(Reader reader) throws IOException {
        return this.tf.createTypesFromXml(reader);
    }

    @Override
    public StatisticDescriptor createIntCounter(String name, String description, String units) {
        return this.createLongCounter(name, description, units);
    }

    @Override
    public StatisticDescriptor createLongCounter(String name, String description, String units) {
        return this.tf.createLongCounter(name, description, units);
    }

    @Override
    public StatisticDescriptor createDoubleCounter(String name, String description, String units) {
        return this.tf.createDoubleCounter(name, description, units);
    }

    @Override
    public StatisticDescriptor createIntGauge(String name, String description, String units) {
        return this.createLongGauge(name, description, units);
    }

    @Override
    public StatisticDescriptor createLongGauge(String name, String description, String units) {
        return this.tf.createLongGauge(name, description, units);
    }

    @Override
    public StatisticDescriptor createDoubleGauge(String name, String description, String units) {
        return this.tf.createDoubleGauge(name, description, units);
    }

    @Override
    public StatisticDescriptor createIntCounter(String name, String description, String units, boolean largerBetter) {
        return this.createLongCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createLongCounter(String name, String description, String units, boolean largerBetter) {
        return this.tf.createLongCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createDoubleCounter(String name, String description, String units, boolean largerBetter) {
        return this.tf.createDoubleCounter(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createIntGauge(String name, String description, String units, boolean largerBetter) {
        return this.createLongGauge(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createLongGauge(String name, String description, String units, boolean largerBetter) {
        return this.tf.createLongGauge(name, description, units, largerBetter);
    }

    @Override
    public StatisticDescriptor createDoubleGauge(String name, String description, String units, boolean largerBetter) {
        return this.tf.createDoubleGauge(name, description, units, largerBetter);
    }
}

