/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import org.apache.geode.cache.CacheException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TransactionDataNodeHasDepartedException;
import org.apache.geode.cache.TransactionDataNotColocatedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.TXStateStub;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.tx.AbstractPeerTXRegionStub;
import org.apache.geode.internal.cache.tx.RemoteContainsKeyValueMessage;
import org.apache.geode.internal.cache.tx.RemoteDestroyMessage;
import org.apache.geode.internal.cache.tx.RemoteFetchEntryMessage;
import org.apache.geode.internal.cache.tx.RemoteGetMessage;
import org.apache.geode.internal.cache.tx.RemoteInvalidateMessage;
import org.apache.geode.internal.cache.tx.RemoteOperationMessage;
import org.apache.geode.internal.cache.tx.RemotePutAllMessage;
import org.apache.geode.internal.cache.tx.RemotePutMessage;
import org.apache.geode.internal.cache.tx.RemoteRemoveAllMessage;

public class DistributedTXRegionStub
extends AbstractPeerTXRegionStub {
    private final DistributedRegion region;

    public DistributedTXRegionStub(TXStateStub txstate, DistributedRegion r) {
        super(txstate);
        this.region = r;
    }

    @Override
    public void destroyExistingEntry(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) {
        try {
            RemoteOperationMessage.RemoteOperationResponse response = this.sendRemoteDestroyMessage(event, expectedOldValue);
            response.waitForRemoteResponse();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(String.format("Region %s not colocated with other regions in transaction", rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    RemoteOperationMessage.RemoteOperationResponse sendRemoteDestroyMessage(EntryEventImpl event, Object expectedOldValue) throws RemoteOperationException {
        return RemoteDestroyMessage.send(this.state.getTarget(), event.getRegion(), event, expectedOldValue, true, false);
    }

    @Override
    public Region.Entry getEntry(KeyInfo keyInfo, boolean allowTombstone) {
        try {
            RemoteFetchEntryMessage.FetchEntryResponse res = this.sendRemoteFetchEntryMessage((InternalDistributedMember)this.state.getTarget(), this.region, keyInfo.getKey());
            return res.waitForResponse();
        }
        catch (EntryNotFoundException enfe) {
            return null;
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(String.format("Region %s not colocated with other regions in transaction", rde.getRegionFullPath()), rde);
        }
        catch (TransactionException e) {
            throw e;
        }
        catch (CacheException | RemoteOperationException e) {
            throw new TransactionDataNodeHasDepartedException(e);
        }
    }

    RemoteFetchEntryMessage.FetchEntryResponse sendRemoteFetchEntryMessage(InternalDistributedMember recipient, LocalRegion region, Object key) throws RemoteOperationException {
        return RemoteFetchEntryMessage.send(recipient, region, key);
    }

    @Override
    public void invalidateExistingEntry(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        try {
            RemoteOperationMessage.RemoteOperationResponse response = this.sendRemoteInvalidateMessage(this.state.getTarget(), event);
            response.waitForRemoteResponse();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(String.format("Region %s not colocated with other regions in transaction", rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    RemoteOperationMessage.RemoteOperationResponse sendRemoteInvalidateMessage(DistributedMember recipient, EntryEventImpl event) throws RemoteOperationException {
        return RemoteInvalidateMessage.send(recipient, event.getRegion(), event, true, false);
    }

    @Override
    public boolean containsKey(KeyInfo keyInfo) {
        try {
            RemoteContainsKeyValueMessage.RemoteContainsKeyValueResponse response = this.sendRemoteContainsKeyValueMessage((InternalDistributedMember)this.state.getTarget(), keyInfo.getKey(), false);
            return response.waitForContainsResult();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(String.format("Region %s not colocated with other regions in transaction", rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    @Override
    public boolean containsValueForKey(KeyInfo keyInfo) {
        try {
            RemoteContainsKeyValueMessage.RemoteContainsKeyValueResponse response = this.sendRemoteContainsKeyValueMessage((InternalDistributedMember)this.state.getTarget(), keyInfo.getKey(), true);
            return response.waitForContainsResult();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(String.format("Region %s not colocated with other regions in transaction", rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    RemoteContainsKeyValueMessage.RemoteContainsKeyValueResponse sendRemoteContainsKeyValueMessage(InternalDistributedMember recipient, Object key, boolean valueCheck) throws RemoteOperationException {
        return RemoteContainsKeyValueMessage.send(recipient, this.region, key, valueCheck);
    }

    @Override
    public Object findObject(KeyInfo keyInfo, boolean isCreate, boolean generateCallbacks, Object value, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent) {
        Object retVal;
        Object key = keyInfo.getKey();
        Object callbackArgument = keyInfo.getCallbackArg();
        try {
            RemoteGetMessage.RemoteGetResponse response = this.sendRemoteGetMessage((InternalDistributedMember)this.state.getTarget(), key, callbackArgument, requestingClient);
            retVal = response.waitForResponse(preferCD);
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(String.format("Region %s not colocated with other regions in transaction", rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
        return retVal;
    }

    RemoteGetMessage.RemoteGetResponse sendRemoteGetMessage(InternalDistributedMember recipient, Object key, Object callbackArgument, ClientProxyMembershipID requestingClient) throws RemoteOperationException {
        return RemoteGetMessage.send(recipient, this.region, key, callbackArgument, requestingClient);
    }

    @Override
    public Object getEntryForIterator(KeyInfo keyInfo, boolean allowTombstone) {
        return this.getEntry(keyInfo, allowTombstone);
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) {
        boolean retVal;
        InternalRegion r = event.getRegion();
        try {
            RemotePutMessage.RemotePutResponse response = this.txSendRemotePutMessage(this.state.getTarget(), r, event, lastModified, ifNew, ifOld, expectedOldValue, requireOldValue);
            RemotePutMessage.PutResult result = response.waitForResult();
            event.setOldValue(result.oldValue, true);
            retVal = result.returnValue;
        }
        catch (TransactionDataNotColocatedException enfe) {
            throw enfe;
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(String.format("Region %s not colocated with other regions in transaction", rde.getRegionFullPath()), rde);
        }
        catch (CacheException | RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
        return retVal;
    }

    RemotePutMessage.RemotePutResponse txSendRemotePutMessage(DistributedMember recipient, InternalRegion r, EntryEventImpl event, long lastModified, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue) throws RemoteOperationException {
        return RemotePutMessage.txSend(recipient, r, event, lastModified, ifNew, ifOld, expectedOldValue, requireOldValue);
    }

    @Override
    public void postPutAll(DistributedPutAllOperation putallOp, VersionedObjectList successfulPuts, InternalRegion region) {
        try {
            RemotePutAllMessage.PutAllResponse response = this.sendRemotePutAllMessage(this.state.getTarget(), putallOp.getBaseEvent(), putallOp.getPutAllEntryData(), putallOp.getPutAllEntryData().length);
            response.waitForRemoteResponse();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(String.format("Region %s not colocated with other regions in transaction", rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    RemotePutAllMessage.PutAllResponse sendRemotePutAllMessage(DistributedMember recipient, EntryEventImpl event, DistributedPutAllOperation.PutAllEntryData[] putAllData, int putAllDataCount) throws RemoteOperationException {
        return RemotePutAllMessage.send(recipient, event, putAllData, putAllDataCount, true, false);
    }

    @Override
    public void postRemoveAll(DistributedRemoveAllOperation op, VersionedObjectList successfulOps, InternalRegion region) {
        try {
            RemoteRemoveAllMessage.RemoveAllResponse response = this.sendRemoteRemoveAllMessage(this.state.getTarget(), op.getBaseEvent(), op.getRemoveAllEntryData(), op.getRemoveAllEntryData().length);
            response.waitForRemoteResponse();
        }
        catch (RegionDestroyedException rde) {
            throw new TransactionDataNotColocatedException(String.format("Region %s not colocated with other regions in transaction", rde.getRegionFullPath()), rde);
        }
        catch (RemoteOperationException roe) {
            throw new TransactionDataNodeHasDepartedException(roe);
        }
    }

    RemoteRemoveAllMessage.RemoveAllResponse sendRemoteRemoveAllMessage(DistributedMember recipient, EntryEventImpl event, DistributedRemoveAllOperation.RemoveAllEntryData[] removeAllData, int removeAllDataCount) throws RemoteOperationException {
        return RemoteRemoveAllMessage.send(recipient, event, removeAllData, removeAllDataCount, true, false);
    }

    @Override
    public void cleanup() {
    }

    @Override
    protected InternalRegion getRegion() {
        return this.region;
    }
}

