/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.entries;

import java.util.UUID;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.InlineKeyHelper;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.RegionEntryFactory;
import org.apache.geode.internal.cache.entries.OffHeapRegionEntry;
import org.apache.geode.internal.cache.entries.VersionedThinLRURegionEntry;
import org.apache.geode.internal.cache.entries.VersionedThinLRURegionEntryHeap;
import org.apache.geode.internal.cache.entries.VersionedThinLRURegionEntryOffHeapIntKey;
import org.apache.geode.internal.cache.entries.VersionedThinLRURegionEntryOffHeapLongKey;
import org.apache.geode.internal.cache.entries.VersionedThinLRURegionEntryOffHeapObjectKey;
import org.apache.geode.internal.cache.entries.VersionedThinLRURegionEntryOffHeapStringKey1;
import org.apache.geode.internal.cache.entries.VersionedThinLRURegionEntryOffHeapStringKey2;
import org.apache.geode.internal.cache.entries.VersionedThinLRURegionEntryOffHeapUUIDKey;

public abstract class VersionedThinLRURegionEntryOffHeap
extends VersionedThinLRURegionEntry
implements OffHeapRegionEntry {
    @Immutable
    private static final VersionedThinLRURegionEntryOffHeapFactory factory = new VersionedThinLRURegionEntryOffHeapFactory();

    public VersionedThinLRURegionEntryOffHeap(RegionEntryContext context, Object value) {
        super(context, value);
    }

    public static RegionEntryFactory getEntryFactory() {
        return factory;
    }

    private static class VersionedThinLRURegionEntryOffHeapFactory
    implements RegionEntryFactory {
        private VersionedThinLRURegionEntryOffHeapFactory() {
        }

        @Override
        public RegionEntry createEntry(RegionEntryContext context, Object key, Object value) {
            if (InlineKeyHelper.INLINE_REGION_KEYS) {
                Class<?> keyClass = key.getClass();
                if (keyClass == Integer.class) {
                    return new VersionedThinLRURegionEntryOffHeapIntKey(context, (Integer)key, value);
                }
                if (keyClass == Long.class) {
                    return new VersionedThinLRURegionEntryOffHeapLongKey(context, (Long)key, value);
                }
                if (keyClass == String.class) {
                    String skey = (String)key;
                    Boolean info = InlineKeyHelper.canStringBeInlineEncoded(skey);
                    if (info != null) {
                        boolean byteEncoded = info;
                        if (skey.length() <= InlineKeyHelper.getMaxInlineStringKey(1, byteEncoded)) {
                            return new VersionedThinLRURegionEntryOffHeapStringKey1(context, skey, value, byteEncoded);
                        }
                        return new VersionedThinLRURegionEntryOffHeapStringKey2(context, skey, value, byteEncoded);
                    }
                } else if (keyClass == UUID.class) {
                    return new VersionedThinLRURegionEntryOffHeapUUIDKey(context, (UUID)key, value);
                }
            }
            return new VersionedThinLRURegionEntryOffHeapObjectKey(context, key, value);
        }

        @Override
        public Class getEntryClass() {
            return VersionedThinLRURegionEntryOffHeapObjectKey.class;
        }

        @Override
        public RegionEntryFactory makeVersioned() {
            return this;
        }

        @Override
        public RegionEntryFactory makeOnHeap() {
            return VersionedThinLRURegionEntryHeap.getEntryFactory();
        }
    }
}

