/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.cache.CommitConflictException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.DistTXCommitMessage;
import org.apache.geode.internal.cache.DistTXCoordinatorInterface;
import org.apache.geode.internal.cache.DistTXPrecommitMessage;
import org.apache.geode.internal.cache.DistTXRollbackMessage;
import org.apache.geode.internal.cache.DistTXStateOnCoordinator;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.PeerTXStateStub;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.tx.DistTxEntryEvent;

public class DistPeerTXStateStub
extends PeerTXStateStub
implements DistTXCoordinatorInterface {
    private ArrayList<DistTxEntryEvent> primaryTransactionalOperations = new ArrayList();
    private ArrayList<DistTxEntryEvent> secondaryTransactionalOperations = new ArrayList();
    private DistTXPrecommitMessage precommitDistTxMsg = null;
    private DistTXCommitMessage commitDistTxMsg = null;
    private DistTXRollbackMessage rollbackDistTxMsg = null;
    private DistributionManager dm = null;

    public DistPeerTXStateStub(TXStateProxy stateProxy, DistributedMember target, InternalDistributedMember onBehalfOfClient) {
        super(stateProxy, target, onBehalfOfClient);
    }

    @Override
    public void precommit() throws CommitConflictException {
        if (logger.isDebugEnabled()) {
            logger.debug("DistPeerTXStateStub.precommit target=" + this.target + " ,primaryTransactionalOperations=" + this.primaryTransactionalOperations + " ,secondaryTransactionalOperations=" + this.secondaryTransactionalOperations);
        }
        assert (this.target != null);
        assert (this.primaryTransactionalOperations != null || this.secondaryTransactionalOperations != null);
        this.precommitDistTxMsg.setSecondaryTransactionalOperations(this.secondaryTransactionalOperations);
        Set<DistributedMember> recipients = Collections.singleton(this.target);
        this.precommitDistTxMsg.setRecipients(recipients);
        this.dm.putOutgoing(this.precommitDistTxMsg);
        this.precommitDistTxMsg.resetRecipients();
    }

    @Override
    public void commit() throws CommitConflictException {
        if (logger.isDebugEnabled()) {
            logger.debug("DistPeerTXStateStub.commit target=" + this.target);
        }
        this.dm.getStats().incSentCommitMessages(1L);
        Set<DistributedMember> recipients = Collections.singleton(this.target);
        this.commitDistTxMsg.setRecipients(recipients);
        this.dm.putOutgoing(this.commitDistTxMsg);
        this.commitDistTxMsg.resetRecipients();
    }

    @Override
    public void rollback() {
        if (logger.isDebugEnabled()) {
            logger.debug("DistPeerTXStateStub.rollback target=" + this.target);
        }
        Set<DistributedMember> recipients = Collections.singleton(this.target);
        this.rollbackDistTxMsg.setRecipients(recipients);
        this.dm.putOutgoing(this.rollbackDistTxMsg);
        this.rollbackDistTxMsg.resetRecipients();
    }

    @Override
    public ArrayList<DistTxEntryEvent> getPrimaryTransactionalOperations() throws UnsupportedOperationInTransactionException {
        return this.primaryTransactionalOperations;
    }

    private void addPrimaryTransactionalOperations(DistTxEntryEvent dtop) {
        if (logger.isDebugEnabled()) {
            logger.debug("DistPeerTXStateStub.addPrimaryTransactionalOperations add " + dtop + " ,stub before=" + this);
        }
        this.primaryTransactionalOperations.add(dtop);
        if (logger.isDebugEnabled()) {
            logger.debug("DistPeerTXStateStub.addPrimaryTransactionalOperations stub after add = " + this);
        }
    }

    @Override
    public void addSecondaryTransactionalOperations(DistTxEntryEvent dtop) throws UnsupportedOperationInTransactionException {
        this.secondaryTransactionalOperations.add(dtop);
    }

    @Override
    protected void cleanup() {
        super.cleanup();
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) {
        return this.putEntry(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed, true, false);
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed, boolean invokeCallbacks, boolean throwConcurrentModification) {
        if (logger.isDebugEnabled()) {
            logger.debug("DistPeerTXStateStub.putEntry " + event.getKeyInfo().getKey(), new Throwable());
        }
        boolean returnValue = super.putEntry(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed, invokeCallbacks, throwConcurrentModification);
        this.addPrimaryTransactionalOperations(new DistTxEntryEvent(event));
        return returnValue;
    }

    @Override
    public boolean putEntryOnRemote(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws DataLocationException {
        if (logger.isDebugEnabled()) {
            logger.debug("DistPeerTXStateStub.putEntryOnRemote " + event.getKeyInfo().getKey(), new Throwable());
        }
        boolean returnValue = super.putEntryOnRemote(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed);
        this.addPrimaryTransactionalOperations(new DistTxEntryEvent(event));
        return returnValue;
    }

    @Override
    public void destroyExistingEntry(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException {
        this.primaryTransactionalOperations.add(new DistTxEntryEvent(event));
        super.destroyExistingEntry(event, cacheWrite, expectedOldValue);
    }

    @Override
    public void destroyOnRemote(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws DataLocationException {
        super.destroyOnRemote(event, cacheWrite, expectedOldValue);
        this.primaryTransactionalOperations.add(new DistTxEntryEvent(event));
    }

    @Override
    public void invalidateExistingEntry(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        super.invalidateExistingEntry(event, invokeCallbacks, forceNewEntry);
        this.primaryTransactionalOperations.add(new DistTxEntryEvent(event));
    }

    @Override
    public void invalidateOnRemote(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) throws DataLocationException {
        super.invalidateExistingEntry(event, invokeCallbacks, forceNewEntry);
        this.primaryTransactionalOperations.add(new DistTxEntryEvent(event));
    }

    @Override
    public void postPutAll(DistributedPutAllOperation putallOp, VersionedObjectList successfulPuts, InternalRegion reg) {
        super.postPutAll(putallOp, successfulPuts, reg);
        EntryEventImpl event = EntryEventImpl.createPutAllEvent(putallOp, reg, Operation.PUTALL_CREATE, putallOp.getBaseEvent().getKey(), putallOp.getBaseEvent().getValue());
        event.setEventId(putallOp.getBaseEvent().getEventId());
        DistTxEntryEvent dtop = new DistTxEntryEvent(event);
        dtop.setPutAllOperation(putallOp);
        this.primaryTransactionalOperations.add(dtop);
    }

    @Override
    public void postRemoveAll(DistributedRemoveAllOperation removeAllOp, VersionedObjectList successfulOps, InternalRegion reg) {
        super.postRemoveAll(removeAllOp, successfulOps, reg);
        EntryEventImpl event = EntryEventImpl.createRemoveAllEvent(removeAllOp, reg, removeAllOp.getBaseEvent().getKey());
        event.setEventId(removeAllOp.getBaseEvent().getEventId());
        DistTxEntryEvent dtop = new DistTxEntryEvent(event);
        dtop.setRemoveAllOperation(removeAllOp);
        this.primaryTransactionalOperations.add(dtop);
    }

    @Override
    public String toString() {
        return super.toString() + " ,primary txOps=" + this.primaryTransactionalOperations + " ,secondary txOps=" + this.secondaryTransactionalOperations;
    }

    @Override
    public boolean getPreCommitResponse() throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(String.format("precommit() operation %s meant for Dist Tx is not supported", "getPreCommitResponse"));
    }

    @Override
    public boolean getRollbackResponse() throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(String.format("rollback() operation %s meant for Dist Tx is not supported", "getRollbackResponse"));
    }

    @Override
    public void setPrecommitMessage(DistTXPrecommitMessage precommitMsg, DistributionManager dm) throws UnsupportedOperationInTransactionException {
        this.precommitDistTxMsg = precommitMsg;
        this.dm = dm;
    }

    @Override
    public void setCommitMessage(DistTXCommitMessage commitMsg, DistributionManager dm) throws UnsupportedOperationInTransactionException {
        this.commitDistTxMsg = commitMsg;
        this.dm = dm;
    }

    @Override
    public void setRollbackMessage(DistTXRollbackMessage rollbackMsg, DistributionManager dm) throws UnsupportedOperationInTransactionException {
        this.rollbackDistTxMsg = rollbackMsg;
        this.dm = dm;
    }

    @Override
    public void gatherAffectedRegions(HashSet<InternalRegion> regionSet, boolean includePrimaryRegions, boolean includeRedundantRegions) throws UnsupportedOperationInTransactionException {
        if (includePrimaryRegions) {
            for (DistTxEntryEvent dtos : this.primaryTransactionalOperations) {
                regionSet.add(dtos.getRegion());
            }
        }
        if (includeRedundantRegions) {
            for (DistTxEntryEvent dtos : this.secondaryTransactionalOperations) {
                regionSet.add(dtos.getRegion());
            }
        }
    }

    @Override
    public void gatherAffectedRegionsName(TreeSet<String> sortedRegionName, boolean includePrimaryRegions, boolean includeRedundantRegions) throws UnsupportedOperationInTransactionException {
        if (includePrimaryRegions) {
            DistTXStateOnCoordinator.gatherAffectedRegions(sortedRegionName, this.primaryTransactionalOperations);
        }
        if (includeRedundantRegions) {
            DistTXStateOnCoordinator.gatherAffectedRegions(sortedRegionName, this.secondaryTransactionalOperations);
        }
    }

    @Override
    public boolean isDistTx() {
        return true;
    }

    @Override
    public boolean isCreatedOnDistTxCoordinator() {
        return true;
    }

    @Override
    public void finalCleanup() {
        this.cleanup();
    }
}

