/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.geode.DataSerializable;
import org.apache.geode.DataSerializer;
import org.apache.geode.Instantiator;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.SerialDistributionMessage;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PoolManagerImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.cache.tier.sockets.ClientInstantiatorMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class InternalInstantiator {
    private static final Logger logger = LogService.getLogger();
    @MakeNotStatic
    private static final ConcurrentMap<String, Instantiator> dsMap = new ConcurrentHashMap<String, Instantiator>();
    @MakeNotStatic
    private static final ConcurrentMap<Integer, Object> idsToInstantiators = new ConcurrentHashMap<Integer, Object>();
    @MakeNotStatic
    private static final ConcurrentHashMap<String, InstantiatorAttributesHolder> classNamesToHolders = new ConcurrentHashMap();
    @MakeNotStatic
    private static final ConcurrentHashMap<Integer, InstantiatorAttributesHolder> idsToHolders = new ConcurrentHashMap();
    private static final String SERVER_CONNECTION_THREAD = "ServerConnection";

    public static void register(Instantiator instantiator, boolean distribute) {
        if (!distribute || InternalInstantiator.checkForThread()) {
            InternalInstantiator._register(instantiator, distribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _register(Instantiator instantiator, boolean distribute) {
        if (instantiator == null) {
            throw new NullPointerException("Cannot register a null Instantiator.");
        }
        int classId = instantiator.getId();
        if (classId == 0) {
            throw new IllegalArgumentException("Instantiator id cannot be zero");
        }
        Class<? extends DataSerializable> c = instantiator.getInstantiatedClass();
        String cName = c.getName();
        int oldId = InternalInstantiator.getClassId(c);
        if (oldId != 0 && oldId != classId) {
            throw new IllegalStateException(String.format("Class %s is already registered with id %s so it can not be registered with id %s", c.getName(), oldId, classId));
        }
        Integer idx = classId;
        Class<InternalInstantiator> clazz = InternalInstantiator.class;
        synchronized (InternalInstantiator.class) {
            boolean retry;
            do {
                retry = false;
                Object oldInst = idsToInstantiators.putIfAbsent(idx, instantiator);
                if (oldInst != null) {
                    if (oldInst instanceof Marker) {
                        boolean bl = retry = !idsToInstantiators.replace(idx, oldInst, instantiator);
                        if (retry) continue;
                        dsMap.put(cName, instantiator);
                        ((Marker)oldInst).setInstantiator(instantiator);
                        continue;
                    }
                    Class<? extends DataSerializable> oldClass = ((Instantiator)oldInst).getInstantiatedClass();
                    if (!oldClass.getName().equals(cName)) {
                        throw new IllegalStateException(String.format("Class id %s is already registered for class %s so it could not be registered for class %s", classId, oldClass.getName(), cName));
                    }
                    // ** MonitorExit[var6_7] (shouldn't be in output)
                    return;
                }
                dsMap.put(cName, instantiator);
            } while (retry);
            InternalInstantiator.setEventIdIfNew(instantiator);
            logger.info("Instantiator registered with id {} class {}", (Object)classId, (Object)c.getName());
            // ** MonitorExit[var6_7] (shouldn't be in output)
            if (distribute) {
                InternalInstantiator.sendRegistrationMessage(instantiator);
                InternalInstantiator.sendRegistrationMessageToServers(instantiator);
            }
            InternalInstantiator.sendRegistrationMessageToClients(instantiator);
            InternalDataSerializer.fireNewInstantiator(instantiator);
            return;
        }
    }

    private static void setEventIdIfNew(Instantiator instantiator) {
        InternalCache cache = InternalInstantiator.getInternalCache();
        if (cache != null && instantiator.getEventId() == null) {
            instantiator.setEventId(new EventID(cache.getDistributedSystem()));
        }
    }

    private static InternalCache getInternalCache() {
        return GemFireCacheImpl.getInstance();
    }

    private static boolean checkForThread() {
        String name = Thread.currentThread().getName();
        return !name.startsWith("Cache Client Updater Thread ") && !name.startsWith(SERVER_CONNECTION_THREAD);
    }

    public static EventID generateEventId() {
        if (InternalInstantiator.isCacheCreated()) {
            return new EventID(InternalDistributedSystem.getAnyInstance());
        }
        return null;
    }

    private static void sendRegistrationMessageToServers(Instantiator instantiator) {
        PoolManagerImpl.allPoolsRegisterInstantiator(instantiator);
    }

    private static void sendRegistrationMessageToServers(InstantiatorAttributesHolder holder) {
        PoolManagerImpl.allPoolsRegisterInstantiator(holder);
    }

    private static void sendRegistrationMessageToClients(Instantiator instantiator) {
        byte[][] serializedInstantiators;
        block3: {
            if (!InternalInstantiator.isCacheCreated()) {
                return;
            }
            serializedInstantiators = new byte[3][];
            try {
                serializedInstantiators[0] = CacheServerHelper.serialize(instantiator.getClass().toString().substring(6));
                serializedInstantiators[1] = CacheServerHelper.serialize(instantiator.getInstantiatedClass().toString().substring(6));
                byte[] idBytes = new byte[4];
                Part.encodeInt(instantiator.getId(), idBytes);
                serializedInstantiators[2] = idBytes;
            }
            catch (IOException e) {
                if (!logger.isDebugEnabled()) break block3;
                logger.debug("IOException encountered while serializing instantiators using CacheServerHelper.serialize() method");
            }
        }
        ClientInstantiatorMessage clientInstantiatorMessage = new ClientInstantiatorMessage(EnumListenerEvent.AFTER_REGISTER_INSTANTIATOR, serializedInstantiators, (ClientProxyMembershipID)instantiator.getContext(), (EventID)instantiator.getEventId());
        CacheClientNotifier.routeClientMessage(clientInstantiatorMessage);
    }

    private static boolean isCacheCreated() {
        return InternalInstantiator.getInternalCache() != null;
    }

    public static void register(Class instantiatorClass, Class instantiatedClass, int id, boolean distribute) {
        if (InternalInstantiator.checkForThread()) {
            Instantiator inst = InternalInstantiator.newInstance(instantiatorClass, instantiatedClass, id);
            InternalInstantiator._register(inst, distribute);
        }
    }

    public static void register(Class instantiatorClass, Class instantiatedClass, int id, boolean distribute, EventID eventId, ClientProxyMembershipID context) {
        Instantiator inst = InternalInstantiator.newInstance(instantiatorClass, instantiatedClass, id);
        inst.setEventId(eventId);
        inst.setContext(context);
        InternalInstantiator._register(inst, distribute);
    }

    public static void register(String instantiatorClass, String instantiatedClass, int id, boolean distribute) {
        if (InternalInstantiator.checkForThread()) {
            InternalInstantiator.register(instantiatorClass, new InstantiatorAttributesHolder(instantiatorClass, instantiatedClass, id), distribute);
        }
    }

    public static void register(String instantiatorClass, String instantiatedClass, int id, boolean distribute, EventID eventId, ClientProxyMembershipID context) {
        InternalInstantiator.register(instantiatorClass, new InstantiatorAttributesHolder(instantiatorClass, instantiatedClass, id, eventId, context), distribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void register(String instantiatorClassName, InstantiatorAttributesHolder holder, boolean distribute) {
        Class<InternalInstantiator> clazz = InternalInstantiator.class;
        synchronized (InternalInstantiator.class) {
            Object inst = idsToInstantiators.get(holder.getId());
            if (inst == null) {
                if (instantiatorClassName == null || instantiatorClassName.trim().equals("")) {
                    throw new IllegalArgumentException("Instantiator class name cannot be null or empty.");
                }
                if (holder.getId() == 0) {
                    throw new IllegalArgumentException("Instantiator id cannot be zero");
                }
                InstantiatorAttributesHolder iah = classNamesToHolders.putIfAbsent(holder.getInstantiatedClassName(), holder);
                if (iah != null && iah.getId() != holder.getId()) {
                    throw new IllegalStateException(String.format("Class %s is already registered with id %s so it can not be registered with id %s", instantiatorClassName, iah.getId(), holder.getId()));
                }
                idsToHolders.putIfAbsent(holder.getId(), holder);
                logger.info("Instantiator registered with holder id {} class {}", (Object)holder.getId(), (Object)holder.getInstantiatedClassName());
                if (!distribute) return;
                InternalInstantiator.sendRegistrationMessageToServers(holder);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (!(inst instanceof Marker)) return;
            Class instantiatorClass = null;
            Class instantiatedClass = null;
            try {
                instantiatorClass = InternalDataSerializer.getCachedClass(holder.getInstantiatorClassName());
                instantiatedClass = InternalDataSerializer.getCachedClass(holder.getInstantiatedClassName());
            }
            catch (ClassNotFoundException e) {
                InternalInstantiator.logClassNotFoundException(e);
            }
            Class<InternalInstantiator> clazz2 = InternalInstantiator.class;
            synchronized (InternalInstantiator.class) {
                Object inst2 = idsToInstantiators.get(holder.getId());
                if (inst2 == inst) {
                    InternalInstantiator.register(instantiatorClass, instantiatedClass, holder.getId(), distribute, holder.getEventId(), holder.getContext());
                } else {
                    if (inst2 != null && !(inst2 instanceof Marker)) return;
                    InternalInstantiator.register(instantiatorClassName, holder, distribute);
                }
                // ** MonitorExit[var6_9] (shouldn't be in output)
                return;
            }
        }
    }

    private static void logClassNotFoundException(ClassNotFoundException e) {
        InternalCache cache = InternalInstantiator.getInternalCache();
        if (cache != null && cache.getLogger() != null && cache.getLogger().infoEnabled()) {
            cache.getLogger().info(String.format("Could not load instantiator class: %s", e.getMessage()));
        }
    }

    public static synchronized void unregister(Class c, int classId) {
        if (c == null) {
            throw new NullPointerException("Cannot unregister a null class");
        }
        Integer idx = classId;
        Instantiator i = (Instantiator)idsToInstantiators.remove(idx);
        if (i == null) {
            throw new IllegalArgumentException(String.format("Class %s was not registered with id %s", c.getName(), classId));
        }
        dsMap.remove(c.getName(), i);
        idsToHolders.remove(idx);
        classNamesToHolders.remove(i.getInstantiatedClass().getName());
    }

    @VisibleForTesting
    public static void reinitialize() {
        idsToInstantiators.clear();
        dsMap.clear();
        idsToHolders.clear();
        classNamesToHolders.clear();
    }

    public static int getClassId(Class c) {
        int result = 0;
        Instantiator i = (Instantiator)dsMap.get(c.getName());
        if (i != null) {
            result = i.getId();
        } else {
            InstantiatorAttributesHolder iah = classNamesToHolders.get(c.getName());
            if (iah != null) {
                result = iah.getId();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Instantiator getInstantiator(int classId) {
        Marker marker;
        boolean retry;
        Integer idx = classId;
        Object o = idsToInstantiators.get(idx);
        do {
            retry = false;
            if (o == null) {
                marker = new Marker();
                o = idsToInstantiators.putIfAbsent(idx, marker);
                retry = o != null;
                continue;
            }
            if (o instanceof Marker) {
                marker = (Marker)o;
                continue;
            }
            return (Instantiator)o;
        } while (retry);
        Instantiator instantiator = null;
        if (idsToHolders.get(classId) == null) {
            instantiator = marker.getInstantiator();
        }
        if (instantiator != null) {
            return instantiator;
        }
        InstantiatorAttributesHolder holder = idsToHolders.get(classId);
        if (holder != null) {
            try {
                Class instantiatorClass = InternalDataSerializer.getCachedClass(holder.getInstantiatorClassName());
                Class instantiatedClass = InternalDataSerializer.getCachedClass(holder.getInstantiatedClassName());
                Class<InternalInstantiator> clazz = InternalInstantiator.class;
                synchronized (InternalInstantiator.class) {
                    InternalInstantiator.register(instantiatorClass, instantiatedClass, holder.getId(), false, holder.getEventId(), holder.getContext());
                    classNamesToHolders.remove(holder.getInstantiatedClassName());
                    idsToHolders.remove(classId);
                    instantiator = (Instantiator)idsToInstantiators.get(classId);
                    // ** MonitorExit[var9_10] (shouldn't be in output)
                }
            }
            catch (ClassNotFoundException e) {
                InternalInstantiator.logClassNotFoundException(e);
            }
        }
        {
            return instantiator;
        }
    }

    private static void sendRegistrationMessage(Instantiator s) {
        InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
        if (system != null) {
            RegistrationMessage m = s.getContext() == null ? new RegistrationMessage(s) : new RegistrationContextMessage(s);
            system.getDistributionManager().putOutgoing(m);
        }
    }

    protected static Instantiator newInstance(Class<?> instantiatorClass, Class<?> instantiatedClass, int id) throws IllegalArgumentException {
        Instantiator s;
        Constructor<?> init;
        if (!Instantiator.class.isAssignableFrom(instantiatorClass)) {
            throw new IllegalArgumentException(String.format("%s does not extend Instantiator.", instantiatorClass.getName()));
        }
        boolean intConstructor = false;
        try {
            init = instantiatorClass.getDeclaredConstructor(Class.class, Integer.TYPE);
            intConstructor = true;
        }
        catch (NoSuchMethodException ex) {
            try {
                init = instantiatorClass.getDeclaredConstructor(Class.class, Byte.TYPE);
            }
            catch (NoSuchMethodException ex2) {
                if (instantiatorClass.getDeclaringClass() != null) {
                    throw new IllegalArgumentException(String.format("Class %s does not have a two-argument (Class, int) constructor. It is an inner class of %s. Should it be a static inner class?", instantiatorClass.getName(), instantiatorClass.getDeclaringClass()));
                }
                throw new IllegalArgumentException(String.format("Class %s does not have a two-argument (Class, int) constructor.", instantiatorClass.getName()));
            }
        }
        try {
            init.setAccessible(true);
            s = (Instantiator)init.newInstance(instantiatedClass, InternalInstantiator.convertId(id, intConstructor));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(String.format("Could not access zero-argument constructor of %s", instantiatorClass.getName()));
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(String.format("Could not instantiate an instance of %s", instantiatorClass.getName()), ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException(String.format("While instantiating an instance of %s", instantiatorClass.getName()), ex);
        }
        return s;
    }

    private static Object convertId(int id, boolean asInteger) {
        if (asInteger) {
            return id;
        }
        return (byte)id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Instantiator[] getInstantiators() {
        if (classNamesToHolders.isEmpty()) return dsMap.values().toArray(new Instantiator[0]);
        Iterator<InstantiatorAttributesHolder> iterator = classNamesToHolders.values().iterator();
        while (iterator.hasNext()) {
            InstantiatorAttributesHolder holder = iterator.next();
            try {
                Class instantiatorClass = InternalDataSerializer.getCachedClass(holder.getInstantiatorClassName());
                Class instantiatedClass = InternalDataSerializer.getCachedClass(holder.getInstantiatedClassName());
                Class<InternalInstantiator> clazz = InternalInstantiator.class;
                // MONITORENTER : org.apache.geode.internal.InternalInstantiator.class
                if (!idsToInstantiators.containsKey(holder.getId())) {
                    InternalInstantiator.register(instantiatorClass, instantiatedClass, holder.getId(), false, holder.getEventId(), holder.getContext());
                }
                classNamesToHolders.remove(holder.getInstantiatedClassName());
                idsToHolders.remove(holder.getId());
                // MONITOREXIT : clazz
            }
            catch (ClassNotFoundException e) {
                InternalInstantiator.logClassNotFoundException(e);
            }
        }
        return dsMap.values().toArray(new Instantiator[0]);
    }

    public static Object[] getInstantiatorsForSerialization() {
        ArrayList<Object> instantiators = new ArrayList<Object>(dsMap.size() + idsToHolders.size());
        instantiators.addAll(dsMap.values());
        instantiators.addAll(classNamesToHolders.values());
        return instantiators.toArray();
    }

    public static void logInstantiators() {
        for (Instantiator instantiator : dsMap.values()) {
            logger.info("Instantiator registered with id {} class {}", (Object)instantiator.getId(), (Object)instantiator.getInstantiatedClass().getName());
        }
        for (InstantiatorAttributesHolder holder : idsToHolders.values()) {
            logger.info("Instantiator registered with holder id {} class {}", (Object)holder.getId(), (Object)holder.getInstantiatedClassName());
        }
    }

    public static class RegistrationContextMessage
    extends RegistrationMessage {
        private transient ClientProxyMembershipID context;

        public RegistrationContextMessage() {
        }

        public RegistrationContextMessage(Instantiator s) {
            this.instantiatorClass = s.getClass();
            this.instantiatedClass = s.getInstantiatedClass();
            this.id = s.getId();
            this.eventId = (EventID)s.getEventId();
            this.context = (ClientProxyMembershipID)s.getContext();
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            if (this.fromDataProblems != null && logger.isDebugEnabled()) {
                logger.debug((CharSequence)this.fromDataProblems);
            }
            if (this.instantiatorClass != null && this.instantiatedClass != null) {
                Instantiator s = InternalInstantiator.newInstance(this.instantiatorClass, this.instantiatedClass, this.id);
                s.setEventId(this.eventId);
                s.setContext(this.context);
                InternalInstantiator.register(s, false);
            } else if (this.instantiatorClassName != null && this.instantiatedClassName != null) {
                InternalInstantiator.register(this.instantiatorClassName, this.instantiatedClassName, this.id, false, this.eventId, this.context);
            }
        }

        @Override
        public int getDSFID() {
            return 13;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.context = ClientProxyMembershipID.readCanonicalized(in);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeObject(this.context, out);
        }
    }

    public static class RegistrationMessage
    extends SerialDistributionMessage {
        Class instantiatorClass;
        Class instantiatedClass;
        protected int id;
        protected EventID eventId;
        transient StringBuilder fromDataProblems;
        String instantiatorClassName;
        String instantiatedClassName;

        public RegistrationMessage() {
        }

        public RegistrationMessage(Instantiator s) {
            this.instantiatorClass = s.getClass();
            this.instantiatedClass = s.getInstantiatedClass();
            this.id = s.getId();
            this.eventId = (EventID)s.getEventId();
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            if (this.fromDataProblems != null && logger.isDebugEnabled()) {
                logger.debug((CharSequence)this.fromDataProblems);
            }
            if (this.instantiatorClass != null && this.instantiatedClass != null) {
                Instantiator s = InternalInstantiator.newInstance(this.instantiatorClass, this.instantiatedClass, this.id);
                s.setEventId(this.eventId);
                InternalInstantiator.register(s, false);
            } else if (this.instantiatorClassName != null && this.instantiatedClassName != null) {
                InternalInstantiator.register(this.instantiatorClassName, this.instantiatedClassName, this.id, false, this.eventId, null);
            }
        }

        public int getDSFID() {
            return 12;
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            DataSerializer.writeNonPrimitiveClassName(this.instantiatorClass.getName(), out);
            DataSerializer.writeNonPrimitiveClassName(this.instantiatedClass.getName(), out);
            out.writeInt(this.id);
            DataSerializer.writeObject(this.eventId, out);
        }

        private void recordFromDataProblem(String s) {
            if (this.fromDataProblems == null) {
                this.fromDataProblems = new StringBuilder();
            }
            this.fromDataProblems.append(s);
            this.fromDataProblems.append("\n\n");
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.instantiatorClassName = DataSerializer.readNonPrimitiveClassName(in);
            this.instantiatedClassName = DataSerializer.readNonPrimitiveClassName(in);
            if (CacheClientNotifier.getInstance() != null) {
                try {
                    this.instantiatorClass = InternalDataSerializer.getCachedClass(this.instantiatorClassName);
                }
                catch (ClassNotFoundException ex) {
                    this.recordFromDataProblem(String.format("Could not load instantiator class: %s", ex));
                    this.instantiatorClass = null;
                }
                try {
                    this.instantiatedClass = InternalDataSerializer.getCachedClass(this.instantiatedClassName);
                }
                catch (ClassNotFoundException ex) {
                    this.recordFromDataProblem(String.format("Could not load instantiated class: %s", ex));
                    this.instantiatedClass = null;
                }
            }
            this.id = in.readInt();
            this.eventId = (EventID)DataSerializer.readObject(in);
        }

        @Override
        public String toString() {
            String instatiatorName = this.instantiatorClass == null ? this.instantiatorClassName : this.instantiatorClass.getName();
            String instatiatedName = this.instantiatedClass == null ? this.instantiatedClassName : this.instantiatedClass.getName();
            return String.format("Register Instantiator %s of class %s that instantiates a %s", this.id, instatiatorName, instatiatedName);
        }
    }

    static class Marker {
        private volatile Instantiator instantiator = null;

        Marker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Instantiator getInstantiator() {
            Marker marker = this;
            synchronized (marker) {
                if (this.instantiator == null) {
                    try {
                        this.wait(InternalDataSerializer.GetMarker.WAIT_MS);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
                return this.instantiator;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setInstantiator(Instantiator instantiator) {
            Marker marker = this;
            synchronized (marker) {
                this.instantiator = instantiator;
                this.notifyAll();
            }
        }
    }

    public static class InstantiatorAttributesHolder {
        private final String instantiatorName;
        private final String instantiatedName;
        private final int id;
        private EventID eventId;
        private ClientProxyMembershipID context;

        InstantiatorAttributesHolder(String instantiatorClass, String instantiatedClass, int id) {
            this.instantiatorName = instantiatorClass;
            this.instantiatedName = instantiatedClass;
            this.id = id;
        }

        InstantiatorAttributesHolder(String instantiatorClass, String instantiatedClass, int id, EventID eventId, ClientProxyMembershipID context) {
            this.instantiatorName = instantiatorClass;
            this.instantiatedName = instantiatedClass;
            this.id = id;
            this.eventId = eventId;
            this.context = context;
        }

        public String getInstantiatorClassName() {
            return this.instantiatorName;
        }

        public String getInstantiatedClassName() {
            return this.instantiatedName;
        }

        public int getId() {
            return this.id;
        }

        public EventID getEventId() {
            return this.eventId;
        }

        public ClientProxyMembershipID getContext() {
            return this.context;
        }

        public String toString() {
            return "InstantiatorAttributesHolder[irName=" + this.instantiatorName + ",idName=" + this.instantiatedName + ",id=" + this.id + (this.eventId != null ? ",this.eventId=" + this.eventId : "") + (this.context != null ? ",this.context=" + this.context : "") + "]";
        }
    }
}

