/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.security;

import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.query.security.MethodInvocationAuthorizer;
import org.apache.geode.cache.query.security.RestrictedMethodAuthorizer;

public final class UnrestrictedMethodAuthorizer
implements MethodInvocationAuthorizer {
    static final String NULL_CACHE_MESSAGE = "Cache should be provided to configure the authorizer.";
    static final String NULL_AUTHORIZER_MESSAGE = "RestrictedMethodAuthorizer should be provided to create this authorizer.";
    private static final String GEODE_BASE_PACKAGE = "org.apache.geode";
    private final RestrictedMethodAuthorizer restrictedMethodAuthorizer;

    public UnrestrictedMethodAuthorizer(Cache cache) {
        Objects.requireNonNull(cache, NULL_CACHE_MESSAGE);
        this.restrictedMethodAuthorizer = new RestrictedMethodAuthorizer(cache);
    }

    public UnrestrictedMethodAuthorizer(RestrictedMethodAuthorizer restrictedMethodAuthorizer) {
        Objects.requireNonNull(restrictedMethodAuthorizer, NULL_AUTHORIZER_MESSAGE);
        this.restrictedMethodAuthorizer = restrictedMethodAuthorizer;
    }

    @Override
    public boolean authorize(Method method, Object target) {
        if (this.restrictedMethodAuthorizer.isPermanentlyForbiddenMethod(method, target)) {
            return false;
        }
        String packageName = target.getClass().getPackage().getName().toLowerCase();
        if (!packageName.startsWith(GEODE_BASE_PACKAGE)) {
            return true;
        }
        return this.restrictedMethodAuthorizer.isAllowedGeodeMethod(method, target);
    }
}

