/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.List;
import java.util.Set;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractCompiledValue;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.ResultsSet;
import org.apache.geode.internal.Assert;

public class CompiledConstruction
extends AbstractCompiledValue {
    private final Class objectType;
    private final List args;

    public CompiledConstruction(Class objectType, List args) {
        this.objectType = objectType;
        this.args = args;
    }

    @Override
    public List getChildren() {
        return this.args;
    }

    @Override
    public int getType() {
        return -6;
    }

    @Override
    public Object evaluate(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        Assert.assertTrue(this.objectType == ResultsSet.class);
        ResultsSet newSet = new ResultsSet(this.args.size());
        for (Object arg : this.args) {
            CompiledValue cv = (CompiledValue)arg;
            Object eval = cv.evaluate(context);
            if (eval == QueryService.UNDEFINED) {
                return QueryService.UNDEFINED;
            }
            newSet.add(eval);
        }
        return newSet;
    }

    @Override
    public Set computeDependencies(ExecutionContext context) throws TypeMismatchException, NameResolutionException {
        for (Object arg : this.args) {
            CompiledValue cv = (CompiledValue)arg;
            context.addDependencies(this, cv.computeDependencies(context));
        }
        return context.getDependencySet(this, true);
    }
}

