/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.alerting.internal;

import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.alerting.internal.AlertListener;
import org.apache.geode.alerting.internal.AlertMessaging;
import org.apache.geode.alerting.internal.InternalAlertingService;
import org.apache.geode.alerting.internal.NullAlertMessaging;
import org.apache.geode.alerting.internal.spi.AlertLevel;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.DistributedMember;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterAlertingService
implements InternalAlertingService {
    private static final Logger logger = LogManager.getLogger();
    private final CopyOnWriteArrayList<AlertListener> listeners = new CopyOnWriteArrayList();
    private final AtomicReference<AlertMessaging> alertMessagingRef = new AtomicReference<NullAlertMessaging>(new NullAlertMessaging());

    @Override
    public void useAlertMessaging(AlertMessaging alertMessaging) {
        this.alertMessagingRef.set(alertMessaging);
    }

    @Override
    public void sendAlerts(AlertLevel alertLevel, Instant timestamp, String threadName, long threadId, String formattedMessage, String stackTrace) {
        for (AlertListener listener : this.listeners) {
            if (alertLevel.meetsOrExceeds(listener.getLevel())) break;
            logger.trace("Sending alert message for {} to {}.", (Object)formattedMessage, (Object)listener.getMember());
            this.alertMessagingRef.get().sendAlert(listener.getMember(), alertLevel, timestamp, threadName, threadId, formattedMessage, stackTrace);
        }
    }

    @Override
    public synchronized void addAlertListener(DistributedMember member, AlertLevel alertLevel) {
        if (alertLevel == AlertLevel.NONE) {
            return;
        }
        AlertListener listener = new AlertListener(alertLevel, member);
        this.listeners.remove(listener);
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (listener.getLevel().compareTo(this.listeners.get(i).getLevel()) > 0) continue;
            this.listeners.add(i, listener);
            return;
        }
        this.listeners.add(listener);
        logger.debug("Added/Replaced alert listener for member {} at level {}.", (Object)member, (Object)alertLevel);
    }

    @Override
    public synchronized boolean removeAlertListener(DistributedMember member) {
        boolean memberWasFound = this.listeners.remove(new AlertListener(null, member));
        if (memberWasFound) {
            logger.debug("Removed alert listener for member {}.", (Object)member);
        }
        return memberWasFound;
    }

    @Override
    public synchronized boolean hasAlertListener(DistributedMember member, AlertLevel alertLevel) {
        for (AlertListener listener : this.listeners) {
            if (!listener.getMember().equals(member) || !listener.getLevel().equals((Object)alertLevel)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAlertListeners() {
        return !this.listeners.isEmpty();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    }

    @VisibleForTesting
    synchronized List<AlertListener> getAlertListeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

