/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.serialization.filter;

import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.geode.internal.serialization.filter.FilterAlreadyConfiguredException;
import org.apache.geode.internal.serialization.filter.ObjectInputFilterApi;
import org.apache.geode.internal.serialization.filter.StreamSerialFilter;
import org.apache.geode.internal.serialization.filter.UnableToSetSerialFilterException;
import org.jetbrains.annotations.TestOnly;

class ReflectiveFacadeStreamSerialFilter
implements StreamSerialFilter {
    private final ObjectInputFilterApi api;
    private final String pattern;
    private final Collection<String> sanctionedClasses;

    ReflectiveFacadeStreamSerialFilter(ObjectInputFilterApi api, String pattern, Collection<String> sanctionedClasses) {
        this.api = Objects.requireNonNull(api, "ObjectInputFilterApi is required");
        this.pattern = pattern;
        this.sanctionedClasses = Collections.unmodifiableCollection(sanctionedClasses);
    }

    @Override
    public void setFilterOn(ObjectInputStream objectInputStream) throws UnableToSetSerialFilterException {
        try {
            Object objectInputFilter = this.api.createObjectInputFilterProxy(this.pattern, this.sanctionedClasses);
            this.api.setObjectInputFilter(objectInputStream, objectInputFilter);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.handleExceptionThrownByApi(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + '{' + "api=" + this.api + ", pattern='" + this.pattern + '\'' + '}';
    }

    @TestOnly
    ObjectInputFilterApi getObjectInputFilterApi() {
        return this.api;
    }

    private void handleExceptionThrownByApi(ReflectiveOperationException e) throws UnableToSetSerialFilterException {
        String className;
        switch (className = ReflectiveFacadeStreamSerialFilter.getClassName(e)) {
            case "java.lang.IllegalAccessException": {
                throw new UnableToSetSerialFilterException("Unable to configure an input stream serialization filter using reflection.", e);
            }
            case "java.lang.reflect.InvocationTargetException": {
                if (ExceptionUtils.getRootCause(e) instanceof IllegalStateException) {
                    throw new FilterAlreadyConfiguredException("Unable to configure an input stream serialization filter because a non-null filter has already been set.", e);
                }
                String causeClassName = e.getCause() == null ? ReflectiveFacadeStreamSerialFilter.getClassName(e) : ReflectiveFacadeStreamSerialFilter.getClassName(e.getCause());
                throw new UnableToSetSerialFilterException("Unable to configure an input stream serialization filter because invocation target threw " + causeClassName + ".", e);
            }
        }
        throw new UnableToSetSerialFilterException("Unable to configure an input stream serialization filter.", e);
    }

    private static String getClassName(Throwable throwable) {
        return throwable.getClass().getName();
    }
}

