/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueImpl;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.management.internal.cli.functions.DestroyAsyncEventQueueFunctionArgs;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.functions.CliFunctionResult;

public class DestroyAsyncEventQueueFunction
implements InternalFunction<DestroyAsyncEventQueueFunctionArgs> {
    private static final long serialVersionUID = -7754359270344102817L;
    private static final String ID = "org.apache.geode.management.internal.cli.functions.DestroyAsyncEventQueueFunction";

    public String getId() {
        return ID;
    }

    public void execute(FunctionContext<DestroyAsyncEventQueueFunctionArgs> context) {
        DestroyAsyncEventQueueFunctionArgs aeqArgs = (DestroyAsyncEventQueueFunctionArgs)context.getArguments();
        String aeqId = aeqArgs.getId();
        String memberId = context.getMemberName();
        try {
            AsyncEventQueueImpl aeq = (AsyncEventQueueImpl)context.getCache().getAsyncEventQueue(aeqId);
            if (aeq == null) {
                if (aeqArgs.isIfExists()) {
                    context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, true, String.format("Skipping: Async event queue \"%s\" not found", aeqId)));
                } else {
                    context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, false, String.format("Async event queue \"%s\" not found", aeqId)));
                }
            } else {
                XmlEntity xmlEntity = this.getAEQXmlEntity("id", aeqId);
                aeq.stop();
                aeq.destroy();
                CliFunctionResult lastResult = new CliFunctionResult(memberId, xmlEntity, String.format("Async event queue \"%s\" destroyed", aeqId));
                context.getResultSender().lastResult((Object)lastResult);
            }
        }
        catch (Exception e) {
            context.getResultSender().lastResult((Object)new CliFunctionResult(memberId, (Object)e, e.getMessage()));
        }
    }

    XmlEntity getAEQXmlEntity(String key, String value) {
        return new XmlEntity("async-event-queue", key, value);
    }
}

