/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

public class FetchRegionAttributesFunction
extends CliFunction<String> {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 4366812590788342070L;
    private static final String ID = "org.apache.geode.management.internal.cli.functions.FetchRegionAttributesFunction";
    @Immutable
    public static final FetchRegionAttributesFunction INSTANCE = new FetchRegionAttributesFunction();

    public String getId() {
        return ID;
    }

    @Override
    public boolean isHA() {
        return false;
    }

    @Override
    public CliFunctionResult executeFunction(FunctionContext<String> context) throws Exception {
        String regionPath = (String)context.getArguments();
        if (regionPath == null) {
            throw new IllegalArgumentException("Specify a valid name");
        }
        XmlEntity xmlEntity = new XmlEntity("region", "name", regionPath.substring(1));
        return new CliFunctionResult(context.getMemberName(), (Object)xmlEntity.getXmlDefinition());
    }
}

