/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class RegionPathConverter
implements Converter<String> {
    @Override
    public boolean supports(Class<?> type, String optionContext) {
        return String.class.equals(type) && optionContext.contains("geode.converter.region.path:disable-string-converter");
    }

    @Override
    public String convertFromText(String value, Class<?> targetType, String optionContext) {
        if (value == null) {
            return null;
        }
        if (value.equals("/")) {
            throw new IllegalArgumentException("invalid region path: " + value);
        }
        if (!value.startsWith("/")) {
            value = "/" + value;
        }
        return value;
    }

    @Override
    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        Set<String> regionPathSet = this.getAllRegionPaths();
        for (String regionPath : regionPathSet) {
            if (existingData != null) {
                if (!regionPath.startsWith(existingData)) continue;
                completions.add(new Completion(regionPath));
                continue;
            }
            completions.add(new Completion(regionPath));
        }
        return !completions.isEmpty();
    }

    public Set<String> getAllRegionPaths() {
        Set<String> regionPathSet = Collections.emptySet();
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh != null && gfsh.isConnectedAndReady()) {
            String[] regionPaths = gfsh.getOperationInvoker().getDistributedSystemMXBean().listAllRegionPaths();
            regionPathSet = Arrays.stream(regionPaths).collect(Collectors.toSet());
        }
        return regionPathSet;
    }
}

