/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.realizers;

import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.GatewayReceiverConfig;
import org.apache.geode.cache.wan.GatewayReceiverFactory;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.api.RealizationResult;
import org.apache.geode.management.configuration.GatewayReceiver;
import org.apache.geode.management.internal.beans.GatewayReceiverMBeanBridge;
import org.apache.geode.management.internal.configuration.converters.GatewayReceiverConverter;
import org.apache.geode.management.internal.configuration.domain.DeclarableTypeInstantiator;
import org.apache.geode.management.internal.configuration.realizers.ConfigurationRealizer;
import org.apache.geode.management.runtime.GatewayReceiverInfo;

public class GatewayReceiverRealizer
implements ConfigurationRealizer<GatewayReceiver, GatewayReceiverInfo> {
    private final GatewayReceiverConverter converter = new GatewayReceiverConverter();

    @Override
    public RealizationResult create(GatewayReceiver config, InternalCache cache) {
        return this.create((GatewayReceiverConfig)this.converter.fromConfigObject(config), cache);
    }

    @Override
    public RealizationResult create(GatewayReceiverConfig config, InternalCache cache) {
        List<DeclarableType> gatewayTransportFilters;
        Boolean manualStart;
        String socketBufferSize;
        String maxTimeBetweenPings;
        String hostnameForSenders;
        String bindAddress;
        String endPort;
        GatewayReceiverFactory gatewayReceiverFactory = cache.createGatewayReceiverFactory();
        String startPort = config.getStartPort();
        if (startPort != null) {
            gatewayReceiverFactory.setStartPort(Integer.parseInt(startPort));
        }
        if ((endPort = config.getEndPort()) != null) {
            gatewayReceiverFactory.setEndPort(Integer.parseInt(endPort));
        }
        if ((bindAddress = config.getBindAddress()) != null) {
            gatewayReceiverFactory.setBindAddress(bindAddress);
        }
        if ((hostnameForSenders = config.getHostnameForSenders()) != null) {
            gatewayReceiverFactory.setHostnameForSenders(hostnameForSenders);
        }
        if ((maxTimeBetweenPings = config.getMaximumTimeBetweenPings()) != null) {
            gatewayReceiverFactory.setMaximumTimeBetweenPings(Integer.parseInt(maxTimeBetweenPings));
        }
        if ((socketBufferSize = config.getSocketBufferSize()) != null) {
            gatewayReceiverFactory.setSocketBufferSize(Integer.parseInt(socketBufferSize));
        }
        if ((manualStart = config.isManualStart()) != null) {
            gatewayReceiverFactory.setManualStart(manualStart);
        }
        if ((gatewayTransportFilters = config.getGatewayTransportFilters()) != null) {
            for (DeclarableType gatewayTransportFilter : gatewayTransportFilters) {
                gatewayReceiverFactory.addGatewayTransportFilter((GatewayTransportFilter)DeclarableTypeInstantiator.newInstance(gatewayTransportFilter, (Cache)cache));
            }
        }
        gatewayReceiverFactory.create();
        return new RealizationResult().setSuccess(true);
    }

    @Override
    public boolean exists(GatewayReceiver config, InternalCache cache) {
        return cache.getGatewayReceivers() != null && cache.getGatewayReceivers().size() > 0;
    }

    @Override
    public GatewayReceiverInfo get(GatewayReceiver config, InternalCache cache) {
        if (cache.getGatewayReceivers() == null || cache.getGatewayReceivers().size() == 0) {
            return null;
        }
        org.apache.geode.cache.wan.GatewayReceiver receiver = cache.getGatewayReceivers().iterator().next();
        return this.generateGatewayReceiverInfo(receiver);
    }

    @VisibleForTesting
    GatewayReceiverInfo generateGatewayReceiverInfo(org.apache.geode.cache.wan.GatewayReceiver receiver) {
        GatewayReceiverMBeanBridge bridge = new GatewayReceiverMBeanBridge(receiver);
        GatewayReceiverInfo info = new GatewayReceiverInfo();
        info.setBindAddress(receiver.getBindAddress());
        info.setHostnameForSenders(receiver.getHostnameForSenders());
        info.setPort(receiver.getPort());
        info.setRunning(receiver.isRunning());
        info.setSenderCount(bridge.getClientConnectionCount());
        info.setConnectedSenders(bridge.getConnectedGatewaySenders());
        return info;
    }

    @Override
    public RealizationResult update(GatewayReceiver config, InternalCache cache) {
        throw new NotImplementedException("Not implemented");
    }

    @Override
    public RealizationResult delete(GatewayReceiver config, InternalCache cache) {
        throw new NotImplementedException("Not implemented");
    }
}

