/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.size;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.JvmSizeUtils;
import org.apache.geode.internal.size.SingleObjectSizer;
import org.apache.geode.unsafe.internal.sun.misc.Unsafe;

public class ReflectionSingleObjectSizer
implements SingleObjectSizer {
    public static final int REFERENCE_SIZE = JvmSizeUtils.getReferenceSize();
    public static final int OBJECT_SIZE = JvmSizeUtils.getObjectHeaderSize();
    @Immutable
    private static final Unsafe unsafe;

    @Override
    public long sizeof(Object object) {
        return this.sizeof(object, true);
    }

    public long sizeof(Object object, boolean roundResult) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            long size;
            if (unsafe != null) {
                size = unsafe.arrayBaseOffset(clazz);
                int arrayLength = Array.getLength(object);
                if (arrayLength > 0) {
                    int typeSize = unsafe.arrayScaleIndex(clazz);
                    if (typeSize == 0) {
                        typeSize = ReflectionSingleObjectSizer.sizeType(clazz.getComponentType());
                    }
                    size += (long)arrayLength * (long)typeSize;
                }
            } else {
                size = OBJECT_SIZE + 4;
                int arrayLength = Array.getLength(object);
                if (arrayLength > 0) {
                    size += (long)arrayLength * (long)ReflectionSingleObjectSizer.sizeType(clazz.getComponentType());
                }
            }
            if (roundResult) {
                size = JvmSizeUtils.roundUpSize(size);
            }
            return size;
        }
        return ReflectionSingleObjectSizer.sizeof(clazz, roundResult);
    }

    public static long sizeof(Class<?> clazz) {
        return ReflectionSingleObjectSizer.sizeof(clazz, true);
    }

    public static long sizeof(Class<?> clazz, boolean roundResult) {
        return ReflectionSingleObjectSizer.sizeof(clazz, roundResult, unsafe);
    }

    static long sizeof(Class<?> clazz, boolean roundResult, Unsafe myUnsafe) {
        Assert.assertTrue(!clazz.isArray());
        long size = ReflectionSingleObjectSizer.unsafeSizeof(clazz, myUnsafe);
        if (size == -1L) {
            size = ReflectionSingleObjectSizer.safeSizeof(clazz);
        }
        if (roundResult) {
            size = JvmSizeUtils.roundUpSize(size);
        }
        return size;
    }

    static long unsafeSizeof(Class<?> clazz, Unsafe myUnsafe) {
        if (myUnsafe == null) {
            return -1L;
        }
        Field lastField = null;
        long lastFieldOffset = 0L;
        do {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                try {
                    long offset = myUnsafe.fieldOffset(field);
                    if (offset < lastFieldOffset) continue;
                    lastFieldOffset = offset;
                    lastField = field;
                }
                catch (UnsupportedOperationException ex) {
                    return -1L;
                }
            }
        } while (lastField == null && (clazz = clazz.getSuperclass()) != null);
        long size = lastField != null ? lastFieldOffset + (long)ReflectionSingleObjectSizer.sizeType(lastField.getType()) : (long)OBJECT_SIZE;
        return size;
    }

    static long safeSizeof(Class<?> clazz) {
        long size = OBJECT_SIZE;
        do {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                size += (long)ReflectionSingleObjectSizer.sizeType(field.getType());
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return size;
    }

    private static int sizeType(Class<?> t) {
        if (t == Boolean.TYPE) {
            return 1;
        }
        if (t == Byte.TYPE) {
            return 1;
        }
        if (t == Character.TYPE) {
            return 2;
        }
        if (t == Short.TYPE) {
            return 2;
        }
        if (t == Integer.TYPE) {
            return 4;
        }
        if (t == Long.TYPE) {
            return 8;
        }
        if (t == Float.TYPE) {
            return 4;
        }
        if (t == Double.TYPE) {
            return 8;
        }
        if (t == Void.TYPE) {
            return 0;
        }
        return REFERENCE_SIZE;
    }

    static {
        Unsafe tmp = null;
        try {
            tmp = new Unsafe();
        }
        catch (Error | RuntimeException throwable) {
            // empty catch block
        }
        unsafe = tmp;
    }
}

