/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.process;

import org.apache.commons.lang3.Validate;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.process.ProcessUtilsProvider;
import org.apache.geode.internal.shared.NativeCalls;

public class NativeProcessUtils
implements ProcessUtilsProvider {
    @Immutable
    private static final NativeCalls nativeCalls = NativeCalls.getInstance();

    public static ProcessUtilsProvider create() {
        return new NativeProcessUtils();
    }

    @Override
    public boolean isProcessAlive(int pid) {
        Validate.isTrue((pid > 0 ? 1 : 0) != 0, (String)("Invalid pid '" + pid + "' specified"), (Object[])new Object[0]);
        return nativeCalls.isProcessActive(pid);
    }

    @Override
    public boolean killProcess(int pid) {
        Validate.isTrue((pid > 0 ? 1 : 0) != 0, (String)("Invalid pid '" + pid + "' specified"), (Object[])new Object[0]);
        return nativeCalls.killProcess(pid);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean isAttachApiAvailable() {
        return false;
    }
}

