/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.io.Console;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.distributed.ClientSocketFactory;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.distributed.internal.tcpserver.AdvancedSocketCreatorImpl;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreatorImpl;
import org.apache.geode.internal.cache.wan.TransportFilterServerSocket;
import org.apache.geode.internal.cache.wan.TransportFilterSocketFactory;
import org.apache.geode.internal.classloader.ClassPathLoader;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.net.BufferPool;
import org.apache.geode.internal.net.NioSslEngine;
import org.apache.geode.internal.net.SCAdvancedSocketCreator;
import org.apache.geode.internal.net.SCClientSocketCreator;
import org.apache.geode.internal.net.SCClusterSocketCreator;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.SSLUtil;
import org.apache.geode.internal.net.filewatch.FileWatchingX509ExtendedKeyManager;
import org.apache.geode.internal.net.filewatch.FileWatchingX509ExtendedTrustManager;
import org.apache.geode.internal.tcp.TCPConduit;
import org.apache.geode.internal.util.ArgumentRedactor;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.net.SSLParameterExtension;
import org.apache.logging.log4j.Logger;

public class SocketCreator
extends TcpSocketCreatorImpl {
    private static final Logger logger = LogService.getLogger();
    public static final boolean FORCE_DNS_USE = Boolean.getBoolean("gemfire.forceDnsUse");
    @MakeNotStatic
    public static volatile boolean resolve_dns = true;
    @MakeNotStatic
    public static volatile boolean use_client_host_name = true;
    @MakeNotStatic
    private static final ConcurrentHashMap<InetAddress, String> hostNames = new ConcurrentHashMap();
    private boolean configShown = false;
    private boolean hostnameValidationDisabledLogShown = false;
    private SSLContext sslContext;
    private final SSLConfig sslConfig;
    private ClientSocketFactory clientSocketFactory;
    public static final boolean ENABLE_TCP_KEEP_ALIVE = AdvancedSocketCreatorImpl.ENABLE_TCP_KEEP_ALIVE;

    @Deprecated
    public static InetAddress getLocalHost() throws UnknownHostException {
        return LocalHostUtil.getLocalHost();
    }

    public static String getHostName(InetAddress address) {
        String result = hostNames.get(address);
        if (result == null) {
            result = address.getHostName();
            hostNames.put(address, result);
        }
        return result;
    }

    public static void resetHostNameCache() {
        hostNames.clear();
    }

    public SocketCreator(SSLConfig sslConfig) {
        this.sslConfig = sslConfig;
        this.initialize();
    }

    @VisibleForTesting
    SocketCreator(SSLConfig sslConfig, SSLContext sslContext) {
        this.sslConfig = sslConfig;
        this.sslContext = sslContext;
    }

    public static String getClientHostName() throws UnknownHostException {
        InetAddress address = LocalHostUtil.getLocalHost();
        return use_client_host_name ? address.getCanonicalHostName() : address.getHostAddress();
    }

    protected void initializeCreators() {
        this.clusterSocketCreator = new SCClusterSocketCreator(this);
        this.clientSocketCreator = new SCClientSocketCreator(this);
        this.advancedSocketCreator = new SCAdvancedSocketCreator(this);
    }

    private void initialize() {
        try {
            try {
                if (this.sslConfig.isEnabled() && this.getSslContext() == null) {
                    this.sslContext = this.createAndConfigureSSLContext();
                }
            }
            catch (Exception e) {
                throw new GemFireConfigException("Error configuring GemFire ssl ", e);
            }
            TCPConduit.init();
            this.initializeClientSocketFactory();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error t) {
            SystemFailure.checkFailure();
            t.printStackTrace();
            throw t;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            throw re;
        }
    }

    private SSLContext createAndConfigureSSLContext() throws GeneralSecurityException {
        if (this.sslConfig.useDefaultSSLContext()) {
            return SSLContext.getDefault();
        }
        SSLContext newSSLContext = SSLUtil.getSSLContextInstance();
        KeyManager[] keyManagers = null;
        if (this.sslConfig.getKeystore() != null) {
            keyManagers = new KeyManager[]{FileWatchingX509ExtendedKeyManager.newFileWatchingKeyManager(this.sslConfig)};
        }
        TrustManager[] trustManagers = null;
        if (this.sslConfig.getTruststore() != null) {
            trustManagers = new TrustManager[]{FileWatchingX509ExtendedTrustManager.newFileWatchingTrustManager(this.sslConfig)};
        }
        newSSLContext.init(keyManagers, trustManagers, null);
        return newSSLContext;
    }

    public static void readSSLProperties(Map<String, String> env) {
        SocketCreator.readSSLProperties(env, false);
    }

    public static void readSSLProperties(Map<String, String> env, boolean ignoreGemFirePropsFile) {
        Properties props = new Properties();
        DistributionConfigImpl.loadGemFireProperties(props, ignoreGemFirePropsFile);
        for (Map.Entry<Object, Object> ent : props.entrySet()) {
            String value;
            String key = (String)ent.getKey();
            if (!key.startsWith("javax.net.ssl") && !key.startsWith("sysprop-")) continue;
            if (key.startsWith("sysprop-")) {
                key = key.substring("sysprop-".length());
            }
            if ((value = (String)ent.getValue()) != null && !value.trim().equals("")) continue;
            Console console = System.console();
            if (console == null) {
                throw new GemFireConfigException("SSL properties are empty, but a console is not available");
            }
            String val = console.readLine("Please enter " + key + ": ", new Object[0]);
            env.put(key, val);
        }
    }

    @VisibleForTesting
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public ClientSocketFactory getClientSocketFactory() {
        return this.clientSocketFactory;
    }

    public SSLConfig getSslConfig() {
        return this.sslConfig;
    }

    protected boolean useSSL() {
        return this.sslConfig.isEnabled();
    }

    public SSLEngine createSSLEngine(String hostName, int port, boolean clientSocket) {
        SSLEngine engine = this.getSslContext().createSSLEngine(hostName, port);
        this.configureSSLEngine(engine, hostName, port, clientSocket);
        return engine;
    }

    @VisibleForTesting
    void configureSSLEngine(SSLEngine engine, String hostName, int port, boolean clientSocket) {
        engine.setUseClientMode(clientSocket);
        SSLParameters parameters = engine.getSSLParameters();
        this.configureSSLParameters(parameters, hostName, port, clientSocket);
        engine.setSSLParameters(parameters);
    }

    @VisibleForTesting
    void configureSSLParameters(SSLParameters parameters, String hostName, int port, boolean clientSocket) {
        if (this.sslConfig.doEndpointIdentification()) {
            SocketCreator.addServerNameIfNotSet(parameters, new HostAndPort(hostName, port));
        }
        if (clientSocket) {
            this.checkAndEnableHostnameValidation(parameters);
        } else {
            parameters.setNeedClientAuth(this.sslConfig.isRequireAuth());
        }
        this.configureProtocols(clientSocket, parameters);
        this.configureCipherSuites(parameters);
    }

    public NioSslEngine handshakeSSLSocketChannel(SocketChannel socketChannel, SSLEngine engine, int timeout, ByteBuffer peerNetBuffer, BufferPool bufferPool) throws IOException {
        while (!socketChannel.finishConnect()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                if (!socketChannel.socket().isClosed()) {
                    socketChannel.close();
                }
                throw new IOException("Interrupted while performing handshake", e);
            }
        }
        NioSslEngine nioSslEngine = new NioSslEngine(engine, bufferPool);
        boolean blocking = socketChannel.isBlocking();
        if (blocking) {
            socketChannel.configureBlocking(false);
        }
        try {
            nioSslEngine.handshake(socketChannel, timeout, peerNetBuffer);
        }
        catch (SSLException e) {
            if (!socketChannel.socket().isClosed()) {
                socketChannel.close();
            }
            logger.warn("SSL handshake exception", (Throwable)e);
            throw e;
        }
        finally {
            if (blocking) {
                try {
                    socketChannel.configureBlocking(true);
                }
                catch (IOException iOException) {}
            }
        }
        return nioSslEngine;
    }

    void checkAndEnableHostnameValidation(SSLParameters sslParameters) {
        if (this.sslConfig.doEndpointIdentification()) {
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            return;
        }
        if (!this.hostnameValidationDisabledLogShown) {
            logger.info("Your SSL configuration disables hostname validation. ssl-endpoint-identification-enabled should be set to true when SSL is enabled. Please refer to the Apache GEODE SSL Documentation for SSL Property: ssl\u2011endpoint\u2011identification\u2011enabled");
            this.hostnameValidationDisabledLogShown = true;
        }
    }

    void handshakeIfSocketIsSSL(Socket socket, int timeout) throws IOException {
        if (!(socket instanceof SSLSocket)) {
            return;
        }
        int oldTimeout = socket.getSoTimeout();
        socket.setSoTimeout(timeout);
        SSLSocket sslSocket = (SSLSocket)socket;
        try {
            sslSocket.startHandshake();
        }
        catch (SSLPeerUnverifiedException ex) {
            if (this.sslConfig.isRequireAuth()) {
                logger.fatal(String.format("SSL Error in authenticating peer %s[%s].", socket.getInetAddress(), socket.getPort()), (Throwable)ex);
                throw ex;
            }
        }
        catch (SSLProtocolException ex) {
            if (ex.getCause() instanceof SocketTimeoutException) {
                throw (SocketTimeoutException)ex.getCause();
            }
            throw ex;
        }
        finally {
            try {
                socket.setSoTimeout(oldTimeout);
            }
            catch (SocketException ex) {}
        }
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddress, List<GatewayTransportFilter> transportFilters, int socketBufferSize) throws IOException {
        if (transportFilters.isEmpty()) {
            return ((SCClusterSocketCreator)this.forCluster()).createServerSocket(port, backlog, bindAddress, socketBufferSize, this.useSSL());
        }
        this.printConfig();
        TransportFilterServerSocket result = new TransportFilterServerSocket(transportFilters);
        result.setReuseAddress(true);
        result.setReceiveBufferSize(socketBufferSize);
        try {
            result.bind(new InetSocketAddress(bindAddress, port), backlog);
        }
        catch (BindException e) {
            BindException throwMe = new BindException(String.format("Failed to create server socket on %s[%s]", bindAddress, port));
            throwMe.initCause(e);
            throw throwMe;
        }
        return result;
    }

    void configureClientSSLSocket(Socket socket, HostAndPort address, int timeout) throws IOException {
        block8: {
            if (socket instanceof SSLSocket) {
                SSLSocket sslSocket = (SSLSocket)socket;
                sslSocket.setUseClientMode(true);
                sslSocket.setEnableSessionCreation(true);
                SSLParameters parameters = sslSocket.getSSLParameters();
                this.checkAndEnableHostnameValidation(parameters);
                SocketCreator.addServerNameIfNotSet(parameters, address);
                this.configureProtocols(true, parameters);
                this.configureCipherSuites(parameters);
                sslSocket.setSSLParameters(this.applySSLParameterExtensions(parameters));
                try {
                    if (timeout > 0) {
                        sslSocket.setSoTimeout(timeout);
                    }
                    sslSocket.startHandshake();
                }
                catch (SSLProtocolException ex) {
                    if (ex.getCause() instanceof SocketTimeoutException) {
                        throw (SocketTimeoutException)ex.getCause();
                    }
                    throw ex;
                }
                catch (SSLHandshakeException ex) {
                    String message = ex.getMessage();
                    if (message != null && !message.contains("Remote host terminated the handshake")) {
                        logger.fatal(String.format("Problem forming SSL connection to %s[%s].", socket.getInetAddress(), socket.getPort()), (Throwable)ex);
                    }
                    throw ex;
                }
                catch (SSLPeerUnverifiedException ex) {
                    if (!this.sslConfig.isRequireAuth()) break block8;
                    logger.fatal("SSL authentication exception.", (Throwable)ex);
                    throw ex;
                }
            }
        }
    }

    SSLParameters applySSLParameterExtensions(SSLParameters parameters) {
        SSLParameterExtension sslParameterExtension = this.sslConfig.getSSLParameterExtension();
        if (sslParameterExtension != null) {
            return sslParameterExtension.modifySSLClientSocketParameters(parameters);
        }
        return parameters;
    }

    void configureProtocols(boolean clientSocket, SSLParameters parameters) {
        String[] protocols;
        String[] stringArray = protocols = clientSocket ? this.sslConfig.getClientProtocolsAsStringArray() : this.sslConfig.getServerProtocolsAsStringArray();
        if (!SSLConfig.isAnyProtocols(protocols)) {
            parameters.setProtocols(protocols);
        }
    }

    void configureCipherSuites(SSLParameters parameters) {
        String[] ciphers = this.sslConfig.getCiphersAsStringArray();
        if (!SSLConfig.isAnyCiphers(ciphers)) {
            parameters.setCipherSuites(ciphers);
        }
    }

    static void addServerNameIfNotSet(SSLParameters parameters, HostAndPort address) {
        ArrayList<SNIServerName> serverNames = new ArrayList<SNIServerName>((Collection)ObjectUtils.getIfNull(parameters.getServerNames(), Collections::emptyList));
        if (serverNames.stream().mapToInt(SNIServerName::getType).anyMatch(type -> type == 0)) {
            return;
        }
        serverNames.add(new SNIHostName(address.getHostName()));
        parameters.setServerNames(serverNames);
    }

    void printConfig() {
        if (!this.configShown && logger.isDebugEnabled()) {
            this.configShown = true;
            StringBuilder sb = new StringBuilder();
            sb.append("SSL Configuration: \n");
            sb.append("  ssl-enabled = ").append(this.sslConfig.isEnabled()).append("\n");
            for (String key : System.getProperties().stringPropertyNames()) {
                if (!key.startsWith("javax.net.ssl")) continue;
                String possiblyRedactedValue = ArgumentRedactor.redactArgumentIfNecessary(key, System.getProperty(key));
                sb.append("  ").append(key).append(" = ").append(possiblyRedactedValue).append("\n");
            }
            logger.debug(sb.toString());
        }
    }

    protected void initializeClientSocketFactory() {
        this.clientSocketFactory = null;
        String className = System.getProperty("gemfire.clientSocketFactory");
        if (className != null) {
            Object o;
            try {
                Class<?> c = ClassPathLoader.getLatest().forName(className);
                o = c.newInstance();
            }
            catch (Exception e) {
                String s = "An unexpected exception occurred while instantiating a " + className + ": " + e;
                throw new IllegalArgumentException(s);
            }
            if (o instanceof ClientSocketFactory) {
                this.clientSocketFactory = (ClientSocketFactory)o;
            } else {
                String s = "Class \"" + className + "\" is not a ClientSocketFactory";
                throw new IllegalArgumentException(s);
            }
        }
    }

    public void initializeTransportFilterClientSocketFactory(GatewaySender sender) {
        this.clientSocketFactory = new TransportFilterSocketFactory().setGatewayTransportFilters(sender.getGatewayTransportFilters());
    }
}

