/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.distributed.internal.tcpserver.ClusterSocketCreatorImpl;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreatorImpl;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.net.SSLParameterExtension;

class SCClusterSocketCreator
extends ClusterSocketCreatorImpl {
    private final SocketCreator coreSocketCreator;

    protected SCClusterSocketCreator(SocketCreator socketCreator) {
        super((TcpSocketCreatorImpl)socketCreator);
        this.coreSocketCreator = socketCreator;
    }

    public void handshakeIfSocketIsSSL(Socket socket, int timeout) throws IOException {
        this.coreSocketCreator.handshakeIfSocketIsSSL(socket, timeout);
    }

    public ServerSocket createServerSocket(int nport, int backlog, InetAddress bindAddr, int socketBufferSize) throws IOException {
        return this.createServerSocket(nport, backlog, bindAddr, socketBufferSize, this.coreSocketCreator.useSSL());
    }

    protected ServerSocket createServerSocket(int nport, int backlog, InetAddress bindAddr, int socketBufferSize, boolean sslConnection) throws IOException {
        this.coreSocketCreator.printConfig();
        if (!sslConnection) {
            return super.createServerSocket(nport, backlog, bindAddr, socketBufferSize, sslConnection);
        }
        if (this.coreSocketCreator.getSslContext() == null) {
            throw new GemFireConfigException("SSL not configured correctly, Please look at previous error");
        }
        SSLServerSocketFactory ssf = this.coreSocketCreator.getSslContext().getServerSocketFactory();
        SSLServerSocket serverSocket = (SSLServerSocket)ssf.createServerSocket();
        serverSocket.setReuseAddress(true);
        if (socketBufferSize != -1) {
            serverSocket.setReceiveBufferSize(socketBufferSize);
        }
        serverSocket.bind(new InetSocketAddress(bindAddr, nport), backlog);
        this.finishServerSocket(serverSocket);
        return serverSocket;
    }

    private void finishServerSocket(SSLServerSocket serverSocket) {
        SCClusterSocketCreator.configureServerSocket(this.coreSocketCreator.getSslConfig(), serverSocket);
    }

    static void configureServerSocket(SSLConfig sslConfig, SSLServerSocket serverSocket) {
        SSLParameterExtension sslParameterExtension;
        serverSocket.setUseClientMode(false);
        if (sslConfig.isRequireAuth()) {
            serverSocket.setNeedClientAuth(true);
        }
        serverSocket.setEnableSessionCreation(true);
        String[] protocols = sslConfig.getServerProtocolsAsStringArray();
        if (!SSLConfig.isAnyProtocols(protocols)) {
            serverSocket.setEnabledProtocols(protocols);
        }
        if (!sslConfig.isAnyCiphers()) {
            serverSocket.setEnabledCipherSuites(sslConfig.getCiphersAsStringArray());
        }
        if ((sslParameterExtension = sslConfig.getSSLParameterExtension()) != null) {
            SSLParameters modifiedParams = sslParameterExtension.modifySSLServerSocketParameters(serverSocket.getSSLParameters());
            serverSocket.setSSLParameters(modifiedParams);
        }
    }
}

