/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.classloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.internal.classloader.ClasspathService;
import org.apache.geode.internal.deployment.DeploymentServiceFactory;
import org.apache.geode.internal.deployment.JarDeploymentService;

public class ClassPathLoader {
    static final String EXCLUDE_TCCL_PROPERTY = "gemfire.excludeThreadContextClassLoader";
    @MakeNotStatic
    private static volatile ClassPathLoader latest;
    private final JarDeploymentService jarDeploymentService = DeploymentServiceFactory.getJarDeploymentServiceInstance();
    private final ClasspathService classPathService;

    private ClassPathLoader(boolean excludeTCCL) {
        this.classPathService = DeploymentServiceFactory.getClasspathServiceInstance();
        this.classPathService.init(excludeTCCL, this.jarDeploymentService);
    }

    private ClassPathLoader(boolean excludeTCCL, File workingDir) {
        this.jarDeploymentService.reinitializeWithWorkingDirectory(workingDir);
        this.classPathService = DeploymentServiceFactory.getClasspathServiceInstance();
        this.classPathService.init(excludeTCCL, this.jarDeploymentService);
    }

    public static ClassPathLoader setLatestToDefault(File workingDir) {
        latest = new ClassPathLoader(Boolean.getBoolean(EXCLUDE_TCCL_PROPERTY), workingDir);
        return latest;
    }

    @VisibleForTesting
    static ClassPathLoader createWithDefaults(boolean excludeTCCL) {
        return new ClassPathLoader(excludeTCCL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClassPathLoader getLatest() {
        if (latest != null) return latest;
        Class<ClassPathLoader> clazz = ClassPathLoader.class;
        synchronized (ClassPathLoader.class) {
            if (latest != null) return latest;
            ClassPathLoader.setLatestToDefault(null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return latest;
        }
    }

    public static ClassLoader getLatestAsClassLoader() {
        return ClassPathLoader.getLatest().asClassLoader();
    }

    public String toString() {
        return this.classPathService.toString();
    }

    public ClassLoader asClassLoader() {
        return new ClassLoader(){

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                return ClassPathLoader.this.forName(name);
            }

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                return ClassPathLoader.this.forName(name);
            }

            @Override
            public URL getResource(String name) {
                return ClassPathLoader.this.getResource(name);
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                return ClassPathLoader.this.getResources(name);
            }

            @Override
            public InputStream getResourceAsStream(String name) {
                return ClassPathLoader.this.getResourceAsStream(name);
            }
        };
    }

    public void chainClassloader(File jar) {
        this.classPathService.chainClassloader(jar);
    }

    public void unloadClassloaderForArtifact(String artifactId) {
        this.classPathService.unloadClassloaderForArtifact(artifactId);
    }

    public Class<?> forName(String name) throws ClassNotFoundException {
        return this.classPathService.forName(name);
    }

    public Class<?> getProxyClass(Class<?> ... classObjs) {
        return this.classPathService.getProxyClass(classObjs);
    }

    public URL getResource(Class<?> contextClass, String name) {
        return this.classPathService.getResource(contextClass, name);
    }

    public URL getResource(String name) {
        return this.classPathService.getResource(name);
    }

    public InputStream getResourceAsStream(Class<?> contextClass, String name) {
        return this.classPathService.getResourceAsStream(contextClass, name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.classPathService.getResourceAsStream(name);
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return this.classPathService.getResources(name);
    }

    public JarDeploymentService getJarDeploymentService() {
        return this.jarDeploymentService;
    }
}

