/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.PooledDistributionMessage;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class ClientDenylistProcessor
extends ReplyProcessor21 {
    public static void sendDenylistedClient(ClientProxyMembershipID proxyId, DistributionManager dm, Set members) {
        ClientDenylistProcessor processor = new ClientDenylistProcessor(dm, members);
        ClientDenylistMessage.send(proxyId, dm, processor, members);
        try {
            processor.waitForRepliesUninterruptibly();
        }
        catch (ReplyException e) {
            e.handleCause();
        }
    }

    @Override
    public void process(DistributionMessage msg) {
        super.process(msg);
    }

    private ClientDenylistProcessor(DistributionManager dm, Set members) {
        super(dm, (Collection)members);
    }

    public static class ClientDenylistReply
    extends ReplyMessage {
    }

    public static class ClientDenylistMessage
    extends PooledDistributionMessage
    implements MessageWithReply {
        private int processorId;
        private ClientProxyMembershipID proxyId;

        protected static void send(ClientProxyMembershipID proxyId, DistributionManager dm, ClientDenylistProcessor proc, Set members) {
            ClientDenylistMessage msg = new ClientDenylistMessage();
            msg.processorId = proc.getProcessorId();
            msg.proxyId = proxyId;
            msg.setRecipients(members);
            dm.putOutgoing(msg);
        }

        @Override
        public int getProcessorId() {
            return this.processorId;
        }

        public ClientProxyMembershipID getProxyId() {
            return this.proxyId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void process(ClusterDistributionManager dm) {
            try {
                List<CacheServer> l;
                InternalCache c = dm.getCache();
                if (c != null && (l = c.getCacheServers()) != null) {
                    for (CacheServer o : l) {
                        CacheServerImpl bs = (CacheServerImpl)o;
                        CacheClientNotifier ccn = bs.getAcceptor().getCacheClientNotifier();
                        ccn.addToDenylistedClient(this.proxyId);
                        CacheClientProxy proxy = ccn.getClientProxy(this.proxyId);
                        if (proxy == null) continue;
                        proxy.close(false, false);
                        ccn.removeClientProxy(proxy);
                    }
                }
            }
            finally {
                ClientDenylistReply reply = new ClientDenylistReply();
                reply.setProcessorId(this.getProcessorId());
                reply.setRecipient(this.getSender());
                if (dm.getId().equals(this.getSender())) {
                    reply.setSender(this.getSender());
                    reply.dmProcess(dm);
                } else {
                    dm.putOutgoing(reply);
                }
            }
        }

        public int getDSFID() {
            return -45;
        }

        protected Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.processorId = in.readInt();
            this.proxyId = ClientProxyMembershipID.readCanonicalized(in);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeInt(this.processorId);
            DataSerializer.writeObject(this.proxyId, out);
        }

        @Override
        public String toString() {
            return "ClientDenylistMessage (proxyId='" + this.proxyId + "' processorId=" + this.processorId + ")";
        }
    }
}

