/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.ServerConnectivityException;
import org.apache.geode.cache.client.internal.ExecuteFunctionNoAckOp;
import org.apache.geode.cache.client.internal.ExecuteFunctionOp;
import org.apache.geode.cache.client.internal.GetFunctionAttributeOp;
import org.apache.geode.cache.client.internal.PoolImpl;
import org.apache.geode.cache.client.internal.ProxyCache;
import org.apache.geode.cache.client.internal.UserAttributes;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.DefaultResultCollector;
import org.apache.geode.internal.cache.execute.InternalExecution;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.NoResult;
import org.apache.geode.internal.cache.execute.TimeoutHelper;
import org.apache.geode.internal.cache.execute.metrics.FunctionStats;
import org.apache.geode.internal.cache.execute.metrics.FunctionStatsManager;
import org.apache.geode.internal.cache.execute.util.SynchronizedResultCollector;

public class ServerFunctionExecutor
extends AbstractExecution {
    private PoolImpl pool;
    private final boolean allServers;
    private final String[] groups;

    ServerFunctionExecutor(Pool pool, boolean allServers, String ... groups) {
        this.pool = (PoolImpl)pool;
        this.allServers = allServers;
        this.groups = groups;
    }

    ServerFunctionExecutor(Pool pool, boolean allServers, ProxyCache proxyCache, String ... groups) {
        this.pool = (PoolImpl)pool;
        this.allServers = allServers;
        this.proxyCache = proxyCache;
        this.groups = groups;
    }

    private ServerFunctionExecutor(ServerFunctionExecutor sfe) {
        super(sfe);
        if (sfe.pool != null) {
            this.pool = sfe.pool;
        }
        this.allServers = sfe.allServers;
        this.groups = sfe.groups;
    }

    private ServerFunctionExecutor(ServerFunctionExecutor sfe, Object args) {
        this(sfe);
        this.args = args;
    }

    private ServerFunctionExecutor(ServerFunctionExecutor sfe, ResultCollector collector) {
        this(sfe);
        this.rc = collector != null ? new SynchronizedResultCollector(collector) : null;
    }

    private ServerFunctionExecutor(ServerFunctionExecutor sfe, MemberMappedArgument argument) {
        this(sfe);
        this.memberMappedArg = argument;
        this.isMemberMappedArgument = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultCollector executeFunction(String functionId, boolean result, boolean isHA, boolean optimizeForWrite, long timeout, TimeUnit unit) {
        try {
            if (this.proxyCache != null) {
                if (this.proxyCache.isClosed()) {
                    throw this.proxyCache.getCacheClosedException("Cache is closed for this user.");
                }
                UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
            }
            int timeoutMs = TimeoutHelper.toMillis(timeout, unit);
            byte hasResult = 0;
            if (result) {
                hasResult = 1;
                if (this.rc == null) {
                    DefaultResultCollector defaultCollector = new DefaultResultCollector();
                    ResultCollector resultCollector = this.executeOnServer(functionId, defaultCollector, hasResult, isHA, optimizeForWrite, timeoutMs);
                    return resultCollector;
                }
                ResultCollector resultCollector = this.executeOnServer(functionId, this.rc, hasResult, isHA, optimizeForWrite, timeoutMs);
                return resultCollector;
            }
            this.executeOnServerNoAck(functionId, hasResult, isHA, optimizeForWrite);
            NoResult noResult = new NoResult();
            return noResult;
        }
        finally {
            UserAttributes.userAttributes.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ResultCollector executeFunction(Function function, long timeout, TimeUnit unit) {
        byte hasResult = 0;
        try {
            if (this.proxyCache != null) {
                if (this.proxyCache.isClosed()) {
                    throw this.proxyCache.getCacheClosedException("Cache is closed for this user.");
                }
                UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
            }
            if (function.hasResult()) {
                hasResult = 1;
                int timeoutMs = TimeoutHelper.toMillis(timeout, unit);
                if (this.rc == null) {
                    DefaultResultCollector defaultCollector = new DefaultResultCollector();
                    ResultCollector resultCollector = this.executeOnServer(function, defaultCollector, hasResult, timeoutMs);
                    return resultCollector;
                }
                ResultCollector resultCollector = this.executeOnServer(function, this.rc, hasResult, timeoutMs);
                return resultCollector;
            }
            this.executeOnServerNoAck(function, hasResult);
            NoResult noResult = new NoResult();
            return noResult;
        }
        finally {
            UserAttributes.userAttributes.set(null);
        }
    }

    private ResultCollector executeOnServer(Function function, ResultCollector rc, byte hasResult, int timeoutMs) {
        FunctionStats stats = FunctionStatsManager.getFunctionStats(function.getId());
        long start = stats.startFunctionExecution(true);
        try {
            this.validateExecution(function, (Set)null);
            ExecuteFunctionOp.ExecuteFunctionOpImpl executeFunctionOp = new ExecuteFunctionOp.ExecuteFunctionOpImpl(function, this.args, this.memberMappedArg, rc, this.isFnSerializationReqd, 0, this.groups, this.allServers, this.isIgnoreDepartedMembers(), timeoutMs);
            Supplier<ExecuteFunctionOp.ExecuteFunctionOpImpl> executeFunctionOpSupplier = () -> new ExecuteFunctionOp.ExecuteFunctionOpImpl(function, this.args, this.memberMappedArg, rc, this.isFnSerializationReqd, 0, null, false, false, timeoutMs);
            Supplier<ExecuteFunctionOp.ExecuteFunctionOpImpl> reExecuteFunctionOpSupplier = () -> new ExecuteFunctionOp.ExecuteFunctionOpImpl(function, this.getArguments(), this.getMemberMappedArgument(), rc, this.isFnSerializationReqd, 1, this.groups, this.allServers, this.isIgnoreDepartedMembers(), timeoutMs);
            ExecuteFunctionOp.execute(this.pool, this.allServers, rc, function.isHA(), UserAttributes.userAttributes.get(), this.groups, executeFunctionOp, executeFunctionOpSupplier, reExecuteFunctionOpSupplier);
            stats.endFunctionExecution(start, true);
            rc.endResults();
            return rc;
        }
        catch (FunctionException functionException) {
            stats.endFunctionExecutionWithException(start, true);
            throw functionException;
        }
        catch (ServerConnectivityException exception) {
            throw exception;
        }
        catch (Exception exception) {
            stats.endFunctionExecutionWithException(start, true);
            throw new FunctionException(exception);
        }
    }

    private ResultCollector executeOnServer(String functionId, ResultCollector rc, byte hasResult, boolean isHA, boolean optimizeForWrite, int timeoutMs) {
        FunctionStats stats = FunctionStatsManager.getFunctionStats(functionId);
        long start = stats.startFunctionExecution(true);
        try {
            this.validateExecution((Function)null, (Set)null);
            ExecuteFunctionOp.ExecuteFunctionOpImpl executeFunctionOp = new ExecuteFunctionOp.ExecuteFunctionOpImpl(functionId, this.args, this.memberMappedArg, hasResult, rc, this.isFnSerializationReqd, isHA, optimizeForWrite, 0, this.groups, this.allServers, this.isIgnoreDepartedMembers(), timeoutMs);
            Supplier<ExecuteFunctionOp.ExecuteFunctionOpImpl> executeFunctionOpSupplier = () -> new ExecuteFunctionOp.ExecuteFunctionOpImpl(functionId, this.args, this.memberMappedArg, hasResult, rc, this.isFnSerializationReqd, isHA, optimizeForWrite, 0, null, false, false, timeoutMs);
            Supplier<ExecuteFunctionOp.ExecuteFunctionOpImpl> reExecuteFunctionOpSupplier = () -> new ExecuteFunctionOp.ExecuteFunctionOpImpl(functionId, this.args, this.getMemberMappedArgument(), hasResult, rc, this.isFnSerializationReqd, isHA, optimizeForWrite, 1, this.groups, this.allServers, this.isIgnoreDepartedMembers(), timeoutMs);
            ExecuteFunctionOp.execute(this.pool, this.allServers, rc, isHA, UserAttributes.userAttributes.get(), this.groups, executeFunctionOp, executeFunctionOpSupplier, reExecuteFunctionOpSupplier);
            stats.endFunctionExecution(start, true);
            rc.endResults();
            return rc;
        }
        catch (FunctionException functionException) {
            stats.endFunctionExecutionWithException(start, true);
            throw functionException;
        }
        catch (ServerConnectivityException exception) {
            throw exception;
        }
        catch (Exception exception) {
            stats.endFunctionExecutionWithException(start, true);
            throw new FunctionException(exception);
        }
    }

    private void executeOnServerNoAck(Function function, byte hasResult) {
        FunctionStats stats = FunctionStatsManager.getFunctionStats(function.getId());
        long start = stats.startFunctionExecution(false);
        try {
            this.validateExecution(function, (Set)null);
            ExecuteFunctionNoAckOp.execute(this.pool, function, this.args, this.memberMappedArg, this.allServers, hasResult, this.isFnSerializationReqd, this.groups);
            stats.endFunctionExecution(start, false);
        }
        catch (FunctionException functionException) {
            stats.endFunctionExecutionWithException(start, false);
            throw functionException;
        }
        catch (ServerConnectivityException exception) {
            throw exception;
        }
        catch (Exception exception) {
            stats.endFunctionExecutionWithException(start, false);
            throw new FunctionException(exception);
        }
    }

    private void executeOnServerNoAck(String functionId, byte hasResult, boolean isHA, boolean optimizeForWrite) {
        FunctionStats stats = FunctionStatsManager.getFunctionStats(functionId);
        long start = stats.startFunctionExecution(false);
        try {
            this.validateExecution((Function)null, (Set)null);
            ExecuteFunctionNoAckOp.execute(this.pool, functionId, this.args, this.memberMappedArg, this.allServers, hasResult, this.isFnSerializationReqd, isHA, optimizeForWrite, this.groups);
            stats.endFunctionExecution(start, false);
        }
        catch (FunctionException functionException) {
            stats.endFunctionExecutionWithException(start, false);
            throw functionException;
        }
        catch (ServerConnectivityException exception) {
            throw exception;
        }
        catch (Exception exception) {
            stats.endFunctionExecutionWithException(start, false);
            throw new FunctionException(exception);
        }
    }

    public Pool getPool() {
        return this.pool;
    }

    public Execution withFilter(Set filter) {
        throw new FunctionException(String.format("Cannot specify %s for data independent functions", "filter"));
    }

    @Override
    public InternalExecution withBucketFilter(Set<Integer> bucketIDs) {
        throw new FunctionException(String.format("Cannot specify %s for data independent functions", "buckets as filter"));
    }

    public Execution setArguments(Object args) {
        if (args == null) {
            throw new FunctionException(String.format("The input %s for the execute function request is null", "args"));
        }
        return new ServerFunctionExecutor(this, args);
    }

    public Execution withArgs(Object args) {
        return this.setArguments(args);
    }

    public Execution withCollector(ResultCollector rs) {
        if (rs == null) {
            throw new FunctionException(String.format("The input %s for the execute function request is null", "Result Collector"));
        }
        return new ServerFunctionExecutor(this, rs);
    }

    @Override
    public InternalExecution withMemberMappedArgument(MemberMappedArgument argument) {
        if (argument == null) {
            throw new FunctionException(String.format("The input %s for the execute function request is null", "MemberMapped Args"));
        }
        return new ServerFunctionExecutor(this, argument);
    }

    public void validateExecution(Function function, Set targetMembers) {
        if (TXManagerImpl.getCurrentTXUniqueId() != -1) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultCollector execute(String functionName, long timeout, TimeUnit unit) {
        if (functionName == null) {
            throw new FunctionException("The input function for the execute function request is null");
        }
        this.isFnSerializationReqd = false;
        Function functionObject = FunctionService.getFunction(functionName);
        if (functionObject == null) {
            byte[] functionAttributes = this.getFunctionAttributes(functionName);
            if (functionAttributes == null) {
                try {
                    if (this.proxyCache != null) {
                        if (this.proxyCache.isClosed()) {
                            throw this.proxyCache.getCacheClosedException("Cache is closed for this user.");
                        }
                        UserAttributes.userAttributes.set(this.proxyCache.getUserAttributes());
                    }
                    Object obj = GetFunctionAttributeOp.execute(this.pool, functionName);
                    functionAttributes = (byte[])obj;
                    this.addFunctionAttributes(functionName, functionAttributes);
                }
                finally {
                    UserAttributes.userAttributes.set(null);
                }
            }
            boolean isHA = functionAttributes[1] == 1;
            boolean hasResult = functionAttributes[0] == 1;
            boolean optimizeForWrite = functionAttributes[2] == 1;
            return this.executeFunction(functionName, hasResult, isHA, optimizeForWrite, timeout, unit);
        }
        return this.executeFunction(functionObject, timeout, unit);
    }

    @Override
    public ResultCollector execute(String functionName) {
        return this.execute(functionName, (long)this.getTimeoutMs(), TimeUnit.MILLISECONDS);
    }
}

